/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public final class NumericConstantNode
extends ConstantNode {
    public void init(Object object) throws StandardException {
        boolean bl;
        Boolean bl2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TypeId typeId = null;
        int n4 = 0;
        if (object instanceof TypeId) {
            typeId = (TypeId)object;
            bl2 = Boolean.TRUE;
            bl = false;
            n3 = 0;
        } else {
            bl2 = Boolean.FALSE;
            bl = true;
        }
        switch (this.getNodeType()) {
            case 75: {
                n = 5;
                n2 = 0;
                if (!bl) break;
                n3 = 2;
                n4 = -6;
                this.setValue(new SQLTinyint((Byte)object));
                break;
            }
            case 70: {
                n = 10;
                n2 = 0;
                if (!bl) break;
                n3 = 4;
                n4 = 4;
                this.setValue(new SQLInteger((Integer)object));
                break;
            }
            case 74: {
                n = 5;
                n2 = 0;
                if (!bl) break;
                n3 = 2;
                n4 = 5;
                this.setValue(new SQLSmallint((Short)object));
                break;
            }
            case 71: {
                n = 19;
                n2 = 0;
                if (!bl) break;
                n3 = 8;
                n4 = -5;
                this.setValue(new SQLLongint((Long)object));
                break;
            }
            case 67: {
                if (bl) {
                    NumberDataValue numberDataValue = this.getDataValueFactory().getDecimalDataValue((String)object);
                    n4 = 3;
                    n = numberDataValue.getDecimalValuePrecision();
                    n2 = numberDataValue.getDecimalValueScale();
                    n3 = DataTypeUtilities.computeMaxWidth(n, n2);
                    this.setValue(numberDataValue);
                    break;
                }
                n = 5;
                n2 = 0;
                n3 = 31;
                break;
            }
            case 68: {
                n = 52;
                n2 = 0;
                if (!bl) break;
                n3 = 8;
                n4 = 8;
                this.setValue(new SQLDouble((Double)object));
                break;
            }
            case 69: {
                n = 23;
                n2 = 0;
                if (!bl) break;
                n3 = 4;
                n4 = 7;
                this.setValue(new SQLReal((Float)object));
                break;
            }
        }
        this.setType(typeId != null ? typeId : TypeId.getBuiltInTypeId(n4), n, n2, bl2, n3);
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getObject();
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        switch (this.getNodeType()) {
            case 70: {
                methodBuilder.push(this.value.getInt());
                break;
            }
            case 75: {
                methodBuilder.push(this.value.getByte());
                break;
            }
            case 74: {
                methodBuilder.push(this.value.getShort());
                break;
            }
            case 67: {
                if (!JVMInfo.J2ME) {
                    methodBuilder.pushNewStart("java.math.BigDecimal");
                }
                methodBuilder.push(this.value.getString());
                if (JVMInfo.J2ME) break;
                methodBuilder.pushNewComplete(1);
                break;
            }
            case 68: {
                methodBuilder.push(this.value.getDouble());
                break;
            }
            case 69: {
                methodBuilder.push(this.value.getFloat());
                break;
            }
            case 71: {
                methodBuilder.push(this.value.getLong());
                break;
            }
        }
    }
}

