/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.Utf8;
import java.nio.ByteBuffer;

public final class IsoTypeWriter {
    public static void writeUInt64(ByteBuffer bb, long u) {
        assert (u >= 0L) : "The given long is negative";
        bb.putLong(u);
    }

    public static void writeUInt32(ByteBuffer bb, long u) {
        assert (u >= 0L && u <= 0x100000000L) : "The given long is not in the range of uint32 (" + u + ")";
        bb.putInt((int)u);
    }

    public static void writeUInt32BE(ByteBuffer bb, long u) {
        assert (u >= 0L && u <= 0x100000000L) : "The given long is not in the range of uint32 (" + u + ")";
        IsoTypeWriter.writeUInt16BE(bb, (int)u & 0xFFFF);
        IsoTypeWriter.writeUInt16BE(bb, (int)(u >> 16 & 0xFFFFL));
    }

    public static void writeUInt24(ByteBuffer bb, int i) {
        IsoTypeWriter.writeUInt16(bb, (i &= 0xFFFFFF) >> 8);
        IsoTypeWriter.writeUInt8(bb, i);
    }

    public static void writeUInt16(ByteBuffer bb, int i) {
        IsoTypeWriter.writeUInt8(bb, (i &= 0xFFFF) >> 8);
        IsoTypeWriter.writeUInt8(bb, i & 0xFF);
    }

    public static void writeUInt16BE(ByteBuffer bb, int i) {
        IsoTypeWriter.writeUInt8(bb, (i &= 0xFFFF) & 0xFF);
        IsoTypeWriter.writeUInt8(bb, i >> 8);
    }

    public static void writeUInt8(ByteBuffer bb, int i) {
        bb.put((byte)(i &= 0xFF));
    }

    public static void writeFixedPoint1616(ByteBuffer bb, double v) {
        int result = (int)(v * 65536.0);
        bb.put((byte)((result & 0xFF000000) >> 24));
        bb.put((byte)((result & 0xFF0000) >> 16));
        bb.put((byte)((result & 0xFF00) >> 8));
        bb.put((byte)(result & 0xFF));
    }

    public static void writeFixedPoint0230(ByteBuffer bb, double v) {
        int result = (int)(v * 1.073741824E9);
        bb.put((byte)((result & 0xFF000000) >> 24));
        bb.put((byte)((result & 0xFF0000) >> 16));
        bb.put((byte)((result & 0xFF00) >> 8));
        bb.put((byte)(result & 0xFF));
    }

    public static void writeFixedPoint88(ByteBuffer bb, double v) {
        short result = (short)(v * 256.0);
        bb.put((byte)((result & 0xFF00) >> 8));
        bb.put((byte)(result & 0xFF));
    }

    public static void writeIso639(ByteBuffer bb, String language) {
        if (language.getBytes().length != 3) {
            throw new IllegalArgumentException("\"" + language + "\" language string isn't exactly 3 characters long!");
        }
        int bits = 0;
        int i = 0;
        while (i < 3) {
            bits += language.getBytes()[i] - 96 << (2 - i) * 5;
            ++i;
        }
        IsoTypeWriter.writeUInt16(bb, bits);
    }

    public static void writePascalUtfString(ByteBuffer bb, String string) {
        byte[] b = Utf8.convert(string);
        assert (b.length < 255);
        IsoTypeWriter.writeUInt8(bb, b.length);
        bb.put(b);
    }

    public static void writeZeroTermUtf8String(ByteBuffer bb, String string) {
        byte[] b = Utf8.convert(string);
        bb.put(b);
        IsoTypeWriter.writeUInt8(bb, 0);
    }

    public static void writeUtf8String(ByteBuffer bb, String string) {
        bb.put(Utf8.convert(string));
        IsoTypeWriter.writeUInt8(bb, 0);
    }
}

