/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.throttler;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.manifoldcf.core.interfaces.BreakException;
import org.apache.manifoldcf.core.interfaces.IBreakCheck;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IServiceDataAcceptor;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ConnectionBin {
    protected boolean isAlive = true;
    protected final String binName;
    protected final String serviceTypeName;
    protected final String serviceName;
    protected final String targetCalcLockName;
    protected int maxActiveConnections = 0;
    protected int localMax = 0;
    protected int reservedConnections = 0;
    protected int inUseConnections = 0;
    protected int referencingPools = 0;
    protected static final String serviceTypePrefix = "_CONNECTIONBIN_";
    protected static final String targetCalcLockPrefix = "_CONNECTIONBINTARGET_";
    protected static final Random randomNumberGenerator = new Random();
    public static final int CONNECTION_DESTROY = 0;
    public static final int CONNECTION_POOLEMPTY = 1;
    public static final int CONNECTION_WITHINBOUNDS = 2;

    public ConnectionBin(IThreadContext threadContext, String throttlingGroupName, String binName) throws ManifoldCFException {
        this.binName = binName;
        this.serviceTypeName = ConnectionBin.buildServiceTypeName(throttlingGroupName, binName);
        this.targetCalcLockName = ConnectionBin.buildTargetCalcLockName(throttlingGroupName, binName);
        ILockManager lockManager = LockManagerFactory.make(threadContext);
        this.serviceName = lockManager.registerServiceBeginServiceActivity(this.serviceTypeName, null, null);
    }

    protected static String buildServiceTypeName(String throttlingGroupName, String binName) {
        return serviceTypePrefix + throttlingGroupName + "_" + binName;
    }

    protected static String buildTargetCalcLockName(String throttlingGroupName, String binName) {
        return targetCalcLockPrefix + throttlingGroupName + "_" + binName;
    }

    public String getBinName() {
        return this.binName;
    }

    public synchronized void updateMaxActiveConnections(int maxActiveConnections) {
        this.maxActiveConnections = maxActiveConnections;
    }

    public synchronized int waitConnectionAvailable(AtomicInteger poolCount, IBreakCheck breakCheck) throws InterruptedException, BreakException {
        while (this.isAlive) {
            int currentPoolCount = poolCount.get();
            if (currentPoolCount > 0) {
                poolCount.set(currentPoolCount - 1);
                if (currentPoolCount == 1) {
                    --this.referencingPools;
                }
                return 0;
            }
            if (this.inUseConnections + this.reservedConnections < this.localMax) {
                ++this.reservedConnections;
                return 1;
            }
            if (breakCheck == null) {
                this.wait();
                continue;
            }
            long amt = breakCheck.abortCheck();
            this.wait(amt);
        }
        return -1;
    }

    public synchronized void undoReservation(int recommendation, AtomicInteger poolCount) {
        if (recommendation == 1) {
            if (this.reservedConnections == 0) {
                throw new IllegalStateException("Can't clear a reservation we don't have");
            }
            --this.reservedConnections;
            this.notifyAll();
        } else if (recommendation == 0) {
            int currentCount = poolCount.get();
            poolCount.set(currentCount + 1);
            if (currentCount == 0) {
                ++this.referencingPools;
            }
            this.notifyAll();
        }
    }

    public synchronized void noteConnectionCreation() {
        if (this.reservedConnections == 0) {
            throw new IllegalStateException("Creating a connection when no connection slot reserved!");
        }
        --this.reservedConnections;
        ++this.inUseConnections;
    }

    public synchronized boolean shouldReturnedConnectionBeDestroyed() {
        return this.inUseConnections > this.localMax;
    }

    public synchronized int shouldPooledConnectionBeDestroyed(AtomicInteger poolCount) {
        int currentPoolCount = poolCount.get();
        if (currentPoolCount > 0) {
            int individualPoolAllocation = this.localMax / this.referencingPools;
            poolCount.set(currentPoolCount - 1);
            if (currentPoolCount == 1) {
                --this.referencingPools;
            }
            if (this.inUseConnections > individualPoolAllocation) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public synchronized boolean hasPooledConnection(AtomicInteger poolCount) {
        int currentPoolCount = poolCount.get();
        if (currentPoolCount > 0) {
            poolCount.set(currentPoolCount - 1);
            if (currentPoolCount == 1) {
                --this.referencingPools;
            }
            return true;
        }
        return false;
    }

    public synchronized void undoPooledConnectionDecision(AtomicInteger poolCount) {
        int currentPoolCount = poolCount.get();
        poolCount.set(currentPoolCount + 1);
        if (currentPoolCount == 0) {
            ++this.referencingPools;
        }
        this.notifyAll();
    }

    public synchronized void noteConnectionReturnedToPool(AtomicInteger poolCount) {
        int currentPoolCount = poolCount.get();
        poolCount.set(currentPoolCount + 1);
        if (currentPoolCount == 0) {
            ++this.referencingPools;
        }
        this.notifyAll();
    }

    public synchronized void noteConnectionDestroyed() {
        --this.inUseConnections;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void poll(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make(threadContext);
        lockManager.enterWriteLock(this.targetCalcLockName);
        try {
            int globalInUse;
            SumClass sumClass = new SumClass(this.serviceName);
            lockManager.scanServiceData(this.serviceTypeName, sumClass);
            int numServices = sumClass.getNumServices();
            if (numServices == 0) {
                return;
            }
            int globalTarget = sumClass.getGlobalTarget();
            int maximumTarget = this.maxActiveConnections - globalTarget;
            if (maximumTarget > this.maxActiveConnections - (globalInUse = sumClass.getGlobalInUse())) {
                maximumTarget = this.maxActiveConnections - globalInUse;
            }
            if (maximumTarget < 0) {
                maximumTarget = 0;
            }
            int fairTarget = this.maxActiveConnections / numServices;
            int remainder = this.maxActiveConnections % numServices;
            if (randomNumberGenerator.nextInt(numServices) < remainder) {
                ++fairTarget;
            }
            int localInUse = this.inUseConnections;
            int optimalTarget = this.localMax;
            if (this.localMax > localInUse) {
                --optimalTarget;
            } else {
                int increment = this.maxActiveConnections >> 2;
                if (increment == 0) {
                    increment = 1;
                }
                optimalTarget += increment;
            }
            int target = maximumTarget;
            if (target > fairTarget) {
                target = fairTarget;
            }
            if (target > optimalTarget) {
                target = optimalTarget;
            }
            lockManager.updateServiceData(this.serviceTypeName, this.serviceName, ConnectionBin.pack(target, localInUse));
            if (target == this.localMax) {
                return;
            }
            this.localMax = target;
            this.notifyAll();
        }
        finally {
            lockManager.leaveWriteLock(this.targetCalcLockName);
        }
    }

    public synchronized void shutDown(IThreadContext threadContext) throws ManifoldCFException {
        this.isAlive = false;
        this.notifyAll();
        ILockManager lockManager = LockManagerFactory.make(threadContext);
        lockManager.endServiceActivity(this.serviceTypeName, this.serviceName);
    }

    protected static int unpackTarget(byte[] data) {
        if (data == null || data.length != 8) {
            return 0;
        }
        return (data[0] & 0xFF) + (data[1] << 8 & 0xFF00) + (data[2] << 16 & 0xFF0000) + (data[3] << 24 & 0xFF000000);
    }

    protected static int unpackInUse(byte[] data) {
        if (data == null || data.length != 8) {
            return 0;
        }
        return (data[4] & 0xFF) + (data[5] << 8 & 0xFF00) + (data[6] << 16 & 0xFF0000) + (data[7] << 24 & 0xFF000000);
    }

    protected static byte[] pack(int target, int inUse) {
        byte[] rval = new byte[]{(byte)(target & 0xFF), (byte)(target >> 8 & 0xFF), (byte)(target >> 16 & 0xFF), (byte)(target >> 24 & 0xFF), (byte)(inUse & 0xFF), (byte)(inUse >> 8 & 0xFF), (byte)(inUse >> 16 & 0xFF), (byte)(inUse >> 24 & 0xFF)};
        return rval;
    }

    protected static class SumClass
    implements IServiceDataAcceptor {
        protected final String serviceName;
        protected int numServices = 0;
        protected int globalTargetTally = 0;
        protected int globalInUseTally = 0;

        public SumClass(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public boolean acceptServiceData(String serviceName, byte[] serviceData) throws ManifoldCFException {
            ++this.numServices;
            if (!serviceName.equals(this.serviceName)) {
                this.globalTargetTally += ConnectionBin.unpackTarget(serviceData);
                this.globalInUseTally += ConnectionBin.unpackInUse(serviceData);
            }
            return false;
        }

        public int getNumServices() {
            return this.numServices;
        }

        public int getGlobalTarget() {
            return this.globalTargetTally;
        }

        public int getGlobalInUse() {
            return this.globalInUseTally;
        }
    }
}

