/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.common;

import org.apache.manifoldcf.agents.common.XMLStream;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLContext {
    protected XMLStream theStream;
    protected XMLContext previousContext;
    protected Attributes theseAttributes = null;
    protected String namespaceURI = null;
    protected String localname = null;
    protected String qname = null;

    public XMLContext(XMLStream theStream) {
        this(theStream, null, null, null, null);
    }

    public XMLContext(XMLStream theStream, String namespaceURI, String localname, String qname, Attributes theseAttributes) {
        this.theStream = theStream;
        this.previousContext = theStream.getContext();
        this.namespaceURI = namespaceURI;
        this.localname = localname;
        this.qname = qname;
        this.theseAttributes = theseAttributes;
    }

    public String getAttribute(String attributeName) {
        if (this.theseAttributes != null) {
            return this.theseAttributes.getValue(attributeName);
        }
        return null;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalname() {
        return this.localname;
    }

    public String getQname() {
        return this.qname;
    }

    public final void startDocument() throws SAXException {
    }

    public final void endDocument() throws SAXException {
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            XMLContext newContext = this.beginTag(namespaceURI, localName, qName, atts);
            if (newContext == null) {
                newContext = new XMLContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            this.theStream.setContext(newContext);
        }
        catch (ServiceInterruption e) {
            throw new SAXException(e);
        }
        catch (ManifoldCFException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.previousContext != null) {
                this.previousContext.endTag();
            }
            this.theStream.getContext().tagCleanup();
            this.theStream.setContext(this.previousContext);
        }
        catch (ServiceInterruption e) {
            throw new SAXException(e);
        }
        catch (ManifoldCFException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.tagContents(ch, start, length);
        }
        catch (ServiceInterruption e) {
            throw new SAXException(e);
        }
        catch (ManifoldCFException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public final void cleanup() throws ManifoldCFException {
        this.tagCleanup();
        this.theStream.setContext(this.previousContext);
    }

    protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
        return null;
    }

    protected void endTag() throws ManifoldCFException, ServiceInterruption {
    }

    protected void tagContents(char[] ch, int start, int length) throws ManifoldCFException, ServiceInterruption {
    }

    protected void tagCleanup() throws ManifoldCFException {
    }
}

