/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.crawler.system.Logging;

public class TrackerClass {
    protected static final long HISTORY_LENGTH = 900000L;
    protected static final Map<String, TransactionData> transactionData = new HashMap<String, TransactionData>();
    protected static final List<HistoryRecord> history = new ArrayList<HistoryRecord>();

    private TrackerClass() {
    }

    public static void noteRecordChange(Long recordID, int newStatus, String description) {
        if (Logging.diagnostics.isDebugEnabled()) {
            TrackerClass.addChange(new RecordChange(recordID, newStatus, description));
        }
    }

    public static void noteJobChange(Long jobID, String description) {
        if (Logging.diagnostics.isDebugEnabled()) {
            TrackerClass.addChange(new JobChange(jobID, description));
        }
    }

    public static void noteGlobalChange(String description) {
        if (Logging.diagnostics.isDebugEnabled()) {
            TrackerClass.addChange(new GlobalChange(description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addChange(DataChange dc) {
        TransactionData td;
        String threadName = Thread.currentThread().getName();
        Map<String, TransactionData> map = transactionData;
        synchronized (map) {
            td = transactionData.get(threadName);
            if (td == null) {
                td = new TransactionData();
                transactionData.put(threadName, td);
            }
        }
        td.addChange(dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notePrecommit() {
        TransactionData td;
        if (!Logging.diagnostics.isDebugEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        Map<String, TransactionData> map = transactionData;
        synchronized (map) {
            td = transactionData.get(threadName);
        }
        if (td == null) {
            return;
        }
        PrecommitEvent hr = new PrecommitEvent(new Exception("Precommit stack trace"), currentTime, threadName, td);
        List<HistoryRecord> list = history;
        synchronized (list) {
            history.add(hr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteRead(Long recordID) {
        if (!Logging.diagnostics.isDebugEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        ReadEvent hr = new ReadEvent(new Exception("Read stack trace"), currentTime, threadName, recordID);
        List<HistoryRecord> list = history;
        synchronized (list) {
            history.add(hr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notePreread(Long recordID) {
        if (!Logging.diagnostics.isDebugEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        PrereadEvent hr = new PrereadEvent(new Exception("Pre-read stack trace"), currentTime, threadName, recordID);
        List<HistoryRecord> list = history;
        synchronized (list) {
            history.add(hr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteCommit() {
        TransactionData td;
        if (!Logging.diagnostics.isDebugEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        Map<String, TransactionData> map = transactionData;
        synchronized (map) {
            td = transactionData.get(threadName);
            transactionData.remove(threadName);
        }
        if (td == null) {
            return;
        }
        CommitEvent hr = new CommitEvent(new Exception("Commit stack trace"), currentTime, threadName, td);
        long removalCutoff = currentTime - 900000L;
        List<HistoryRecord> list = history;
        synchronized (list) {
            HistoryRecord oldRecord;
            history.add(hr);
            while (history.size() > 0 && (oldRecord = history.get(0)).isFlushable(removalCutoff)) {
                history.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteRollback() {
        if (!Logging.diagnostics.isDebugEnabled()) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        Map<String, TransactionData> map = transactionData;
        synchronized (map) {
            transactionData.remove(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printForensics(Long recordID, int existingStatus) {
        if (Logging.diagnostics.isDebugEnabled()) {
            Map<String, TransactionData> map = transactionData;
            synchronized (map) {
                List<HistoryRecord> list = history;
                synchronized (list) {
                    Logging.diagnostics.debug((Object)("==== Forensics for record " + recordID + ", current status: " + existingStatus + " ===="));
                    Logging.diagnostics.debug((Object)"=== Current stack trace ===", (Throwable)new Exception("Forensics stack trace"));
                    Logging.diagnostics.debug((Object)"=== Active transactions ===");
                    for (String threadName : transactionData.keySet()) {
                        for (DataChange dc : transactionData.get(threadName).getChanges()) {
                            if (!dc.applies(recordID)) continue;
                            Logging.diagnostics.debug((Object)("Thread '" + threadName + "' was doing things to this record: " + dc.getDescription()));
                        }
                    }
                    Logging.diagnostics.debug((Object)"=== Pertinent History ===");
                    for (HistoryRecord hr : history) {
                        if (!hr.applies(recordID)) continue;
                        hr.print();
                    }
                }
            }
        }
    }

    protected static class GlobalChange
    extends DataChange {
        public GlobalChange(String description) {
            super(description);
        }

        @Override
        public String getDescription() {
            return "All records modified: " + super.getDescription();
        }

        @Override
        public boolean applies(Long recordID) {
            return true;
        }
    }

    protected static class JobChange
    extends DataChange {
        protected final Long jobID;

        public JobChange(Long jobID, String description) {
            super(description);
            this.jobID = jobID;
        }

        @Override
        public String getDescription() {
            return "All job related records modified for job " + this.jobID + ": " + super.getDescription();
        }

        @Override
        public boolean applies(Long recordID) {
            return true;
        }
    }

    protected static class RecordChange
    extends DataChange {
        protected final Long recordID;
        protected final int newStatus;

        public RecordChange(Long recordID, int newStatus, String description) {
            super(description);
            this.recordID = recordID;
            this.newStatus = newStatus;
        }

        @Override
        public String getDescription() {
            return "Record " + this.recordID + " status modified to " + this.newStatus + ": " + super.getDescription();
        }

        @Override
        public boolean applies(Long recordID) {
            return recordID.equals(this.recordID);
        }
    }

    protected static class PrereadEvent
    extends HistoryRecord {
        protected final Long recordID;

        public PrereadEvent(Exception trace, long timestamp, String threadName, Long recordID) {
            super(trace, timestamp, threadName);
            this.recordID = recordID;
        }

        @Override
        public void print() {
            super.print("About to read status");
        }

        @Override
        public boolean applies(Long recordID) {
            return recordID.equals(this.recordID);
        }
    }

    protected static class ReadEvent
    extends HistoryRecord {
        protected final Long recordID;

        public ReadEvent(Exception trace, long timestamp, String threadName, Long recordID) {
            super(trace, timestamp, threadName);
            this.recordID = recordID;
        }

        @Override
        public void print() {
            super.print("Read status");
        }

        @Override
        public boolean applies(Long recordID) {
            return recordID.equals(this.recordID);
        }
    }

    protected static class PrecommitEvent
    extends HistoryRecord {
        protected final TransactionData transactionData;

        public PrecommitEvent(Exception trace, long timestamp, String threadName, TransactionData transactionData) {
            super(trace, timestamp, threadName);
            this.transactionData = transactionData;
        }

        @Override
        public void print() {
            super.print("About to commit transaction");
            Logging.diagnostics.debug((Object)"    Transaction includes:");
            for (DataChange dc : this.transactionData.getChanges()) {
                Logging.diagnostics.debug((Object)("      " + dc.getDescription()));
            }
        }

        @Override
        public boolean applies(Long recordID) {
            return this.transactionData.applies(recordID);
        }
    }

    protected static class CommitEvent
    extends HistoryRecord {
        protected final TransactionData transactionData;

        public CommitEvent(Exception trace, long timestamp, String threadName, TransactionData transactionData) {
            super(trace, timestamp, threadName);
            this.transactionData = transactionData;
        }

        @Override
        public void print() {
            super.print("Commit transaction");
            Logging.diagnostics.debug((Object)"    Transaction includes:");
            for (DataChange dc : this.transactionData.getChanges()) {
                Logging.diagnostics.debug((Object)("      " + dc.getDescription()));
            }
        }

        @Override
        public boolean applies(Long recordID) {
            return this.transactionData.applies(recordID);
        }
    }

    protected static abstract class HistoryRecord {
        protected final long timestamp;
        protected final Exception trace;
        protected final String threadName;

        public HistoryRecord(Exception trace, long timestamp, String threadName) {
            this.trace = trace;
            this.timestamp = timestamp;
            this.threadName = threadName;
        }

        public void print(String description) {
            Logging.diagnostics.debug((Object)("== " + description + " by '" + this.threadName + "' at " + new Long(this.timestamp) + " =="), (Throwable)this.trace);
        }

        public boolean isFlushable(long timestamp) {
            return this.timestamp < timestamp;
        }

        public abstract boolean applies(Long var1);

        public abstract void print();
    }

    protected static abstract class DataChange {
        protected final String description;

        public DataChange(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract boolean applies(Long var1);
    }

    protected static class TransactionData {
        protected final List<DataChange> changes = new ArrayList<DataChange>();

        public void addChange(DataChange change) {
            this.changes.add(change);
        }

        public List<DataChange> getChanges() {
            return this.changes;
        }

        public boolean applies(Long recordID) {
            for (DataChange dc : this.changes) {
                if (!dc.applies(recordID)) continue;
                return true;
            }
            return false;
        }
    }
}

