/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.solr.client.solrj.io.CloudSolrStream;
import org.apache.solr.client.solrj.io.SolrStream;
import org.apache.solr.client.solrj.io.StreamContext;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.TupleStream;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Base64;

public class ParallelStream
extends CloudSolrStream {
    private TupleStream tupleStream;
    private int workers;
    private String encoded;

    public ParallelStream(String zkHost, String collection, TupleStream tupleStream, int workers, Comparator<Tuple> comp) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.workers = workers;
        this.comp = comp;
        this.tupleStream = tupleStream;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(tupleStream);
        byte[] bytes = bout.toByteArray();
        this.encoded = Base64.byteArrayToBase64(bytes, 0, bytes.length);
        this.encoded = URLEncoder.encode(this.encoded, "UTF-8");
        this.tuples = new TreeSet();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this._read();
        if (tuple.EOF) {
            HashMap<String, Boolean> m = new HashMap<String, Boolean>();
            m.put("EOF", true);
            Tuple t = new Tuple(m);
            t.setMetrics(this.eofTuples);
            return t;
        }
        return tuple;
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
    }

    @Override
    protected void constructStreams() throws IOException {
        try {
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
            long time = System.currentTimeMillis();
            ArrayList<Replica> shuffler = new ArrayList<Replica>();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    shuffler.add(replica);
                }
            }
            if (this.workers > shuffler.size()) {
                throw new IOException("Number of workers exceeds nodes in the worker collection");
            }
            Collections.shuffle(shuffler, new Random(time));
            for (int w = 0; w < this.workers; ++w) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("distrib", "false");
                params.put("numWorkers", this.workers);
                params.put("workerID", w);
                params.put("stream", this.encoded);
                params.put("qt", "/stream");
                Replica rep = (Replica)shuffler.get(w);
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                SolrStream solrStream = new SolrStream(url, params);
                this.solrStreams.add(solrStream);
            }
            assert (this.solrStreams.size() == this.workers);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

