/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class RemoveCommand
implements Command {
    @Override
    public boolean parseAndExecute(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        VariableReference indexRef = sp.evaluateExpression(currentStream);
        if (indexRef == null) {
            ScriptParser.syntaxError(currentStream, "Missing index expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("from")) {
            ScriptParser.syntaxError(currentStream, "Missing 'from'");
        }
        currentStream.skip();
        VariableReference targetRef = sp.evaluateExpression(currentStream);
        if (targetRef == null) {
            ScriptParser.syntaxError(currentStream, "Missing target expression");
        }
        Variable target = ScriptParser.resolveMustExist(currentStream, targetRef);
        target.removeAt(indexRef.resolve());
        return false;
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing index expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("from")) {
            ScriptParser.syntaxError(currentStream, "Missing 'from'");
        }
        currentStream.skip();
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing target expression");
        }
    }
}

