/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.fuzzyml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.manifoldcf.core.fuzzyml.ByteReceiver;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public abstract class SingleByteReceiver
extends ByteReceiver {
    protected final byte[] byteBuffer;

    public SingleByteReceiver(int chunkSize) {
        this.byteBuffer = new byte[chunkSize];
    }

    @Override
    public final boolean dealWithBytes(InputStream inputStream) throws IOException, ManifoldCFException {
        int amt;
        block0: while ((amt = inputStream.read(this.byteBuffer)) != -1) {
            int i = 0;
            while (true) {
                if (i >= amt) continue block0;
                if (this.dealWithByte(this.byteBuffer[i])) {
                    return this.dealWithRemainder(this.byteBuffer, i + 1, amt - (i + 1), inputStream);
                }
                ++i;
            }
            break;
        }
        return false;
    }

    public abstract boolean dealWithByte(byte var1) throws IOException, ManifoldCFException;

    protected boolean dealWithRemainder(byte[] buffer, int offset, int len, InputStream inputStream) throws IOException, ManifoldCFException {
        return true;
    }
}

