/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.awt.geom.AffineTransform;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.Matrix;

public class PDAppearanceStream
implements COSObjectable {
    private COSStream stream = null;

    public PDAppearanceStream(COSStream s) {
        this.stream = s;
    }

    public COSStream getStream() {
        return this.stream;
    }

    public COSBase getCOSObject() {
        return this.stream;
    }

    public PDRectangle getBoundingBox() {
        PDRectangle box = null;
        COSArray bbox = (COSArray)this.stream.getDictionaryObject(COSName.BBOX);
        if (bbox != null) {
            box = new PDRectangle(bbox);
        }
        return box;
    }

    public void setBoundingBox(PDRectangle rectangle) {
        COSArray array = null;
        if (rectangle != null) {
            array = rectangle.getCOSArray();
        }
        this.stream.setItem(COSName.BBOX, (COSBase)array);
    }

    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary dict = (COSDictionary)this.stream.getDictionaryObject(COSName.RESOURCES);
        if (dict != null) {
            retval = new PDResources(dict);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        COSDictionary dict = null;
        if (resources != null) {
            dict = resources.getCOSDictionary();
        }
        this.stream.setItem(COSName.RESOURCES, (COSBase)dict);
    }

    public Matrix getMatrix() {
        Matrix retval = null;
        COSArray array = (COSArray)this.stream.getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((COSNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((COSNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((COSNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((COSNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((COSNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((COSNumber)array.get(5)).floatValue());
        }
        return retval;
    }

    public void setMatrix(AffineTransform transform) {
        if (transform != null) {
            COSArray matrix = new COSArray();
            double[] values = new double[6];
            transform.getMatrix(values);
            for (double v : values) {
                matrix.add(new COSFloat((float)v));
            }
            this.stream.setItem(COSName.MATRIX, (COSBase)matrix);
        } else {
            this.stream.removeItem(COSName.MATRIX);
        }
    }
}

