/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty;

import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.ThreadNameDeterminer;
import org.elasticsearch.common.netty.util.ThreadRenamingRunnable;
import org.elasticsearch.transport.netty.NettyInternalESLoggerFactory;

public class NettyStaticSetup {
    private static EsThreadNameDeterminer ES_THREAD_NAME_DETERMINER = new EsThreadNameDeterminer();

    public static void setup() {
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new NettyInternalESLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return super.newInstance(name.replace("org.elasticsearch.common.netty.", "netty.").replace("org.elasticsearch.common.netty.", "netty."));
            }
        });
        ThreadRenamingRunnable.setThreadNameDeterminer(ES_THREAD_NAME_DETERMINER);
    }

    public static class EsThreadNameDeterminer
    implements ThreadNameDeterminer {
        @Override
        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return currentThreadName + "{" + proposedThreadName + "}";
        }
    }
}

