/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.max;

import java.io.IOException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class MaxAggregator
extends MetricsAggregator.SingleValue {
    private final NumericValuesSource valuesSource;
    private DoubleArray maxes;

    public MaxAggregator(String name, long estimatedBucketsCount, NumericValuesSource valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.maxes = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (this.valuesSource != null) : "collect should only be called when value source is not null";
        DoubleValues values = this.valuesSource.doubleValues();
        if (values == null) {
            return;
        }
        if (owningBucketOrdinal >= this.maxes.size()) {
            long from = this.maxes.size();
            this.maxes = BigArrays.grow(this.maxes, owningBucketOrdinal + 1L);
            this.maxes.fill(from, this.maxes.size(), Double.NEGATIVE_INFINITY);
        }
        int valueCount = values.setDocument(doc);
        double max = this.maxes.get(owningBucketOrdinal);
        for (int i = 0; i < valueCount; ++i) {
            max = Math.max(max, values.nextValue());
        }
        this.maxes.set(owningBucketOrdinal, max);
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.maxes.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalMax(this.name, Double.NEGATIVE_INFINITY);
        }
        assert (owningBucketOrdinal < this.maxes.size());
        return new InternalMax(this.name, this.maxes.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMax(this.name, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.maxes);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<NumericValuesSource> {
        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valuesSourceConfig) {
            super(name, InternalMax.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new MaxAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new MaxAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

