/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class FetchSearchRequest
extends TransportRequest {
    private long id;
    private int[] docIds;
    private int size;

    public FetchSearchRequest() {
    }

    public FetchSearchRequest(TransportRequest request, long id, IntArrayList list) {
        super(request);
        this.id = id;
        this.docIds = list.buffer;
        this.size = list.size();
    }

    public long id() {
        return this.id;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public int docIdsSize() {
        return this.size;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.size = in.readVInt();
        this.docIds = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.docIds[i] = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeVInt(this.docIds[i]);
        }
    }
}

