/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.metadata.SnapshotMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotAndRestoreService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class SnapshotsService
extends AbstractComponent
implements ClusterStateListener {
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final IndicesService indicesService;
    private final TransportService transportService;
    private volatile ImmutableMap<SnapshotId, SnapshotShards> shardSnapshots = ImmutableMap.of();
    private final CopyOnWriteArrayList<SnapshotCompletionListener> snapshotCompletionListeners = new CopyOnWriteArrayList();

    @Inject
    public SnapshotsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, IndicesService indicesService, TransportService transportService) {
        super(settings);
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
        this.indicesService = indicesService;
        this.transportService = transportService;
        transportService.registerHandler("cluster/snapshot/update_snapshot", new UpdateSnapshotStateRequestHandler());
        clusterService.addLast(this);
    }

    public Snapshot snapshot(SnapshotId snapshotId) {
        return this.repositoriesService.repository(snapshotId.getRepository()).readSnapshot(snapshotId);
    }

    public ImmutableList<Snapshot> snapshots(String repositoryName) {
        ArrayList<Snapshot> snapshotList = Lists.newArrayList();
        Repository repository = this.repositoriesService.repository(repositoryName);
        ImmutableList<SnapshotId> snapshotIds = repository.snapshots();
        for (SnapshotId snapshotId : snapshotIds) {
            snapshotList.add(repository.readSnapshot(snapshotId));
        }
        CollectionUtil.timSort(snapshotList);
        return ImmutableList.copyOf(snapshotList);
    }

    public void createSnapshot(final SnapshotRequest request, final CreateSnapshotListener listener) {
        final SnapshotId snapshotId = new SnapshotId(request.repository(), request.name());
        this.clusterService.submitStateUpdateTask(request.cause(), new TimeoutClusterStateUpdateTask(){
            private SnapshotMetaData.Entry newSnapshot = null;

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.this.validate(request, currentState);
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                if (snapshots != null && !snapshots.entries().isEmpty()) {
                    throw new ConcurrentSnapshotExecutionException(snapshotId, "a snapshot is already running");
                }
                ImmutableList<String> indices = ImmutableList.copyOf(metaData.concreteIndices(request.indices(), request.indicesOptions()));
                SnapshotsService.this.logger.trace("[{}][{}] creating snapshot for indices [{}]", request.repository(), request.name(), indices);
                this.newSnapshot = new SnapshotMetaData.Entry(snapshotId, request.includeGlobalState(), SnapshotMetaData.State.INIT, indices, null);
                snapshots = new SnapshotMetaData(this.newSnapshot);
                mdBuilder.putCustom("snapshots", snapshots);
                return ClusterState.builder(currentState).metaData(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                SnapshotsService.this.logger.warn("[{}][{}] failed to create snapshot", t, request.repository(), request.name());
                this.newSnapshot = null;
                listener.onFailure(t);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, final ClusterState newState) {
                if (this.newSnapshot != null) {
                    SnapshotsService.this.threadPool.executor("snapshot").execute(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotsService.this.beginSnapshot(newState, newSnapshot, request.partial, listener);
                        }
                    });
                }
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }
        });
    }

    private void validate(SnapshotRequest request, ClusterState state) throws ElasticsearchException {
        RepositoriesMetaData repositoriesMetaData = (RepositoriesMetaData)state.getMetaData().custom("repositories");
        if (repositoriesMetaData == null || repositoriesMetaData.repository(request.repository()) == null) {
            throw new RepositoryMissingException(request.repository());
        }
        if (!Strings.hasLength(request.name())) {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "cannot be empty");
        }
        if (request.name().contains(" ")) {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "must not contain whitespace");
        }
        if (request.name().contains(",")) {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "must not contain ','");
        }
        if (request.name().contains("#")) {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "must not contain '#'");
        }
        if (request.name().charAt(0) == '_') {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "must not start with '_'");
        }
        if (!request.name().toLowerCase(Locale.ROOT).equals(request.name())) {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "must be lowercase");
        }
        if (!Strings.validFileName(request.name())) {
            throw new InvalidSnapshotNameException(new SnapshotId(request.repository(), request.name()), "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
    }

    private void beginSnapshot(ClusterState clusterState, final SnapshotMetaData.Entry snapshot, final boolean partial, final CreateSnapshotListener userCreateSnapshotListener) {
        boolean snapshotCreated = false;
        try {
            Repository repository = this.repositoriesService.repository(snapshot.snapshotId().getRepository());
            MetaData metaData = clusterState.metaData();
            if (!snapshot.includeGlobalState()) {
                MetaData.Builder builder = MetaData.builder();
                for (String index : snapshot.indices()) {
                    builder.put(metaData.index(index), false);
                }
                metaData = builder.build();
            }
            repository.initializeSnapshot(snapshot.snapshotId(), snapshot.indices(), metaData);
            snapshotCreated = true;
            if (snapshot.indices().isEmpty()) {
                userCreateSnapshotListener.onResponse();
                this.endSnapshot(snapshot);
                return;
            }
            this.clusterService.submitStateUpdateTask("update_snapshot [" + snapshot + "]", new ProcessedClusterStateUpdateTask(){
                boolean accepted = false;
                SnapshotMetaData.Entry updatedSnapshot;
                String failure = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    MetaData metaData = currentState.metaData();
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                    ImmutableList.Builder entries = ImmutableList.builder();
                    for (SnapshotMetaData.Entry entry : snapshots.entries()) {
                        if (entry.snapshotId().equals(snapshot.snapshotId())) {
                            Set indicesWithMissingShards;
                            ImmutableMap shards = SnapshotsService.this.shards(snapshot.snapshotId(), currentState, snapshot.indices());
                            if (!partial && (indicesWithMissingShards = SnapshotsService.this.indicesWithMissingShards(shards)) != null) {
                                this.updatedSnapshot = new SnapshotMetaData.Entry(snapshot.snapshotId(), snapshot.includeGlobalState(), SnapshotMetaData.State.FAILED, snapshot.indices(), shards);
                                entries.add(this.updatedSnapshot);
                                this.failure = "Indices don't have primary shards +[" + indicesWithMissingShards + "]";
                                continue;
                            }
                            this.updatedSnapshot = new SnapshotMetaData.Entry(snapshot.snapshotId(), snapshot.includeGlobalState(), SnapshotMetaData.State.STARTED, snapshot.indices(), shards);
                            entries.add(this.updatedSnapshot);
                            if (SnapshotsService.this.completed(shards.values())) continue;
                            this.accepted = true;
                            continue;
                        }
                        entries.add(entry);
                    }
                    mdBuilder.putCustom("snapshots", new SnapshotMetaData((ImmutableList<SnapshotMetaData.Entry>)entries.build()));
                    return ClusterState.builder(currentState).metaData(mdBuilder).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    SnapshotsService.this.logger.warn("[{}] failed to create snapshot", t, snapshot.snapshotId());
                    userCreateSnapshotListener.onFailure(t);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    userCreateSnapshotListener.onResponse();
                    if (!this.accepted && this.updatedSnapshot != null) {
                        SnapshotsService.this.endSnapshot(this.updatedSnapshot, this.failure);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.logger.warn("failed to create snapshot [{}]", t, snapshot.snapshotId());
            this.clusterService.submitStateUpdateTask("fail_snapshot [" + snapshot.snapshotId() + "]", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    MetaData metaData = currentState.metaData();
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                    ImmutableList.Builder entries = ImmutableList.builder();
                    for (SnapshotMetaData.Entry entry : snapshots.entries()) {
                        if (entry.snapshotId().equals(snapshot.snapshotId())) continue;
                        entries.add(entry);
                    }
                    mdBuilder.putCustom("snapshots", new SnapshotMetaData((ImmutableList<SnapshotMetaData.Entry>)entries.build()));
                    return ClusterState.builder(currentState).metaData(mdBuilder).build();
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    SnapshotsService.this.logger.warn("[{}] failed to delete snapshot", t, snapshot.snapshotId());
                }
            });
            if (snapshotCreated) {
                try {
                    this.repositoriesService.repository(snapshot.snapshotId().getRepository()).finalizeSnapshot(snapshot.snapshotId(), ExceptionsHelper.detailedMessage(t), 0, ImmutableList.<SnapshotShardFailure>of());
                }
                catch (Throwable t2) {
                    this.logger.warn("[{}] failed to close snapshot in repository", snapshot.snapshotId());
                }
            }
            userCreateSnapshotListener.onFailure(t);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster() && event.nodesRemoved()) {
                this.processSnapshotsOnRemovedNodes(event);
            }
            SnapshotMetaData prev = (SnapshotMetaData)event.previousState().metaData().custom("snapshots");
            SnapshotMetaData curr = (SnapshotMetaData)event.state().metaData().custom("snapshots");
            if (prev == null) {
                if (curr != null) {
                    this.processIndexShardSnapshots(curr);
                }
            } else if (!prev.equals(curr)) {
                this.processIndexShardSnapshots(curr);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to update snapshot state ", t, new Object[0]);
        }
    }

    private void processSnapshotsOnRemovedNodes(ClusterChangedEvent event) {
        if (this.removedNodesCleanupNeeded(event)) {
            final boolean newMaster = !event.previousState().nodes().localNodeMaster();
            this.clusterService.submitStateUpdateTask("update snapshot state after node removal", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    DiscoveryNodes nodes = currentState.nodes();
                    MetaData metaData = currentState.metaData();
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                    if (snapshots == null) {
                        return currentState;
                    }
                    boolean changed = false;
                    ArrayList<SnapshotMetaData.Entry> entries = Lists.newArrayList();
                    Iterator i$ = snapshots.entries().iterator();
                    while (i$.hasNext()) {
                        SnapshotMetaData.Entry snapshot;
                        SnapshotMetaData.Entry updatedSnapshot = snapshot = (SnapshotMetaData.Entry)i$.next();
                        boolean snapshotChanged = false;
                        if (snapshot.state() == SnapshotMetaData.State.STARTED) {
                            ImmutableMap.Builder shards = ImmutableMap.builder();
                            for (Map.Entry shardEntry : snapshot.shards().entrySet()) {
                                SnapshotMetaData.ShardSnapshotStatus shardStatus = (SnapshotMetaData.ShardSnapshotStatus)shardEntry.getValue();
                                if (shardStatus.state().completed() || shardStatus.nodeId() == null) continue;
                                if (nodes.nodeExists(shardStatus.nodeId())) {
                                    shards.put(shardEntry);
                                    continue;
                                }
                                snapshotChanged = true;
                                SnapshotsService.this.logger.warn("failing snapshot of shard [{}] on closed node [{}]", shardEntry.getKey(), shardStatus.nodeId());
                                shards.put(shardEntry.getKey(), new SnapshotMetaData.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotMetaData.State.FAILED, "node shutdown"));
                            }
                            if (snapshotChanged) {
                                changed = true;
                                ImmutableMap<ShardId, SnapshotMetaData.ShardSnapshotStatus> shardsMap = shards.build();
                                if (!snapshot.state().completed() && SnapshotsService.this.completed(shardsMap.values())) {
                                    updatedSnapshot = new SnapshotMetaData.Entry(snapshot.snapshotId(), snapshot.includeGlobalState(), SnapshotMetaData.State.SUCCESS, snapshot.indices(), shardsMap);
                                    SnapshotsService.this.endSnapshot(updatedSnapshot);
                                } else {
                                    updatedSnapshot = new SnapshotMetaData.Entry(snapshot.snapshotId(), snapshot.includeGlobalState(), snapshot.state(), snapshot.indices(), shardsMap);
                                }
                            }
                            entries.add(updatedSnapshot);
                            continue;
                        }
                        if (snapshot.state() == SnapshotMetaData.State.INIT && newMaster) {
                            SnapshotsService.this.deleteSnapshot(snapshot.snapshotId(), new DeleteSnapshotListener(){

                                @Override
                                public void onResponse() {
                                    SnapshotsService.this.logger.debug("cleaned up abandoned snapshot {} in INIT state", snapshot.snapshotId());
                                }

                                @Override
                                public void onFailure(Throwable t) {
                                    SnapshotsService.this.logger.warn("failed to clean up abandoned snapshot {} in INIT state", snapshot.snapshotId());
                                }
                            });
                            continue;
                        }
                        if (snapshot.state() != SnapshotMetaData.State.SUCCESS || !newMaster) continue;
                        SnapshotsService.this.endSnapshot(snapshot);
                    }
                    if (changed) {
                        snapshots = new SnapshotMetaData(entries.toArray(new SnapshotMetaData.Entry[entries.size()]));
                        mdBuilder.putCustom("snapshots", snapshots);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                    return currentState;
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    SnapshotsService.this.logger.warn("failed to update snapshot state after node removal", new Object[0]);
                }
            });
        }
    }

    private boolean removedNodesCleanupNeeded(ClusterChangedEvent event) {
        boolean newMaster = !event.previousState().nodes().localNodeMaster();
        SnapshotMetaData snapshotMetaData = (SnapshotMetaData)event.state().getMetaData().custom("snapshots");
        if (snapshotMetaData == null) {
            return false;
        }
        for (SnapshotMetaData.Entry snapshot : snapshotMetaData.entries()) {
            if (newMaster && (snapshot.state() == SnapshotMetaData.State.SUCCESS || snapshot.state() == SnapshotMetaData.State.INIT)) {
                return true;
            }
            for (DiscoveryNode node : event.nodesDelta().removedNodes()) {
                for (Map.Entry shardEntry : snapshot.shards().entrySet()) {
                    SnapshotMetaData.ShardSnapshotStatus shardStatus = (SnapshotMetaData.ShardSnapshotStatus)shardEntry.getValue();
                    if (shardStatus.state().completed() || !node.getId().equals(shardStatus.nodeId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processIndexShardSnapshots(SnapshotMetaData snapshotMetaData) {
        HashMap survivors = Maps.newHashMap();
        for (Map.Entry entry : this.shardSnapshots.entrySet()) {
            if (snapshotMetaData == null || snapshotMetaData.snapshot((SnapshotId)entry.getKey()) == null) continue;
            survivors.put(entry.getKey(), entry.getValue());
        }
        HashMap<SnapshotId, SnapshotShards> newSnapshots = null;
        final String localNodeId = this.clusterService.localNode().id();
        for (SnapshotMetaData.Entry entry : snapshotMetaData.entries()) {
            HashMap startedShards = null;
            for (Map.Entry shard : entry.shards().entrySet()) {
                IndexShardSnapshotStatus snapshotStatus;
                SnapshotShards snapshotShards;
                if (!localNodeId.equals(((SnapshotMetaData.ShardSnapshotStatus)shard.getValue()).nodeId())) continue;
                if (entry.state() == SnapshotMetaData.State.STARTED) {
                    if (startedShards == null) {
                        startedShards = Maps.newHashMap();
                    }
                    startedShards.put(shard.getKey(), new IndexShardSnapshotStatus());
                    continue;
                }
                if (entry.state() != SnapshotMetaData.State.ABORTED || (snapshotShards = this.shardSnapshots.get(entry.snapshotId())) == null || (snapshotStatus = (IndexShardSnapshotStatus)snapshotShards.shards.get(shard.getKey())) == null) continue;
                snapshotStatus.abort();
            }
            if (startedShards == null || survivors.containsKey(entry.snapshotId())) continue;
            if (newSnapshots == null) {
                newSnapshots = Maps.newHashMapWithExpectedSize(2);
            }
            newSnapshots.put(entry.snapshotId(), new SnapshotShards(ImmutableMap.copyOf(startedShards)));
        }
        if (newSnapshots != null) {
            survivors.putAll(newSnapshots);
        }
        this.shardSnapshots = ImmutableMap.copyOf(survivors);
        if (newSnapshots != null) {
            for (final Map.Entry entry : newSnapshots.entrySet()) {
                for (final Map.Entry shardEntry : ((SnapshotShards)entry.getValue()).shards.entrySet()) {
                    try {
                        final IndexShardSnapshotAndRestoreService shardSnapshotService = this.indicesService.indexServiceSafe(((ShardId)shardEntry.getKey()).getIndex()).shardInjectorSafe(((ShardId)shardEntry.getKey()).id()).getInstance(IndexShardSnapshotAndRestoreService.class);
                        this.threadPool.executor("snapshot").execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    shardSnapshotService.snapshot((SnapshotId)entry.getKey(), (IndexShardSnapshotStatus)shardEntry.getValue());
                                    SnapshotsService.this.updateIndexShardSnapshotStatus(new UpdateIndexShardSnapshotStatusRequest((SnapshotId)entry.getKey(), (ShardId)shardEntry.getKey(), new SnapshotMetaData.ShardSnapshotStatus(localNodeId, SnapshotMetaData.State.SUCCESS)));
                                }
                                catch (Throwable t) {
                                    SnapshotsService.this.logger.warn("[{}] [{}] failed to create snapshot", t, shardEntry.getKey(), entry.getKey());
                                    SnapshotsService.this.updateIndexShardSnapshotStatus(new UpdateIndexShardSnapshotStatusRequest((SnapshotId)entry.getKey(), (ShardId)shardEntry.getKey(), new SnapshotMetaData.ShardSnapshotStatus(localNodeId, SnapshotMetaData.State.FAILED, ExceptionsHelper.detailedMessage(t))));
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.updateIndexShardSnapshotStatus(new UpdateIndexShardSnapshotStatusRequest((SnapshotId)entry.getKey(), (ShardId)shardEntry.getKey(), new SnapshotMetaData.ShardSnapshotStatus(localNodeId, SnapshotMetaData.State.FAILED, ExceptionsHelper.detailedMessage(t))));
                    }
                }
            }
        }
    }

    private void updateIndexShardSnapshotStatus(UpdateIndexShardSnapshotStatusRequest request) {
        try {
            if (this.clusterService.state().nodes().localNodeMaster()) {
                this.innerUpdateSnapshotState(request);
            } else {
                this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/snapshot/update_snapshot", request, EmptyTransportResponseHandler.INSTANCE_SAME);
            }
        }
        catch (Throwable t) {
            this.logger.warn("[{}] [{}] failed to update snapshot state", t, request.snapshotId(), request.status());
        }
    }

    private boolean completed(Collection<SnapshotMetaData.ShardSnapshotStatus> shards) {
        for (SnapshotMetaData.ShardSnapshotStatus status : shards) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    private Set<String> indicesWithMissingShards(ImmutableMap<ShardId, SnapshotMetaData.ShardSnapshotStatus> shards) {
        HashSet<String> indices = null;
        for (Map.Entry entry : shards.entrySet()) {
            if (((SnapshotMetaData.ShardSnapshotStatus)entry.getValue()).state() != SnapshotMetaData.State.MISSING) continue;
            if (indices == null) {
                indices = Sets.newHashSet();
            }
            indices.add(((ShardId)entry.getKey()).getIndex());
        }
        return indices;
    }

    private void innerUpdateSnapshotState(final UpdateIndexShardSnapshotStatusRequest request) {
        this.clusterService.submitStateUpdateTask("update snapshot state", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                if (snapshots != null) {
                    boolean changed = false;
                    ArrayList<SnapshotMetaData.Entry> entries = Lists.newArrayList();
                    for (SnapshotMetaData.Entry entry : snapshots.entries()) {
                        if (entry.snapshotId().equals(request.snapshotId())) {
                            HashMap<ShardId, SnapshotMetaData.ShardSnapshotStatus> shards = Maps.newHashMap(entry.shards());
                            SnapshotsService.this.logger.trace("[{}] Updating shard [{}] with status [{}]", new Object[]{request.snapshotId(), request.shardId(), request.status().state()});
                            shards.put(request.shardId(), request.status());
                            if (!SnapshotsService.this.completed(shards.values())) {
                                entries.add(new SnapshotMetaData.Entry(entry.snapshotId(), entry.includeGlobalState(), entry.state(), entry.indices(), ImmutableMap.copyOf(shards)));
                            } else {
                                SnapshotMetaData.Entry updatedEntry = new SnapshotMetaData.Entry(entry.snapshotId(), entry.includeGlobalState(), SnapshotMetaData.State.SUCCESS, entry.indices(), ImmutableMap.copyOf(shards));
                                entries.add(updatedEntry);
                                SnapshotsService.this.endSnapshot(updatedEntry);
                                SnapshotsService.this.logger.info("snapshot [{}] is done", updatedEntry.snapshotId());
                            }
                            changed = true;
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changed) {
                        snapshots = new SnapshotMetaData(entries.toArray(new SnapshotMetaData.Entry[entries.size()]));
                        mdBuilder.putCustom("snapshots", snapshots);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                SnapshotsService.this.logger.warn("[{}][{}] failed to update snapshot status to [{}]", t, request.snapshotId(), request.shardId(), request.status());
            }
        });
    }

    private void endSnapshot(SnapshotMetaData.Entry entry) {
        this.endSnapshot(entry, null);
    }

    private void endSnapshot(final SnapshotMetaData.Entry entry, final String failure) {
        this.threadPool.executor("snapshot").execute(new Runnable(){

            @Override
            public void run() {
                SnapshotId snapshotId = entry.snapshotId();
                try {
                    Repository repository = SnapshotsService.this.repositoriesService.repository(snapshotId.getRepository());
                    SnapshotsService.this.logger.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", new Object[]{snapshotId, entry.state(), failure});
                    ArrayList<ShardSearchFailure> failures = Lists.newArrayList();
                    ArrayList<SnapshotShardFailure> shardFailures = Lists.newArrayList();
                    for (Map.Entry shardStatus : entry.shards().entrySet()) {
                        ShardId shardId = (ShardId)shardStatus.getKey();
                        SnapshotMetaData.ShardSnapshotStatus status = (SnapshotMetaData.ShardSnapshotStatus)shardStatus.getValue();
                        if (!status.state().failed()) continue;
                        failures.add(new ShardSearchFailure(status.reason(), new SearchShardTarget(status.nodeId(), shardId.getIndex(), shardId.id())));
                        shardFailures.add(new SnapshotShardFailure(status.nodeId(), shardId.getIndex(), shardId.id(), status.reason()));
                    }
                    Snapshot snapshot = repository.finalizeSnapshot(snapshotId, failure, entry.shards().size(), ImmutableList.copyOf(shardFailures));
                    SnapshotsService.this.removeSnapshotFromClusterState(snapshotId, new SnapshotInfo(snapshot), null);
                }
                catch (Throwable t) {
                    SnapshotsService.this.logger.warn("[{}] failed to finalize snapshot", t, snapshotId);
                    SnapshotsService.this.removeSnapshotFromClusterState(snapshotId, null, t);
                }
            }
        });
    }

    private void removeSnapshotFromClusterState(final SnapshotId snapshotId, final SnapshotInfo snapshot, final Throwable t) {
        this.clusterService.submitStateUpdateTask("remove snapshot metadata", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                if (snapshots != null) {
                    boolean changed = false;
                    ArrayList<SnapshotMetaData.Entry> entries = Lists.newArrayList();
                    for (SnapshotMetaData.Entry entry : snapshots.entries()) {
                        if (entry.snapshotId().equals(snapshotId)) {
                            changed = true;
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changed) {
                        snapshots = new SnapshotMetaData(entries.toArray(new SnapshotMetaData.Entry[entries.size()]));
                        mdBuilder.putCustom("snapshots", snapshots);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Throwable t2) {
                SnapshotsService.this.logger.warn("[{}][{}] failed to remove snapshot metadata", t2, snapshotId);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                for (SnapshotCompletionListener listener : SnapshotsService.this.snapshotCompletionListeners) {
                    try {
                        if (snapshot != null) {
                            listener.onSnapshotCompletion(snapshotId, snapshot);
                            continue;
                        }
                        listener.onSnapshotFailure(snapshotId, t);
                    }
                    catch (Throwable t2) {
                        SnapshotsService.this.logger.warn("failed to refresh settings for [{}]", t2, listener);
                    }
                }
            }
        });
    }

    public void deleteSnapshot(final SnapshotId snapshotId, final DeleteSnapshotListener listener) {
        this.clusterService.submitStateUpdateTask("delete snapshot", new ProcessedClusterStateUpdateTask(){
            boolean waitForSnapshot = false;

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ImmutableMap<ShardId, SnapshotMetaData.ShardSnapshotStatus> shards;
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
                if (snapshots == null) {
                    return currentState;
                }
                SnapshotMetaData.Entry snapshot = snapshots.snapshot(snapshotId);
                if (snapshot == null) {
                    if (!snapshots.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshotId, "another snapshot is currently running cannot delete");
                    }
                    return currentState;
                }
                this.waitForSnapshot = true;
                if (snapshot.state() == SnapshotMetaData.State.STARTED && snapshot.shards() != null) {
                    ImmutableMap.Builder shardsBuilder = ImmutableMap.builder();
                    for (Map.Entry shardEntry : snapshot.shards().entrySet()) {
                        SnapshotMetaData.ShardSnapshotStatus status = (SnapshotMetaData.ShardSnapshotStatus)shardEntry.getValue();
                        if (!status.state().completed()) {
                            shardsBuilder.put(shardEntry.getKey(), new SnapshotMetaData.ShardSnapshotStatus(status.nodeId(), SnapshotMetaData.State.ABORTED));
                            continue;
                        }
                        shardsBuilder.put(shardEntry.getKey(), status);
                    }
                    shards = shardsBuilder.build();
                } else if (snapshot.state() == SnapshotMetaData.State.INIT) {
                    shards = snapshot.shards();
                    SnapshotsService.this.endSnapshot(snapshot);
                } else {
                    SnapshotsService.this.logger.trace("trying to delete completed snapshot - save to delete", new Object[0]);
                    return currentState;
                }
                SnapshotMetaData.Entry newSnapshot = new SnapshotMetaData.Entry(snapshotId, snapshot.includeGlobalState(), SnapshotMetaData.State.ABORTED, snapshot.indices(), shards);
                snapshots = new SnapshotMetaData(newSnapshot);
                mdBuilder.putCustom("snapshots", snapshots);
                return ClusterState.builder(currentState).metaData(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.waitForSnapshot) {
                    SnapshotsService.this.logger.trace("adding snapshot completion listener to wait for deleted snapshot to finish", new Object[0]);
                    SnapshotsService.this.addListener(new SnapshotCompletionListener(){

                        @Override
                        public void onSnapshotCompletion(SnapshotId snapshotId, SnapshotInfo snapshot) {
                            SnapshotsService.this.logger.trace("deleted snapshot completed - deleting files", new Object[0]);
                            SnapshotsService.this.removeListener(this);
                            SnapshotsService.this.deleteSnapshotFromRepository(snapshotId, listener);
                        }

                        @Override
                        public void onSnapshotFailure(SnapshotId snapshotId, Throwable t) {
                            SnapshotsService.this.logger.trace("deleted snapshot failed - deleting files", t, new Object[0]);
                            SnapshotsService.this.removeListener(this);
                            SnapshotsService.this.deleteSnapshotFromRepository(snapshotId, listener);
                        }
                    });
                } else {
                    SnapshotsService.this.logger.trace("deleted snapshot is not running - deleting files", new Object[0]);
                    SnapshotsService.this.deleteSnapshotFromRepository(snapshotId, listener);
                }
            }
        });
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        MetaData metaData = clusterState.metaData();
        SnapshotMetaData snapshots = (SnapshotMetaData)metaData.custom("snapshots");
        if (snapshots != null) {
            for (SnapshotMetaData.Entry snapshot : snapshots.entries()) {
                if (!repository.equals(snapshot.snapshotId().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteSnapshotFromRepository(final SnapshotId snapshotId, final DeleteSnapshotListener listener) {
        this.threadPool.executor("snapshot").execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Repository repository = SnapshotsService.this.repositoriesService.repository(snapshotId.getRepository());
                    repository.deleteSnapshot(snapshotId);
                    listener.onResponse();
                }
                catch (Throwable t) {
                    listener.onFailure(t);
                }
            }
        });
    }

    private ImmutableMap<ShardId, SnapshotMetaData.ShardSnapshotStatus> shards(SnapshotId snapshotId, ClusterState clusterState, ImmutableList<String> indices) {
        ImmutableMap.Builder<ShardId, SnapshotMetaData.ShardSnapshotStatus> builder = ImmutableMap.builder();
        MetaData metaData = clusterState.metaData();
        for (String index : indices) {
            IndexMetaData indexMetaData = metaData.index(index);
            IndexRoutingTable indexRoutingTable = clusterState.getRoutingTable().index(index);
            if (indexRoutingTable == null) {
                throw new SnapshotCreationException(snapshotId, "Missing routing table for index [" + index + "]");
            }
            for (int i = 0; i < indexMetaData.numberOfShards(); ++i) {
                ShardId shardId = new ShardId(index, i);
                ShardRouting primary = indexRoutingTable.shard(i).primaryShard();
                if (primary == null || !primary.assignedToNode()) {
                    builder.put(shardId, new SnapshotMetaData.ShardSnapshotStatus(null, SnapshotMetaData.State.MISSING, "primary shard is not allocated"));
                    continue;
                }
                if (!primary.started()) {
                    builder.put(shardId, new SnapshotMetaData.ShardSnapshotStatus(primary.currentNodeId(), SnapshotMetaData.State.MISSING, "primary shard hasn't been started yet"));
                    continue;
                }
                builder.put(shardId, new SnapshotMetaData.ShardSnapshotStatus(primary.currentNodeId()));
            }
        }
        return builder.build();
    }

    public void addListener(SnapshotCompletionListener listener) {
        this.snapshotCompletionListeners.add(listener);
    }

    public void removeListener(SnapshotCompletionListener listener) {
        this.snapshotCompletionListeners.remove(listener);
    }

    private class UpdateSnapshotStateRequestHandler
    extends BaseTransportRequestHandler<UpdateIndexShardSnapshotStatusRequest> {
        static final String ACTION = "cluster/snapshot/update_snapshot";

        private UpdateSnapshotStateRequestHandler() {
        }

        @Override
        public UpdateIndexShardSnapshotStatusRequest newInstance() {
            return new UpdateIndexShardSnapshotStatusRequest();
        }

        @Override
        public void messageReceived(UpdateIndexShardSnapshotStatusRequest request, TransportChannel channel) throws Exception {
            SnapshotsService.this.innerUpdateSnapshotState(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private static class UpdateIndexShardSnapshotStatusRequest
    extends TransportRequest {
        private SnapshotId snapshotId;
        private ShardId shardId;
        private SnapshotMetaData.ShardSnapshotStatus status;

        private UpdateIndexShardSnapshotStatusRequest() {
        }

        private UpdateIndexShardSnapshotStatusRequest(SnapshotId snapshotId, ShardId shardId, SnapshotMetaData.ShardSnapshotStatus status) {
            this.snapshotId = snapshotId;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshotId = SnapshotId.readSnapshotId(in);
            this.shardId = ShardId.readShardId(in);
            this.status = SnapshotMetaData.ShardSnapshotStatus.readShardSnapshotStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public SnapshotMetaData.ShardSnapshotStatus status() {
            return this.status;
        }
    }

    private static class SnapshotShards {
        private final ImmutableMap<ShardId, IndexShardSnapshotStatus> shards;

        private SnapshotShards(ImmutableMap<ShardId, IndexShardSnapshotStatus> shards) {
            this.shards = shards;
        }
    }

    public static class SnapshotRequest {
        private String cause;
        private String name;
        private String repository;
        private String[] indices;
        private IndicesOptions indicesOptions = IndicesOptions.strict();
        private boolean partial;
        private Settings settings;
        private boolean includeGlobalState;
        private TimeValue masterNodeTimeout;

        public SnapshotRequest(String cause, String name, String repository) {
            this.cause = cause;
            this.name = name;
            this.repository = repository;
        }

        public SnapshotRequest indices(String[] indices) {
            this.indices = indices;
            return this;
        }

        public SnapshotRequest settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public SnapshotRequest includeGlobalState(boolean includeGlobalState) {
            this.includeGlobalState = includeGlobalState;
            return this;
        }

        public SnapshotRequest masterNodeTimeout(TimeValue masterNodeTimeout) {
            this.masterNodeTimeout = masterNodeTimeout;
            return this;
        }

        public SnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public SnapshotRequest partial(boolean partial) {
            this.partial = partial;
            return this;
        }

        public String cause() {
            return this.cause;
        }

        public String name() {
            return this.name;
        }

        public String repository() {
            return this.repository;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }
    }

    public static interface SnapshotCompletionListener {
        public void onSnapshotCompletion(SnapshotId var1, SnapshotInfo var2);

        public void onSnapshotFailure(SnapshotId var1, Throwable var2);
    }

    public static interface DeleteSnapshotListener {
        public void onResponse();

        public void onFailure(Throwable var1);
    }

    public static interface CreateSnapshotListener {
        public void onResponse();

        public void onFailure(Throwable var1);
    }
}

