/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.concurrent.Callable;
import org.elasticsearch.common.hppc.BitUtil;
import org.elasticsearch.common.hppc.hash.MurmurHash3;

final class HashContainerUtils {
    static final int MAX_CAPACITY = 0x40000000;
    static final int MIN_CAPACITY = 4;
    static final int DEFAULT_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int[] PERTURBATIONS = new Callable<int[]>(){

        @Override
        public int[] call() {
            int[] result = new int[32];
            for (int i = 0; i < result.length; ++i) {
                result[i] = MurmurHash3.hash(17 + i);
            }
            return result;
        }
    }.call();

    HashContainerUtils() {
    }

    static int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    static int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        if (current < 2) {
            current = 2;
        }
        if ((current <<= 1) < 0) {
            throw new RuntimeException("Maximum capacity exceeded.");
        }
        return current;
    }
}

