/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.rest.RestStatus;

public interface Discovery
extends LifecycleComponent<Discovery> {
    public static final ClusterBlock NO_MASTER_BLOCK = new ClusterBlock(2, "no master", true, true, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final TimeValue DEFAULT_PUBLISH_TIMEOUT = TimeValue.timeValueSeconds(30L);

    public DiscoveryNode localNode();

    public void addListener(InitialStateDiscoveryListener var1);

    public void removeListener(InitialStateDiscoveryListener var1);

    public String nodeDescription();

    public void setNodeService(@Nullable NodeService var1);

    public void setAllocationService(AllocationService var1);

    public void publish(ClusterState var1, AckListener var2);

    public static interface AckListener {
        public void onNodeAck(DiscoveryNode var1, @Nullable Throwable var2);

        public void onTimeout();
    }
}

