/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.util.Map;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BloomFilter;
import org.elasticsearch.index.codec.postingsformat.AbstractPostingsFormatProvider;
import org.elasticsearch.index.codec.postingsformat.BloomFilterPostingsFormat;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.settings.IndexSettings;

public class BloomFilterPostingsFormatProvider
extends AbstractPostingsFormatProvider {
    private final PostingsFormatProvider delegate;
    private final BloomFilterPostingsFormat postingsFormat;

    @Inject
    public BloomFilterPostingsFormatProvider(@IndexSettings Settings indexSettings, @Nullable Map<String, PostingsFormatProvider.Factory> postingFormatFactories, @Assisted String name, @Assisted Settings postingsFormatSettings) {
        super(name);
        this.delegate = PostingsFormatProvider.Helper.lookup(indexSettings, postingsFormatSettings.get("delegate"), postingFormatFactories);
        this.postingsFormat = new BloomFilterPostingsFormat(this.delegate.get(), BloomFilter.Factory.buildFromString(postingsFormatSettings.get("fpp")));
    }

    public PostingsFormatProvider delegate() {
        return this.delegate;
    }

    @Override
    public PostingsFormat get() {
        return this.postingsFormat;
    }
}

