/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class GeoBoundingBoxFilterBuilder
extends BaseFilterBuilder {
    public static final String TOP_LEFT = "top_left";
    public static final String BOTTOM_RIGHT = "bottom_right";
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int BOTTOM = 2;
    private static final int RIGHT = 3;
    private final String name;
    private double[] box = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private String type;

    public GeoBoundingBoxFilterBuilder(String name) {
        this.name = name;
    }

    public GeoBoundingBoxFilterBuilder topLeft(double lat, double lon) {
        this.box[0] = lat;
        this.box[1] = lon;
        return this;
    }

    public GeoBoundingBoxFilterBuilder topLeft(GeoPoint point) {
        return this.topLeft(point.lat(), point.lon());
    }

    public GeoBoundingBoxFilterBuilder topLeft(String geohash) {
        return this.topLeft(GeoHashUtils.decode(geohash));
    }

    public GeoBoundingBoxFilterBuilder bottomRight(double lat, double lon) {
        this.box[2] = lat;
        this.box[3] = lon;
        return this;
    }

    public GeoBoundingBoxFilterBuilder bottomRight(GeoPoint point) {
        return this.bottomRight(point.lat(), point.lon());
    }

    public GeoBoundingBoxFilterBuilder bottomRight(String geohash) {
        return this.bottomRight(GeoHashUtils.decode(geohash));
    }

    public GeoBoundingBoxFilterBuilder bottomLeft(double lat, double lon) {
        this.box[2] = lat;
        this.box[1] = lon;
        return this;
    }

    public GeoBoundingBoxFilterBuilder bottomLeft(GeoPoint point) {
        return this.bottomLeft(point.lat(), point.lon());
    }

    public GeoBoundingBoxFilterBuilder bottomLeft(String geohash) {
        return this.bottomLeft(GeoHashUtils.decode(geohash));
    }

    public GeoBoundingBoxFilterBuilder topRight(double lat, double lon) {
        this.box[0] = lat;
        this.box[3] = lon;
        return this;
    }

    public GeoBoundingBoxFilterBuilder topRight(GeoPoint point) {
        return this.topRight(point.lat(), point.lon());
    }

    public GeoBoundingBoxFilterBuilder topRight(String geohash) {
        return this.topRight(GeoHashUtils.decode(geohash));
    }

    public GeoBoundingBoxFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoBoundingBoxFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GeoBoundingBoxFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public GeoBoundingBoxFilterBuilder type(String type) {
        this.type = type;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (Double.isNaN(this.box[0])) {
            throw new ElasticsearchIllegalArgumentException("geo_bounding_box requires top latitude to be set");
        }
        if (Double.isNaN(this.box[2])) {
            throw new ElasticsearchIllegalArgumentException("geo_bounding_box requires bottom latitude to be set");
        }
        if (Double.isNaN(this.box[3])) {
            throw new ElasticsearchIllegalArgumentException("geo_bounding_box requires right longitude to be set");
        }
        if (Double.isNaN(this.box[1])) {
            throw new ElasticsearchIllegalArgumentException("geo_bounding_box requires left longitude to be set");
        }
        builder.startObject("geo_bbox");
        builder.startObject(this.name);
        builder.array(TOP_LEFT, this.box[1], this.box[0]);
        builder.array(BOTTOM_RIGHT, this.box[3], this.box[2]);
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        if (this.type != null) {
            builder.field("type", this.type);
        }
        builder.endObject();
    }
}

