/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class GeoDistanceRangeFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private double lat;
    private double lon;
    private String geohash;
    private GeoDistance geoDistance;
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private String optimizeBbox;

    public GeoDistanceRangeFilterBuilder(String name) {
        this.name = name;
    }

    public GeoDistanceRangeFilterBuilder point(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoDistanceRangeFilterBuilder lat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoDistanceRangeFilterBuilder lon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoDistanceRangeFilterBuilder from(Object from) {
        this.from = from;
        return this;
    }

    public GeoDistanceRangeFilterBuilder to(Object to) {
        this.to = to;
        return this;
    }

    public GeoDistanceRangeFilterBuilder gt(Object from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public GeoDistanceRangeFilterBuilder gte(Object from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public GeoDistanceRangeFilterBuilder lt(Object to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public GeoDistanceRangeFilterBuilder lte(Object to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public GeoDistanceRangeFilterBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public GeoDistanceRangeFilterBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public GeoDistanceRangeFilterBuilder geohash(String geohash) {
        this.geohash = geohash;
        return this;
    }

    public GeoDistanceRangeFilterBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceRangeFilterBuilder optimizeBbox(String optimizeBbox) {
        this.optimizeBbox = optimizeBbox;
        return this;
    }

    public GeoDistanceRangeFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoDistanceRangeFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GeoDistanceRangeFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_distance_range");
        if (this.geohash != null) {
            builder.field(this.name, this.geohash);
        } else {
            builder.startArray(this.name).value(this.lon).value(this.lat).endArray();
        }
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase(Locale.ROOT));
        }
        if (this.optimizeBbox != null) {
            builder.field("optimize_bbox", this.optimizeBbox);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

