/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.ram;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.ram.RamDirectoryService;
import org.elasticsearch.index.store.support.AbstractIndexStore;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.jvm.JvmStats;

public class RamIndexStore
extends AbstractIndexStore {
    @Inject
    public RamIndexStore(Index index, @IndexSettings Settings indexSettings, IndexService indexService, IndicesStore indicesStore) {
        super(index, indexSettings, indexService, indicesStore);
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public Class<? extends DirectoryService> shardDirectory() {
        return RamDirectoryService.class;
    }

    @Override
    public ByteSizeValue backingStoreTotalSpace() {
        return JvmInfo.jvmInfo().getMem().heapMax();
    }

    @Override
    public ByteSizeValue backingStoreFreeSpace() {
        return JvmStats.jvmStats().getMem().heapUsed();
    }
}

