/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.min;

import java.io.IOException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.min.InternalMin;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class MinAggregator
extends MetricsAggregator.SingleValue {
    private final NumericValuesSource valuesSource;
    private DoubleArray mins;

    public MinAggregator(String name, long estimatedBucketsCount, NumericValuesSource valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.mins = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (this.valuesSource != null) : "collect must only be called if #shouldCollect returns true";
        DoubleValues values = this.valuesSource.doubleValues();
        if (values == null || values.setDocument(doc) == 0) {
            return;
        }
        if (owningBucketOrdinal >= this.mins.size()) {
            long from = this.mins.size();
            this.mins = BigArrays.grow(this.mins, owningBucketOrdinal + 1L);
            this.mins.fill(from, this.mins.size(), Double.POSITIVE_INFINITY);
        }
        this.mins.set(owningBucketOrdinal, Math.min(values.nextValue(), this.mins.get(owningBucketOrdinal)));
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.mins.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalMin(this.name, Double.POSITIVE_INFINITY);
        }
        assert (owningBucketOrdinal < this.mins.size());
        return new InternalMin(this.name, this.mins.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMin(this.name, Double.POSITIVE_INFINITY);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.mins);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<NumericValuesSource> {
        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valuesSourceConfig) {
            super(name, InternalMin.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new MinAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new MinAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

