/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io.sample;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.Shape;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class SampleDataWriter {
    protected final PrintWriter out;
    protected final SpatialContext ctx;
    protected final boolean bbox;
    protected final int maxLength;

    public SampleDataWriter(File f, SpatialContext ctx, boolean bbox, int maxLength) throws IOException {
        this.ctx = ctx;
        this.bbox = bbox;
        this.maxLength = maxLength;
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8"));
        this.out.print("#id");
        this.out.print('\t');
        this.out.print("name");
        this.out.print('\t');
        this.out.print("shape");
        this.out.print('\t');
        this.out.println();
        this.out.flush();
    }

    protected String toString(String name, Shape shape) {
        String v = this.ctx.toString(shape);
        if (this.maxLength > 0 && v.length() > this.maxLength) {
            Geometry g = ((JtsSpatialContext)this.ctx).getGeometryFrom(shape);
            long last = v.length();
            Envelope env = g.getEnvelopeInternal();
            double mins = Math.min(env.getWidth(), env.getHeight());
            double div = 1000.0;
            while (v.length() > this.maxLength) {
                double tolerance = mins / div;
                System.out.println(name + " :: Simplifying long geometry: WKT.length=" + v.length() + " tolerance=" + tolerance);
                Geometry simple = TopologyPreservingSimplifier.simplify((Geometry)g, (double)tolerance);
                v = simple.toText();
                if ((long)v.length() == last) {
                    System.out.println(name + " :: Can not simplify geometry smaller then max. " + last);
                    break;
                }
                last = v.length();
                div *= 0.7;
            }
        }
        return v;
    }

    public void write(String id, String name, double x, double y) throws IOException {
        this.write(id, name, this.ctx.makePoint(x, y));
    }

    public void write(String id, String name, Shape shape) throws IOException {
        String geo = this.toString(name, this.bbox ? shape.getBoundingBox() : shape);
        this.out.print(id);
        this.out.print('\t');
        this.out.print(name);
        this.out.print('\t');
        this.out.print(geo);
        this.out.print('\t');
        this.out.println();
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }
}

