/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.util.Service;

public class ImageHandlerRegistry {
    private static Log log = LogFactory.getLog((Class)ImageHandlerRegistry.class);
    private static final Comparator HANDLER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            ImageHandler h1 = (ImageHandler)o1;
            ImageHandler h2 = (ImageHandler)o2;
            return h1.getPriority() - h2.getPriority();
        }
    };
    private Map handlers = new HashMap();
    private List handlerList = new LinkedList();
    private int handlerRegistrations;

    public ImageHandlerRegistry() {
        this.discoverHandlers();
    }

    public void addHandler(String classname) {
        try {
            ImageHandler handlerInstance = (ImageHandler)Class.forName(classname).newInstance();
            this.addHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + ImageHandler.class.getName());
        }
    }

    public synchronized void addHandler(ImageHandler handler) {
        Class imageClass = handler.getSupportedImageClass();
        this.handlers.put(imageClass, handler);
        ListIterator<ImageHandler> iter = this.handlerList.listIterator();
        while (iter.hasNext()) {
            ImageHandler h = (ImageHandler)iter.next();
            if (HANDLER_COMPARATOR.compare(handler, h) >= 0) continue;
            iter.previous();
            break;
        }
        iter.add(handler);
        ++this.handlerRegistrations;
    }

    public ImageHandler getHandler(RenderingContext targetContext, Image image) {
        ListIterator iter = this.handlerList.listIterator();
        while (iter.hasNext()) {
            ImageHandler h = (ImageHandler)iter.next();
            if (!h.isCompatible(targetContext, image)) continue;
            return h;
        }
        return null;
    }

    public synchronized ImageFlavor[] getSupportedFlavors(RenderingContext context) {
        ArrayList<ImageFlavor> flavors = new ArrayList<ImageFlavor>();
        Iterator iter = this.handlerList.iterator();
        while (iter.hasNext()) {
            ImageHandler handler = (ImageHandler)iter.next();
            if (!handler.isCompatible(context, null)) continue;
            ImageFlavor[] f = handler.getSupportedImageFlavors();
            for (int i = 0; i < f.length; ++i) {
                flavors.add(f[i]);
            }
        }
        return flavors.toArray(new ImageFlavor[flavors.size()]);
    }

    private void discoverHandlers() {
        Iterator providers = Service.providers((Class)ImageHandler.class);
        if (providers != null) {
            while (providers.hasNext()) {
                ImageHandler handler = (ImageHandler)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding ImageHandler: " + handler.getClass().getName()));
                    }
                    this.addHandler(handler);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Error while adding ImageHandler", (Throwable)e);
                }
            }
        }
    }
}

