/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import opennlp.tools.util.CollectionObjectStream;
import opennlp.tools.util.ObjectStream;

public class CrossValidationPartitioner<E> {
    private ObjectStream<E> sampleStream;
    private final int numberOfPartitions;
    private int testIndex;
    private TrainingSampleStream<E> lastTrainingSampleStream;

    public CrossValidationPartitioner(ObjectStream<E> inElements, int numberOfPartitions) {
        this.sampleStream = inElements;
        this.numberOfPartitions = numberOfPartitions;
    }

    public CrossValidationPartitioner(Collection<E> elements, int numberOfPartitions) {
        this(new CollectionObjectStream<E>(elements), numberOfPartitions);
    }

    public boolean hasNext() {
        return this.testIndex < this.numberOfPartitions;
    }

    public TrainingSampleStream<E> next() throws IOException {
        if (this.hasNext()) {
            if (this.lastTrainingSampleStream != null) {
                this.lastTrainingSampleStream.poison();
            }
            this.sampleStream.reset();
            TrainingSampleStream<E> trainingSampleStream = new TrainingSampleStream<E>(this.sampleStream, this.numberOfPartitions, this.testIndex);
            ++this.testIndex;
            this.lastTrainingSampleStream = trainingSampleStream;
            return trainingSampleStream;
        }
        throw new NoSuchElementException();
    }

    public String toString() {
        return "At partition" + Integer.toString(this.testIndex + 1) + " of " + Integer.toString(this.numberOfPartitions);
    }

    public static class TrainingSampleStream<E>
    implements ObjectStream<E> {
        private ObjectStream<E> sampleStream;
        private final int numberOfPartitions;
        private final int testIndex;
        private int index;
        private boolean isPoisened;
        private TestSampleStream<E> testSampleStream;

        TrainingSampleStream(ObjectStream<E> sampleStream, int numberOfPartitions, int testIndex) {
            this.numberOfPartitions = numberOfPartitions;
            this.sampleStream = sampleStream;
            this.testIndex = testIndex;
        }

        @Override
        public E read() throws IOException {
            if (this.testSampleStream != null || this.isPoisened) {
                throw new IllegalStateException();
            }
            if (this.index % this.numberOfPartitions == this.testIndex) {
                this.sampleStream.read();
                ++this.index;
            }
            ++this.index;
            return this.sampleStream.read();
        }

        @Override
        public void reset() throws IOException {
            if (this.testSampleStream != null || this.isPoisened) {
                throw new IllegalStateException();
            }
            this.index = 0;
            this.sampleStream.reset();
        }

        @Override
        public void close() throws IOException {
            this.sampleStream.close();
            this.poison();
        }

        void poison() {
            this.isPoisened = true;
            if (this.testSampleStream != null) {
                this.testSampleStream.poison();
            }
        }

        public ObjectStream<E> getTestSampleStream() throws IOException {
            if (this.isPoisened) {
                throw new IllegalStateException();
            }
            if (this.testSampleStream == null) {
                this.sampleStream.reset();
                this.testSampleStream = new TestSampleStream(this.sampleStream, this.numberOfPartitions, this.testIndex);
            }
            return this.testSampleStream;
        }
    }

    private static class TestSampleStream<E>
    implements ObjectStream<E> {
        private ObjectStream<E> sampleStream;
        private final int numberOfPartitions;
        private final int testIndex;
        private int index;
        private boolean isPoisened;

        private TestSampleStream(ObjectStream<E> sampleStream, int numberOfPartitions, int testIndex) {
            this.numberOfPartitions = numberOfPartitions;
            this.sampleStream = sampleStream;
            this.testIndex = testIndex;
        }

        @Override
        public E read() throws IOException {
            if (this.isPoisened) {
                throw new IllegalStateException();
            }
            while (this.index % this.numberOfPartitions != this.testIndex) {
                this.sampleStream.read();
                ++this.index;
            }
            ++this.index;
            return this.sampleStream.read();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.sampleStream.close();
            this.isPoisened = true;
        }

        void poison() {
            this.isPoisened = true;
        }
    }
}

