/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageDataIndex
extends PageIndex {
    private PageStore store;
    private RegularTable tableData;
    private long lastKey;
    private long rowCount;
    private HashSet<Row> delta;
    private int rowCountDiff;
    private HashMap<Integer, Integer> sessionRowCount;
    private int mainIndexColumn = -1;
    private DbException fastDuplicateKeyException;
    private int memoryPerPage;
    private int memoryCount;
    private boolean multiVersion;

    public PageDataIndex(RegularTable regularTable, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, Session session) {
        this.initBaseIndex(regularTable, n, regularTable.getName() + "_DATA", indexColumnArray, indexType);
        this.multiVersion = this.database.isMultiVersion();
        if (this.multiVersion) {
            this.sessionRowCount = New.hashMap();
            this.isMultiVersion = true;
        }
        this.tableData = regularTable;
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (!this.database.isPersistent()) {
            throw DbException.throwInternalError(regularTable.getName());
        }
        if (bl) {
            this.rootPageId = this.store.allocatePage();
            this.store.addMeta(this, session);
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.update(pageDataLeaf);
        } else {
            this.rootPageId = this.store.getRootPageId(n);
            PageData pageData = this.getPage(this.rootPageId, 0);
            this.lastKey = pageData.getLastKey();
            this.rowCount = pageData.getRowCount();
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} opened rows: {1}", this, this.rowCount);
        }
        regularTable.setRowCount(this.rowCount);
        this.memoryPerPage = 240 + this.store.getPageSize() >> 2;
    }

    @Override
    public DbException getDuplicateKeyException() {
        if (this.fastDuplicateKeyException == null) {
            this.fastDuplicateKeyException = super.getDuplicateKeyException();
        }
        return this.fastDuplicateKeyException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row) {
        boolean bl = false;
        if (this.mainIndexColumn != -1) {
            row.setKey(row.getValue(this.mainIndexColumn).getLong());
        } else if (row.getKey() == 0L) {
            row.setKey((int)(++this.lastKey));
            bl = true;
        }
        if (this.tableData.getContainsLargeObject()) {
            int n = row.getColumnCount();
            for (int i = 0; i < n; ++i) {
                Value value = row.getValue(i);
                Value value2 = value.link(this.database, this.getId());
                if (value2.isLinked()) {
                    session.unlinkAtCommitStop(value2);
                }
                if (value == value2) continue;
                row.setValue(i, value2);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row);
        }
        long l = 0L;
        while (true) {
            try {
                this.addTry(session, row);
            }
            catch (DbException dbException) {
                if (dbException != this.fastDuplicateKeyException) {
                    throw dbException;
                }
                if (!bl) {
                    throw this.getNewDuplicateKeyException();
                }
                if (l == 0L) {
                    row.setKey((long)((double)row.getKey() + Math.random() * 10000.0));
                } else {
                    row.setKey(row.getKey() + l);
                }
                ++l;
                continue;
            }
            finally {
                this.store.incrementChangeCount();
                continue;
            }
            break;
        }
        this.lastKey = Math.max(this.lastKey, row.getKey());
    }

    public DbException getNewDuplicateKeyException() {
        String string = "PRIMARY KEY ON " + this.table.getSQL();
        if (this.mainIndexColumn >= 0 && this.mainIndexColumn < this.indexColumns.length) {
            string = string + "(" + this.indexColumns[this.mainIndexColumn].getSQL() + ")";
        }
        DbException dbException = DbException.get(23505, string);
        dbException.setSource(this);
        return dbException;
    }

    private void addTry(Session session, Row row) {
        PageData pageData;
        int n;
        while ((n = (pageData = this.getPage(this.rootPageId, 0)).addRowTry(row)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("{0} split", this);
            }
            long l = n == 0 ? row.getKey() : pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n2 = this.store.allocatePage();
            pageData2.setPageId(n2);
            pageData2.setParentPageId(this.rootPageId);
            pageData3.setParentPageId(this.rootPageId);
            PageDataNode pageDataNode = PageDataNode.create(this, this.rootPageId, 0);
            pageDataNode.init(pageData2, l, pageData3);
            this.store.update(pageData2);
            this.store.update(pageData3);
            this.store.update(pageDataNode);
            pageData = pageDataNode;
        }
        row.setDeleted(false);
        if (this.multiVersion) {
            boolean bl;
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(bl = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        this.invalidateRowCount();
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageDataOverflow getPageOverflow(int n) {
        Page page = this.store.getPage(n);
        if (page instanceof PageDataOverflow) {
            return (PageDataOverflow)page;
        }
        throw DbException.get(90030, page == null ? "null" : page.toString());
    }

    PageData getPage(int n, int n2) {
        Page page = this.store.getPage(n);
        if (page == null) {
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, n, n2);
            this.store.logUndo(pageDataLeaf, null);
            this.store.update(pageDataLeaf);
            return pageDataLeaf;
        }
        if (!(page instanceof PageData)) {
            throw DbException.get(90030, "" + page);
        }
        PageData pageData = (PageData)page;
        if (n2 != -1 && pageData.getParentPageId() != n2) {
            throw DbException.throwInternalError(pageData + " parent " + pageData.getParentPageId() + " expected " + n2);
        }
        return pageData;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    long getKey(SearchRow searchRow, long l, long l2) {
        if (searchRow == null) {
            return l;
        }
        Value value = searchRow.getValue(this.mainIndexColumn);
        if (value == null) {
            throw DbException.throwInternalError(searchRow.toString());
        }
        if (value == ValueNull.INSTANCE) {
            return l2;
        }
        return value.getLong();
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l = searchRow == null ? Long.MIN_VALUE : searchRow.getKey();
        long l2 = searchRow2 == null ? Long.MAX_VALUE : searchRow2.getKey();
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, l, l2, this.isMultiVersion);
    }

    Cursor find(Session session, long l, long l2, boolean bl) {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, l, l2, bl);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.throwInternalError();
    }

    long getLastKey() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getLastKey();
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        long l = 10L * (this.tableData.getRowCountApproximation() + 1000L);
        return l;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row) {
        Object object;
        int n;
        if (this.tableData.getContainsLargeObject()) {
            int n2 = row.getColumnCount();
            for (n = 0; n < n2; ++n) {
                object = row.getValue(n);
                if (!((Value)object).isLinked()) continue;
                session.unlinkAtCommit((Value)object);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row);
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            try {
                long l = row.getKey();
                object = this.getPage(this.rootPageId, 0);
                ((PageData)object).remove(l);
                this.invalidateRowCount();
                --this.rowCount;
            }
            finally {
                this.store.incrementChangeCount();
            }
        }
        if (this.multiVersion) {
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    @Override
    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove", this);
        }
        this.removeAllRows();
        this.store.free(this.rootPageId);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} truncate", this);
        }
        this.store.logTruncate(session, this.tableData.getId());
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        if (this.multiVersion) {
            this.sessionRowCount.clear();
        }
        this.tableData.setRowCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllRows() {
        try {
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.freeRecursive();
            pageData = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.removeRecord(this.rootPageId);
            this.store.update(pageData);
            this.rowCount = 0L;
            this.lastKey = 0L;
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("PAGE");
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.getRowWithKey(l);
    }

    public Row getRowWithKey(long l) {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getRowWithKey(l);
    }

    PageStore getPageStore() {
        return this.store;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.multiVersion) {
            Integer n = this.sessionRowCount.get(session.getId());
            long l = n == null ? 0L : (long)n.intValue();
            l += this.rowCount;
            return l -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public int getColumnIndex(Column column) {
        return -1;
    }

    @Override
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} close", this);
        }
        if (this.delta != null) {
            this.delta.clear();
        }
        this.rowCountDiff = 0;
        if (this.sessionRowCount != null) {
            this.sessionRowCount.clear();
        }
        this.writeRowCount();
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.delta.iterator();
    }

    private void incrementRowCount(int n, int n2) {
        if (this.multiVersion) {
            Integer n3 = n;
            Integer n4 = this.sessionRowCount.get(n3);
            int n5 = n4 == null ? 0 : n4;
            this.sessionRowCount.put(n3, n5 + n2);
            this.rowCountDiff += n2;
        }
    }

    @Override
    public void commit(int n, Row row) {
        if (this.multiVersion) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n == 1 ? 1 : -1);
        }
    }

    void setRootPageId(Session session, int n) {
        this.store.removeMeta(this, session);
        this.rootPageId = n;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void invalidateRowCount() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        pageData.setRowCountStored(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRowCount() {
        try {
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }

    int getMemoryPerPage() {
        return this.memoryPerPage;
    }

    void memoryChange(int n) {
        this.memoryPerPage = this.memoryCount < 64 ? (this.memoryPerPage += (n - this.memoryPerPage) / ++this.memoryCount) : (this.memoryPerPage += (n > this.memoryPerPage ? 1 : -1) + (n - this.memoryPerPage) / 64);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }
}

