/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.LogRecord;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.storage.csv.FeatureIterator;
import org.apache.sis.internal.storage.csv.FixedSizeList;
import org.apache.sis.internal.storage.csv.MovingFeatureBuilder;
import org.apache.sis.internal.storage.csv.Store;

final class MovingFeatureIterator
extends FeatureIterator
implements Consumer<LogRecord> {
    private String identifier;
    private MovingFeatureBuilder builder;
    private final Map<String, MovingFeatureBuilder> builders = new LinkedHashMap<String, MovingFeatureBuilder>();

    MovingFeatureIterator(Store store) {
        super(store);
    }

    AbstractFeature[] createMovingFeatures() {
        int n = 0;
        int n2 = this.values.length - 3;
        AbstractFeature[] abstractFeatureArray = new AbstractFeature[this.builders.size()];
        for (Map.Entry<String, MovingFeatureBuilder> entry : this.builders.entrySet()) {
            abstractFeatureArray[n++] = this.createMovingFeature(entry.getKey(), entry.getValue(), n2);
        }
        return abstractFeatureArray;
    }

    private AbstractFeature createMovingFeature(String string, MovingFeatureBuilder movingFeatureBuilder, int n) {
        AbstractFeature abstractFeature = this.store.featureType.newInstance();
        abstractFeature.setPropertyValue(this.propertyNames[0], string);
        movingFeatureBuilder.storeTimeRange(this.propertyNames[1], this.propertyNames[2], abstractFeature);
        int n2 = 0;
        if (this.store.hasTrajectories()) {
            movingFeatureBuilder.storeGeometry(string, n2, this.store.spatialDimensionCount(), this.store.geometries, (AbstractAttribute)abstractFeature.getProperty(this.propertyNames[3]), this);
            ++n2;
        }
        while (n2 < n) {
            movingFeatureBuilder.storeAttribute(n2, (AbstractAttribute)abstractFeature.getProperty(this.propertyNames[3 + n2]));
            ++n2;
        }
        return abstractFeature;
    }

    boolean readMoving(Consumer<? super AbstractFeature> consumer, boolean bl) throws IOException {
        String string2;
        FixedSizeList fixedSizeList = new FixedSizeList(this.values);
        int n = this.values.length - 3;
        while ((string2 = this.store.readLine()) != null) {
            Store.split(string2, fixedSizeList);
            int n2 = fixedSizeList.size();
            for (int i = 0; i < n2; ++i) {
                this.values[i] = this.converters[i].apply((String)this.values[i]);
            }
            String string3 = (String)this.values[0];
            long l = ((Instant)this.values[1]).toEpochMilli();
            long l2 = ((Instant)this.values[2]).toEpochMilli();
            String string4 = null;
            if (!string3.equals(this.identifier)) {
                string4 = this.identifier;
                this.identifier = string3;
                this.builder = this.builders.computeIfAbsent(string3, string -> new MovingFeatureBuilder(this.builder, n));
            }
            this.builder.addTimeRange(l, l2);
            for (int i = 0; i < n; ++i) {
                this.builder.addValue(i, l, l2, this.values[i + 3]);
            }
            if (string4 != null && consumer != null) {
                consumer.accept(this.createMovingFeature(string4, this.builders.remove(string4), n));
                if (!bl) {
                    return true;
                }
            }
            fixedSizeList.clear();
        }
        return false;
    }

    @Override
    public void accept(LogRecord logRecord) {
        this.store.log(logRecord);
    }
}

