/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.rocketchat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.notifications.rocketchat.RocketChatCredentials;
import org.apache.manifoldcf.crawler.notifications.rocketchat.RocketChatMessage;
import org.apache.manifoldcf.crawler.system.Logging;

public class RocketChatSession {
    private static String currentHost = null;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;
    private final String serverUrl;
    private final String user;
    private final String password;

    public RocketChatSession(String serverUrl, String user, String password, ProxySettings proxySettingsOrNull) throws ManifoldCFException {
        this.serverUrl = serverUrl.replaceAll("/$", "");
        this.user = user;
        this.password = password;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        int connectionTimeout = 60000;
        int socketTimeout = 900000;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
        if (proxySettingsOrNull != null) {
            this.addProxySettings(requestBuilder, proxySettingsOrNull);
        }
        SSLSocketFactory httpsSocketFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
        SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(httpsSocketFactory, (long)connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).setSSLSocketFactory((LayeredConnectionSocketFactory)myFactory).build();
    }

    private void addProxySettings(RequestConfig.Builder requestBuilder, ProxySettings proxySettingsOrNull) {
        if (proxySettingsOrNull.hasUsername()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxySettingsOrNull.getHost(), proxySettingsOrNull.getPort()), (Credentials)new NTCredentials(proxySettingsOrNull.getUsername(), proxySettingsOrNull.getPassword() == null ? "" : proxySettingsOrNull.getPassword(), currentHost, proxySettingsOrNull.getDomain() == null ? "" : proxySettingsOrNull.getDomain()));
        }
        HttpHost proxy = new HttpHost(proxySettingsOrNull.getHost(), proxySettingsOrNull.getPort());
        requestBuilder.setProxy(proxy);
    }

    public void checkConnection() throws IOException {
        Header[] authHeader = null;
        try {
            authHeader = this.login();
        }
        finally {
            if (authHeader != null) {
                this.logout(authHeader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(RocketChatMessage message) throws IOException {
        Header[] authHeader = null;
        try {
            authHeader = this.login();
            HttpPost messagePost = new HttpPost(this.serverUrl + "/api/v1/chat.postMessage");
            messagePost.setHeaders(authHeader);
            String json = this.objectMapper.writeValueAsString((Object)message);
            HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(json).build();
            messagePost.setEntity(entity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)messagePost);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 201) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                } else {
                    Logging.connectors.error((Object)("Sending Rocket.Chat message failed with statusline " + response.getStatusLine()));
                    Logging.connectors.error((Object)("  Response was: " + EntityUtils.toString((HttpEntity)response.getEntity())));
                }
            }
        }
        finally {
            if (authHeader != null) {
                this.logout(authHeader);
            }
        }
    }

    private Header[] login() throws IOException {
        HttpPost loginPost = new HttpPost(this.serverUrl + "/api/v1/login");
        RocketChatCredentials credentials = new RocketChatCredentials();
        credentials.setUser(this.user);
        credentials.setPassword(this.password);
        String json = this.objectMapper.writeValueAsString((Object)credentials);
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(json).build();
        loginPost.setEntity(entity);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)loginPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                JsonNode jsonResponse = this.objectMapper.readTree(response.getEntity().getContent());
                JsonNode dataNode = jsonResponse.get("data");
                if (dataNode != null) {
                    String authToken = dataNode.get("authToken").asText();
                    String userId = dataNode.get("userId").asText();
                    Header[] headerArray = new Header[]{new BasicHeader("X-Auth-Token", authToken), new BasicHeader("X-User-Id", userId)};
                    return headerArray;
                }
                Logging.connectors.error((Object)"The login returned OK, but the response did not contain any authentication data.");
                Logging.connectors.error((Object)("  Response was: " + this.objectMapper.writeValueAsString((Object)jsonResponse)));
                throw new ClientProtocolException("login response did not contain any authentication data");
            }
            Logging.connectors.error((Object)("Login to Rocket.Chat failed with statusline " + response.getStatusLine()));
            Logging.connectors.error((Object)("  Response was: " + EntityUtils.toString((HttpEntity)response.getEntity())));
            throw new HttpResponseException(statusCode, response.getStatusLine().getReasonPhrase());
        }
    }

    private void logout(Header[] authHeader) throws IOException {
        HttpGet logoutGet = new HttpGet(this.serverUrl + "/api/v1/logout");
        logoutGet.setHeaders(authHeader);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)logoutGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Logging.connectors.error((Object)("Logout from Rocket.Chat failed with statusline " + response.getStatusLine()));
                Logging.connectors.error((Object)("  Response was: " + EntityUtils.toString((HttpEntity)response.getEntity())));
            }
        }
    }

    public void close() throws IOException {
        this.httpClient.close();
        this.httpClient = null;
        this.objectMapper = null;
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static final class ProxySettings {
        private String host;
        private int port = -1;
        private String username;
        private String password;
        private String domain;

        public ProxySettings(String host, String portString, String username, String password, String domain) {
            this.host = host;
            if (StringUtils.isNotEmpty((String)portString)) {
                try {
                    this.port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    Logging.connectors.warn((Object)("Proxy port must be an number. Found " + portString));
                }
            }
            this.username = username;
            this.password = password;
            this.domain = domain;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean hasUsername() {
            return StringUtils.isNotEmpty((String)this.username);
        }

        public String getPassword() {
            return this.password;
        }

        public String getDomain() {
            return this.domain;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProxySettings{");
            sb.append("host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
            sb.append(", username='").append(this.username).append('\'');
            sb.append(", password='").append(this.password).append('\'');
            sb.append(", domain='").append(this.domain).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

