/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.DCTM;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.common.DCTM.DocumentumException;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentum;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumFactory;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumObject;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumResult;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.DCTM.MatchMap;
import org.apache.manifoldcf.crawler.connectors.DCTM.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.ui.util.Encoder;

public class DCTM
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: DCTM.java 996524 2010-09-13 13:38:01Z kwright $";
    public static String CONFIG_PARAM_DOCBASE = "docbasename";
    public static String CONFIG_PARAM_USERNAME = "docbaseusername";
    public static String CONFIG_PARAM_PASSWORD = "docbasepassword";
    public static String CONFIG_PARAM_WEBTOPBASEURL = "webtopbaseurl";
    public static String CONFIG_PARAM_DOMAIN = "domain";
    public static String CONFIG_PARAM_LOCATION = "docbaselocation";
    public static String CONFIG_PARAM_OBJECTTYPE = "objecttype";
    public static String CONFIG_PARAM_ATTRIBUTENAME = "attrname";
    public static String CONFIG_PARAM_MAXLENGTH = "maxdoclength";
    public static String CONFIG_PARAM_FORMAT = "mimetype";
    public static String CONFIG_PARAM_FORMAT_ALL = "mimetypeall";
    public static String CONFIG_PARAM_PATHNAMEATTRIBUTE = "pathnameattribute";
    public static String CONFIG_PARAM_PATHMAP = "pathmap";
    public static String CONFIG_PARAM_FILTER = "filter";
    public static final String ACTIVITY_FETCH = "fetch";
    protected String docbaseName = null;
    protected String userName = null;
    protected String password = null;
    protected String domain = null;
    protected String webtopBaseURL = null;
    protected boolean hasSessionParameters = false;
    protected IDocumentum session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    private static final String denyToken = "DEAD_AUTHORITY";

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            if (this.docbaseName == null || this.docbaseName.length() < 1) {
                throw new ManifoldCFException("Parameter " + CONFIG_PARAM_DOCBASE + " required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("DCTM: Docbase = '" + this.docbaseName + "'"));
            }
            if (this.userName == null || this.userName.length() < 1) {
                throw new ManifoldCFException("Parameter " + CONFIG_PARAM_USERNAME + " required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("DCTM: Username = '" + this.userName + "'"));
            }
            if (this.password == null || this.password.length() < 1) {
                throw new ManifoldCFException("Parameter " + CONFIG_PARAM_PASSWORD + " required but not set");
            }
            Logging.connectors.debug((Object)"DCTM: Password exists");
            if (this.webtopBaseURL == null || this.webtopBaseURL.length() < 1) {
                throw new ManifoldCFException("Required parameter " + CONFIG_PARAM_WEBTOPBASEURL + " missing");
            }
            if (this.domain == null) {
                Logging.connectors.debug((Object)"DCTM: No domain");
            } else {
                Logging.connectors.debug((Object)("DCTM: Domain = '" + this.domain + "'"));
            }
            this.hasSessionParameters = true;
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        this.getSessionParameters();
        if (this.session == null) {
            GetSessionThread t = new GetSessionThread();
            t.start();
            try {
                t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (MalformedURLException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            catch (NotBoundException e) {
                Logging.connectors.warn((Object)("DCTM: RMI server not up at the moment: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                Logging.connectors.warn((Object)("DCTM: Transient remote exception creating session: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    Logging.connectors.warn((Object)("DCTM: Remote service interruption creating session: " + e.getMessage()), (Throwable)e);
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
                }
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    protected List<String> getAttributesForType(String typeName) throws DocumentumException, ManifoldCFException, ServiceInterruption {
        String strDQL = "select distinct attr_name FROM dmi_dd_attr_info where type_name = '" + typeName + "'";
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            GetListOfValuesThread t = new GetListOfValuesThread(strDQL, "attr_name");
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected void checkConnection() throws DocumentumException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            CheckConnectionThread t = new CheckConnectionThread();
            t.start();
            try {
                t.finishUp();
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected String buildDateString(long timevalue) throws DocumentumException, ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            BuildDateStringThread t = new BuildDateStringThread(timevalue);
            t.start();
            try {
                return t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            t.start();
            try {
                t.finishUp();
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    Logging.connectors.warn((Object)("Remote service interruption closing session: " + e.getMessage()), (Throwable)e);
                }
                Logging.connectors.warn((Object)("Error closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public int getConnectorModel() {
        return 1;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH};
    }

    public String check() throws ManifoldCFException {
        try {
            try {
                this.checkConnection();
                return super.check();
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    throw new ServiceInterruption(e.getMessage(), 0L);
                }
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.docbaseName = this.params.getParameter(CONFIG_PARAM_DOCBASE);
        this.userName = this.params.getParameter(CONFIG_PARAM_USERNAME);
        this.password = this.params.getObfuscatedParameter(CONFIG_PARAM_PASSWORD);
        this.webtopBaseURL = this.params.getParameter(CONFIG_PARAM_WEBTOPBASEURL);
        this.domain = this.params.getParameter(CONFIG_PARAM_DOMAIN);
        if (this.domain == null || this.domain.length() < 1) {
            this.domain = null;
        }
    }

    public void poll() throws ManifoldCFException {
        this.releaseCheck();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        if (this.session != null) {
            DestroySessionThread t = new DestroySessionThread();
            t.start();
            try {
                t.finishUp();
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("DCTM: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    Logging.connectors.warn((Object)("DCTM: Remote service interruption closing session: " + e.getMessage()), (Throwable)e);
                }
                Logging.connectors.warn((Object)("DCTM: Error closing session: " + e.getMessage()), (Throwable)e);
            }
        }
        this.docbaseName = null;
        this.userName = null;
        this.password = null;
        this.domain = null;
        this.webtopBaseURL = null;
    }

    protected String convertToURI(String strObjectId, String objectType) throws ManifoldCFException {
        Object strWebtopBaseUrl = this.webtopBaseURL;
        if (!((String)strWebtopBaseUrl).endsWith("/")) {
            strWebtopBaseUrl = (String)strWebtopBaseUrl + "/";
        }
        return (String)strWebtopBaseUrl + "component/drl?versionLabel=CURRENT&objectId=" + strObjectId;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.docbaseName};
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.equals("contenttypes")) {
            try {
                String[] contentTypes = this.getContentTypes();
                int i = 0;
                while (i < contentTypes.length) {
                    String contentType = contentTypes[i++];
                    ConfigurationNode node = new ConfigurationNode("content_type");
                    node.setValue(contentType);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.equals("objecttypes")) {
            try {
                String[] objectTypes = this.getObjectTypes();
                int i = 0;
                while (i < objectTypes.length) {
                    String objectType = objectTypes[i++];
                    ConfigurationNode node = new ConfigurationNode("object_type");
                    node.setValue(objectType);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("folders/")) {
            String parentFolder = command.substring("folders/".length());
            try {
                String[] folders = this.getChildFolderNames(parentFolder);
                int i = 0;
                while (i < folders.length) {
                    String folder = folders[i++];
                    ConfigurationNode node = new ConfigurationNode("folder");
                    node.setValue(folder);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("indexableattributes/")) {
            String objectType = command.substring("indexableattributes/".length());
            try {
                String[] indexableAttributes = this.getIngestableAttributes(objectType);
                int i = 0;
                while (i < indexableAttributes.length) {
                    String indexableAttribute = indexableAttributes[i++];
                    ConfigurationNode node = new ConfigurationNode("attribute");
                    node.setValue(indexableAttribute);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        StringBuilder strLocationsClause = new StringBuilder();
        HashMap tokenList = new HashMap();
        ArrayList<String> contentList = null;
        boolean seenAllMimeTypes = false;
        boolean allMimeTypes = false;
        String maxSize = null;
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode n = spec.getChild(i);
            if (n.getType().equals(CONFIG_PARAM_LOCATION)) {
                String strLocation = n.getAttributeValue("path");
                if (strLocation == null || strLocation.length() <= 0) continue;
                if (strLocationsClause != null && strLocationsClause.length() > 0) {
                    strLocationsClause.append(" OR Folder('").append(strLocation).append("', DESCEND)");
                    continue;
                }
                strLocationsClause.append("Folder('").append(strLocation).append("', DESCEND)");
                continue;
            }
            if (n.getType().equals(CONFIG_PARAM_OBJECTTYPE)) {
                String objType = n.getAttributeValue("token");
                HashMap filters = (HashMap)tokenList.get(objType);
                if (filters == null) {
                    filters = new HashMap();
                    tokenList.put(objType, filters);
                }
                for (int j = 0; j < n.getChildCount(); ++j) {
                    HashSet<String> values;
                    SpecificationNode sn = n.getChild(j);
                    if (!sn.getType().equals(CONFIG_PARAM_FILTER)) continue;
                    String attributeName = sn.getAttributeValue("name");
                    String operation = sn.getAttributeValue("op");
                    String value = sn.getAttributeValue("value");
                    HashMap<String, HashSet<String>> operations = (HashMap<String, HashSet<String>>)filters.get(attributeName);
                    if (operations == null) {
                        operations = new HashMap<String, HashSet<String>>();
                        filters.put(attributeName, operations);
                    }
                    if ((values = (HashSet<String>)operations.get(operation)) == null) {
                        values = new HashSet<String>();
                        operations.put(operation, values);
                    }
                    values.add(value);
                }
                continue;
            }
            if (n.getType().equals(CONFIG_PARAM_FORMAT_ALL)) {
                seenAllMimeTypes = true;
                String all = n.getAttributeValue("value");
                if (!all.equals("true")) continue;
                allMimeTypes = true;
                continue;
            }
            if (n.getType().equals(CONFIG_PARAM_FORMAT)) {
                seenAllMimeTypes = true;
                String docType = n.getAttributeValue("value");
                if (contentList == null) {
                    contentList = new ArrayList<String>();
                }
                contentList.add(docType);
                continue;
            }
            if (!n.getType().equals(CONFIG_PARAM_MAXLENGTH)) continue;
            maxSize = n.getAttributeValue("value");
        }
        if (tokenList.size() == 0) {
            Logging.connectors.debug((Object)"DCTM: No ObjectType found in Document Spec. Setting it to dm_document");
            tokenList.put("dm_document", new HashMap());
        }
        if (strLocationsClause.length() < 1) {
            Logging.connectors.debug((Object)"DCTM: No location found in document specification. Search will be across entire docbase");
        }
        try {
            String strDQLstart = "select for READ distinct i_chronicle_id from ";
            startTime = startTime > 300000L ? (startTime -= 300000L) : 0L;
            StringBuilder strDQLend = new StringBuilder(" where r_modify_date >= " + this.buildDateString(startTime) + " and r_modify_date<=" + this.buildDateString(seedTime) + " AND (i_is_deleted=TRUE Or (i_is_deleted=FALSE AND a_full_text=TRUE AND r_content_size>=0");
            if (maxSize != null && maxSize.length() > 0) {
                strDQLend.append(" AND r_content_size<=").append(maxSize);
            }
            if (seenAllMimeTypes && !allMimeTypes) {
                String[] dctmTypes = DCTM.convertToDCTMTypes(contentList);
                if (dctmTypes == null || dctmTypes.length == 0) {
                    strDQLend.append(" AND 1<0");
                } else {
                    strDQLend.append(" AND a_content_type IN (");
                    boolean commaNeeded = false;
                    for (String cType : dctmTypes) {
                        if (commaNeeded) {
                            strDQLend.append(",");
                        } else {
                            commaNeeded = true;
                        }
                        strDQLend.append(DCTM.quoteDQLString(cType));
                    }
                    strDQLend.append(")");
                }
            }
            strDQLend.append("))");
            if (strLocationsClause.length() > 0) {
                strDQLend.append(" AND ( " + strLocationsClause.toString() + " )");
            }
            block12: for (String tokenValue : tokenList.keySet()) {
                activities.checkJobStillActive();
                Map filters = (Map)tokenList.get(tokenValue);
                StringBuilder filterPart = new StringBuilder();
                for (String attributeName : filters.keySet()) {
                    Map operations = (Map)filters.get(attributeName);
                    for (String operation : operations.keySet()) {
                        Set values = (Set)operations.get(operation);
                        if (operation.equals("=")) {
                            filterPart.append(" AND \"").append(attributeName).append("\"").append(" IN (");
                            boolean commaNeeded = false;
                            for (String value : values) {
                                if (commaNeeded) {
                                    filterPart.append(",");
                                } else {
                                    commaNeeded = true;
                                }
                                filterPart.append(DCTM.quoteDQLString(value));
                            }
                            filterPart.append(")");
                            continue;
                        }
                        if (operation.equals("<>")) {
                            filterPart.append(" AND (");
                            boolean andNeeded = false;
                            for (String value : values) {
                                if (andNeeded) {
                                    filterPart.append(" AND ");
                                } else {
                                    andNeeded = true;
                                }
                                filterPart.append("\"").append(attributeName).append("\"").append("<>").append(DCTM.quoteDQLString(value));
                            }
                            filterPart.append(")");
                            continue;
                        }
                        throw new ManifoldCFException("Unrecognized operation: " + operation);
                    }
                }
                String strDQL = strDQLstart + tokenValue + strDQLend + filterPart;
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("DCTM: About to execute query= (" + strDQL + ")"));
                }
                while (true) {
                    boolean noSession = this.session == null;
                    this.getSession();
                    try {
                        StringQueue stringQueue = new StringQueue();
                        GetDocumentsFromQueryThread t = new GetDocumentsFromQueryThread(strDQL, stringQueue);
                        t.start();
                        try {
                            int checkIndex = 0;
                            while (true) {
                                if (checkIndex == 10) {
                                    activities.checkJobStillActive();
                                    checkIndex = 0;
                                }
                                ++checkIndex;
                                String next = stringQueue.getNext();
                                if (next == null) break;
                                activities.addSeedDocument(next);
                            }
                            t.finishUp();
                            continue block12;
                        }
                        catch (InterruptedException e) {
                            t.abort();
                            t.interrupt();
                            throw e;
                        }
                        catch (ManifoldCFException e) {
                            t.abort();
                            t.join();
                            throw e;
                        }
                        catch (ServiceInterruption e) {
                            t.abort();
                            t.join();
                            throw e;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RemoteException e) {
                        Throwable e2 = e.getCause();
                        if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                            throw new ManifoldCFException(e2.getMessage(), e2, 2);
                        }
                        if (noSession) {
                            long currentTime = System.currentTimeMillis();
                            throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                        }
                        this.session = null;
                        this.lastSessionFetch = -1L;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (DocumentumException e) {
            if (e.getType() == 0) {
                long currentTime = System.currentTimeMillis();
                Logging.connectors.warn((Object)("DCTM: Remote service interruption getting versions: " + e.getMessage()), (Throwable)e);
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        return new Long(seedTime).toString();
    }

    protected static String[] convertToDCTMTypes(List<String> contentList) throws ManifoldCFException, ServiceInterruption {
        if (contentList != null && contentList.size() > 0) {
            return contentList.toArray(new String[0]);
        }
        return null;
    }

    protected static String quoteDQLString(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            if (x == '\'') {
                sb.append("'");
            }
            sb.append(x);
        }
        sb.append("'");
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "DCTM.Docbase"));
        tabsArray.add(Messages.getString(locale, "DCTM.Webtop"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.docbasename.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.PleaseSupplyTheNameofaDocbase") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Docbase") + "\");\n    editconnection.docbasename.focus();\n    return false;\n  }\n  if (editconnection.docbaseusername.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.ConnectionRequiresValidDocumentumUsername") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Docbase") + "\");\n    editconnection.docbaseusername.focus();\n    return false;\n  }\n  if (editconnection.docbasepassword.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.ConnectionRequiresPassword") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Docbase") + "\");\n    editconnection.docbasepassword.focus();\n    return false;\n  }\n  if (editconnection.webtopbaseurl.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.SpecifyBaseWebtopURL") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Webtop") + "\");\n    editconnection.webtopbaseurl.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String webtopBaseUrl;
        String docbasePassword;
        String docbaseUserName;
        String docbaseName = parameters.getParameter(CONFIG_PARAM_DOCBASE);
        if (docbaseName == null) {
            docbaseName = "";
        }
        if ((docbaseUserName = parameters.getParameter(CONFIG_PARAM_USERNAME)) == null) {
            docbaseUserName = "";
        }
        docbasePassword = (docbasePassword = parameters.getObfuscatedParameter(CONFIG_PARAM_PASSWORD)) == null ? "" : out.mapPasswordToKey(docbasePassword);
        String docbaseDomain = parameters.getParameter(CONFIG_PARAM_DOMAIN);
        if (docbaseDomain == null) {
            docbaseDomain = "";
        }
        if ((webtopBaseUrl = parameters.getParameter(CONFIG_PARAM_WEBTOPBASEURL)) == null) {
            webtopBaseUrl = "http://localhost/webtop/";
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.Docbase"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbaseName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"docbasename\" value=\"" + Encoder.attributeEscape((String)docbaseName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbaseUserName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"docbaseusername\" value=\"" + Encoder.attributeEscape((String)docbaseUserName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbasePassword") + "</nobr></td><td class=\"value\"><input type=\"password\" size=\"32\" name=\"docbasepassword\" value=\"" + Encoder.attributeEscape((String)docbasePassword) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbaseDomain") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"docbasedomain\" value=\"" + Encoder.attributeEscape((String)docbaseDomain) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"docbasename\" value=\"" + Encoder.attributeEscape((String)docbaseName) + "\"/>\n<input type=\"hidden\" name=\"docbaseusername\" value=\"" + Encoder.attributeEscape((String)docbaseUserName) + "\"/>\n<input type=\"hidden\" name=\"docbasepassword\" value=\"" + Encoder.attributeEscape((String)docbasePassword) + "\"/>\n<input type=\"hidden\" name=\"docbasedomain\" value=\"" + Encoder.attributeEscape((String)docbaseDomain) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.Webtop"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.WebtopBaseURL") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"webtopbaseurl\" value=\"" + Encoder.attributeEscape((String)webtopBaseUrl) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"webtopbaseurl\" value=\"" + Encoder.attributeEscape((String)webtopBaseUrl) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String webtopBaseUrl;
        String docbaseDomain;
        String docbasePassword;
        String docbaseUserName;
        String docbaseName = variableContext.getParameter("docbasename");
        if (docbaseName != null) {
            parameters.setParameter(CONFIG_PARAM_DOCBASE, docbaseName);
        }
        if ((docbaseUserName = variableContext.getParameter("docbaseusername")) != null) {
            parameters.setParameter(CONFIG_PARAM_USERNAME, docbaseUserName);
        }
        if ((docbasePassword = variableContext.getParameter("docbasepassword")) != null) {
            parameters.setObfuscatedParameter(CONFIG_PARAM_PASSWORD, variableContext.mapKeyToPassword(docbasePassword));
        }
        if ((docbaseDomain = variableContext.getParameter("docbasedomain")) != null) {
            parameters.setParameter(CONFIG_PARAM_DOMAIN, docbaseDomain);
        }
        if ((webtopBaseUrl = variableContext.getParameter("webtopbaseurl")) != null) {
            parameters.setParameter(CONFIG_PARAM_WEBTOPBASEURL, webtopBaseUrl);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "DCTM.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        tabsArray.add(Messages.getString(locale, "DCTM.Paths"));
        tabsArray.add(Messages.getString(locale, "DCTM.DocumentTypes"));
        tabsArray.add(Messages.getString(locale, "DCTM.ContentTypes"));
        tabsArray.add(Messages.getString(locale, "DCTM.ContentLength"));
        tabsArray.add(Messages.getString(locale, "DCTM.Security"));
        tabsArray.add(Messages.getString(locale, "DCTM.PathMetadata"));
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "checkSpecification()\n{\n  if (editjob." + seqPrefix + "specmaxdoclength.value != \"\" && !isInteger(editjob." + seqPrefix + "specmaxdoclength.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.MaximumDocumentLengthMustBeNullOrAnInteger") + "\");\n    editjob." + seqPrefix + "specmaxdoclength.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction " + seqPrefix + "DeleteFilter(k,l)\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "filter_\"+k+\"_\"+l+\"_op\",\"Delete\",\"" + seqPrefix + "filter_\"+k+\"_\"+l);\n}\n\nfunction " + seqPrefix + "AddFilter(k,l)\n{\n  if (eval(\"editjob." + seqPrefix + "filter_\"+k+\"_name.value == \\\"\\\"\"))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.SelectAnAttributeFirst") + "\");\n    eval(\"editjob." + seqPrefix + "filter_\"+k+\"_name.focus()\");\n    return;\n  }\n\n  if (eval(\"editjob." + seqPrefix + "filter_\"+k+\"_operation.value == \\\"\\\"\"))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.SelectAnOperation") + "\");\n    eval(\"editjob." + seqPrefix + "filter_\"+k+\"_operation.focus()\");\n    return;\n  }\n\n  if (eval(\"editjob." + seqPrefix + "filter_\"+k+\"_value.value == \\\"\\\"\"))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.FilterMustHaveValue") + "\");\n    eval(\"editjob." + seqPrefix + "filter_\"+k+\"_value.focus()\");\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "filter_\"+k+\"_op\",\"Add\",\"" + seqPrefix + "filter_\"+k+\"_\"+l);\n}\n\nfunction " + seqPrefix + "SpecAddToPath(anchorvalue)\n{\n  if (editjob." + seqPrefix + "pathaddon.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.SelectAFolderFirst") + "\");\n    editjob." + seqPrefix + "pathaddon.focus();\n    return;\n  }\n\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"AddToPath\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddToken(anchorvalue)\n{\n  if (editjob." + seqPrefix + "spectoken.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.NullTokensNotAllowed") + "\");\n    editjob." + seqPrefix + "spectoken.focus();\n    return;\n  }\n\n  " + seqPrefix + "SpecOp(\"accessop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddMapping(anchorvalue)\n{\n  if (editjob." + seqPrefix + "specmatch.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.EnterASpecificationFirst") + "\");\n    editjob." + seqPrefix + "specmatch.focus();\n    return;\n  }\n  if (!isRegularExpression(editjob." + seqPrefix + "specmatch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.SpecificationMustBeValidRegularExpression") + "\");\n    editjob." + seqPrefix + "specmatch.focus();\n    return false;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specmappingop\",\"Add\",anchorvalue);\n  }\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String matchString;
        int i;
        String accessDescription;
        int i2;
        String pathName;
        SpecificationNode sn;
        int k;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (tabName.equals(Messages.getString(locale, "DCTM.Paths")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            k = 0;
            for (int i3 = 0; i3 < ds.getChildCount(); ++i3) {
                sn = ds.getChild(i3);
                if (!sn.getType().equals(CONFIG_PARAM_LOCATION)) continue;
                String pathDescription = "_" + Integer.toString(k);
                pathName = seqPrefix + "specpath" + pathDescription;
                String pathOpName = seqPrefix + "pathop" + pathDescription;
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + (String)pathName + "\" value=\"" + sn.getAttributeValue("path") + "\"/>\n      <input type=\"hidden\" name=\"" + pathOpName + "\" value=\"\"/>\n      <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Delete\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "DCTM.DeletePath") + Integer.toString(k) + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)sn.getAttributeValue("path")) + "\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "DCTM.NoSpecificCabinetFolderPathsGiven") + "</td>\n  </tr>\n");
            }
            out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
            String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
            if (pathSoFar == null) {
                pathSoFar = "/";
            }
            try {
                String[] childList = this.getChildFolderNames(pathSoFar);
                if (childList == null && (childList = this.getChildFolderNames(pathSoFar = "/")) == null) {
                    throw new ManifoldCFException("Can't find any children for root folder");
                }
                out.print("      <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n        <input type=\"hidden\" name=\"" + seqPrefix + "specpath\" value=\"" + Encoder.attributeEscape((String)pathSoFar) + "\"/>\n        <input type=\"hidden\" name=\"" + seqPrefix + "pathop\" value=\"\"/>\n        <input type=\"button\" value=\"Add\" alt=\"" + Messages.getAttributeString(locale, "DCTM.AddPath") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"Add\",\"" + seqPrefix + "path_" + Integer.toString(k + 1) + "\")'/>&nbsp;\n      </a>\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)pathSoFar) + "\n");
                if (pathSoFar.length() > 1) {
                    out.print("      <input type=\"button\" value=\"-\" alt=\"" + Messages.getAttributeString(locale, "DCTM.RemoveFromPath") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"Up\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>\n");
                }
                if (childList.length > 0) {
                    out.print("      <input type=\"button\" value=\"+\" alt=\"" + Messages.getAttributeString(locale, "DCTM.AddToPath") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToPath(\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>&nbsp;\n      <select multiple=\"false\" name=\"" + seqPrefix + "pathaddon\" size=\"2\">\n        <option value=\"\" selected=\"selected\">" + Messages.getBodyString(locale, "DCTM.PickAFolder") + "</option>\n");
                    for (int j = 0; j < childList.length; ++j) {
                        out.print("        <option value=\"" + Encoder.attributeEscape((String)childList[j]) + "\">" + Encoder.bodyEscape((String)childList[j]) + "</option>\n");
                    }
                    out.print("      </select>\n");
                }
            }
            catch (ManifoldCFException e) {
                out.println(Encoder.bodyEscape((String)e.getMessage()));
            }
            catch (ServiceInterruption e) {
                out.println("Service interruption or invalid credentials - check your repository connection: " + e.getMessage());
            }
            out.print("    </td>\n  </tr>\n</table>\n");
        } else {
            k = 0;
            for (int i4 = 0; i4 < ds.getChildCount(); ++i4) {
                sn = ds.getChild(i4);
                if (!sn.getType().equals(CONFIG_PARAM_LOCATION)) continue;
                String pathDescription = "_" + Integer.toString(k);
                pathName = seqPrefix + "specpath" + pathDescription;
                out.print("<input type=\"hidden\" name=\"" + pathName + "\" value=\"" + sn.getAttributeValue("path") + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        boolean securityOn = true;
        for (i2 = 0; i2 < ds.getChildCount(); ++i2) {
            SpecificationNode sn2 = ds.getChild(i2);
            if (!sn2.getType().equals("security")) continue;
            String securityValue = sn2.getAttributeValue("value");
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.Security2") + "</nobr></td>\n    <td class=\"value\" colspan=\"1\">\n      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"on\" " + (securityOn ? "checked=\"true\"" : "") + " />Enabled&nbsp;\n      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"off\" " + (!securityOn ? "checked=\"true\"" : "") + " />Disabled\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            k = 0;
            for (i2 = 0; i2 < ds.getChildCount(); ++i2) {
                SpecificationNode sn3 = ds.getChild(i2);
                if (!sn3.getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + (String)accessDescription;
                String accessTokenName = seqPrefix + "spectoken" + (String)accessDescription;
                String token = sn3.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n      <input type=\"hidden\" name=\"" + accessTokenName + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" alt=\"" + Messages.getAttributeString(locale, "DCTM.DeleteAccessToken") + Integer.toString(k) + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")'/>\n      </a>\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)token) + "\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "DCTM.NoAccessTokensPresent") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Add\" alt=\"" + Messages.getAttributeString(locale, "DCTM.AddAccessToken") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")'/>\n      </a>\n    </td>\n    <td class=\"value\">\n      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specsecurity\" value=\"" + (securityOn ? "on" : "off") + "\"/>\n");
            k = 0;
            for (i2 = 0; i2 < ds.getChildCount(); ++i2) {
                SpecificationNode sn4 = ds.getChild(i2);
                if (!sn4.getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String token = sn4.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        HashMap<String, Serializable> dtMetadata = new HashMap<String, Serializable>();
        HashMap dtFilters = new HashMap();
        for (int i5 = 0; i5 < ds.getChildCount(); ++i5) {
            SpecificationNode dsn;
            int kk;
            String token;
            String[] sn5 = ds.getChild(i5);
            if (!sn5.getType().equals(CONFIG_PARAM_OBJECTTYPE) || (token = sn5.getAttributeValue("token")) == null || token.length() <= 0) continue;
            String isAllString = sn5.getAttributeValue("all");
            if (isAllString != null && isAllString.equals("true")) {
                dtMetadata.put(token, new Boolean(true));
            } else {
                HashSet<String> attrMap = new HashSet<String>();
                for (kk = 0; kk < sn5.getChildCount(); ++kk) {
                    dsn = sn5.getChild(kk);
                    if (!dsn.getType().equals(CONFIG_PARAM_ATTRIBUTENAME)) continue;
                    String attr = dsn.getAttributeValue("attrname");
                    attrMap.add(attr);
                }
                dtMetadata.put(token, attrMap);
            }
            HashMap<String, Object[]> filterInfo = new HashMap<String, Object[]>();
            for (kk = 0; kk < sn5.getChildCount(); ++kk) {
                String[] filterValues;
                dsn = sn5.getChild(kk);
                if (!dsn.getType().equals(CONFIG_PARAM_FILTER)) continue;
                String name = dsn.getAttributeValue("name");
                String op = dsn.getAttributeValue("op");
                String value = dsn.getAttributeValue("value");
                Object[] filters = (Object[])filterInfo.get(name);
                if (filters == null) {
                    filters = new HashMap();
                    filterInfo.put(name, filters);
                }
                if ((filterValues = (String[])filters.get(op)) == null) {
                    filterValues = new HashSet();
                    filters.put(op, filterValues);
                }
                filterValues.add(value);
            }
            dtFilters.put(token, filterInfo);
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.DocumentTypes")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            try {
                String[] strarrObjTypes;
                out.print("  <tr>\n    <td class=\"boxcell\" colspan=\"2\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "filter_op\" value=\"Continue\"/>\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocumentType") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Filters") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.AllMetadataQ") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.SpecificMetadata") + "</nobr></td>\n        </tr>\n");
                k = 0;
                for (String strObjectType : strarrObjTypes = this.getObjectTypes()) {
                    if (strObjectType == null || strObjectType.length() <= 0) continue;
                    String[] values = this.getIngestableAttributes(strObjectType);
                    out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <input type=\"hidden\" name=\"" + seqPrefix + "datatype_" + k + "\" value=\"" + Encoder.attributeEscape((String)strObjectType) + "\"/>\n");
                    Object o = dtMetadata.get(strObjectType);
                    if (o == null) {
                        out.print("            <input type=\"checkbox\" name=\"" + seqPrefix + "specfiletype\" value=\"" + Encoder.attributeEscape((String)strObjectType) + "\">" + Encoder.bodyEscape((String)strObjectType) + "</input>\n");
                    } else {
                        out.print("            <input type=\"checkbox\" name=\"" + seqPrefix + "specfiletype\" checked=\"\" value=\"" + Encoder.attributeEscape((String)strObjectType) + "\">" + Encoder.bodyEscape((String)strObjectType) + "</input>\n");
                    }
                    out.print("          </td>\n          <td class=\"boxcell\">\n            <input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_op\" value=\"Continue\"/>\n            <table class=\"formtable\">\n              <tr class=\"formheaderrow\">\n                <td class=\"formcolumnheader\"></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.AttributeName") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Operation") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Value") + "</nobr></td>\n              </tr>\n");
                    Map currentFilters = (Map)dtFilters.get(strObjectType);
                    int l = 0;
                    if (currentFilters != null) {
                        Object[] filterAttributes = currentFilters.keySet().toArray(new String[0]);
                        Arrays.sort(filterAttributes);
                        for (Object filterAttribute : filterAttributes) {
                            Map filters = (Map)currentFilters.get(filterAttribute);
                            Object[] sortedOperations = filters.keySet().toArray(new String[0]);
                            Arrays.sort(sortedOperations);
                            for (Object filterOperation : sortedOperations) {
                                Set filterValues = (Set)filters.get(filterOperation);
                                Object[] sortedValues = filterValues.toArray(new String[0]);
                                Arrays.sort(sortedValues);
                                for (Object filterValue : sortedValues) {
                                    out.print("              <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n                <td class=\"formcolumncell\">\n                  <input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_op\" value=\"Continue\"/>\n                  <input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_name\" value=\"" + Encoder.attributeEscape((String)filterAttribute) + "\"/>\n                  <input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_operation\" value=\"" + Encoder.attributeEscape((String)filterOperation) + "\"/>\n                  <input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_value\" value=\"" + Encoder.attributeEscape((String)filterValue) + "\"/>\n                  <a name=\"" + seqPrefix + "filter_" + k + "_" + l + "\">\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "DCTM.Delete") + "\" alt=\"" + Messages.getAttributeString(locale, "DCTM.DeleteFilter") + "\" onclick='javascript:" + seqPrefix + "DeleteFilter(" + k + "," + l + ");'/>\n                  </a>\n                </td>\n                <td class=\"formcolumncell\">\n                  " + Encoder.bodyEscape((String)filterAttribute) + "\n                </td>\n                <td class=\"formcolumncell\">\n                  " + Encoder.bodyEscape((String)filterOperation) + "\n                </td>\n                <td class=\"formcolumncell\">\n                  " + Encoder.bodyEscape((String)filterValue) + "\n                </td>\n              </tr>\n");
                                    ++l;
                                }
                            }
                        }
                    }
                    if (l == 0) {
                        out.print("              <tr class=\"formrow\"><td colspan=\"4\" class=\"formcolumnmessage\"><nobr>" + Messages.getBodyString(locale, "DCTM.NoAttributeFiltersSpecified") + "</nobr></td></tr>\n");
                    }
                    out.print("              <tr class=\"formrow\"><td colspan=\"4\" class=\"formseparator\"><hr/></td></tr>\n              <tr class=\"formrow\">\n                <td class=\"formcolumncell\">\n                  <a name=\"" + seqPrefix + "filter_" + k + "_" + l + "\">\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "DCTM.Add") + "\" alt=\"" + Messages.getAttributeString(locale, "DCTM.AddFilter") + "\" onclick='javascript:" + seqPrefix + "AddFilter(" + k + "," + l + ");'/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_count\" value=\"" + l + "\"/>\n                  </a>\n                </td>\n                <td class=\"formcolumncell\">\n                  <select multiple=\"false\" name=\"" + seqPrefix + "filter_" + k + "_name\" size=\"3\">\n                    <option value=\"\" selected=\"selected\">" + Messages.getBodyString(locale, "DCTM.PickAnAttribute") + "</option>\n");
                    for (String attributeName : values) {
                        out.print("                    <option value=\"" + Encoder.attributeEscape((String)attributeName) + "\">" + Encoder.bodyEscape((String)attributeName) + "</option>\n");
                    }
                    out.print("                  </select>\n                </td>\n                <td class=\"formcolumncell\">\n                  <select multiple=\"false\" name=\"" + seqPrefix + "filter_" + k + "_operation\" size=\"3\">\n                    <option value=\"\" selected=\"selected\">" + Messages.getBodyString(locale, "DCTM.PickAnOperation") + "</option>\n                    <option value=\"" + Encoder.attributeEscape((String)"=") + "\">" + Messages.getBodyString(locale, "DCTM.Equals") + "</option>\n                    <option value=\"" + Encoder.attributeEscape((String)"<>") + "\">" + Messages.getBodyString(locale, "DCTM.NotEquals") + "</option>\n                  </select>\n                </td>\n                <td class=\"formcolumncell\"><input type=\"text\" name=\"" + seqPrefix + "filter_" + k + "_value\" size=\"30\" value=\"\"/></td>\n              </tr>\n            </table>\n          </td>\n          <td class=\"formcolumncell\">\n");
                    boolean isAll = false;
                    HashSet attrMap = null;
                    if (o instanceof Boolean) {
                        isAll = (Boolean)o;
                        attrMap = new HashSet();
                    } else {
                        isAll = false;
                        attrMap = (HashSet)o;
                    }
                    out.print("            <input type=\"checkbox\" name=\"" + seqPrefix + "specfileallattrs_" + k + "\" value=\"true\" " + (isAll ? "checked=\"\"" : "") + "/>\n          </td>\n          <td class=\"formcolumncell\">\n            <select multiple=\"true\" name=\"" + seqPrefix + "specfileattrs_" + k + "\" size=\"3\">\n");
                    for (String option : values) {
                        if (attrMap != null && attrMap.contains(option)) {
                            out.print("              <option selected=\"\" value=\"" + Encoder.attributeEscape((String)option) + "\">" + Encoder.bodyEscape((String)option) + "</option>\n");
                            continue;
                        }
                        out.print("              <option value=\"" + Encoder.attributeEscape((String)option) + "\">" + Encoder.bodyEscape((String)option) + "</option>\n");
                    }
                    out.print("            </select>\n          </td>\n");
                    out.print("        </tr>\n");
                    ++k;
                }
                out.print("      </table>\n      <input type=\"hidden\" name=\"" + seqPrefix + "datatype_count\" value=\"" + k + "\"/>\n    </td>\n  </tr>\n");
            }
            catch (ManifoldCFException e) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">\n      " + Encoder.bodyEscape((String)e.getMessage()) + "\n    </td>\n  </tr>\n");
            }
            catch (ServiceInterruption e) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">\n\t\t" + Messages.getBodyString(locale, "DCTM.ServiceInterruptionOrInvalidCredentials") + "    </td>\n  </tr>\n");
            }
            out.print("</table>\n");
        } else {
            k = 0;
            for (String strObjectType : dtMetadata.keySet()) {
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "datatype_" + k + "\" value=\"" + Encoder.attributeEscape((String)strObjectType) + "\"/>\n");
                Map currentFilters = (Map)dtFilters.get(strObjectType);
                int l = 0;
                for (String filterAttribute : currentFilters.keySet()) {
                    Map filters = (Map)currentFilters.get(filterAttribute);
                    for (String filterOperation : filters.keySet()) {
                        Set filterValues = (Set)filters.get(filterOperation);
                        for (String filterValue : filterValues) {
                            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_name\" value=\"" + Encoder.attributeEscape((String)filterAttribute) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_operation\" value=\"" + Encoder.attributeEscape((String)filterOperation) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_" + l + "_value\" value=\"" + Encoder.attributeEscape((String)filterValue) + "\"/>\n");
                            ++l;
                        }
                    }
                }
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "filter_" + k + "_count\" value=\"" + l + "\"/>\n");
                Object o = dtMetadata.get(strObjectType);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfiletype\" value=\"" + Encoder.attributeEscape((String)strObjectType) + "\"/>\n");
                if (o instanceof Boolean) {
                    Boolean b = (Boolean)o;
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfileallattrs_" + k + "\" value=\"" + (b != false ? "true" : "false") + "\"/>\n");
                } else {
                    Set map = (Set)o;
                    for (String attrName : map) {
                        out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfileattrs_" + k + "\" value=\"" + Encoder.attributeEscape((String)attrName) + "\"/>\n");
                    }
                }
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "datatype_count\" value=\"" + k + "\"/>\n");
        }
        HashSet<String> ctMap = null;
        boolean seenAll = false;
        boolean doAll = false;
        for (int i6 = 0; i6 < ds.getChildCount(); ++i6) {
            String[] sn6 = ds.getChild(i6);
            if (sn6.getType().equals(CONFIG_PARAM_FORMAT)) {
                seenAll = true;
                String token = sn6.getAttributeValue("value");
                if (token == null || token.length() <= 0) continue;
                if (ctMap == null) {
                    ctMap = new HashSet<String>();
                }
                ctMap.add(token);
                continue;
            }
            if (!sn6.getType().equals(CONFIG_PARAM_FORMAT_ALL)) continue;
            seenAll = true;
            String value = sn6.getAttributeValue("value");
            if (!value.equals("true")) continue;
            doAll = true;
        }
        out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmimetype_posted\" value=\"true\"/>\n");
        if (tabName.equals(Messages.getString(locale, "DCTM.ContentTypes")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n");
            if (!seenAll || doAll) {
                out.print("      <input type=\"checkbox\" name=\"" + seqPrefix + "specmimetypeall\" checked=\"\" value=\"true\"></input>\n");
            } else {
                out.print("      <input type=\"checkbox\" name=\"" + seqPrefix + "specmimetypeall\" value=\"true\"></input>\n");
            }
            out.print("    </td>\n    <td class=\"value\">\n      " + Messages.getBodyString(locale, "DCTM.AllContentTypes") + "\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            try {
                String[] strarrMimeTypes;
                for (String strMimeType : strarrMimeTypes = this.getContentTypes()) {
                    if (strMimeType == null || strMimeType.length() <= 0) continue;
                    out.print("  <tr>\n    <td class=\"description\">\n");
                    if (ctMap != null && ctMap.contains(strMimeType)) {
                        out.print("      <input type=\"checkbox\" name=\"" + seqPrefix + "specmimetype\" checked=\"\" value=\"" + Encoder.attributeEscape((String)strMimeType) + "\"></input>\n");
                    } else {
                        out.print("      <input type=\"checkbox\" name=\"" + seqPrefix + "specmimetype\" value=\"" + Encoder.attributeEscape((String)strMimeType) + "\"></input>\n");
                    }
                    out.print("    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)strMimeType) + "\n    </td>\n  </tr>\n");
                }
            }
            catch (ManifoldCFException e) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">\n      " + Encoder.bodyEscape((String)e.getMessage()) + "\n    </td>\n  </tr>\n");
            }
            catch (ServiceInterruption e) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">\n\t\t" + Messages.getBodyString(locale, "DCTM.ServiceInterruptionOrInvalidCredentials") + "    </td>\n  </tr>\n");
            }
            out.print("</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmimetypeall\" value=\"" + (!seenAll || doAll ? "true" : "false") + "\"/>\n");
            if (ctMap != null) {
                for (String strMimeType : ctMap) {
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmimetype\" value=\"" + Encoder.attributeEscape((String)strMimeType) + "\"/>\n");
                }
            }
        }
        String maxDocLength = "";
        for (int i7 = 0; i7 < ds.getChildCount(); ++i7) {
            SpecificationNode sn7 = ds.getChild(i7);
            if (!sn7.getType().equals(CONFIG_PARAM_MAXLENGTH)) continue;
            maxDocLength = sn7.getAttributeValue("value");
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.ContentLength")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"separator\" colspan=\"2\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.ContentLength") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"" + seqPrefix + "specmaxdoclength\" type=\"text\" size=\"10\" value=\"" + maxDocLength + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmaxdoclength\" value=\"" + maxDocLength + "\"/>\n");
        }
        String pathNameAttribute = "";
        for (int i8 = 0; i8 < ds.getChildCount(); ++i8) {
            SpecificationNode sn8 = ds.getChild(i8);
            if (!sn8.getType().equals(CONFIG_PARAM_PATHNAMEATTRIBUTE)) continue;
            pathNameAttribute = sn8.getAttributeValue("value");
        }
        MatchMap matchMap = new MatchMap();
        for (i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn9 = ds.getChild(i);
            if (!sn9.getType().equals(CONFIG_PARAM_PATHMAP)) continue;
            String pathMatch = sn9.getAttributeValue("match");
            String pathReplace = sn9.getAttributeValue("replace");
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.PathMetadata")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmappingcount\" value=\"" + Integer.toString(matchMap.getMatchCount()) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specmappingop\" value=\"\"/>\n\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "DCTM.PathAttributeName") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n      <input type=\"text\" name=\"" + seqPrefix + "specpathnameattribute\" size=\"20\" value=\"" + Encoder.attributeEscape((String)pathNameAttribute) + "\"/>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("  <tr>\n    <td class=\"description\"><input type=\"hidden\" name=\"" + seqPrefix + "specmappingop_" + Integer.toString(i) + "\" value=\"\"/>\n      <a name=\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specmappingop_" + Integer.toString(i) + "\",\"" + Messages.getAttributeJavascriptString(locale, "DCTM.Delete") + "\",\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\")' alt=\"" + Messages.getAttributeString(locale, "DCTM.DeleteMapping") + Integer.toString(i) + "\" value=\"Delete\"/>\n      </a>\n    </td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>" + Encoder.bodyEscape((String)matchString) + "</td>\n    <td class=\"value\">==></td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>" + Encoder.bodyEscape((String)replaceString) + "</td>\n  </tr>\n");
            }
            if (matchMap.getMatchCount() == 0) {
                out.print("  <tr><td colspan=\"4\" class=\"message\">" + Messages.getBodyString(locale, "DCTM.NoMappingsSpecified") + "</td></tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\">\n      <a name=\"" + seqPrefix + "mapping_" + Integer.toString(matchMap.getMatchCount()) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecAddMapping(\"" + seqPrefix + "mapping_" + Integer.toString(matchMap.getMatchCount() + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "DCTM.AddToMappings") + "\" value=\"" + Messages.getAttributeString(locale, "DCTM.Add") + "\"/>\n      </a>\n    </td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "DCTM.MatchRegexp") + "&nbsp;<input type=\"text\" name=\"" + seqPrefix + "specmatch\" size=\"32\" value=\"\"/></td>\n    <td class=\"value\">==></td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "DCTM.ReplaceString") + "&nbsp;<input type=\"text\" name=\"" + seqPrefix + "specreplace\" size=\"32\" value=\"\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmappingcount\" value=\"" + Integer.toString(matchMap.getMatchCount()) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specpathnameattribute\" value=\"" + Encoder.attributeEscape((String)pathNameAttribute) + "\"/>\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>\n");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        SpecificationNode sn;
        String[] y;
        String op;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "pathcount");
        if (x != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i);
                if (sn2.getType().equals(CONFIG_PARAM_LOCATION)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int pathCount = Integer.parseInt(x);
            i = 0;
            while (i < pathCount) {
                String pathDescription = "_" + Integer.toString(i);
                String string = seqPrefix + "pathop" + pathDescription;
                String pathName = seqPrefix + "specpath" + pathDescription;
                x = variableContext.getParameter(string);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path2 = variableContext.getParameter(pathName);
                SpecificationNode node = new SpecificationNode(CONFIG_PARAM_LOCATION);
                node.setAttribute("path", path2);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "pathop");
            if (op != null && op.equals("Add")) {
                String string = variableContext.getParameter(seqPrefix + "specpath");
                SpecificationNode node = new SpecificationNode(CONFIG_PARAM_LOCATION);
                node.setAttribute("path", string);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            } else if (op != null && op.equals("Up")) {
                void var11_32;
                void var11_30;
                String string = variableContext.getParameter(seqPrefix + "specpath");
                int k = string.lastIndexOf("/");
                if (k != -1) {
                    String string2 = string.substring(0, k);
                }
                if (var11_30.length() == 0) {
                    String string3 = "/";
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)var11_32);
            } else if (op != null && op.equals("AddToPath")) {
                void var11_36;
                String string = variableContext.getParameter(seqPrefix + "specpath");
                String addon = variableContext.getParameter(seqPrefix + "pathaddon");
                if (addon != null && addon.length() > 0) {
                    if (string.length() == 1) {
                        String string4 = "/" + addon;
                    } else {
                        String string5 = string + "/" + addon;
                    }
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)var11_36);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn3 = ds.getChild(i);
                if (sn3.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node = new SpecificationNode("security");
            node.setAttribute("value", x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((x = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn4 = ds.getChild(i);
                if (sn4.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(x);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String string = seqPrefix + "accessop" + accessDescription;
                x = variableContext.getParameter(string);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String string = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", string);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "datatype_count")) != null) {
            void var11_45;
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(i);
                if (sn5.getType().equals(CONFIG_PARAM_OBJECTTYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int dataCount = Integer.parseInt(x);
            y = variableContext.getParameterValues(seqPrefix + "specfiletype");
            HashSet<String> checkedTypes = new HashSet<String>();
            if (y != null) {
                for (String s : y) {
                    checkedTypes.add(s);
                }
            }
            boolean bl = false;
            while (var11_45 < dataCount) {
                String fileType = variableContext.getParameter(seqPrefix + "datatype_" + (int)var11_45);
                if (checkedTypes.contains(fileType)) {
                    String[] z;
                    SpecificationNode node = new SpecificationNode(CONFIG_PARAM_OBJECTTYPE);
                    node.setAttribute("token", fileType);
                    String isAll = variableContext.getParameter(seqPrefix + "specfileallattrs_" + (int)var11_45);
                    if (isAll != null) {
                        node.setAttribute("all", isAll);
                    }
                    if ((z = variableContext.getParameterValues(seqPrefix + "specfileattrs_" + (int)var11_45)) != null) {
                        for (int kk = 0; kk < z.length; ++kk) {
                            SpecificationNode attrNode = new SpecificationNode(CONFIG_PARAM_ATTRIBUTENAME);
                            attrNode.setAttribute("attrname", z[kk]);
                            node.addChild(node.getChildCount(), (ConfigurationNode)attrNode);
                        }
                    }
                    x = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_count");
                    int filterCount = Integer.parseInt(x);
                    for (int kk = 0; kk < filterCount; ++kk) {
                        String op2 = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_" + kk + "_op");
                        if (op2 != null && op2.equals("Delete")) continue;
                        String attributeName = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_" + kk + "_name");
                        String operation = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_" + kk + "_operation");
                        String value = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_" + kk + "_value");
                        SpecificationNode filterNode = new SpecificationNode(CONFIG_PARAM_FILTER);
                        filterNode.setAttribute("name", attributeName);
                        filterNode.setAttribute("op", operation);
                        filterNode.setAttribute("value", value);
                        node.addChild(node.getChildCount(), (ConfigurationNode)filterNode);
                    }
                    x = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_op");
                    if (x != null && x.equals("Add")) {
                        String attributeName = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_name");
                        String operation = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_operation");
                        String value = variableContext.getParameter(seqPrefix + "filter_" + (int)var11_45 + "_value");
                        SpecificationNode filterNode = new SpecificationNode(CONFIG_PARAM_FILTER);
                        filterNode.setAttribute("name", attributeName);
                        filterNode.setAttribute("op", operation);
                        filterNode.setAttribute("value", value);
                        node.addChild(node.getChildCount(), (ConfigurationNode)filterNode);
                    }
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                }
                ++var11_45;
            }
        }
        if (variableContext.getParameter(seqPrefix + "specmimetype_posted") != null) {
            String all = variableContext.getParameter(seqPrefix + "specmimetypeall");
            y = variableContext.getParameterValues(seqPrefix + "specmimetype");
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                sn = ds.getChild(i2);
                if (sn.getType().equals(CONFIG_PARAM_FORMAT) || sn.getType().equals(CONFIG_PARAM_FORMAT_ALL)) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            SpecificationNode n2 = new SpecificationNode(CONFIG_PARAM_FORMAT_ALL);
            n2.setAttribute("value", all != null && all.equals("true") ? "true" : "false");
            ds.addChild(ds.getChildCount(), (ConfigurationNode)n2);
            if (y != null) {
                i2 = 0;
                while (i2 < y.length) {
                    String string = y[i2++];
                    SpecificationNode node = new SpecificationNode(CONFIG_PARAM_FORMAT);
                    node.setAttribute("value", string);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                }
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specmaxdoclength")) != null) {
            int i3 = 0;
            while (i3 < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i3);
                if (sn6.getType().equals(CONFIG_PARAM_MAXLENGTH)) {
                    ds.removeChild(i3);
                    continue;
                }
                ++i3;
            }
            if (x.length() > 0) {
                SpecificationNode node = new SpecificationNode(CONFIG_PARAM_MAXLENGTH);
                node.setAttribute("value", x);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specpathnameattribute")) != null) {
            int i4 = 0;
            while (i4 < ds.getChildCount()) {
                sn = ds.getChild(i4);
                if (sn.getType().equals(CONFIG_PARAM_PATHNAMEATTRIBUTE)) {
                    ds.removeChild(i4);
                    continue;
                }
                ++i4;
            }
            if (xc.length() > 0) {
                SpecificationNode node = new SpecificationNode(CONFIG_PARAM_PATHNAMEATTRIBUTE);
                node.setAttribute("value", xc);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specmappingcount")) != null) {
            int i5 = 0;
            while (i5 < ds.getChildCount()) {
                sn = ds.getChild(i5);
                if (sn.getType().equals(CONFIG_PARAM_PATHMAP)) {
                    ds.removeChild(i5);
                    continue;
                }
                ++i5;
            }
            int mappingCount = Integer.parseInt(xc);
            i5 = 0;
            while (i5 < mappingCount) {
                String string = "_" + Integer.toString(i5);
                String pathOpName = seqPrefix + "specmappingop" + string;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i5;
                    continue;
                }
                String match = variableContext.getParameter(seqPrefix + "specmatch" + string);
                String replace = variableContext.getParameter(seqPrefix + "specreplace" + string);
                SpecificationNode node = new SpecificationNode(CONFIG_PARAM_PATHMAP);
                node.setAttribute("match", match);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i5;
            }
            xc = variableContext.getParameter(seqPrefix + "specmappingop");
            if (xc != null && xc.equals("Add")) {
                String string = variableContext.getParameter(seqPrefix + "specmatch");
                String replace = variableContext.getParameter(seqPrefix + "specreplace");
                SpecificationNode node = new SpecificationNode(CONFIG_PARAM_PATHMAP);
                node.setAttribute("match", string);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        int i;
        SpecificationNode sn;
        int i2;
        SpecificationNode sn2;
        int i3;
        out.print("<table class=\"displaytable\">\n  <tr>\n");
        boolean seenAny = false;
        for (int i4 = 0; i4 < ds.getChildCount(); ++i4) {
            SpecificationNode sn3 = ds.getChild(i4);
            if (!sn3.getType().equals(CONFIG_PARAM_LOCATION)) continue;
            if (!seenAny) {
                seenAny = true;
                out.print("    <td class=\"description\">" + Messages.getBodyString(locale, "DCTM.CabinetFolderPaths") + "</td>\n    <td class=\"value\">\n");
            }
            out.print("      " + Encoder.bodyEscape((String)sn3.getAttributeValue("path")) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n");
        } else {
            out.print("    <td colspan=\"2\" class=\"message\">" + Messages.getBodyString(locale, "DCTM.NoCabinetFolderPathsSpecified") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"boxcell\" colspan=\"2\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocumentType") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Filters") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Metadata") + "</nobr></td>\n        </tr>\n");
        int l = 0;
        for (i3 = 0; i3 < ds.getChildCount(); ++i3) {
            sn2 = ds.getChild(i3);
            if (!sn2.getType().equals(CONFIG_PARAM_OBJECTTYPE)) continue;
            out.print("        <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n");
            String strObjectType = sn2.getAttributeValue("token");
            out.print("          <td class=\"formcolumncell\">\n            " + Encoder.bodyEscape((String)strObjectType) + "\n          </td>\n");
            out.print("          <td class=\"boxcell\">\n            <table class=\"formtable\">\n              <tr class=\"formheaderrow\">\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.AttributeName") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Operation") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "DCTM.Value") + "</nobr></td>\n              </tr>\n");
            HashMap currentFilters = new HashMap();
            for (int k = 0; k < sn2.getChildCount(); ++k) {
                HashSet<String> values;
                SpecificationNode dsn = sn2.getChild(k);
                if (!dsn.getType().equals(CONFIG_PARAM_FILTER)) continue;
                Object[] attributeName = dsn.getAttributeValue("name");
                String operation = dsn.getAttributeValue("op");
                String value = dsn.getAttributeValue("value");
                HashMap<String, HashSet<String>> filters = (HashMap<String, HashSet<String>>)currentFilters.get(attributeName);
                if (filters == null) {
                    filters = new HashMap<String, HashSet<String>>();
                    currentFilters.put(attributeName, filters);
                }
                if ((values = (HashSet<String>)filters.get(operation)) == null) {
                    values = new HashSet<String>();
                    filters.put(operation, values);
                }
                values.add(value);
            }
            int kk = 0;
            Object[] sortedAttributes = currentFilters.keySet().toArray(new String[0]);
            Arrays.sort(sortedAttributes);
            for (Object filterAttribute : sortedAttributes) {
                Map currentOperations = (Map)currentFilters.get(filterAttribute);
                Object[] sortedOperations = currentOperations.keySet().toArray(new String[0]);
                Arrays.sort(sortedOperations);
                for (Object filterOperation : sortedOperations) {
                    Set currentValues = (Set)currentOperations.get(filterOperation);
                    Object[] sortedValues = currentValues.toArray(new String[0]);
                    Arrays.sort(sortedValues);
                    StringBuilder sb = new StringBuilder();
                    boolean commaNeeded = false;
                    for (Object value : sortedValues) {
                        if (commaNeeded) {
                            sb.append(", ");
                        } else {
                            commaNeeded = true;
                        }
                        sb.append("\"").append((String)value).append("\"");
                    }
                    out.print("              <tr class=\"" + (kk % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n                <td class=\"formcolumncell\">\n                  <nobr>" + Encoder.bodyEscape((String)filterAttribute) + "</nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>" + Encoder.bodyEscape((String)filterOperation) + "</nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  " + Encoder.bodyEscape((String)sb.toString()) + "\n                </td>\n              </tr>\n");
                    ++kk;
                }
            }
            out.print("            </table>\n          </td>\n");
            out.print("          <td class=\"formcolumncell\">\n");
            String isAll = sn2.getAttributeValue("all");
            if (isAll != null && isAll.equals("true")) {
                out.print("            <nobr>" + Messages.getBodyString(locale, "DCTM.allMetadataAttributes") + "</nobr>\n");
            } else {
                for (int k = 0; k < sn2.getChildCount(); ++k) {
                    SpecificationNode dsn = sn2.getChild(k);
                    if (!dsn.getType().equals(CONFIG_PARAM_ATTRIBUTENAME)) continue;
                    String attrName = dsn.getAttributeValue("attrname");
                    out.print("            <nobr>" + Encoder.bodyEscape((String)attrName) + "</nobr>\n");
                }
            }
            out.print("          </td>\n");
            out.print("        </tr>\n");
            ++l;
        }
        if (l == 0) {
            out.print("        <tr class=\"formrow\">\n          <td colspan=\"3\" class=\"message\">" + Messages.getBodyString(locale, "DCTM.NoDocumentTypesSpecified") + "</td>\n        </tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n");
        seenAny = false;
        for (i3 = 0; i3 < ds.getChildCount(); ++i3) {
            sn2 = ds.getChild(i3);
            if (!sn2.getType().equals(CONFIG_PARAM_FORMAT)) continue;
            if (!seenAny) {
                out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.ContentTypes2") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String strContentType = sn2.getAttributeValue("value");
            out.print("      " + Encoder.bodyEscape((String)strContentType) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n");
        } else {
            out.print("    <td colspan=\"2\" class=\"message\">" + Messages.getBodyString(locale, "DCTM.NoMimeTypesSpecified") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        String maxDocumentLength = "unlimited";
        for (int i5 = 0; i5 < ds.getChildCount(); ++i5) {
            SpecificationNode sn4 = ds.getChild(i5);
            if (!sn4.getType().equals(CONFIG_PARAM_MAXLENGTH)) continue;
            maxDocumentLength = sn4.getAttributeValue("value");
        }
        out.print("\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.MaximumDocumentLength") + "</nobr></td>\n    <td class=\"value\">" + maxDocumentLength + "</td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        boolean securityOn = true;
        for (i2 = 0; i2 < ds.getChildCount(); ++i2) {
            sn = ds.getChild(i2);
            if (!sn.getType().equals("security")) continue;
            String securityValue = sn.getAttributeValue("value");
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        out.print("\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.Security2") + "</nobr></td>\n    <td class=\"value\">" + (securityOn ? "Enabled" : "Disabled") + "</td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        for (i2 = 0; i2 < ds.getChildCount(); ++i2) {
            sn = ds.getChild(i2);
            if (!sn.getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.AccessTokens") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "DCTM.NoAccessTokensSpecified") + "</td></tr>\n");
        }
        out.print("\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        String pathNameAttribute = "";
        for (int i6 = 0; i6 < ds.getChildCount(); ++i6) {
            SpecificationNode sn5 = ds.getChild(i6);
            if (!sn5.getType().equals(CONFIG_PARAM_PATHNAMEATTRIBUTE)) continue;
            pathNameAttribute = sn5.getAttributeValue("value");
        }
        out.print("  <tr>\n");
        if (pathNameAttribute.length() > 0) {
            out.print("    <td class=\"description\">" + Messages.getBodyString(locale, "DCTM.PathNameMetadataAttribute") + "</td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)pathNameAttribute) + "</td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "DCTM.NoPathNameMetadataAttributeSpecified") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n    \n  <tr>\n");
        MatchMap matchMap = new MatchMap();
        for (i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn6 = ds.getChild(i);
            if (!sn6.getType().equals(CONFIG_PARAM_PATHMAP)) continue;
            String pathMatch = sn6.getAttributeValue("match");
            String pathReplace = sn6.getAttributeValue("replace");
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (matchMap.getMatchCount() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.PathValueMapping") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                String matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("        <tr>\n          <td class=\"value\">" + Encoder.bodyEscape((String)matchString) + "</td>\n          <td class=\"value\">--></td>\n          <td class=\"value\">" + Encoder.bodyEscape((String)replaceString) + "</td>\n        </tr>\n");
            }
            out.print("      </table>\n    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "DCTM.NoMappingsSpecified") + "</td>\n");
        }
        out.print("  </tr>\n</table>\n");
    }

    public String[] getContentTypes() throws ManifoldCFException, ServiceInterruption {
        try {
            String dql = "select name from dm_format where can_index=true order by name asc";
            while (true) {
                boolean noSession = this.session == null;
                this.getSession();
                GetListOfValuesThread t = new GetListOfValuesThread(dql, "name");
                try {
                    t.start();
                    List<String> contentTypes = t.finishUp();
                    String[] rval = new String[contentTypes.size()];
                    for (int i = 0; i < rval.length; ++i) {
                        rval[i] = contentTypes.get(i);
                    }
                    return rval;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RemoteException e) {
                    Throwable e2 = e.getCause();
                    if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                    if (noSession) {
                        long currentTime = System.currentTimeMillis();
                        throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                    }
                    this.session = null;
                    this.lastSessionFetch = -1L;
                    continue;
                }
                break;
            }
        }
        catch (DocumentumException e) {
            long currentTime = System.currentTimeMillis();
            if (e.getType() == 0) {
                Logging.connectors.warn((Object)("DCTM: Remote service interruption reading content types: " + e.getMessage()), (Throwable)e);
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getObjectTypes() throws ManifoldCFException, ServiceInterruption {
        try {
            String strDQL = "select distinct A.r_type_name from dmi_type_info A, dmi_dd_type_info B   where ((not A.r_type_name like 'dm_%' and any A.r_supertype='dm_document' and B.life_cycle <> 3) or (A.r_type_name = 'dm_document' and B.life_cycle <> 3))  AND A.r_type_name = B.type_name order by A.r_type_name";
            while (true) {
                boolean noSession = this.session == null;
                this.getSession();
                GetListOfValuesThread t = new GetListOfValuesThread(strDQL, "r_type_name");
                try {
                    t.start();
                    List<String> objectTypes = t.finishUp();
                    String[] rval = new String[objectTypes.size()];
                    for (int i = 0; i < rval.length; ++i) {
                        rval[i] = objectTypes.get(i);
                    }
                    return rval;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RemoteException e) {
                    Throwable e2 = e.getCause();
                    if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                    if (noSession) {
                        long currentTime = System.currentTimeMillis();
                        throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                    }
                    this.session = null;
                    this.lastSessionFetch = -1L;
                    continue;
                }
                break;
            }
        }
        catch (DocumentumException e) {
            long currentTime = System.currentTimeMillis();
            if (e.getType() == 0) {
                Logging.connectors.warn((Object)("DCTM: Remote service interruption reading object types: " + e.getMessage()), (Throwable)e);
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getChildFolderNames(String strTheParentFolderPath) throws ManifoldCFException, ServiceInterruption {
        try {
            while (true) {
                boolean noSession = this.session == null;
                this.getSession();
                GetChildFolderNamesThread t = new GetChildFolderNamesThread(strTheParentFolderPath);
                try {
                    t.start();
                    return t.finishUp();
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RemoteException e) {
                    Throwable e2 = e.getCause();
                    if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                    if (noSession) {
                        long currentTime = System.currentTimeMillis();
                        throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                    }
                    this.session = null;
                    this.lastSessionFetch = -1L;
                    continue;
                }
                break;
            }
        }
        catch (DocumentumException e) {
            long currentTime = System.currentTimeMillis();
            if (e.getType() == 0) {
                Logging.connectors.warn((Object)("DCTM: Remote service interruption reading child folders: " + e.getMessage()), (Throwable)e);
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getIngestableAttributes(String docType) throws ManifoldCFException, ServiceInterruption {
        try {
            String strDQL = "select distinct attr_name FROM dmi_dd_attr_info where type_name = '" + docType + "' order by attr_name asc";
            while (true) {
                boolean noSession = this.session == null;
                this.getSession();
                GetListOfValuesThread t = new GetListOfValuesThread(strDQL, "attr_name");
                try {
                    t.start();
                    List<String> attributes = t.finishUp();
                    String[] rval = new String[attributes.size()];
                    for (int i = 0; i < rval.length; ++i) {
                        rval[i] = attributes.get(i);
                    }
                    return rval;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RemoteException e) {
                    Throwable e2 = e.getCause();
                    if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                    if (noSession) {
                        long currentTime = System.currentTimeMillis();
                        throw new ServiceInterruption("Transient error connecting to documentum service: " + e.getMessage(), currentTime + 60000L);
                    }
                    this.session = null;
                    this.lastSessionFetch = -1L;
                    continue;
                }
                break;
            }
        }
        catch (DocumentumException e) {
            long currentTime = System.currentTimeMillis();
            if (e.getType() == 0) {
                Logging.connectors.warn((Object)("DCTM: Remote service interruption reading child folders: " + e.getMessage()), (Throwable)e);
                throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected class SpecInfo {
        protected final String pathAttributeName;
        protected final Map<String, String[]> pathMap = new HashMap<String, String[]>();
        protected final MatchMap matchMap = new MatchMap();
        protected final Set<String> aclSet = new HashSet<String>();
        protected final boolean securityOn;
        protected final Map<String, List<String>> typeMap = new HashMap<String, List<String>>();
        protected final Set<String> pathSet = new HashSet<String>();
        protected final Set<String> mimeTypeSet;

        public SpecInfo(Specification spec) throws ManifoldCFException, ServiceInterruption {
            HashSet<String> mimeTypeSet = null;
            boolean allMimeTypes = false;
            String pathAttributeName = null;
            boolean securityOn = true;
            for (int i = 0; i < spec.getChildCount(); ++i) {
                List<Object> list;
                SpecificationNode n = spec.getChild(i);
                if (n.getType().equals(CONFIG_PARAM_FORMAT_ALL)) {
                    String all = n.getAttributeValue("value");
                    if (!all.equals("true")) continue;
                    allMimeTypes = true;
                    continue;
                }
                if (n.getType().equals(CONFIG_PARAM_FORMAT)) {
                    String docType = n.getAttributeValue("value");
                    if (mimeTypeSet == null) {
                        mimeTypeSet = new HashSet<String>();
                    }
                    mimeTypeSet.add(docType);
                    continue;
                }
                if (n.getType().equals(CONFIG_PARAM_PATHNAMEATTRIBUTE)) {
                    pathAttributeName = n.getAttributeValue("value");
                    continue;
                }
                if (n.getType().equals(CONFIG_PARAM_PATHMAP)) {
                    String pathMatch = n.getAttributeValue("match");
                    String pathReplace = n.getAttributeValue("replace");
                    this.matchMap.appendMatchPair(pathMatch, pathReplace);
                    continue;
                }
                if (n.getType().equals(CONFIG_PARAM_LOCATION)) {
                    String strLocation = n.getAttributeValue("path");
                    if (strLocation == null || strLocation.length() <= 0) continue;
                    this.pathSet.add(strLocation);
                    continue;
                }
                if (n.getType().equals("access")) {
                    String token = n.getAttributeValue("token");
                    this.aclSet.add(token);
                    continue;
                }
                if (n.getType().equals("security")) {
                    String value = n.getAttributeValue("value");
                    if (value.equals("on")) {
                        securityOn = true;
                        continue;
                    }
                    if (!value.equals("off")) continue;
                    securityOn = false;
                    continue;
                }
                if (!n.getType().equals(CONFIG_PARAM_OBJECTTYPE)) continue;
                String typeName = n.getAttributeValue("token");
                String isAll = n.getAttributeValue("all");
                if (isAll != null && isAll.equals("true")) {
                    try {
                        list = DCTM.this.getAttributesForType(typeName);
                    }
                    catch (DocumentumException e) {
                        if (e.getType() == 0) {
                            long currentTime = System.currentTimeMillis();
                            Logging.connectors.warn((Object)("DCTM: Remote service interruption listing attributes: " + e.getMessage()), (Throwable)e);
                            throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
                        }
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                } else {
                    list = new ArrayList();
                    int l = 0;
                    while (i < n.getChildCount()) {
                        SpecificationNode sn = n.getChild(l);
                        if (sn.getType().equals(CONFIG_PARAM_ATTRIBUTENAME)) {
                            String attrName = sn.getAttributeValue("attrname");
                            list.add(attrName);
                        }
                        ++l;
                    }
                }
                this.typeMap.put(typeName, list);
            }
            this.pathAttributeName = pathAttributeName;
            this.securityOn = securityOn;
            this.mimeTypeSet = allMimeTypes ? null : (mimeTypeSet == null ? new HashSet<String>(0) : mimeTypeSet);
        }

        public String getPathAttributeName() {
            return this.pathAttributeName;
        }

        public String[] getPathAttributeValue(IDocumentumObject object) throws DocumentumException, RemoteException, ManifoldCFException {
            String[] paths = object.getFolderPaths(this.pathMap);
            String[] rval = new String[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                rval[i] = this.matchMap.translate(paths[i]);
            }
            return rval;
        }

        public boolean pathMatches(String[] documentPaths) {
            if (this.pathSet.size() == 0) {
                return true;
            }
            for (String path : documentPaths) {
                if (!this.pathSet.contains(path)) continue;
                return true;
            }
            return false;
        }

        public boolean contentTypeMatches(String contentType) {
            if (this.mimeTypeSet == null) {
                return true;
            }
            boolean rval = this.mimeTypeSet.contains(contentType);
            return rval;
        }

        public String[] getAcls() {
            if (!this.securityOn) {
                return null;
            }
            String[] rval = new String[this.aclSet.size()];
            Iterator<String> iter = this.aclSet.iterator();
            int i = 0;
            for (String value : this.aclSet) {
                rval[i++] = value;
            }
            return rval;
        }

        public String getForcedAclString() {
            Object[] acls = this.getAcls();
            StringBuilder forcedAclString = new StringBuilder();
            if (acls != null) {
                forcedAclString.append('+');
                Arrays.sort(acls);
                DCTM.packList((StringBuilder)forcedAclString, (String[])((String[])acls), (char)'+');
                DCTM.pack((StringBuilder)forcedAclString, (String)DCTM.denyToken, (char)'+');
            } else {
                forcedAclString.append('-');
            }
            return forcedAclString.toString();
        }

        public List<String> getMetadataFields(String typeName) {
            return this.typeMap.get(typeName);
        }

        public String getMetadataVersionAddendum(String typeName) {
            StringBuilder sb = new StringBuilder();
            List<String> list = this.typeMap.get(typeName);
            if (list == null) {
                DCTM.packList((StringBuilder)sb, (String[])new String[0], (char)'+');
            } else {
                Object[] sortArray = new String[list.size()];
                int j = 0;
                for (String thing : list) {
                    sortArray[j++] = thing;
                }
                Arrays.sort(sortArray);
                DCTM.packList((StringBuilder)sb, (String[])((String[])sortArray), (char)'+');
            }
            return sb.toString();
        }

        public String getPathNameAttributeAddendum() {
            StringBuilder pathNameAttributeVersion = new StringBuilder();
            if (this.pathAttributeName != null) {
                pathNameAttributeVersion.append("=").append(this.pathAttributeName).append(":").append(this.matchMap);
            }
            return pathNameAttributeVersion.toString();
        }
    }

    protected class GetChildFolderNamesThread
    extends Thread {
        protected final String strTheParentFolderPath;
        protected Throwable exception = null;
        protected String[] rval = null;

        public GetChildFolderNamesThread(String strTheParentFolderPath) {
            this.setDaemon(true);
            this.strTheParentFolderPath = strTheParentFolderPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                IDocumentumResult result;
                ArrayList<String> objFolderNames = new ArrayList<String>();
                if (this.strTheParentFolderPath.equalsIgnoreCase("/")) {
                    String strDQLForCabinets = "select object_name, r_object_type, r_object_id from dm_cabinet order by 1";
                    result = DCTM.this.session.performDQLQuery(strDQLForCabinets);
                } else {
                    result = DCTM.this.session.getFolderContents(this.strTheParentFolderPath);
                }
                try {
                    HashMap<String, Boolean> matchTypes = new HashMap<String, Boolean>();
                    while (result.isValidRow()) {
                        String strObjectName = result.getStringValue("object_name");
                        String strObjectType = result.getStringValue("r_object_type").trim();
                        Boolean x = (Boolean)matchTypes.get(strObjectType);
                        if (x == null) {
                            boolean isMatch = DCTM.this.session.isOneOf(strObjectType, new String[]{"dm_folder", "dm_cabinet"});
                            x = new Boolean(isMatch);
                            matchTypes.put(strObjectType, x);
                        }
                        if (x.booleanValue()) {
                            objFolderNames.add(strObjectName);
                        }
                        result.nextRow();
                    }
                }
                finally {
                    result.close();
                }
                this.rval = new String[objFolderNames.size()];
                for (int i = 0; i < this.rval.length; ++i) {
                    this.rval[i] = (String)objFolderNames.get(i);
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String[] finishUp() throws InterruptedException, RemoteException, DocumentumException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class ProcessDocumentThread
    extends Thread {
        protected final String documentIdentifier;
        protected final SpecInfo sDesc;
        protected volatile boolean versionPartDone = false;
        protected volatile boolean threadExit = false;
        protected volatile boolean startFetch = false;
        protected volatile boolean abort = false;
        protected File objFileTemp = null;
        protected Throwable exception = null;
        protected String versionString = null;
        protected RepositoryDocument rval = null;
        protected Long activityStartTime = null;
        protected Long activityFileLength = null;
        protected String activityStatus = null;
        protected String activityMessage = null;
        protected String uri = null;
        protected String contentType = null;
        protected Long contentSize = null;

        public ProcessDocumentThread(String documentIdentifier, SpecInfo sDesc) {
            this.setDaemon(true);
            this.documentIdentifier = documentIdentifier;
            this.objFileTemp = this.objFileTemp;
            this.sDesc = sDesc;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 86[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getVersionString() throws RemoteException, DocumentumException, InterruptedException {
            ProcessDocumentThread processDocumentThread = this;
            synchronized (processDocumentThread) {
                do {
                    this.wait();
                } while (!this.threadExit && !this.versionPartDone);
            }
            if (this.exception != null) {
                if (this.exception instanceof RemoteException) {
                    throw (RemoteException)this.exception;
                }
                if (this.exception instanceof DocumentumException) {
                    throw (DocumentumException)this.exception;
                }
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                throw new RuntimeException("Unexpected exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
            }
            return this.versionString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startFetch(File objFileTemp) {
            ProcessDocumentThread processDocumentThread = this;
            synchronized (processDocumentThread) {
                this.objFileTemp = objFileTemp;
                this.startFetch = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishWithoutFetch() throws InterruptedException {
            ProcessDocumentThread processDocumentThread = this;
            synchronized (processDocumentThread) {
                this.abort = true;
                this.notifyAll();
            }
            this.join();
        }

        public RepositoryDocument finishUp() throws RemoteException, DocumentumException, InterruptedException, ManifoldCFException {
            this.join();
            if (this.exception != null) {
                if (this.exception instanceof RemoteException) {
                    throw (RemoteException)this.exception;
                }
                if (this.exception instanceof DocumentumException) {
                    throw (DocumentumException)this.exception;
                }
                if (this.exception instanceof ManifoldCFException) {
                    throw (ManifoldCFException)this.exception;
                }
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                throw new RuntimeException("Unexpected exception type: " + this.exception.getClass().getName() + ": " + this.exception.getMessage(), this.exception);
            }
            return this.rval;
        }

        public Long getContentSize() {
            return this.contentSize;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Long getActivityStartTime() {
            return this.activityStartTime;
        }

        public Long getActivityFileLength() {
            return this.activityFileLength;
        }

        public String getActivityStatus() {
            return this.activityStatus;
        }

        public String getActivityMessage() {
            return this.activityMessage;
        }

        public String getURI() {
            return this.uri;
        }
    }

    protected class GetDocumentsFromQueryThread
    extends Thread {
        protected String dql;
        protected StringQueue queue;
        protected Throwable exception = null;
        protected boolean abortSignaled = false;

        public GetDocumentsFromQueryThread(String dql, StringQueue queue) {
            this.setDaemon(true);
            this.dql = dql;
            this.queue = queue;
        }

        public void abort() {
            this.abortSignaled = true;
            this.queue.abort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    try {
                        if (this.abortSignaled) break block13;
                        try (IDocumentumResult result = DCTM.this.session.performDQLQuery(this.dql);){
                            while (result.isValidRow()) {
                                if (this.abortSignaled) {
                                    break;
                                }
                                String strObjectId = result.getStringValue("i_chronicle_id");
                                result.nextRow();
                                this.queue.add(strObjectId);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        this.exception = e;
                    }
                    finally {
                        this.queue.add(null);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void finishUp() throws RemoteException, DocumentumException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected static class StringQueue {
        protected String value = null;
        protected boolean present = false;
        protected boolean abort = false;

        public synchronized String getNext() throws InterruptedException {
            while (!this.abort && !this.present) {
                this.wait();
            }
            if (this.abort) {
                return null;
            }
            this.present = false;
            String rval = this.value;
            this.notifyAll();
            return rval;
        }

        public synchronized void add(String value) throws InterruptedException {
            while (!this.abort && this.present) {
                this.wait();
            }
            if (this.abort) {
                return;
            }
            this.present = true;
            this.value = value;
            this.notifyAll();
        }

        public synchronized void abort() {
            this.abort = true;
            this.notifyAll();
        }
    }

    protected class DestroySessionThread
    extends Thread {
        protected Throwable exception = null;

        public DestroySessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                DCTM.this.session.destroySession();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, RemoteException, DocumentumException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class BuildDateStringThread
    extends Thread {
        protected long timevalue;
        protected Throwable exception = null;
        protected String rval = null;

        public BuildDateStringThread(long timevalue) {
            this.setDaemon(true);
            this.timevalue = timevalue;
        }

        @Override
        public void run() {
            try {
                this.rval = DCTM.this.session.buildDateString(this.timevalue);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String finishUp() throws InterruptedException, RemoteException, DocumentumException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                DCTM.this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, RemoteException, DocumentumException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }

    protected class GetListOfValuesThread
    extends Thread {
        protected final String query;
        protected final String fieldName;
        protected Throwable exception = null;
        protected final List<String> list = new ArrayList<String>();

        public GetListOfValuesThread(String query, String fieldName) {
            this.setDaemon(true);
            this.query = query;
            this.fieldName = fieldName;
        }

        @Override
        public void run() {
            try (IDocumentumResult result = DCTM.this.session.performDQLQuery(this.query);){
                while (result.isValidRow()) {
                    this.list.add(result.getStringValue(this.fieldName));
                    result.nextRow();
                }
                return;
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public List<String> finishUp() throws InterruptedException, RemoteException, DocumentumException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.list;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                IDocumentumFactory df = (IDocumentumFactory)Naming.lookup("rmi://127.0.0.1:8300/documentum_factory");
                IDocumentum newSession = df.make();
                newSession.createSession(DCTM.this.docbaseName, DCTM.this.userName, DCTM.this.password, DCTM.this.domain);
                DCTM.this.session = newSession;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, MalformedURLException, NotBoundException, RemoteException, DocumentumException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof MalformedURLException) {
                    throw (MalformedURLException)thr;
                }
                if (thr instanceof NotBoundException) {
                    throw (NotBoundException)thr;
                }
                if (thr instanceof RemoteException) {
                    throw (RemoteException)thr;
                }
                if (thr instanceof DocumentumException) {
                    throw (DocumentumException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unexpected exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }
}

