/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.LocalTransactionContext;
import org.castor.util.Messages;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.AbstractDatabaseImpl;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;

public class LocalDatabaseImpl
extends AbstractDatabaseImpl {
    private static Log _log = LogFactory.getFactory().getInstance(LocalDatabaseImpl.class);

    public LocalDatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        super(dbName, lockTimeout, callback, instanceFactory, classLoader, autoStore);
        this._ctx = new LocalTransactionContext(this);
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this._classLoader = classLoader;
        this.loadSynchronizables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws PersistenceException {
        block7: {
            try {
                if (!this.isActive()) break block7;
                try {
                    this._ctx.rollback();
                }
                catch (Exception except) {
                    // empty catch block
                }
                try {
                    this._ctx.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new PersistenceException(Messages.message("jdo.dbClosedTxRolledback"));
            }
            finally {
                this._scope = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this._scope != null || !this.isActive()) {
            return;
        }
        OQLQuery oqlQuery = this.getOQLQuery();
        String sql = ((OQLQueryImpl)oqlQuery).getSQL();
        _log.warn((Object)Messages.format("jdo.finalize_close", this.toString(), this._dbName, sql));
        this.close();
    }

    public void begin() throws PersistenceException {
        _log.debug((Object)"Beginning tx");
        if (this.isActive()) {
            throw new PersistenceException(Messages.message("jdo.txInProgress"));
        }
        this._ctx.setStatus(0);
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this.registerSynchronizables();
    }

    /*
     * Loose catch block
     */
    public void commit() throws TransactionNotInProgressException, TransactionAbortedException {
        block11: {
            _log.debug((Object)"Committing tx");
            if (!this.isActive()) {
                throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
            }
            if (this._ctx.getStatus() == 1) {
                throw new TransactionAbortedException(Messages.message("jdo.txRollback"));
            }
            this._ctx.prepare();
            this._ctx.commit();
            Object var3_1 = null;
            try {
                if (this._ctx.isOpen()) {
                    this._ctx.close();
                }
                break block11;
            }
            catch (Exception e) {
                _log.info((Object)e.getMessage(), (Throwable)e);
            }
            break block11;
            {
                catch (TransactionAbortedException except) {
                    _log.error((Object)Messages.format("jdo.txAborted", except.getMessage()), (Throwable)except);
                    this._ctx.rollback();
                    throw except;
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    if (this._ctx.isOpen()) {
                        this._ctx.close();
                    }
                }
                catch (Exception e) {
                    _log.info((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
        }
        this.unregisterSynchronizables();
    }

    public void rollback() throws TransactionNotInProgressException {
        _log.debug((Object)"Rolling back tx");
        if (!this.isActive()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.rollback();
        this.unregisterSynchronizables();
    }

    public Connection getJdbcConnection() throws PersistenceException {
        if (this._ctx == null || !this._ctx.isOpen()) {
            String message = Messages.message("jdo.dbTxNotInProgress.jdbc");
            throw new PersistenceException(message);
        }
        return this._ctx.getConnection(this._scope.getLockEngine());
    }
}

