/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class CacheTypeMapping
implements Serializable {
    private String _type = "count-limited";
    private boolean _debug = false;
    private boolean _has_debug;
    private int _capacity;
    private boolean _has_capacity;
    private ArrayList _paramList;

    public CacheTypeMapping() {
        this.setType("count-limited");
        this._paramList = new ArrayList();
    }

    public void addParam(Param vParam) throws IndexOutOfBoundsException {
        this._paramList.add(vParam);
    }

    public void addParam(int index, Param vParam) throws IndexOutOfBoundsException {
        this._paramList.add(index, vParam);
    }

    public void clearParam() {
        this._paramList.clear();
    }

    public void deleteCapacity() {
        this._has_capacity = false;
    }

    public void deleteDebug() {
        this._has_debug = false;
    }

    public Enumeration enumerateParam() {
        return Collections.enumeration(this._paramList);
    }

    public int getCapacity() {
        return this._capacity;
    }

    public boolean getDebug() {
        return this._debug;
    }

    public Param getParam(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._paramList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Param)this._paramList.get(index);
    }

    public Param[] getParam() {
        int size = this._paramList.size();
        Param[] mArray = new Param[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Param)this._paramList.get(index);
        }
        return mArray;
    }

    public int getParamCount() {
        return this._paramList.size();
    }

    public String getType() {
        return this._type;
    }

    public boolean hasCapacity() {
        return this._has_capacity;
    }

    public boolean hasDebug() {
        return this._has_debug;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, handler);
    }

    public boolean removeParam(Param vParam) {
        boolean removed = this._paramList.remove(vParam);
        return removed;
    }

    public void setCapacity(int capacity) {
        this._capacity = capacity;
        this._has_capacity = true;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
        this._has_debug = true;
    }

    public void setParam(int index, Param vParam) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._paramList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._paramList.set(index, vParam);
    }

    public void setParam(Param[] paramArray) {
        this._paramList.clear();
        for (int i = 0; i < paramArray.length; ++i) {
            this._paramList.add(paramArray[i]);
        }
    }

    public void setType(String type) {
        this._type = type;
    }

    public static CacheTypeMapping unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CacheTypeMapping)Unmarshaller.unmarshal(CacheTypeMapping.class, reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate(this);
    }
}

