/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.filter.sqlmm.SpatialFunction;

class OneGeometry<R, G>
extends SpatialFunction<R> {
    private static final long serialVersionUID = 3895562608419096524L;
    final Expression<? super R, GeometryWrapper<G>> geometry;

    OneGeometry(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
        super(sQLMM, expressionArray);
        this.geometry = OneGeometry.toGeometryWrapper(geometries, expressionArray[0]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
        return new OneGeometry(this.operation, expressionArray, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return OneGeometry.getGeometryLibrary(this.geometry);
    }

    @Override
    public List<Expression<? super R, ?>> getParameters() {
        return Collections.singletonList(OneGeometry.unwrap(this.geometry));
    }

    @Override
    public Object apply(R r) {
        GeometryWrapper<G> geometryWrapper = this.geometry.apply(r);
        if (geometryWrapper != null) {
            try {
                return geometryWrapper.operation(this.operation);
            }
            catch (RuntimeException runtimeException) {
                this.warning(runtimeException, false);
            }
        }
        return null;
    }

    static final class WithArgument<R, G>
    extends OneGeometry<R, G> {
        private static final long serialVersionUID = 2422322830405666146L;
        final Expression<? super R, ?> argument;

        WithArgument(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
            super(sQLMM, expressionArray, geometries);
            this.argument = expressionArray[1];
        }

        @Override
        public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
            return new WithArgument(this.operation, expressionArray, this.getGeometryLibrary());
        }

        @Override
        public List<Expression<? super R, ?>> getParameters() {
            return Arrays.asList(this.geometry, this.argument);
        }

        @Override
        public Object apply(R r) {
            GeometryWrapper geometryWrapper = (GeometryWrapper)this.geometry.apply(r);
            if (geometryWrapper != null) {
                try {
                    return geometryWrapper.operationWithArgument(this.operation, this.argument.apply(r));
                }
                catch (RuntimeException runtimeException) {
                    this.warning(runtimeException, false);
                }
            }
            return null;
        }
    }
}

