/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.livelink;

import com.opentext.api.LAPI_ATTRIBUTES;
import com.opentext.api.LAPI_DOCUMENTS;
import com.opentext.api.LAPI_USERS;
import com.opentext.api.LLBadServerCertificateException;
import com.opentext.api.LLConnect;
import com.opentext.api.LLCouldNotConnectHTTPException;
import com.opentext.api.LLHTTPAccessDeniedException;
import com.opentext.api.LLHTTPCGINotFoundException;
import com.opentext.api.LLHTTPClientException;
import com.opentext.api.LLHTTPForbiddenException;
import com.opentext.api.LLHTTPProxyAuthRequiredException;
import com.opentext.api.LLHTTPRedirectionException;
import com.opentext.api.LLHTTPServerException;
import com.opentext.api.LLIOException;
import com.opentext.api.LLIllegalOperationException;
import com.opentext.api.LLIndexOutOfBoundsException;
import com.opentext.api.LLNoFieldSpecifiedException;
import com.opentext.api.LLNoValueSpecifiedException;
import com.opentext.api.LLSSLNotAvailableException;
import com.opentext.api.LLSecurityProviderException;
import com.opentext.api.LLUnknownFieldException;
import com.opentext.api.LLUnsupportedAuthMethodException;
import com.opentext.api.LLValue;
import com.opentext.api.LLValueEnumeration;
import com.opentext.api.LLWebAuthInitException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.common.XThreadOutputStream;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.livelink.MatchMap;
import org.apache.manifoldcf.crawler.connectors.livelink.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.livelink.LLSERVER;
import org.apache.manifoldcf.ui.util.Encoder;

public class LivelinkConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: LivelinkConnector.java 996524 2010-09-13 13:38:01Z kwright $";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_SPECIFICATION_PATHS_HTML = "editSpecification_Paths.html";
    private static final String EDIT_SPECIFICATION_FILTERS_HTML = "editSpecification_Filters.html";
    private static final String EDIT_SPECIFICATION_SECURITY_HTML = "editSpecification_Security.html";
    private static final String EDIT_SPECIFICATION_METADATA_HTML = "editSpecification_Metadata.html";
    private static final String EDIT_CONFIGURATION_SERVER_HTML = "editConfiguration_Server.html";
    private static final String EDIT_CONFIGURATION_ACCESS_HTML = "editConfiguration_Access.html";
    private static final String EDIT_CONFIGURATION_VIEW_HTML = "editConfiguration_View.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private static final String TAB_NAME_PARAM = "TabName";
    private static final String ACTIVITY_SEED = "find documents";
    private static final String ACTIVITY_FETCH = "fetch document";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static final String GENERAL_NAME_FIELD = "general_name";
    protected static final String GENERAL_DESCRIPTION_FIELD = "general_description";
    protected static final String GENERAL_CREATIONDATE_FIELD = "general_creationdate";
    protected static final String GENERAL_MODIFYDATE_FIELD = "general_modifydate";
    protected static final String GENERAL_OWNER = "general_owner";
    protected static final String GENERAL_CREATOR = "general_creator";
    protected static final String GENERAL_MODIFIER = "general_modifier";
    protected static final String GENERAL_PARENTID = "general_parentid";
    private boolean hasSessionParameters = false;
    private boolean hasConnected = false;
    private long expirationTime = -1L;
    private static final long expirationInterval = 300000L;
    private LAPI_DOCUMENTS LLDocs = null;
    private LAPI_ATTRIBUTES LLAttributes = null;
    private LAPI_USERS LLUsers = null;
    private LLSERVER llServer = null;
    private int LLENTWK_VOL;
    private int LLENTWK_ID;
    private int LLCATWK_VOL;
    private int LLCATWK_ID;
    private String serverProtocol = null;
    private String serverName = null;
    private int serverPort = -1;
    private String serverUsername = null;
    private String serverPassword = null;
    private String serverHTTPCgi = null;
    private String serverHTTPNTLMDomain = null;
    private String serverHTTPNTLMUsername = null;
    private String serverHTTPNTLMPassword = null;
    private IKeystoreManager serverHTTPSKeystore = null;
    private String ingestProtocol = null;
    private String ingestPort = null;
    private String ingestCgiPath = null;
    private String viewProtocol = null;
    private String viewServerName = null;
    private String viewPort = null;
    private String viewCgiPath = null;
    private String viewAction = null;
    private String ingestNtlmDomain = null;
    private String ingestNtlmUsername = null;
    private String ingestNtlmPassword = null;
    private IKeystoreManager ingestKeystoreManager = null;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient httpClient = null;
    private String viewBasePath = null;
    private int ingestPortNumber = -1;
    private static final String[] activitiesList = new String[]{"find documents", "fetch document"};
    private static final int FAILURE_RETRY_COUNT = 10;
    private static String currentHost = null;
    private static InetAddress currentAddr = null;
    protected static final String CATEGORY_NAME = "CATEGORY";
    protected static final String ENTWKSPACE_NAME = "ENTERPRISE";

    public int getConnectorModel() {
        return 10;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.serverName = this.params.getParameter("Server name");
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.serverName};
    }

    protected HttpHost getHost() {
        return new HttpHost(this.llServer.getHost(), this.ingestPortNumber, this.ingestProtocol);
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            String serverHTTPSKeystoreData;
            Object viewPortString;
            this.ingestProtocol = this.params.getParameter("Protocol");
            this.ingestPort = this.params.getParameter("Port");
            this.ingestCgiPath = this.params.getParameter("CGI path");
            this.viewProtocol = this.params.getParameter("View protocol");
            this.viewServerName = this.params.getParameter("View server name");
            this.viewPort = this.params.getParameter("View port");
            this.viewCgiPath = this.params.getParameter("View CGI path");
            this.viewAction = this.params.getParameter("View Action");
            this.ingestNtlmDomain = this.params.getParameter("NTLM domain");
            this.ingestNtlmUsername = this.params.getParameter("NTLM user name");
            this.ingestNtlmPassword = this.params.getObfuscatedParameter("NTLM password");
            this.serverProtocol = this.params.getParameter("Server protocol");
            String serverPortString = this.params.getParameter("Server port");
            this.serverUsername = this.params.getParameter("Server user name");
            this.serverPassword = this.params.getObfuscatedParameter("Server password");
            this.serverHTTPCgi = this.params.getParameter("Server HTTP CGI path");
            this.serverHTTPNTLMDomain = this.params.getParameter("Server HTTP NTLM domain");
            this.serverHTTPNTLMUsername = this.params.getParameter("Server HTTP NTLM user name");
            this.serverHTTPNTLMPassword = this.params.getObfuscatedParameter("Server HTTP NTLM password");
            if (this.ingestProtocol == null || this.ingestProtocol.length() == 0) {
                this.ingestProtocol = null;
            }
            if (this.viewProtocol == null || this.viewProtocol.length() == 0) {
                this.viewProtocol = this.ingestProtocol == null ? "http" : this.ingestProtocol;
            }
            if (this.ingestPort == null || this.ingestPort.length() == 0) {
                this.ingestPort = this.ingestProtocol != null ? (!this.ingestProtocol.equals("https") ? "80" : "443") : null;
            }
            if (this.viewPort == null || this.viewPort.length() == 0) {
                this.viewPort = this.ingestProtocol == null || !this.viewProtocol.equals(this.ingestProtocol) ? (!this.viewProtocol.equals("https") ? "80" : "443") : this.ingestPort;
            }
            if (this.ingestPort != null) {
                try {
                    this.ingestPortNumber = Integer.parseInt(this.ingestPort);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad ingest port: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                int portNumber = Integer.parseInt(this.viewPort);
                viewPortString = ":" + Integer.toString(portNumber);
                if (!this.viewProtocol.equals("https")) {
                    if (portNumber == 80) {
                        viewPortString = "";
                    }
                } else if (portNumber == 443) {
                    viewPortString = "";
                }
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad view port: " + e.getMessage(), (Throwable)e);
            }
            if (this.viewCgiPath == null || this.viewCgiPath.length() == 0) {
                this.viewCgiPath = this.ingestCgiPath;
            }
            if (this.ingestNtlmDomain != null && this.ingestNtlmDomain.length() == 0) {
                this.ingestNtlmDomain = null;
            }
            if (this.ingestNtlmDomain == null) {
                this.ingestNtlmUsername = null;
                this.ingestNtlmPassword = null;
            } else if (this.ingestNtlmUsername == null || this.ingestNtlmUsername.length() == 0) {
                this.ingestNtlmUsername = this.serverUsername;
                if (this.ingestNtlmPassword == null || this.ingestNtlmPassword.length() == 0) {
                    this.ingestNtlmPassword = this.serverPassword;
                }
            } else if (this.ingestNtlmPassword == null) {
                this.ingestNtlmPassword = "";
            }
            String ingestKeystoreData = this.params.getParameter("Livelink SSL keystore");
            if (ingestKeystoreData != null) {
                this.ingestKeystoreManager = KeystoreManagerFactory.make((String)"", (String)ingestKeystoreData);
            }
            if (this.serverProtocol == null || this.serverProtocol.length() == 0) {
                this.serverProtocol = "internal";
            }
            this.serverPort = serverPortString == null ? 2099 : new Integer(serverPortString);
            if (this.serverHTTPNTLMDomain != null && this.serverHTTPNTLMDomain.length() == 0) {
                this.serverHTTPNTLMDomain = null;
            }
            if (this.serverHTTPNTLMUsername == null || this.serverHTTPNTLMUsername.length() == 0) {
                this.serverHTTPNTLMUsername = null;
                this.serverHTTPNTLMPassword = null;
            }
            if ((serverHTTPSKeystoreData = this.params.getParameter("Server HTTPS truststore")) != null) {
                this.serverHTTPSKeystore = KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreData);
            }
            if (this.viewServerName == null || this.viewServerName.length() == 0) {
                this.viewServerName = this.serverName;
            }
            this.viewBasePath = this.viewProtocol + "://" + this.viewServerName + (String)viewPortString + this.viewCgiPath;
            this.hasSessionParameters = true;
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        this.getSessionParameters();
        if (!this.hasConnected) {
            int socketTimeout = 900000;
            int connectionTimeout = 300000;
            SSLConnectionSocketFactory myFactory = null;
            myFactory = this.ingestKeystoreManager != null ? new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(this.ingestKeystoreManager.getSecureSocketFactory(), (long)connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : SSLConnectionSocketFactory.getSocketFactory();
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.ingestNtlmDomain != null) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this.ingestNtlmUsername, this.ingestNtlmPassword, currentHost, this.ingestNtlmDomain));
            }
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            this.httpClient = builder.build();
            int sanityRetryCount = 10;
            while (true) {
                GetSessionThread t = new GetSessionThread();
                try {
                    t.start();
                    t.finishUp();
                    this.hasConnected = true;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RuntimeException e2) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e2, sanityRetryCount, true);
                    continue;
                }
                break;
            }
        }
        this.expirationTime = System.currentTimeMillis() + 300000L;
    }

    protected static int executeMethodViaThread(HttpClient client, HttpRequestBase executeMethod) throws InterruptedException, HttpException, IOException {
        ExecuteMethodThread t = new ExecuteMethodThread(client, executeMethod);
        t.start();
        try {
            int n = t.getResponseCode();
            return n;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw e;
        }
        finally {
            t.abort();
            t.finishUp();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.hasConnected = false;
            this.getSession();
            if (this.ingestProtocol != null) {
                String contextMsg = "for document access";
                String ingestHttpAddress = this.ingestCgiPath;
                HttpClient client = this.getInitializedClient(contextMsg);
                HttpGet method = new HttpGet(this.getHost().toURI() + ingestHttpAddress);
                method.setHeader((Header)new BasicHeader("Accept", "*/*"));
                try {
                    int statusCode = LivelinkConnector.executeMethodViaThread(client, (HttpRequestBase)method);
                    switch (statusCode) {
                        case 502: {
                            return "Fetch test had transient 502 error response";
                        }
                        case 401: {
                            return "Fetch test returned UNAUTHORIZED (401) response; check the security credentials and configuration";
                        }
                        case 200: {
                            return super.check();
                        }
                    }
                    return "Fetch test returned an unexpected response code of " + Integer.toString(statusCode);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (SocketTimeoutException e) {
                    return "Fetch test timed out reading from the Livelink HTTP Server: " + e.getMessage();
                }
                catch (SocketException e) {
                    return "Fetch test received a socket error reading from Livelink HTTP Server: " + e.getMessage();
                }
                catch (SSLHandshakeException e) {
                    return "Fetch test was unable to set up a SSL connection to Livelink HTTP Server: " + e.getMessage();
                }
                catch (ConnectTimeoutException e) {
                    return "Fetch test connection timed out reading from Livelink HTTP Server: " + e.getMessage();
                }
                catch (InterruptedIOException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (HttpException e) {
                    return "Fetch test had an HTTP exception: " + e.getMessage();
                }
                catch (IOException e) {
                    return "Fetch test had an IO failure: " + e.getMessage();
                }
            }
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 2) {
                throw e;
            }
            return "Error: " + e.getMessage();
        }
    }

    public void poll() throws ManifoldCFException {
        if (!this.hasConnected) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.expirationTime) {
            this.hasConnected = false;
            this.expirationTime = -1L;
            if (this.llServer != null) {
                this.llServer.disconnect();
                this.llServer = null;
            }
            if (this.connectionManager != null) {
                this.connectionManager.shutdown();
                this.connectionManager = null;
            }
        }
    }

    public boolean isConnected() {
        return this.hasConnected;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        this.hasConnected = false;
        this.expirationTime = -1L;
        if (this.llServer != null) {
            this.llServer.disconnect();
            this.llServer = null;
        }
        this.LLDocs = null;
        this.LLAttributes = null;
        this.ingestKeystoreManager = null;
        this.ingestPortNumber = -1;
        this.serverProtocol = null;
        this.serverName = null;
        this.serverPort = -1;
        this.serverUsername = null;
        this.serverPassword = null;
        this.serverHTTPCgi = null;
        this.serverHTTPNTLMDomain = null;
        this.serverHTTPNTLMUsername = null;
        this.serverHTTPNTLMPassword = null;
        this.serverHTTPSKeystore = null;
        this.ingestPort = null;
        this.ingestProtocol = null;
        this.ingestCgiPath = null;
        this.viewPort = null;
        this.viewServerName = null;
        this.viewProtocol = null;
        this.viewCgiPath = null;
        this.viewBasePath = null;
        this.ingestNtlmDomain = null;
        this.ingestNtlmUsername = null;
        this.ingestNtlmPassword = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
        super.disconnect();
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    protected String convertToIngestURI(String documentIdentifier) throws ManifoldCFException {
        if (!documentIdentifier.startsWith("D")) {
            return null;
        }
        int colonPosition = documentIdentifier.indexOf(":", 1);
        if (colonPosition == -1) {
            return this.ingestCgiPath + "?func=ll&objID=" + documentIdentifier.substring(1) + "&objAction=download";
        }
        return this.ingestCgiPath + "?func=ll&objID=" + documentIdentifier.substring(colonPosition + 1) + "&objAction=download";
    }

    protected String convertToViewURI(String documentIdentifier) throws ManifoldCFException {
        if (!documentIdentifier.startsWith("D")) {
            return null;
        }
        String objectID = null;
        int colonPosition = documentIdentifier.indexOf(":", 1);
        objectID = colonPosition == -1 ? documentIdentifier.substring(1) : documentIdentifier.substring(colonPosition + 1);
        String viewURL = null;
        switch (this.viewAction) {
            case "download": {
                viewURL = this.viewBasePath + "?func=ll&objAction=download&objID=" + objectID;
                break;
            }
            case "open": {
                viewURL = this.viewBasePath + "/open/" + objectID;
                break;
            }
            case "overview": {
                viewURL = this.viewBasePath + "?func=ll&objAction=overview&objID=" + objectID;
                break;
            }
            default: {
                viewURL = this.viewBasePath + "?func=ll&objAction=download&objID=" + objectID;
            }
        }
        return viewURL;
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.equals("workspaces")) {
            try {
                String[] workspaces = this.getWorkspaceNames();
                int i = 0;
                while (i < workspaces.length) {
                    String workspace = workspaces[i++];
                    ConfigurationNode node = new ConfigurationNode("workspace");
                    node.setValue(workspace);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("folders/")) {
            String path = command.substring("folders/".length());
            try {
                String[] folders = this.getChildFolderNames(path);
                int i = 0;
                while (i < folders.length) {
                    String folder = folders[i++];
                    ConfigurationNode node = new ConfigurationNode("folder");
                    node.setValue(folder);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("categories/")) {
            String path = command.substring("categories/".length());
            try {
                String[] categories = this.getChildCategoryNames(path);
                int i = 0;
                while (i < categories.length) {
                    String category = categories[i++];
                    ConfigurationNode node = new ConfigurationNode("category");
                    node.setValue(category);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("categoryattributes/")) {
            String path = command.substring("categoryattributes/".length());
            try {
                String[] attributes = this.getCategoryAttributes(path);
                int i = 0;
                while (i < attributes.length) {
                    String attribute = attributes[i++];
                    ConfigurationNode node = new ConfigurationNode("attribute");
                    node.setValue(attribute);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        LivelinkContext llc = new LivelinkContext();
        ObjectInformation rootValue = llc.getObjectInformation(this.LLENTWK_VOL, this.LLENTWK_ID);
        if (!rootValue.exists()) {
            Logging.connectors.warn((Object)"Livelink: Could not look up root workspace object during seeding!  Retrying -");
            throw new ServiceInterruption("Service interruption during seeding", (Throwable)new ManifoldCFException("Could not looking root workspace object during seeding"), System.currentTimeMillis() + 60000L, System.currentTimeMillis() + 600000L, -1, true);
        }
        boolean doUserWorkspaces = false;
        block5: for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode n = spec.getChild(i);
            if (n.getType().equals("startpoint")) {
                long beginTime = System.currentTimeMillis();
                String path = n.getAttributeValue("path");
                VolumeAndId vaf = rootValue.getPathId(path);
                if (vaf != null) {
                    activities.recordActivity(new Long(beginTime), ACTIVITY_SEED, null, path, "OK", null, null);
                    String newID = "F" + new Integer(vaf.getVolumeID()).toString() + ":" + new Integer(vaf.getPathId()).toString();
                    activities.addSeedDocument(newID);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Livelink: Seed = '" + newID + "'"));
                    }
                } else {
                    activities.recordActivity(new Long(beginTime), ACTIVITY_SEED, null, path, "NOT FOUND", null, null);
                }
            } else if (n.getType().equals("userworkspace")) {
                String value = n.getAttributeValue("value");
                if (value != null && value.equals("true")) {
                    doUserWorkspaces = true;
                } else if (value != null && value.equals("false")) {
                    doUserWorkspaces = false;
                }
            }
            if (!doUserWorkspaces) continue;
            int sanityRetryCount = 10;
            while (true) {
                ListUsersThread t = new ListUsersThread();
                try {
                    LLValue childrenDocs;
                    t.start();
                    try {
                        childrenDocs = t.finishUp();
                    }
                    catch (ManifoldCFException e) {
                        sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                        continue;
                    }
                    int size = 0;
                    if (childrenDocs.isRecord()) {
                        size = 1;
                    }
                    if (childrenDocs.isTable()) {
                        size = childrenDocs.size();
                    }
                    for (int j = 0; j < size; ++j) {
                        int childID = childrenDocs.toInteger(j, "ID");
                        if (childID == 1000 || childID == 1001) continue;
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Livelink: Found a user: ID=" + Integer.toString(childID)));
                        }
                        activities.addSeedDocument("F0:" + Integer.toString(childID));
                    }
                    continue block5;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                    continue;
                }
                break;
            }
        }
        return "";
    }

    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        LivelinkContext llc = new LivelinkContext();
        MetadataDescription desc = new MetadataDescription(llc);
        SystemMetadataDescription sDesc = new SystemMetadataDescription(llc, spec);
        Object[] acls = sDesc.getAcls();
        if (acls != null) {
            Arrays.sort(acls);
        }
        String metadataString = null;
        Object[] specifiedMetadataAttributes = null;
        CategoryPathAccumulator catAccum = null;
        if (!sDesc.includeAllMetadata()) {
            StringBuilder sb = new StringBuilder();
            specifiedMetadataAttributes = sDesc.getMetadataAttributes();
            Arrays.sort(specifiedMetadataAttributes);
            LivelinkConnector.packList((StringBuilder)sb, (String[])specifiedMetadataAttributes, (char)'+');
            metadataString = sb.toString();
        } else {
            catAccum = new CategoryPathAccumulator(llc);
        }
        StringBuilder sb2 = new StringBuilder();
        if (sDesc.getPathAttributeName() != null) {
            sb2.append("=").append(sDesc.getPathAttributeName()).append(":").append(sDesc.getPathSeparator()).append(":").append(sDesc.getMatchMapString());
        }
        String pathNameAttributeVersion = sb2.toString();
        String filterString = sDesc.getFilterString();
        for (String documentIdentifier : documentIdentifiers) {
            String[] denyAcls;
            String denyAcl;
            Object[] actualAcls;
            Object[] categoryPaths;
            int vol;
            int objID;
            activities.checkJobStillActive();
            String docID = documentIdentifier;
            boolean isFolder = docID.startsWith("F");
            int colonPos = docID.indexOf(":", 1);
            if (colonPos == -1) {
                objID = new Integer(docID.substring(1));
                vol = this.LLENTWK_VOL;
            } else {
                objID = new Integer(docID.substring(colonPos + 1));
                vol = new Integer(docID.substring(1, colonPos));
            }
            this.getSession();
            ObjectInformation value = llc.getObjectInformation(vol, objID);
            if (!value.exists()) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Object " + Integer.toString(vol) + ":" + Integer.toString(objID) + " has no information - deleting"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            int permissions = value.getPermissions();
            if ((permissions & 0x9001) == 0) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Crawl user cannot see contents of object " + Integer.toString(vol) + ":" + Integer.toString(objID) + " - deleting"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            Date dt = value.getModifyDate();
            int[] rights = this.getObjectRights(vol, objID);
            if (rights == null) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Could not get rights for object " + Integer.toString(vol) + ":" + Integer.toString(objID) + " - deleting"));
                }
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            if (isFolder) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Processing folder " + Integer.toString(vol) + ":" + Integer.toString(objID)));
                }
                int sanityRetryCount = 10;
                while (true) {
                    ListObjectsThread t = new ListObjectsThread(vol, objID, filterString);
                    try {
                        LLValue childrenDocs;
                        t.start();
                        try {
                            childrenDocs = t.finishUp();
                        }
                        catch (ManifoldCFException e) {
                            sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                            continue;
                        }
                        int size = 0;
                        if (childrenDocs.isRecord()) {
                            size = 1;
                        }
                        if (childrenDocs.isTable()) {
                            size = childrenDocs.size();
                        }
                        for (int j = 0; j < size; ++j) {
                            int subtype;
                            boolean childIsFolder;
                            int childID = childrenDocs.toInteger(j, "ID");
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Found a child of folder " + Integer.toString(vol) + ":" + Integer.toString(objID) + " : ID=" + Integer.toString(childID)));
                            }
                            boolean bl = childIsFolder = (subtype = childrenDocs.toInteger(j, "SubType")) == 0 || subtype == 202 || subtype == 136;
                            if (!childIsFolder && !LivelinkConnector.checkInclude(childrenDocs.toString(j, "Name") + "." + childrenDocs.toString(j, "FileType"), spec)) {
                                if (!Logging.connectors.isDebugEnabled()) continue;
                                Logging.connectors.debug((Object)("Livelink: Child identifier " + Integer.toString(childID) + " was excluded by inclusion criteria"));
                                continue;
                            }
                            if (childIsFolder) {
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("Livelink: Child identifier " + Integer.toString(childID) + " is a folder, project, or compound document; adding a reference"));
                                }
                                if (subtype == 202) {
                                    activities.addDocumentReference("F" + new Integer(childID).toString() + ":" + new Integer(-childID).toString());
                                    continue;
                                }
                                activities.addDocumentReference("F" + new Integer(vol).toString() + ":" + new Integer(childID).toString());
                                continue;
                            }
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Child identifier " + Integer.toString(childID) + " is a simple document; adding a reference"));
                            }
                            activities.addDocumentReference("D" + new Integer(vol).toString() + ":" + new Integer(childID).toString());
                        }
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RuntimeException e) {
                        sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                        continue;
                    }
                    break;
                }
                if (!Logging.connectors.isDebugEnabled()) continue;
                Logging.connectors.debug((Object)("Livelink: Done processing folder " + Integer.toString(vol) + ":" + Integer.toString(objID)));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (sDesc.includeAllMetadata()) {
                int[] catIDs = this.getObjectCategoryIDs(vol, objID);
                categoryPaths = catAccum.getCategoryPathsAttributeNames(catIDs);
                Arrays.sort(categoryPaths);
                LivelinkConnector.packList((StringBuilder)sb, (String[])categoryPaths, (char)'+');
            } else {
                categoryPaths = specifiedMetadataAttributes;
                sb.append(metadataString);
            }
            if (acls != null && acls.length == 0) {
                actualAcls = this.lookupTokens(rights, value);
                Arrays.sort(actualAcls);
                denyAcl = defaultAuthorityDenyToken;
            } else if (acls != null && acls.length > 0) {
                actualAcls = acls;
                denyAcl = defaultAuthorityDenyToken;
            } else {
                actualAcls = acls;
                denyAcl = null;
            }
            if (actualAcls == null) {
                sb.append('-');
                denyAcls = null;
            } else {
                sb.append('+');
                LivelinkConnector.packList((StringBuilder)sb, (String[])actualAcls, (char)'+');
                LivelinkConnector.pack((StringBuilder)sb, (String)denyAcl, (char)'+');
                denyAcls = new String[]{denyAcl};
            }
            sb.append(new Long(dt.getTime()).toString());
            sb.append("=").append(pathNameAttributeVersion);
            sb.append("_").append(this.viewBasePath);
            String versionString = sb.toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Livelink: Successfully calculated version string for document " + Integer.toString(vol) + ":" + Integer.toString(objID) + " : '" + versionString + "'"));
            }
            if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Livelink: Processing document " + Integer.toString(vol) + ":" + Integer.toString(objID)));
            }
            if (!this.checkIngest(llc, objID, spec)) {
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Decided not to ingest document " + Integer.toString(vol) + ":" + Integer.toString(objID) + " - Did not match ingestion criteria"));
                }
                activities.noDocument(documentIdentifier, versionString);
                continue;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Livelink: Decided to ingest document " + Integer.toString(vol) + ":" + Integer.toString(objID)));
            }
            this.ingestFromLiveLink(llc, documentIdentifier, versionString, (String[])actualAcls, denyAcls, (String[])categoryPaths, activities, desc, sDesc);
            if (!Logging.connectors.isDebugEnabled()) continue;
            Logging.connectors.debug((Object)("Livelink: Done processing document " + Integer.toString(vol) + ":" + Integer.toString(objID)));
        }
    }

    public int getMaxDocumentRequest() {
        return 6;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Server"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.DocumentAccess"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.DocumentView"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_JS, null, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put(TAB_NAME_PARAM, tabName);
        LivelinkConnector.fillInServerTab(velocityContext, out, parameters);
        LivelinkConnector.fillInDocumentAccessTab(velocityContext, out, parameters);
        LivelinkConnector.fillInDocumentViewTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_SERVER_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_ACCESS_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_VIEW_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol = parameters.getParameter("Server protocol");
        if (serverProtocol == null) {
            serverProtocol = "internal";
        }
        if ((serverName = parameters.getParameter("Server name")) == null) {
            serverName = "localhost";
        }
        if ((serverPort = parameters.getParameter("Server port")) == null) {
            serverPort = "2099";
        }
        if ((serverUserName = parameters.getParameter("Server user name")) == null) {
            serverUserName = "";
        }
        serverPassword = (serverPassword = parameters.getObfuscatedParameter("Server password")) == null ? "" : out.mapPasswordToKey(serverPassword);
        String serverHTTPCgiPath = parameters.getParameter("Server HTTP CGI path");
        if (serverHTTPCgiPath == null) {
            serverHTTPCgiPath = "/livelink/livelink.exe";
        }
        if ((serverHTTPNTLMDomain = parameters.getParameter("Server HTTP NTLM domain")) == null) {
            serverHTTPNTLMDomain = "";
        }
        if ((serverHTTPNTLMUserName = parameters.getParameter("Server HTTP NTLM user name")) == null) {
            serverHTTPNTLMUserName = "";
        }
        serverHTTPNTLMPassword = (serverHTTPNTLMPassword = parameters.getObfuscatedParameter("Server HTTP NTLM password")) == null ? "" : out.mapPasswordToKey(serverHTTPNTLMPassword);
        String serverHTTPSKeystore = parameters.getParameter("Server HTTPS truststore");
        HashMap<String, String> serverCertificatesMap = null;
        String message = null;
        try {
            IKeystoreManager localServerHTTPSKeystore = serverHTTPSKeystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystore);
            String[] contents = localServerHTTPSKeystore.getContents();
            if (contents.length > 0) {
                serverCertificatesMap = new HashMap<String, String>();
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    Object description = localServerHTTPSKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    serverCertificatesMap.put(alias, (String)description);
                }
            }
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
            Logging.connectors.warn((Object)e);
        }
        velocityContext.put("SERVERPROTOCOL", serverProtocol);
        velocityContext.put("SERVERNAME", serverName);
        velocityContext.put("SERVERPORT", serverPort);
        velocityContext.put("SERVERUSERNAME", serverUserName);
        velocityContext.put("SERVERPASSWORD", serverPassword);
        velocityContext.put("SERVERHTTPCGIPATH", serverHTTPCgiPath);
        velocityContext.put("SERVERHTTPNTLMDOMAIN", serverHTTPNTLMDomain);
        velocityContext.put("SERVERHTTPNTLMUSERNAME", serverHTTPNTLMUserName);
        velocityContext.put("SERVERHTTPNTLMPASSWORD", serverHTTPNTLMPassword);
        if (serverHTTPSKeystore != null) {
            velocityContext.put("SERVERHTTPSKEYSTORE", serverHTTPSKeystore);
        }
        if (serverCertificatesMap != null) {
            velocityContext.put("SERVERCERTIFICATESMAP", serverCertificatesMap);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
    }

    protected static void fillInDocumentAccessTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String ingestNtlmPassword;
        String ingestNtlmUsername;
        String ingestCgiPath;
        String ingestPort;
        String ingestProtocol = parameters.getParameter("Protocol");
        if (ingestProtocol == null) {
            ingestProtocol = "";
        }
        if ((ingestPort = parameters.getParameter("Port")) == null) {
            ingestPort = "";
        }
        if ((ingestCgiPath = parameters.getParameter("CGI path")) == null) {
            ingestCgiPath = "";
        }
        if ((ingestNtlmUsername = parameters.getParameter("NTLM user name")) == null) {
            ingestNtlmUsername = "";
        }
        ingestNtlmPassword = (ingestNtlmPassword = parameters.getObfuscatedParameter("NTLM password")) == null ? "" : out.mapPasswordToKey(ingestNtlmPassword);
        String ingestNtlmDomain = parameters.getParameter("NTLM domain");
        if (ingestNtlmDomain == null) {
            ingestNtlmDomain = "";
        }
        String ingestKeystore = parameters.getParameter("Livelink SSL keystore");
        HashMap<String, String> ingestCertificatesMap = null;
        String message = null;
        try {
            IKeystoreManager localIngestKeystore = ingestKeystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)ingestKeystore);
            String[] contents = localIngestKeystore.getContents();
            if (contents.length > 0) {
                ingestCertificatesMap = new HashMap<String, String>();
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    Object description = localIngestKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    ingestCertificatesMap.put(alias, (String)description);
                }
            }
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
            Logging.connectors.warn((Object)e);
        }
        velocityContext.put("INGESTPROTOCOL", ingestProtocol);
        velocityContext.put("INGESTPORT", ingestPort);
        velocityContext.put("INGESTCGIPATH", ingestCgiPath);
        velocityContext.put("INGESTNTLMUSERNAME", ingestNtlmUsername);
        velocityContext.put("INGESTNTLMPASSWORD", ingestNtlmPassword);
        velocityContext.put("INGESTNTLMDOMAIN", ingestNtlmDomain);
        velocityContext.put("INGESTKEYSTORE", ingestKeystore);
        if (ingestCertificatesMap != null) {
            velocityContext.put("INGESTCERTIFICATESMAP", ingestCertificatesMap);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
    }

    protected static void fillInDocumentViewTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        String viewAction;
        String viewCgiPath;
        String viewPort;
        String viewServerName;
        String viewProtocol = parameters.getParameter("View protocol");
        if (viewProtocol == null) {
            viewProtocol = "http";
        }
        if ((viewServerName = parameters.getParameter("View server name")) == null) {
            viewServerName = "";
        }
        if ((viewPort = parameters.getParameter("View port")) == null) {
            viewPort = "";
        }
        if ((viewCgiPath = parameters.getParameter("View CGI path")) == null) {
            viewCgiPath = "/livelink/livelink.exe";
        }
        if ((viewAction = parameters.getParameter("View Action")) == null) {
            viewAction = "download";
        }
        velocityContext.put("VIEWPROTOCOL", viewProtocol);
        velocityContext.put("VIEWSERVERNAME", viewServerName);
        velocityContext.put("VIEWPORT", viewPort);
        velocityContext.put("VIEWCGIPATH", viewCgiPath);
        velocityContext.put("VIEWACTION", viewAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String ingestNtlmPassword;
        String ingestNtlmUsername;
        String ingestNtlmDomain;
        String ingestCgiPath;
        String ingestPort;
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String serverHTTPCgiPath;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol;
        String viewAction;
        String viewCgiPath;
        String viewPort;
        String viewServerName;
        String viewProtocol = variableContext.getParameter("viewprotocol");
        if (viewProtocol != null) {
            parameters.setParameter("View protocol", viewProtocol);
        }
        if ((viewServerName = variableContext.getParameter("viewservername")) != null) {
            parameters.setParameter("View server name", viewServerName);
        }
        if ((viewPort = variableContext.getParameter("viewport")) != null) {
            parameters.setParameter("View port", viewPort);
        }
        if ((viewCgiPath = variableContext.getParameter("viewcgipath")) != null) {
            parameters.setParameter("View CGI path", viewCgiPath);
        }
        if ((viewAction = variableContext.getParameter("viewaction")) != null) {
            parameters.setParameter("View Action", viewAction);
        }
        if ((serverProtocol = variableContext.getParameter("serverprotocol")) != null) {
            parameters.setParameter("Server protocol", serverProtocol);
        }
        if ((serverName = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", serverName);
        }
        if ((serverPort = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", serverPort);
        }
        if ((serverUserName = variableContext.getParameter("serverusername")) != null) {
            parameters.setParameter("Server user name", serverUserName);
        }
        if ((serverPassword = variableContext.getParameter("serverpassword")) != null) {
            parameters.setObfuscatedParameter("Server password", variableContext.mapKeyToPassword(serverPassword));
        }
        if ((serverHTTPCgiPath = variableContext.getParameter("serverhttpcgipath")) != null) {
            parameters.setParameter("Server HTTP CGI path", serverHTTPCgiPath);
        }
        if ((serverHTTPNTLMDomain = variableContext.getParameter("serverhttpntlmdomain")) != null) {
            parameters.setParameter("Server HTTP NTLM domain", serverHTTPNTLMDomain);
        }
        if ((serverHTTPNTLMUserName = variableContext.getParameter("serverhttpntlmusername")) != null) {
            parameters.setParameter("Server HTTP NTLM user name", serverHTTPNTLMUserName);
        }
        if ((serverHTTPNTLMPassword = variableContext.getParameter("serverhttpntlmpassword")) != null) {
            parameters.setObfuscatedParameter("Server HTTP NTLM password", variableContext.mapKeyToPassword(serverHTTPNTLMPassword));
        }
        String serverHTTPSKeystoreValue = variableContext.getParameter("serverhttpskeystoredata");
        String serverConfigOp = variableContext.getParameter("serverconfigop");
        if (serverConfigOp != null) {
            String alias;
            if (serverConfigOp.equals("Delete")) {
                alias = variableContext.getParameter("serverkeystorealias");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                serverHTTPSKeystoreValue = mgr.getString();
            } else if (serverConfigOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("servercertificate");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                serverHTTPSKeystoreValue = mgr.getString();
            }
        }
        parameters.setParameter("Server HTTPS truststore", serverHTTPSKeystoreValue);
        String ingestProtocol = variableContext.getParameter("ingestprotocol");
        if (ingestProtocol != null) {
            parameters.setParameter("Protocol", ingestProtocol);
        }
        if ((ingestPort = variableContext.getParameter("ingestport")) != null) {
            parameters.setParameter("Port", ingestPort);
        }
        if ((ingestCgiPath = variableContext.getParameter("ingestcgipath")) != null) {
            parameters.setParameter("CGI path", ingestCgiPath);
        }
        if ((ingestNtlmDomain = variableContext.getParameter("ingestntlmdomain")) != null) {
            parameters.setParameter("NTLM domain", ingestNtlmDomain);
        }
        if ((ingestNtlmUsername = variableContext.getParameter("ingestntlmusername")) != null) {
            parameters.setParameter("NTLM user name", ingestNtlmUsername);
        }
        if ((ingestNtlmPassword = variableContext.getParameter("ingestntlmpassword")) != null) {
            parameters.setObfuscatedParameter("NTLM password", variableContext.mapKeyToPassword(ingestNtlmPassword));
        }
        String ingestKeystoreValue = variableContext.getParameter("ingestkeystoredata");
        String ingestConfigOp = variableContext.getParameter("ingestconfigop");
        if (ingestConfigOp != null) {
            if (ingestConfigOp.equals("Delete")) {
                String alias = variableContext.getParameter("ingestkeystorealias");
                IKeystoreManager mgr = ingestKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)ingestKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                ingestKeystoreValue = mgr.getString();
            } else if (ingestConfigOp.equals("Add")) {
                String alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("ingestcertificate");
                IKeystoreManager mgr = ingestKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)ingestKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                ingestKeystoreValue = mgr.getString();
            }
        }
        parameters.setParameter("Livelink SSL keystore", ingestKeystoreValue);
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                configMap.put(Encoder.bodyEscape((String)param), "********");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore") || param.length() > "truststore".length() && param.substring(param.length() - "truststore".length()).equalsIgnoreCase("truststore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                configMap.put(Encoder.bodyEscape((String)param), "=&lt;" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "LivelinkConnector.certificates") + "&gt;");
                continue;
            }
            configMap.put(Encoder.bodyEscape((String)param), Encoder.bodyEscape((String)value));
        }
        paramMap.put("CONFIGMAP", configMap);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_HTML, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Paths"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Filters"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Security"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Metadata"));
        String seqPrefixParam = "s" + connectionSequenceNumber + "_";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("seqPrefix", seqPrefixParam);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap, true);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put(TAB_NAME_PARAM, tabName);
        velocityContext.put("SeqNum", Integer.toString(connectionSequenceNumber));
        velocityContext.put("SelectedNum", Integer.toString(actualSequenceNumber));
        LivelinkConnector.fillInPathsTab(velocityContext, out, ds);
        LivelinkConnector.fillInFiltersTab(velocityContext, out, ds);
        LivelinkConnector.fillInSecurityTab(velocityContext, out, ds);
        LivelinkConnector.fillInMetadataTab(velocityContext, out, ds);
        if (tabName.equals(Messages.getString(locale, "LivelinkConnector.Paths"))) {
            this.fillInTransientPathsInfo(velocityContext, connectionSequenceNumber);
        } else if (tabName.equals(Messages.getString(locale, "LivelinkConnector.Metadata"))) {
            this.fillInTransientMetadataInfo(velocityContext, connectionSequenceNumber);
        }
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_PATHS_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_FILTERS_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_SECURITY_HTML, velocityContext);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_METADATA_HTML, velocityContext);
    }

    protected static void fillInPathsTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        boolean userWorkspaces = false;
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("userworkspace")) {
                String value = sn.getAttributeValue("value");
                if (value == null || !value.equals("true")) continue;
                userWorkspaces = true;
                continue;
            }
            if (!sn.getType().equals("startpoint")) continue;
            paths.add(sn.getAttributeValue("path"));
        }
        velocityContext.put("USERWORKSPACES", userWorkspaces);
        velocityContext.put("PATHS", paths);
    }

    protected void fillInTransientPathsInfo(Map<String, Object> velocityContext, int connectionSequenceNumber) {
        String message = null;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
        if (pathSoFar == null) {
            pathSoFar = "";
        }
        String[] childList = null;
        try {
            childList = this.getChildFolderNames(pathSoFar);
            if (childList == null) {
                pathSoFar = "";
                childList = this.getChildFolderNames("");
                if (childList == null) {
                    throw new ManifoldCFException("Can't find any children for root folder");
                }
            }
        }
        catch (ServiceInterruption e) {
            message = e.getMessage();
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
        }
        velocityContext.put("PATHSOFAR", pathSoFar);
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
        if (childList != null) {
            velocityContext.put("CHILDLIST", childList);
        }
    }

    protected static void fillInFiltersTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        ArrayList<Pair<String, String>> fileSpecs = new ArrayList<Pair<String, String>>();
        int i = 0;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("include") && !sn.getType().equals("exclude")) continue;
            fileSpecs.add(new Pair<String, String>(sn.getType(), sn.getAttributeValue("filespec")));
        }
        velocityContext.put("FILESPECS", fileSpecs);
    }

    protected static void fillInSecurityTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        String security = "on";
        ArrayList<String> accessTokens = new ArrayList<String>();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals("security")) {
                security = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            accessTokens.add(token);
        }
        velocityContext.put("SECURITY", security);
        velocityContext.put("ACCESSTOKENS", accessTokens);
    }

    protected static void fillInMetadataTab(Map<String, Object> velocityContext, IHTTPOutput out, Specification ds) {
        boolean ingestAllMetadata = false;
        String pathNameAttribute = "";
        String pathNameSeparator = "/";
        HashMap<String, String> matchMap = new HashMap<String, String>();
        ArrayList<Pair<String, Pair<String, String>>> metadataList = new ArrayList<Pair<String, Pair<String, String>>>();
        int i = 0;
        while (i < ds.getChildCount()) {
            String attributeName;
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals("allmetadata")) {
                String value = sn.getAttributeValue("all");
                if (value == null || !value.equals("true")) continue;
                ingestAllMetadata = true;
                continue;
            }
            if (sn.getType().equals("pathnameattribute")) {
                pathNameAttribute = sn.getAttributeValue("value");
                if (sn.getAttributeValue("separator") == null) continue;
                pathNameSeparator = sn.getAttributeValue("separator");
                continue;
            }
            if (sn.getType().equals("pathmap")) {
                String pathMatch = sn.getAttributeValue("match");
                String pathReplace = sn.getAttributeValue("replace");
                matchMap.put(pathMatch, pathReplace);
                continue;
            }
            if (!sn.getType().equals("metadata")) continue;
            String categoryPath = sn.getAttributeValue("category");
            String isAll = sn.getAttributeValue("all");
            if (isAll == null) {
                isAll = "false";
            }
            if ((attributeName = sn.getAttributeValue("attribute")) == null) {
                attributeName = "";
            }
            metadataList.add(new Pair<String, Pair<String, String>>(categoryPath, new Pair<String, String>(isAll, attributeName)));
        }
        velocityContext.put("INGESTALLMETADATA", ingestAllMetadata);
        velocityContext.put("PATHNAMEATTRIBUTE", pathNameAttribute);
        velocityContext.put("PATHNAMESEPARATOR", pathNameSeparator);
        velocityContext.put("MATCHMAP", matchMap);
        velocityContext.put("METADATA", metadataList);
    }

    protected void fillInTransientMetadataInfo(Map<String, Object> velocityContext, int connectionSequenceNumber) {
        String message = null;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String categorySoFar = (String)this.currentContext.get((Object)(seqPrefix + "speccategory"));
        if (categorySoFar == null) {
            categorySoFar = "";
        }
        String[] childList = null;
        String[] workspaceList = null;
        String[] categoryList = null;
        String[] attributeList = null;
        try {
            if (categorySoFar.length() == 0) {
                workspaceList = this.getWorkspaceNames();
            } else {
                attributeList = this.getCategoryAttributes(categorySoFar);
                if (attributeList == null) {
                    childList = this.getChildFolderNames(categorySoFar);
                    if (childList == null) {
                        categorySoFar = "";
                        childList = this.getChildFolderNames("");
                        if (childList == null) {
                            throw new ManifoldCFException("Can't find any children for root folder");
                        }
                    }
                    if ((categoryList = this.getChildCategoryNames(categorySoFar)) == null) {
                        throw new ManifoldCFException("Can't find any categories for root folder folder");
                    }
                }
            }
        }
        catch (ServiceInterruption e) {
            message = e.getMessage();
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
        }
        velocityContext.put("CATEGORYSOFAR", categorySoFar);
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
        if (childList != null) {
            velocityContext.put("CHILDLIST", childList);
        }
        if (workspaceList != null) {
            velocityContext.put("WORKSPACELIST", workspaceList);
        }
        if (categoryList != null) {
            velocityContext.put("CATEGORYLIST", categoryList);
        }
        if (attributeList != null) {
            velocityContext.put("ATTRIBUTELIST", attributeList);
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String op;
        String pathOpName;
        String pathDescription;
        String xc;
        SpecificationNode sn;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String userWorkspacesPresent = variableContext.getParameter(seqPrefix + "userworkspace_present");
        if (userWorkspacesPresent != null) {
            String value = variableContext.getParameter(seqPrefix + "userworkspace");
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("userworkspace")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            sn = new SpecificationNode("userworkspace");
            sn.setAttribute("value", value);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "pathcount")) != null) {
            Object path;
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("startpoint")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int pathCount = Integer.parseInt(xc);
            i = 0;
            while (i < pathCount) {
                pathDescription = "_" + Integer.toString(i);
                pathOpName = seqPrefix + "pathop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path2 = variableContext.getParameter(seqPrefix + "specpath" + pathDescription);
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path2);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "pathop");
            if (op != null && op.equals("Add")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", (String)path);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            } else if (op != null && op.equals("Up")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                int lastSlash = -1;
                int k = 0;
                while (k < ((String)path).length()) {
                    char x;
                    if ((x = ((String)path).charAt(k++)) == '/') {
                        lastSlash = k - 1;
                        continue;
                    }
                    if (x != '\\') continue;
                    ++k;
                }
                path = lastSlash == -1 ? "" : ((String)path).substring(0, lastSlash);
                this.currentContext.save((Object)(seqPrefix + "specpath"), path);
            } else if (op != null && op.equals("AddToPath")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                String addon = variableContext.getParameter(seqPrefix + "pathaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    path = ((String)path).length() == 0 ? sb.toString() : (String)path + "/" + sb.toString();
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), path);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "filecount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i);
                if (sn2.getType().equals("include") || sn2.getType().equals("exclude")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int fileCount = Integer.parseInt(xc);
            i = 0;
            while (i < fileCount) {
                String fileSpecDescription = "_" + Integer.toString(i);
                String fileOpName = seqPrefix + "fileop" + fileSpecDescription;
                xc = variableContext.getParameter(fileOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String filespecType = variableContext.getParameter(seqPrefix + "specfiletype" + fileSpecDescription);
                String filespec = variableContext.getParameter(seqPrefix + "specfile" + fileSpecDescription);
                SpecificationNode node = new SpecificationNode(filespecType);
                node.setAttribute("filespec", filespec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "fileop");
            if (op != null && op.equals("Add")) {
                String filespec = variableContext.getParameter(seqPrefix + "specfile");
                String filespectype = variableContext.getParameter(seqPrefix + "specfiletype");
                SpecificationNode node = new SpecificationNode(filespectype);
                node.setAttribute("filespec", filespec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn3 = ds.getChild(i);
                if (sn3.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node = new SpecificationNode("security");
            node.setAttribute("value", xc);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn4 = ds.getChild(i);
                if (sn4.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specallmetadata")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(i);
                if (sn5.getType().equals("allmetadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (xc.equals("true")) {
                SpecificationNode newNode = new SpecificationNode("allmetadata");
                newNode.setAttribute("all", xc);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newNode);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "metadatacount")) != null) {
            Object category;
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i);
                if (sn6.getType().equals("metadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int metadataCount = Integer.parseInt(xc);
            i = 0;
            while (i < metadataCount) {
                pathDescription = "_" + Integer.toString(i);
                pathOpName = seqPrefix + "metadataop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String category2 = variableContext.getParameter(seqPrefix + "speccategory" + pathDescription);
                String attributeName = variableContext.getParameter(seqPrefix + "specattribute" + pathDescription);
                String isAll = variableContext.getParameter(seqPrefix + "specattributeall" + pathDescription);
                SpecificationNode node = new SpecificationNode("metadata");
                node.setAttribute("category", category2);
                if (isAll != null && isAll.equals("true")) {
                    node.setAttribute("all", "true");
                } else {
                    node.setAttribute("attribute", attributeName);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "metadataop");
            if (op != null && op.equals("Add")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                String isAll = variableContext.getParameter(seqPrefix + "attributeall");
                if (isAll != null && isAll.equals("true")) {
                    SpecificationNode node = new SpecificationNode("metadata");
                    node.setAttribute("category", (String)category);
                    node.setAttribute("all", "true");
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                } else {
                    String[] attributes = variableContext.getParameterValues(seqPrefix + "attributeselect");
                    if (attributes != null && attributes.length > 0) {
                        int k = 0;
                        while (k < attributes.length) {
                            String attribute = attributes[k++];
                            SpecificationNode node = new SpecificationNode("metadata");
                            node.setAttribute("category", (String)category);
                            node.setAttribute("attribute", attribute);
                            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                        }
                    }
                }
            } else if (op != null && op.equals("Up")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                int lastSlash = -1;
                int firstColon = -1;
                int k = 0;
                while (k < ((String)category).length()) {
                    char x;
                    if ((x = ((String)category).charAt(k++)) == '/') {
                        lastSlash = k - 1;
                        continue;
                    }
                    if (x == ':') {
                        firstColon = k;
                        continue;
                    }
                    if (x != '\\') continue;
                    ++k;
                }
                category = lastSlash == -1 ? (firstColon == -1 || firstColon == ((String)category).length() ? "" : ((String)category).substring(0, firstColon)) : ((String)category).substring(0, lastSlash);
                this.currentContext.save((Object)(seqPrefix + "speccategory"), category);
            } else if (op != null && op.equals("AddToPath")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                String addon = variableContext.getParameter(seqPrefix + "metadataaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    category = ((String)category).length() == 0 || ((String)category).endsWith(":") ? (String)category + sb.toString() : (String)category + "/" + sb.toString();
                }
                this.currentContext.save((Object)(seqPrefix + "speccategory"), category);
            } else if (op != null && op.equals("SetWorkspace")) {
                String addon = variableContext.getParameter(seqPrefix + "metadataaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    String category3 = sb.toString() + ":";
                    this.currentContext.save((Object)(seqPrefix + "speccategory"), (Object)category3);
                }
            } else if (op != null && op.equals("AddCategory")) {
                category = variableContext.getParameter(seqPrefix + "speccategory");
                String addon = variableContext.getParameter(seqPrefix + "categoryaddon");
                if (addon != null && addon.length() > 0) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < addon.length()) {
                        char x;
                        if ((x = addon.charAt(k++)) == '/' || x == '\\' || x == ':') {
                            sb.append('\\');
                        }
                        sb.append(x);
                    }
                    category = ((String)category).length() == 0 || ((String)category).endsWith(":") ? (String)category + sb.toString() : (String)category + "/" + sb.toString();
                }
                this.currentContext.save((Object)(seqPrefix + "speccategory"), category);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specpathnameattribute")) != null) {
            String separator = variableContext.getParameter(seqPrefix + "specpathnameseparator");
            if (separator == null) {
                separator = "/";
            }
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(i2);
                if (sn7.getType().equals("pathnameattribute")) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            if (xc.length() > 0) {
                SpecificationNode node = new SpecificationNode("pathnameattribute");
                node.setAttribute("value", xc);
                node.setAttribute("separator", separator);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specmappingcount")) != null) {
            int i3 = 0;
            while (i3 < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(i3);
                if (sn8.getType().equals("pathmap")) {
                    ds.removeChild(i3);
                    continue;
                }
                ++i3;
            }
            int mappingCount = Integer.parseInt(xc);
            i3 = 0;
            while (i3 < mappingCount) {
                pathDescription = "_" + Integer.toString(i3);
                pathOpName = seqPrefix + "specmappingop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i3;
                    continue;
                }
                String match = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription);
                String replace = variableContext.getParameter(seqPrefix + "specreplace" + pathDescription);
                SpecificationNode node = new SpecificationNode("pathmap");
                node.setAttribute("match", match);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i3;
            }
            xc = variableContext.getParameter(seqPrefix + "specmappingop");
            if (xc != null && xc.equals("Add")) {
                String match = variableContext.getParameter(seqPrefix + "specmatch");
                String replace = variableContext.getParameter(seqPrefix + "specreplace");
                SpecificationNode node = new SpecificationNode("pathmap");
                node.setAttribute("match", match);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        LivelinkConnector.fillInPathsTab(velocityContext, out, ds);
        LivelinkConnector.fillInFiltersTab(velocityContext, out, ds);
        LivelinkConnector.fillInSecurityTab(velocityContext, out, ds);
        LivelinkConnector.fillInMetadataTab(velocityContext, out, ds);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, velocityContext);
    }

    public String[] getWorkspaceNames() throws ManifoldCFException, ServiceInterruption {
        return new String[]{CATEGORY_NAME, ENTWKSPACE_NAME};
    }

    public String[] getChildFolderNames(String pathString) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.getChildFolders(new LivelinkContext(), pathString);
    }

    public String[] getChildCategoryNames(String pathString) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.getChildCategories(new LivelinkContext(), pathString);
    }

    public String[] getCategoryAttributes(String pathString) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.getCategoryAttributes(new LivelinkContext(), pathString);
    }

    protected String[] getCategoryAttributes(LivelinkContext llc, String pathString) throws ManifoldCFException, ServiceInterruption {
        RootValue rv = new RootValue(llc, pathString);
        int catObjectID = this.getCategoryId(rv);
        if (catObjectID == -1) {
            return null;
        }
        String[] rval = this.getCategoryAttributes(catObjectID);
        if (rval == null) {
            return new String[0];
        }
        return rval;
    }

    protected String createLivelinkLoginURI() throws ManifoldCFException {
        StringBuilder llURI = new StringBuilder();
        llURI.append(this.ingestCgiPath);
        llURI.append("?func=ll.login&CurrentClientTime=D%2F2005%2F3%2F9%3A13%3A16%3A30&NextURL=");
        llURI.append(URLEncoder.encode((String)this.ingestCgiPath));
        llURI.append("%3FRedirect%3D1&Username=");
        llURI.append(URLEncoder.encode((String)this.llServer.getLLUser()));
        llURI.append("&Password=");
        llURI.append(URLEncoder.encode((String)this.llServer.getLLPwd()));
        return llURI.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ingestFromLiveLink(LivelinkContext llc, String documentIdentifier, String version, String[] actualAcls, String[] denyAcls, String[] categoryPaths, IProcessActivity activities, MetadataDescription desc, SystemMetadataDescription sDesc) throws ManifoldCFException, ServiceInterruption {
        block110: {
            block108: {
                block107: {
                    contextMsg = "for '" + documentIdentifier + "'";
                    startTime = System.currentTimeMillis();
                    resultCode = null;
                    resultDescription = null;
                    readSize = null;
                    colonPos = documentIdentifier.indexOf(":", 1);
                    if (colonPos == -1) {
                        objID = new Integer(documentIdentifier.substring(1));
                        vol = this.LLENTWK_VOL;
                    } else {
                        objID = new Integer(documentIdentifier.substring(colonPos + 1));
                        vol = new Integer(documentIdentifier.substring(1, colonPos));
                    }
                    try {
                        viewHttpAddress = this.convertToViewURI(documentIdentifier);
                        if (viewHttpAddress == null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: No view URI " + contextMsg + " - not ingesting"));
                            }
                            resultCode = "NOVIEWURI";
                            resultDescription = "Document had no view URI";
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        if (!activities.checkURLIndexable(viewHttpAddress)) {
                            resultCode = "EXCLUDEDURL";
                            resultDescription = "URL (" + viewHttpAddress + ") was rejected by output connector";
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Excluding document " + documentIdentifier + " because its URL (" + viewHttpAddress + ") was rejected by output connector"));
                            }
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        objInfo = llc.getObjectInformation(vol, objID);
                        versInfo = llc.getVersionInformation(vol, objID, 0);
                        if (!objInfo.exists()) {
                            resultCode = "OBJECTNOTFOUND";
                            resultDescription = "Object was not found in Livelink";
                            Logging.connectors.debug((Object)("Livelink: No object " + contextMsg + ": not ingesting"));
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        if (!versInfo.exists()) {
                            resultCode = "VERSIONNOTFOUND";
                            resultDescription = "Version was not found in Livelink";
                            Logging.connectors.debug((Object)("Livelink: No version data " + contextMsg + ": not ingesting"));
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        mimeType = versInfo.getMimeType();
                        if (!activities.checkMimeTypeIndexable(mimeType)) {
                            resultCode = "EXCLUDEDMIMETYPE";
                            resultDescription = "Mime type (" + mimeType + ") was rejected by output connector";
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Excluding document " + documentIdentifier + " because its mime type (" + mimeType + ") was rejected by output connector"));
                            }
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        dataSize = versInfo.getDataSize();
                        if (dataSize == null) {
                            resultCode = "DOCUMENTNOLENGTH";
                            resultDescription = "Document had no length in Livelink";
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Excluding document " + documentIdentifier + " because it had no length"));
                            }
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        if (!activities.checkLengthIndexable(dataSize.longValue())) {
                            resultCode = "EXCLUDEDLENGTH";
                            resultDescription = "Document length (" + dataSize + ") was rejected by output connector";
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Excluding document " + documentIdentifier + " because its length (" + dataSize + ") was rejected by output connector"));
                            }
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        modifyDate = versInfo.getModifyDate();
                        if (!activities.checkDateIndexable(modifyDate)) {
                            resultCode = "EXCLUDEDDATE";
                            resultDescription = "Document date (" + modifyDate + ") was rejected by output connector";
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Excluding document " + documentIdentifier + " because its date (" + modifyDate + ") was rejected by output connector"));
                            }
                            activities.noDocument(documentIdentifier, version);
                            return;
                        }
                        fileName = versInfo.getFileName();
                        creationDate = objInfo.getCreationDate();
                        parentID = objInfo.getParentId();
                        rd = new RepositoryDocument();
                        if (mimeType != null) {
                            rd.setMimeType(mimeType);
                        }
                        if (fileName != null) {
                            rd.setFileName(fileName);
                        }
                        if (creationDate != null) {
                            rd.setCreatedDate(creationDate);
                        }
                        if (modifyDate != null) {
                            rd.setModifiedDate(modifyDate);
                        }
                        rd.addField("general_name", objInfo.getName());
                        rd.addField("general_description", objInfo.getComments());
                        if (creationDate != null) {
                            rd.addField("general_creationdate", DateParser.formatISO8601Date((Date)creationDate));
                        }
                        if (modifyDate != null) {
                            rd.addField("general_modifydate", DateParser.formatISO8601Date((Date)modifyDate));
                        }
                        if (parentID != null) {
                            rd.addField("general_parentid", parentID.toString());
                        }
                        owner = llc.getUserInformation(objInfo.getOwnerId());
                        creator = llc.getUserInformation(objInfo.getCreatorId());
                        modifier = llc.getUserInformation(versInfo.getOwnerId());
                        if (owner != null) {
                            rd.addField("general_owner", owner.getName());
                        }
                        if (creator != null) {
                            rd.addField("general_creator", creator.getName());
                        }
                        if (modifier != null) {
                            rd.addField("general_modifier", modifier.getName());
                        }
                        catIter = desc.getItems(categoryPaths);
                        while (catIter.hasNext()) {
                            item = catIter.next();
                            pathItem = item.getPathItem();
                            if (pathItem == null || (catVersion = this.getCatVersion(objID, catID = pathItem.getCatID())) == null) continue;
                            attrIter = item.getAttributeNames();
                            while (attrIter.hasNext()) {
                                attrName = attrIter.next();
                                metadataName = pathItem.getCatName() + ":" + attrName;
                                metadataValue = this.getAttributeValue(catVersion, attrName);
                                if (metadataValue != null) {
                                    rd.addField(metadataName, metadataValue);
                                    continue;
                                }
                                Logging.connectors.warn((Object)("Livelink: Metadata attribute '" + metadataName + "' does not seem to exist; please correct the job"));
                            }
                        }
                        if (actualAcls != null && denyAcls != null) {
                            rd.setSecurity("document", actualAcls, denyAcls);
                        }
                        if ((pathAttributeName = sDesc.getPathAttributeName()) != null && pathAttributeName.length() > 0 && (pathString = sDesc.getPathAttributeValue(documentIdentifier)) != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Livelink: Path attribute name is '" + pathAttributeName + "'" + contextMsg + ", value is '" + pathString + "'"));
                            }
                            rd.addField(pathAttributeName, pathString);
                        }
                        if (this.ingestProtocol != null) {
                            ingestHttpAddress = this.convertToIngestURI(documentIdentifier);
                            if (ingestHttpAddress == null) {
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("Livelink: No fetch URI " + contextMsg + " - not ingesting"));
                                }
                                resultCode = "NOURI";
                                resultDescription = "Document had no fetch URI";
                                activities.noDocument(documentIdentifier, version);
                                return;
                            }
                            client = this.getInitializedClient(contextMsg);
                            if (Logging.connectors.isInfoEnabled()) {
                                Logging.connectors.info((Object)("Livelink: " + ingestHttpAddress));
                            }
                            method = new HttpGet(this.getHost().toURI() + ingestHttpAddress);
                            method.setHeader((Header)new BasicHeader("Accept", "*/*"));
                            wasInterrupted = false;
                            methodThread = new ExecuteMethodThread(client, (HttpRequestBase)method);
                            methodThread.start();
                            try {
                                statusCode = methodThread.getResponseCode();
                                switch (statusCode) {
                                    case 500: 
                                    case 502: {
                                        Logging.connectors.warn((Object)("Livelink: Service interruption during fetch " + contextMsg + " with Livelink HTTP Server, retrying..."));
                                        resultCode = "FETCHFAILED";
                                        resultDescription = "HTTP error code " + statusCode + " fetching document";
                                        throw new ServiceInterruption("Service interruption during fetch", (Throwable)new ManifoldCFException(Integer.toString(statusCode) + " error while fetching"), System.currentTimeMillis() + 60000L, System.currentTimeMillis() + 600000L, -1, true);
                                    }
                                    case 401: {
                                        Logging.connectors.warn((Object)("Livelink: Document fetch unauthorized for " + ingestHttpAddress + " (" + contextMsg + ")"));
                                        resultCode = "UNAUTHORIZED";
                                        resultDescription = "Document fetch was unauthorized by IIS";
                                        activities.noDocument(documentIdentifier, version);
                                        if (resultCode == null) return;
                                        break block107;
                                    }
                                    case 200: {
                                        if (Logging.connectors.isDebugEnabled()) {
                                            Logging.connectors.debug((Object)("Livelink: Created http document connection to Livelink " + contextMsg));
                                        }
                                        if (methodThread.getResponseContentLength() < 0L) {
                                            resultCode = "SESSIONLOGINFAILED";
                                            resultDescription = "Response content length was -1, which usually means session login did not succeed";
                                            activities.noDocument(documentIdentifier, version);
                                            if (resultCode == null) return;
                                            break block108;
                                        }
                                        is = methodThread.getSafeInputStream();
                                        try {
                                            rd.setBinary(is, dataSize.longValue());
                                            activities.ingestDocumentWithException(documentIdentifier, version, viewHttpAddress, rd);
                                            resultCode = "OK";
                                            readSize = dataSize;
                                            if (!Logging.connectors.isDebugEnabled()) break;
                                            Logging.connectors.debug((Object)("Livelink: Ingesting done " + contextMsg));
                                        }
                                        finally {
                                            is.close();
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        wasInterrupted = true;
                                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                    }
                                    catch (HttpException e) {
                                        resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                        resultDescription = e.getMessage();
                                        LivelinkConnector.handleHttpException(contextMsg, e);
                                        ** break;
lbl191:
                                        // 1 sources

                                    }
                                    catch (IOException e) {
                                        resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                        resultDescription = e.getMessage();
                                        LivelinkConnector.handleIOException(contextMsg, e);
                                        ** break;
lbl197:
                                        // 1 sources

                                    }
                                    case 305: 
                                    case 400: 
                                    case 410: {
                                        resultCode = "HTTPERROR";
                                        resultDescription = "Http request returned status " + Integer.toString(statusCode);
                                        throw new ManifoldCFException("Unrecoverable request failure; error = " + Integer.toString(statusCode));
                                    }
                                    default: {
                                        resultCode = "UNKNOWNHTTPCODE";
                                        resultDescription = "Http request returned status " + Integer.toString(statusCode);
                                        Logging.connectors.warn((Object)("Livelink: Attempt to retrieve document from '" + ingestHttpAddress + "' received a response of " + Integer.toString(statusCode) + "; retrying in one minute"));
                                        currentTime = System.currentTimeMillis();
                                        throw new ServiceInterruption("Fetch failed; retrying in 1 minute", (Throwable)new ManifoldCFException("Fetch failed with unknown code " + Integer.toString(statusCode)), currentTime + 60000L, currentTime + 600000L, -1, true);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                methodThread.interrupt();
                                methodThread = null;
                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                            }
                            catch (HttpException e) {
                                resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                resultDescription = e.getMessage();
                                LivelinkConnector.handleHttpException(contextMsg, e);
                            }
                            catch (IOException e) {
                                resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                resultDescription = e.getMessage();
                                LivelinkConnector.handleIOException(contextMsg, e);
                            }
                            finally {
                                if (methodThread != null) {
                                    methodThread.abort();
                                    try {
                                        if (!wasInterrupted) {
                                            methodThread.finishUp();
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
                                    }
                                }
                            }
                        } else {
                            t = new DocumentReadingThread(vol, objID, 0);
                            wasInterrupted = false;
                            t.start();
                            try {
                                try {
                                    is = t.getSafeInputStream();
                                    try {
                                        rd.setBinary(is, dataSize.longValue());
                                        activities.ingestDocumentWithException(documentIdentifier, version, viewHttpAddress, rd);
                                        resultCode = "OK";
                                        readSize = dataSize;
                                    }
                                    finally {
                                        is.close();
                                    }
                                }
                                catch (SocketTimeoutException e) {
                                    throw e;
                                }
                                catch (InterruptedIOException e) {
                                    wasInterrupted = true;
                                    throw e;
                                }
                                finally {
                                    if (!wasInterrupted) {
                                        t.finishUp();
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                t.interrupt();
                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                            }
                            catch (IOException e) {
                                resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                resultDescription = e.getMessage();
                                LivelinkConnector.handleIOException(contextMsg, e);
                            }
                            catch (RuntimeException e) {
                                resultCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                resultDescription = e.getMessage();
                                this.handleLivelinkRuntimeException(e, 0, true);
                            }
                        }
                        if (resultCode == null) return;
                        break block110;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() != 2) throw e;
                        resultCode = null;
                        throw e;
                    }
                }
                activities.recordActivity(new Long(startTime), "fetch document", readSize, vol + ":" + objID, resultCode, (String)resultDescription, null);
                return;
            }
            activities.recordActivity(new Long(startTime), "fetch document", readSize, vol + ":" + objID, resultCode, (String)resultDescription, null);
            return;
        }
        activities.recordActivity(new Long(startTime), "fetch document", readSize, vol + ":" + objID, resultCode, (String)resultDescription, null);
        return;
        finally {
            if (resultCode != null) {
                activities.recordActivity(new Long(startTime), "fetch document", readSize, vol + ":" + objID, resultCode, (String)resultDescription, null);
            }
        }
    }

    protected static void handleHttpException(String contextMsg, HttpException e) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        Logging.connectors.warn((Object)("Livelink: HTTP exception ingesting " + contextMsg + ": " + e.getMessage()), (Throwable)e);
        throw new ServiceInterruption("HTTP exception ingesting " + contextMsg + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
    }

    protected static void handleIOException(String contextMsg, IOException e) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        if (e instanceof SocketTimeoutException) {
            Logging.connectors.warn((Object)("Livelink: Livelink socket timed out ingesting from the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Socket timed out: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
        }
        if (e instanceof SocketException) {
            Logging.connectors.warn((Object)("Livelink: Livelink socket error ingesting from the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Socket error: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
        }
        if (e instanceof SSLHandshakeException) {
            Logging.connectors.warn((Object)("Livelink: SSL handshake failed authenticating " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("SSL handshake error: " + e.getMessage(), (Throwable)e, currentTime + 60000L, currentTime + 300000L, -1, true);
        }
        if (e instanceof ConnectTimeoutException) {
            Logging.connectors.warn((Object)("Livelink: Livelink socket timed out connecting to the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Connect timed out: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("Livelink: IO exception ingesting " + contextMsg + ": " + e.getMessage()), (Throwable)e);
        throw new ServiceInterruption("IO exception ingesting " + contextMsg + ": " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, false);
    }

    protected HttpClient getInitializedClient(String contextMsg) throws ServiceInterruption, ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Livelink: Session authenticating via http " + contextMsg + "..."));
        }
        HttpGet authget = new HttpGet(this.getHost().toURI() + this.createLivelinkLoginURI());
        authget.setHeader((Header)new BasicHeader("Accept", "*/*"));
        try {
            int statusCode;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Livelink: Created new HttpGet " + contextMsg + "; executing authentication method"));
            }
            if ((statusCode = LivelinkConnector.executeMethodViaThread(this.httpClient, (HttpRequestBase)authget)) == 502 || statusCode == 500) {
                Logging.connectors.warn((Object)("Livelink: Service interruption during authentication " + contextMsg + " with Livelink HTTP Server, retrying..."));
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("502 error during authentication", (Throwable)new ManifoldCFException("502 error while authenticating"), currentTime + 60000L, currentTime + 600000L, -1, true);
            }
            if (statusCode != 200) {
                Logging.connectors.error((Object)("Livelink: Failed to authenticate " + contextMsg + " against Livelink HTTP Server; Status code: " + statusCode));
                if (statusCode == 401) {
                    throw new ManifoldCFException("Session authorization failed with a 401 code; are credentials correct?");
                }
                throw new ManifoldCFException("Session authorization failed with code " + Integer.toString(statusCode));
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            Logging.connectors.warn((Object)("Livelink: Socket timed out authenticating to the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Socket timed out: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, true);
        }
        catch (SocketException e) {
            long currentTime = System.currentTimeMillis();
            Logging.connectors.warn((Object)("Livelink: Socket error authenticating to the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Socket error: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, true);
        }
        catch (SSLHandshakeException e) {
            long currentTime = System.currentTimeMillis();
            Logging.connectors.warn((Object)("Livelink: SSL handshake failed authenticating " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("SSL handshake error: " + e.getMessage(), (Throwable)e, currentTime + 60000L, currentTime + 300000L, -1, true);
        }
        catch (ConnectTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            Logging.connectors.warn((Object)("Livelink: Connect timed out authenticating to the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Connect timed out: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, true);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (HttpException e) {
            Logging.connectors.error((Object)("Livelink: HTTP exception when authenticating to the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Unable to communicate with the Livelink HTTP Server: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logging.connectors.error((Object)("Livelink: IO exception when authenticating to the Livelink HTTP Server " + contextMsg + ": " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Unable to communicate with the Livelink HTTP Server: " + e.getMessage(), (Throwable)e);
        }
        return this.httpClient;
    }

    protected static String packCategoryAttribute(String category, String attribute) {
        StringBuilder sb = new StringBuilder();
        LivelinkConnector.pack((StringBuilder)sb, (String)category, (char)':');
        LivelinkConnector.pack((StringBuilder)sb, (String)attribute, (char)':');
        return sb.toString();
    }

    protected static void unpackCategoryAttribute(StringBuilder category, StringBuilder attribute, String value) {
        int startPos = 0;
        startPos = LivelinkConnector.unpack((StringBuilder)category, (String)value, (int)startPos, (char)':');
        startPos = LivelinkConnector.unpack((StringBuilder)attribute, (String)value, (int)startPos, (char)':');
    }

    protected String[] getChildFolders(LivelinkContext llc, String pathString) throws ManifoldCFException, ServiceInterruption {
        RootValue rv = new RootValue(llc, pathString);
        VolumeAndId vid = this.getPathId(rv);
        if (vid == null) {
            return null;
        }
        String filterString = "(SubType=0 or SubType=202 or SubType=136)";
        int sanityRetryCount = 10;
        while (true) {
            ListObjectsThread t = new ListObjectsThread(vid.getVolumeID(), vid.getPathId(), filterString);
            try {
                LLValue children;
                t.start();
                try {
                    children = t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
                String[] rval = new String[children.size()];
                for (int j = 0; j < children.size(); ++j) {
                    rval[j] = children.toString(j, "Name");
                }
                return rval;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected String[] getChildCategories(LivelinkContext llc, String pathString) throws ManifoldCFException, ServiceInterruption {
        RootValue rv = new RootValue(llc, pathString);
        VolumeAndId vid = this.getPathId(rv);
        if (vid == null) {
            return null;
        }
        String filterString = "SubType=131";
        int sanityRetryCount = 10;
        while (true) {
            ListObjectsThread t = new ListObjectsThread(vid.getVolumeID(), vid.getPathId(), filterString);
            try {
                LLValue children;
                t.start();
                try {
                    children = t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
                String[] rval = new String[children.size()];
                for (int j = 0; j < children.size(); ++j) {
                    rval[j] = children.toString(j, "Name");
                }
                return rval;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected String[] getCategoryAttributes(int catObjectID) throws ManifoldCFException, ServiceInterruption {
        int sanityRetryCount = 10;
        while (true) {
            GetCategoryAttributesThread t = new GetCategoryAttributesThread(catObjectID);
            try {
                LLValue children;
                t.start();
                try {
                    children = t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
                if (children == null) {
                    return null;
                }
                String[] rval = new String[children.size()];
                LLValueEnumeration en = children.enumerateValues();
                int j = 0;
                while (en.hasMoreElements()) {
                    LLValue v = (LLValue)en.nextElement();
                    rval[j] = v.toString();
                    ++j;
                }
                return rval;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected LLValue getCatVersion(int objID, int catID) throws ManifoldCFException, ServiceInterruption {
        int sanityRetryCount = 10;
        while (true) {
            GetCategoryVersionThread t = new GetCategoryVersionThread(objID, catID);
            try {
                t.start();
                try {
                    return t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (NullPointerException npe) {
                Logging.connectors.warn((Object)("Livelink: Null pointer exception thrown trying to get cat version for category " + Integer.toString(catID) + " for object " + Integer.toString(objID)));
                return null;
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected String[] getAttributeValue(LLValue categoryVersion, String attributeName) throws ManifoldCFException, ServiceInterruption {
        int sanityRetryCount = 10;
        while (true) {
            GetAttributeValueThread t = new GetAttributeValueThread(categoryVersion, attributeName);
            try {
                LLValue children;
                t.start();
                try {
                    children = t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
                if (children == null) {
                    return null;
                }
                String[] rval = new String[children.size()];
                LLValueEnumeration en = children.enumerateValues();
                int j = 0;
                while (en.hasMoreElements()) {
                    LLValue v = (LLValue)en.nextElement();
                    rval[j] = v.toString();
                    ++j;
                }
                return rval;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected int[] getObjectRights(int vol, int objID) throws ManifoldCFException, ServiceInterruption {
        int sanityRetryCount = 10;
        while (true) {
            GetObjectRightsThread t = new GetObjectRightsThread(vol, objID);
            try {
                int j;
                LLValue childrenObjects;
                t.start();
                try {
                    childrenObjects = t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
                if (childrenObjects == null) {
                    return null;
                }
                int size = childrenObjects.isRecord() ? 1 : (childrenObjects.isTable() ? childrenObjects.size() : 0);
                int minPermission = 36867;
                int count = 0;
                for (j = 0; j < size; ++j) {
                    int permission = childrenObjects.toInteger(j, "Permissions");
                    if ((permission & minPermission) != minPermission) continue;
                    ++count;
                }
                int[] rval = new int[count];
                count = 0;
                for (j = 0; j < size; ++j) {
                    int token = childrenObjects.toInteger(j, "RightID");
                    int permission = childrenObjects.toInteger(j, "Permissions");
                    if ((permission & minPermission) != minPermission) continue;
                    rval[count++] = token;
                }
                return rval;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected String[] lookupTokens(int[] rights, ObjectInformation objInfo) throws ManifoldCFException, ServiceInterruption {
        if (!objInfo.exists()) {
            return null;
        }
        String[] convertedAcls = new String[rights.length];
        Object infoObject = null;
        int j = 0;
        int k = 0;
        while (j < rights.length) {
            String tokenValue;
            int token = rights[j++];
            switch (token) {
                case -3: {
                    tokenValue = objInfo.getOwnerId().toString();
                    break;
                }
                case -4: {
                    tokenValue = objInfo.getGroupId().toString();
                    break;
                }
                case -1: {
                    tokenValue = "GUEST";
                    break;
                }
                case -2: {
                    tokenValue = "SYSTEM";
                    break;
                }
                default: {
                    tokenValue = Integer.toString(token);
                }
            }
            if (tokenValue == null) continue;
            convertedAcls[k++] = tokenValue;
        }
        String[] actualAcls = new String[k];
        for (j = 0; j < k; ++j) {
            actualAcls[j] = convertedAcls[j];
        }
        return actualAcls;
    }

    protected int[] getObjectCategoryIDs(int vol, int id) throws ManifoldCFException, ServiceInterruption {
        int sanityRetryCount = 10;
        while (true) {
            GetObjectCategoryIDsThread t = new GetObjectCategoryIDsThread(vol, id);
            try {
                int j;
                LLValue catIDList;
                t.start();
                try {
                    catIDList = t.finishUp();
                }
                catch (ManifoldCFException e) {
                    sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                    continue;
                }
                if (catIDList == null) {
                    return null;
                }
                int size = catIDList.size();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Object " + Integer.toString(vol) + ":" + Integer.toString(id) + " has " + Integer.toString(size) + " attached categories"));
                }
                int count = 0;
                for (j = 0; j < size; ++j) {
                    int type = catIDList.toValue(j).toInteger("Type");
                    if (type != 0) continue;
                    ++count;
                }
                int[] rval = new int[count];
                count = 0;
                for (j = 0; j < size; ++j) {
                    int type = catIDList.toValue(j).toInteger("Type");
                    if (type != 0) continue;
                    int childID = catIDList.toValue(j).toInteger("ID");
                    rval[count++] = childID;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Object " + Integer.toString(vol) + ":" + Integer.toString(id) + " has " + Integer.toString(rval.length) + " attached library categories"));
                }
                return rval;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RuntimeException e) {
                sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                continue;
            }
            break;
        }
    }

    protected VolumeAndId getPathId(RootValue rv) throws ManifoldCFException, ServiceInterruption {
        return rv.getRootValue().getPathId(rv.getRemainderPath());
    }

    protected int getCategoryId(RootValue rv) throws ManifoldCFException, ServiceInterruption {
        return rv.getRootValue().getCategoryId(rv.getRemainderPath());
    }

    protected static boolean checkInclude(String filename, Specification documentSpecification) throws ManifoldCFException {
        String filespec;
        SpecificationNode sn;
        int i;
        for (i = 0; !(i >= documentSpecification.getChildCount() || (sn = documentSpecification.getChild(i)).getType().equals("include") && LivelinkConnector.checkMatch(filename, 0, filespec = sn.getAttributeValue("filespec"))); ++i) {
        }
        if (i == documentSpecification.getChildCount()) {
            return false;
        }
        for (i = 0; i < documentSpecification.getChildCount(); ++i) {
            sn = documentSpecification.getChild(i);
            if (!sn.getType().equals("exclude") || !LivelinkConnector.checkMatch(filename, 0, filespec = sn.getAttributeValue("filespec"))) continue;
            return false;
        }
        return true;
    }

    protected boolean checkIngest(LivelinkContext llc, int objID, Specification documentSpecification) throws ManifoldCFException {
        return true;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = false;
        return LivelinkConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return LivelinkConnector.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || LivelinkConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    protected int handleLivelinkRuntimeException(RuntimeException e, int sanityRetryCount, boolean failIfTimeout) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof LLHTTPAccessDeniedException || e instanceof LLHTTPClientException || e instanceof LLHTTPServerException || e instanceof LLIndexOutOfBoundsException || e instanceof LLNoFieldSpecifiedException || e instanceof LLNoValueSpecifiedException || e instanceof LLSecurityProviderException || e instanceof LLUnknownFieldException || e instanceof NumberFormatException || e instanceof ArrayIndexOutOfBoundsException) {
            String details = this.llServer.getErrors();
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Livelink API error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, failIfTimeout);
        }
        if (e instanceof LLBadServerCertificateException || e instanceof LLHTTPCGINotFoundException || e instanceof LLCouldNotConnectHTTPException || e instanceof LLHTTPForbiddenException || e instanceof LLHTTPProxyAuthRequiredException || e instanceof LLHTTPRedirectionException || e instanceof LLUnsupportedAuthMethodException || e instanceof LLWebAuthInitException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Livelink API error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e);
        }
        if (e instanceof LLSSLNotAvailableException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Missing llssl.jar error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e);
        }
        if (e instanceof LLIllegalOperationException) {
            String details = this.llServer.getErrors();
            return LivelinkConnector.assessRetry(sanityRetryCount, new ManifoldCFException("Livelink API illegal operation error: " + e.getMessage() + (String)(details == null ? "" : "; " + details), (Throwable)e));
        }
        if (e instanceof LLIOException || e instanceof RuntimeException && e.getClass().getName().startsWith("com.opentext.api.")) {
            try {
                InetAddress.getByName(this.serverName);
            }
            catch (UnknownHostException e2) {
                throw new ManifoldCFException("Server name '" + this.serverName + "' cannot be resolved", (Throwable)e2);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption(e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, failIfTimeout);
        }
        throw e;
    }

    protected static int assessRetry(int sanityRetryCount, ManifoldCFException e) throws ManifoldCFException {
        if (sanityRetryCount == 0) {
            throw e;
        }
        --sanityRetryCount;
        try {
            ManifoldCF.sleep((long)1000L);
        }
        catch (InterruptedException e2) {
            throw new ManifoldCFException(e2.getMessage(), (Throwable)e2, 2);
        }
        return sanityRetryCount;
    }

    static {
        try {
            currentAddr = InetAddress.getLocalHost();
            currentHost = currentAddr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static class ExecuteMethodThread
    extends Thread {
        protected final HttpClient httpClient;
        protected final HttpRequestBase executeMethod;
        protected HttpResponse response = null;
        protected Throwable responseException = null;
        protected XThreadInputStream threadStream = null;
        protected InputStream bodyStream = null;
        protected boolean streamCreated = false;
        protected Throwable streamException = null;
        protected boolean abortThread = false;
        protected Throwable shutdownException = null;
        protected Throwable generalException = null;

        public ExecuteMethodThread(HttpClient httpClient, HttpRequestBase executeMethod) {
            this.setDaemon(true);
            this.httpClient = httpClient;
            this.executeMethod = executeMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ExecuteMethodThread executeMethodThread;
                try {
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        if (!this.abortThread) {
                            try {
                                this.response = this.httpClient.execute((HttpUriRequest)this.executeMethod);
                            }
                            catch (SocketTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (ConnectTimeoutException e) {
                                this.responseException = e;
                            }
                            catch (InterruptedIOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                this.responseException = e;
                            }
                            this.notifyAll();
                        }
                    }
                    if (this.responseException == null) {
                        executeMethodThread = this;
                        synchronized (executeMethodThread) {
                            if (!this.abortThread) {
                                try {
                                    this.bodyStream = this.response.getEntity().getContent();
                                    if (this.bodyStream != null) {
                                        this.threadStream = new XThreadInputStream(this.bodyStream);
                                    }
                                    this.streamCreated = true;
                                }
                                catch (SocketTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (ConnectTimeoutException e) {
                                    this.streamException = e;
                                }
                                catch (InterruptedIOException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    this.streamException = e;
                                }
                                this.notifyAll();
                            }
                        }
                    }
                    if (this.responseException == null && this.streamException == null && this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.bodyStream != null) {
                        try {
                            this.bodyStream.close();
                        }
                        catch (IOException iOException) {}
                        this.bodyStream = null;
                    }
                    executeMethodThread = this;
                    synchronized (executeMethodThread) {
                        try {
                            this.executeMethod.abort();
                        }
                        catch (Throwable e) {
                            this.shutdownException = e;
                        }
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable e) {
                this.generalException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getResponseCode() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        return this.response.getStatusLine().getStatusCode();
                    }
                    this.wait();
                }
            }
        }

        public long getResponseContentLength() throws InterruptedException, IOException, HttpException {
            String contentLength = this.getFirstHeader("Content-Length");
            if (contentLength == null || contentLength.length() == 0) {
                return -1L;
            }
            return new Long(contentLength.trim());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getFirstHeader(String headerName) throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    this.checkException(this.responseException);
                    if (this.response != null) {
                        Header h = this.response.getFirstHeader(headerName);
                        if (h == null) {
                            return null;
                        }
                        return h.getValue();
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, HttpException {
            while (true) {
                ExecuteMethodThread executeMethodThread = this;
                synchronized (executeMethodThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.streamException);
                    if (this.streamCreated) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ExecuteMethodThread executeMethodThread = this;
            synchronized (executeMethodThread) {
                if (this.streamCreated && this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
        }

        public void finishUp() throws InterruptedException {
            this.join();
        }

        protected synchronized void checkException(Throwable exception) throws IOException, HttpException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof HttpException) {
                    throw (HttpException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    protected class DocumentReadingThread
    extends Thread {
        protected Throwable exception = null;
        protected final int volumeID;
        protected final int docID;
        protected final int versionNumber;
        protected final XThreadInputStream stream;

        public DocumentReadingThread(int volumeID, int docID, int versionNumber) {
            this.volumeID = volumeID;
            this.docID = docID;
            this.versionNumber = versionNumber;
            this.stream = new XThreadInputStream();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try (XThreadOutputStream outputStream = new XThreadOutputStream(this.stream);){
                int status = LivelinkConnector.this.LLDocs.FetchVersion(this.volumeID, this.docID, this.versionNumber, (OutputStream)outputStream);
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving contents of document " + Integer.toString(this.volumeID) + ":" + Integer.toString(this.docID) + " revision " + this.versionNumber + " : Status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public InputStream getSafeInputStream() {
            return this.stream;
        }

        public void finishUp() throws InterruptedException, ManifoldCFException {
            this.stream.abort();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected class RootValue {
        protected final LivelinkContext llc;
        protected final String workspaceName;
        protected ObjectInformation rootValue = null;
        protected final String remainderPath;

        public RootValue(LivelinkContext llc, String pathString) {
            this.llc = llc;
            int colonPos = pathString.indexOf(":");
            if (colonPos == -1) {
                this.remainderPath = pathString;
                this.workspaceName = LivelinkConnector.ENTWKSPACE_NAME;
            } else {
                this.workspaceName = pathString.substring(0, colonPos);
                this.remainderPath = pathString.substring(colonPos + 1);
            }
        }

        public String getRemainderPath() {
            return this.remainderPath;
        }

        public ObjectInformation getRootValue() throws ManifoldCFException, ServiceInterruption {
            if (this.rootValue == null) {
                if (this.workspaceName.equals(LivelinkConnector.CATEGORY_NAME)) {
                    this.rootValue = this.llc.getObjectInformation(LivelinkConnector.this.LLCATWK_VOL, LivelinkConnector.this.LLCATWK_ID);
                } else if (this.workspaceName.equals(LivelinkConnector.ENTWKSPACE_NAME)) {
                    this.rootValue = this.llc.getObjectInformation(LivelinkConnector.this.LLENTWK_VOL, LivelinkConnector.this.LLENTWK_ID);
                } else {
                    throw new ManifoldCFException("Bad workspace name: " + this.workspaceName);
                }
            }
            if (!this.rootValue.exists()) {
                Logging.connectors.warn((Object)"Livelink: Could not get workspace/volume ID!  Retrying...");
                throw new ServiceInterruption("Service interruption getting root value", (Throwable)new ManifoldCFException("Could not get workspace/volume id"), System.currentTimeMillis() + 60000L, System.currentTimeMillis() + 600000L, -1, true);
            }
            return this.rootValue;
        }
    }

    protected class CategoryPathAccumulator {
        protected final LivelinkContext llc;
        protected final Map<Integer, String> categoryPathMap = new HashMap<Integer, String>();
        protected final Map<Integer, String[]> attributeMap = new HashMap<Integer, String[]>();

        public CategoryPathAccumulator(LivelinkContext llc) {
            this.llc = llc;
        }

        public String[] getCategoryPathsAttributeNames(int[] catIDs) throws ManifoldCFException, ServiceInterruption {
            HashSet<String> set = new HashSet<String>();
            for (int x : catIDs) {
                String[] attributeNames;
                Integer key = new Integer(x);
                String pathValue = this.categoryPathMap.get(key);
                if (pathValue == null) {
                    pathValue = this.findPath(key);
                    if (pathValue == null) continue;
                    this.categoryPathMap.put(key, pathValue);
                }
                if ((attributeNames = this.attributeMap.get(key)) == null) {
                    attributeNames = this.findAttributes(key);
                    if (attributeNames == null) continue;
                    this.attributeMap.put(key, attributeNames);
                }
                for (String attributeName : attributeNames) {
                    String metadataName = LivelinkConnector.packCategoryAttribute(pathValue, attributeName);
                    set.add(metadataName);
                }
            }
            String[] rval = new String[set.size()];
            int i = 0;
            for (String value : set) {
                rval[i++] = value;
            }
            return rval;
        }

        protected String findPath(int catID) throws ManifoldCFException, ServiceInterruption {
            return this.getObjectPath(this.llc.getObjectInformation(0, catID));
        }

        protected String getObjectPath(ObjectInformation currentObject) throws ManifoldCFException, ServiceInterruption {
            Object path = null;
            while (!currentObject.isCategoryWorkspace()) {
                if (currentObject.isEntityWorkspace()) {
                    return LivelinkConnector.ENTWKSPACE_NAME + (String)(path == null ? "" : ":" + path);
                }
                if (!currentObject.exists()) {
                    Logging.connectors.warn((Object)("Livelink: Bad identifier found? " + currentObject.toString() + " apparently does not exist, but need to look up its path"));
                    return null;
                }
                String name = currentObject.getName();
                path = path == null ? name : name + "/" + (String)path;
                int parentID = currentObject.getParentId();
                if (parentID == -1) {
                    Logging.connectors.warn((Object)("Livelink: Object ID " + currentObject.toString() + " doesn't seem to live in enterprise or category workspace!  Path I got was '" + (String)path + "'"));
                    return null;
                }
                currentObject = this.llc.getObjectInformation(0, parentID);
            }
            return LivelinkConnector.CATEGORY_NAME + (String)(path == null ? "" : ":" + path);
        }

        protected String[] findAttributes(int catID) throws ManifoldCFException, ServiceInterruption {
            return LivelinkConnector.this.getCategoryAttributes(catID);
        }
    }

    protected class MetadataDescription {
        protected final LivelinkContext llc;
        protected final Map<String, MetadataPathItem> categoryMap = new HashMap<String, MetadataPathItem>();

        public MetadataDescription(LivelinkContext llc) {
            this.llc = llc;
        }

        public Iterator<MetadataItem> getItems(String[] metadataItems) throws ManifoldCFException, ServiceInterruption {
            HashMap<String, MetadataItem> newMap = new HashMap<String, MetadataItem>();
            ObjectInformation rootValue = null;
            for (String metadataSpec : metadataItems) {
                StringBuilder categoryBuffer = new StringBuilder();
                StringBuilder attributeBuffer = new StringBuilder();
                LivelinkConnector.unpackCategoryAttribute(categoryBuffer, attributeBuffer, metadataSpec);
                String category = categoryBuffer.toString();
                String attributeName = attributeBuffer.toString();
                MetadataItem mi = (MetadataItem)newMap.get(category);
                if (mi == null) {
                    MetadataPathItem item = this.categoryMap.get(category);
                    if (item == null) {
                        int catObjectID;
                        RootValue rv = new RootValue(this.llc, category);
                        if (rootValue == null) {
                            rootValue = rv.getRootValue();
                        }
                        if ((catObjectID = rootValue.getCategoryId(rv.getRemainderPath())) != -1) {
                            item = new MetadataPathItem(catObjectID, rv.getRemainderPath());
                            this.categoryMap.put(category, item);
                        }
                    }
                    mi = new MetadataItem(item);
                    newMap.put(category, mi);
                }
                mi.addAttribute(attributeName);
            }
            return newMap.values().iterator();
        }
    }

    protected class SystemMetadataDescription {
        protected final LivelinkContext llc;
        protected final String pathAttributeName;
        protected final String pathSeparator;
        protected final Map<String, String> pathMap = new HashMap<String, String>();
        protected final MatchMap matchMap = new MatchMap();
        protected final Set<String> aclMap = new HashSet<String>();
        protected final boolean securityOn;
        protected final String filterString;
        protected final Set<String> holder = new HashSet<String>();
        protected final boolean includeAllMetadata;

        public SystemMetadataDescription(LivelinkContext llc, Specification spec) throws ManifoldCFException, ServiceInterruption {
            this.llc = llc;
            String pathAttributeName = null;
            String pathSeparator = null;
            boolean securityOn = true;
            StringBuilder fsb = new StringBuilder();
            boolean first = true;
            boolean includeAllMetadata = false;
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode n = spec.getChild(i);
                if (n.getType().equals("pathnameattribute")) {
                    pathAttributeName = n.getAttributeValue("value");
                    pathSeparator = n.getAttributeValue("separator");
                    if (pathSeparator != null) continue;
                    pathSeparator = "/";
                    continue;
                }
                if (n.getType().equals("pathmap")) {
                    String pathMatch = n.getAttributeValue("match");
                    String pathReplace = n.getAttributeValue("replace");
                    this.matchMap.appendMatchPair(pathMatch, pathReplace);
                    continue;
                }
                if (n.getType().equals("access")) {
                    String token = n.getAttributeValue("token");
                    this.aclMap.add(token);
                    continue;
                }
                if (n.getType().equals("security")) {
                    String value = n.getAttributeValue("value");
                    if (value.equals("on")) {
                        securityOn = true;
                        continue;
                    }
                    if (!value.equals("off")) continue;
                    securityOn = false;
                    continue;
                }
                if (n.getType().equals("include")) {
                    int index;
                    String includeMatch = n.getAttributeValue("filespec");
                    if (includeMatch == null || (index = includeMatch.lastIndexOf(".")) == -1) continue;
                    String type = includeMatch.substring(index + 1).toLowerCase(Locale.ROOT).replace('*', '%');
                    if (first) {
                        first = false;
                    } else {
                        fsb.append(" or ");
                    }
                    fsb.append("lower(FileType) like '").append(type).append("'");
                    continue;
                }
                if (n.getType().equals("allmetadata")) {
                    String isAll = n.getAttributeValue("all");
                    if (isAll == null || !isAll.equals("true")) continue;
                    includeAllMetadata = true;
                    continue;
                }
                if (!n.getType().equals("metadata")) continue;
                String category = n.getAttributeValue("category");
                String attributeName = n.getAttributeValue("attribute");
                String isAll = n.getAttributeValue("all");
                if (isAll != null && isAll.equals("true")) {
                    LivelinkConnector.this.getSession();
                    String[] attrs = LivelinkConnector.this.getCategoryAttributes(llc, category);
                    if (attrs == null) continue;
                    int j = 0;
                    while (j < attrs.length) {
                        attributeName = attrs[j++];
                        String metadataName = LivelinkConnector.packCategoryAttribute(category, attributeName);
                        this.holder.add(metadataName);
                    }
                    continue;
                }
                String metadataName = LivelinkConnector.packCategoryAttribute(category, attributeName);
                this.holder.add(metadataName);
            }
            this.includeAllMetadata = includeAllMetadata;
            this.pathAttributeName = pathAttributeName;
            this.pathSeparator = pathSeparator;
            this.securityOn = securityOn;
            String filterStringPiece = fsb.toString();
            if (filterStringPiece.length() == 0) {
                this.filterString = "0>1";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("SubType=").append(new Integer(0).toString());
                sb.append(" or SubType=").append(new Integer(136).toString());
                sb.append(" or SubType=").append(new Integer(202).toString());
                sb.append(" or (SubType=").append(new Integer(144).toString());
                sb.append(" and (");
                sb.append(filterStringPiece);
                sb.append("))");
                this.filterString = sb.toString();
            }
        }

        public boolean includeAllMetadata() {
            return this.includeAllMetadata;
        }

        public String[] getMetadataAttributes() {
            String[] specifiedMetadataAttributes = new String[this.holder.size()];
            int i = 0;
            for (String attrName : this.holder) {
                specifiedMetadataAttributes[i++] = attrName;
            }
            return specifiedMetadataAttributes;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public String[] getAcls() {
            if (!this.securityOn) {
                return null;
            }
            String[] rval = new String[this.aclMap.size()];
            int i = 0;
            for (String token : this.aclMap) {
                rval[i++] = token;
            }
            return rval;
        }

        public String getPathAttributeName() {
            return this.pathAttributeName;
        }

        public String getPathSeparator() {
            return this.pathSeparator;
        }

        public String getPathAttributeValue(String documentIdentifier) throws ManifoldCFException, ServiceInterruption {
            String path = this.getNodePathString(documentIdentifier);
            if (path == null) {
                return null;
            }
            return this.matchMap.translate(path);
        }

        public String getMatchMapString() {
            return this.matchMap.toString();
        }

        public String getNodePathString(String documentIdentifier) throws ManifoldCFException, ServiceInterruption {
            Object path;
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Looking up path for '" + documentIdentifier + "'"));
            }
            if ((path = this.pathMap.get(documentIdentifier)) == null) {
                int objectID;
                int volumeID;
                String identifierPart = documentIdentifier;
                if (identifierPart.startsWith("D") || identifierPart.startsWith("F")) {
                    identifierPart = identifierPart.substring(1);
                }
                int colonPosition = identifierPart.indexOf(":");
                try {
                    if (colonPosition == -1) {
                        volumeID = LivelinkConnector.this.LLENTWK_VOL;
                        objectID = Integer.parseInt(identifierPart);
                    } else {
                        volumeID = Integer.parseInt(identifierPart.substring(0, colonPosition));
                        objectID = Integer.parseInt(identifierPart.substring(colonPosition + 1));
                    }
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad document identifier: " + e.getMessage(), (Throwable)e);
                }
                ObjectInformation objInfo = this.llc.getObjectInformation(volumeID, objectID);
                if (!objInfo.exists()) {
                    Logging.connectors.warn((Object)("Livelink: Bad document identifier: '" + documentIdentifier + "' apparently does not exist, but need to find its path"));
                    return null;
                }
                String name = objInfo.getName();
                int parentID = objInfo.getParentId();
                if (parentID == -1) {
                    path = name;
                } else {
                    String parentIdentifier = "F" + Integer.toString(volumeID) + ":" + Integer.toString(parentID);
                    String parentPath = this.getNodePathString(parentIdentifier);
                    if (parentPath == null) {
                        return null;
                    }
                    path = parentPath + this.pathSeparator + name;
                }
                this.pathMap.put(documentIdentifier, (String)path);
            }
            return path;
        }
    }

    protected static class MetadataItem {
        protected final MetadataPathItem pathItem;
        protected final Set<String> attributeNames = new HashSet<String>();

        public MetadataItem(MetadataPathItem pathItem) {
            this.pathItem = pathItem;
        }

        public void addAttribute(String attributeName) {
            this.attributeNames.add(attributeName);
        }

        public MetadataPathItem getPathItem() {
            return this.pathItem;
        }

        public Iterator<String> getAttributeNames() {
            return this.attributeNames.iterator();
        }
    }

    protected static class MetadataPathItem {
        protected final int catID;
        protected final String catName;

        public MetadataPathItem(int catID, String catName) {
            this.catID = catID;
            this.catName = catName;
        }

        public int getCatID() {
            return this.catID;
        }

        public String getCatName() {
            return this.catName;
        }
    }

    protected static class VolumeAndId {
        protected final int volumeID;
        protected final int folderID;

        public VolumeAndId(int volumeID, int folderID) {
            this.volumeID = volumeID;
            this.folderID = folderID;
        }

        public int getVolumeID() {
            return this.volumeID;
        }

        public int getPathId() {
            return this.folderID;
        }
    }

    protected class GetObjectCategoryIDsThread
    extends Thread {
        protected final int vol;
        protected final int id;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetObjectCategoryIDsThread(int vol, int id) {
            this.setDaemon(true);
            this.vol = vol;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                LLValue objIDValue = new LLValue().setAssocNotSet();
                objIDValue.add("ID", this.id);
                LLValue catIDList = new LLValue().setAssocNotSet();
                int status = LivelinkConnector.this.LLDocs.ListObjectCategoryIDs(objIDValue, catIDList);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Status value for getting object categories for " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + " is: " + Integer.toString(status)));
                }
                if (status == 103101) {
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving document categories for " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + ": status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
                this.rval = catIDList;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetObjectInfoThread
    extends Thread {
        protected int vol;
        protected int id;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetObjectInfoThread(int vol, int id) {
            this.setDaemon(true);
            this.vol = vol;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                LLValue objinfo = new LLValue().setAssocNotSet();
                int status = LivelinkConnector.this.LLDocs.GetObjectInfo(this.vol, this.id, objinfo);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Status retrieved for " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + ": status=" + Integer.toString(status)));
                }
                if (status == 103101 || status == 103102) {
                    return;
                }
                if (status < 0) {
                    Logging.connectors.debug((Object)("Livelink: Object info inaccessable for object " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + " (" + LivelinkConnector.this.llServer.getErrors() + ")"));
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving document object " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + ": status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
                this.rval = objinfo;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetVersionInfoThread
    extends Thread {
        protected final int vol;
        protected final int id;
        protected final int revNumber;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetVersionInfoThread(int vol, int id, int revNumber) {
            this.setDaemon(true);
            this.vol = vol;
            this.id = id;
            this.revNumber = revNumber;
        }

        @Override
        public void run() {
            try {
                LLValue versioninfo = new LLValue().setAssocNotSet();
                int status = LivelinkConnector.this.LLDocs.GetVersionInfo(this.vol, this.id, this.revNumber, versioninfo);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: Version status retrieved for " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + ", rev " + this.revNumber + ": status=" + Integer.toString(status)));
                }
                if (status == 103101 || status == 103102) {
                    return;
                }
                if (status < 0) {
                    Logging.connectors.debug((Object)("Livelink: Version info inaccessable for object " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + ", rev " + this.revNumber + " (" + LivelinkConnector.this.llServer.getErrors() + ")"));
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving document version " + Integer.toString(this.vol) + ":" + Integer.toString(this.id) + ", rev " + this.revNumber + ": status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
                this.rval = versioninfo;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetUserInfoThread
    extends Thread {
        protected final int user;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetUserInfoThread(int user) {
            this.setDaemon(true);
            this.user = user;
        }

        @Override
        public void run() {
            try {
                LLValue userinfo = new LLValue().setAssoc();
                int status = LivelinkConnector.this.LLUsers.GetUserByID(this.user, userinfo);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: User status retrieved for " + Integer.toString(this.user) + ": status=" + Integer.toString(status)));
                }
                if (status == 103101 || status == 103102 || status == 401101) {
                    return;
                }
                if (status < 0) {
                    Logging.connectors.debug((Object)("Livelink: User info inaccessable for user " + Integer.toString(this.user) + " (" + LivelinkConnector.this.llServer.getErrors() + ")"));
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving user " + Integer.toString(this.user) + ": status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
                this.rval = userinfo;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class ListUsersThread
    extends Thread {
        protected LLValue rval = null;
        protected Throwable exception = null;

        public ListUsersThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                LLValue userList = new LLValue();
                int status = LivelinkConnector.this.LLUsers.ListUsers(userList);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Livelink: User list retrieved: status=" + Integer.toString(status)));
                }
                if (status < 0) {
                    Logging.connectors.debug((Object)("Livelink: User list inaccessable (" + LivelinkConnector.this.llServer.getErrors() + ")"));
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving user list: status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
                this.rval = userList;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class ObjectInformation {
        protected final int volumeID;
        protected final int objectID;
        protected LLValue objectValue = null;

        public ObjectInformation(int volumeID, int objectID) {
            this.volumeID = volumeID;
            this.objectID = objectID;
        }

        public boolean exists() throws ServiceInterruption, ManifoldCFException {
            return this.getObjectValue() != null;
        }

        public boolean isCategoryWorkspace() {
            return this.objectID == LivelinkConnector.this.LLCATWK_ID;
        }

        public boolean isEntityWorkspace() {
            return this.objectID == LivelinkConnector.this.LLENTWK_ID;
        }

        public String toString() {
            return "(Volume: " + this.volumeID + ", Object: " + this.objectID + ")";
        }

        public VolumeAndId getPathId(String startPath) throws ServiceInterruption, ManifoldCFException {
            LLValue objInfo = this.getObjectValue();
            if (objInfo == null) {
                return null;
            }
            int obj = objInfo.toInteger("ID");
            int vol = objInfo.toInteger("VolumeID");
            int charindex = 0;
            block5: while (charindex < startPath.length()) {
                char x;
                StringBuilder currentTokenBuffer = new StringBuilder();
                while (charindex < startPath.length() && (x = startPath.charAt(charindex++)) != '/') {
                    if (x == '\\') {
                        x = startPath.charAt(charindex);
                        ++charindex;
                    }
                    currentTokenBuffer.append(x);
                }
                String subFolder = currentTokenBuffer.toString();
                String filterString = "(SubType=0 or SubType=202 or SubType=136) and Name='" + subFolder + "'";
                int sanityRetryCount = 10;
                while (true) {
                    ListObjectsThread t = new ListObjectsThread(vol, obj, filterString);
                    try {
                        LLValue children;
                        t.start();
                        try {
                            children = t.finishUp();
                        }
                        catch (ManifoldCFException e) {
                            sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                            continue;
                        }
                        if (children == null) {
                            return null;
                        }
                        if (children.size() == 1) {
                            obj = children.toInteger(0, "ID");
                            int subtype = children.toInteger(0, "SubType");
                            if (subtype != 202) continue block5;
                            vol = obj;
                            obj = -obj;
                            continue block5;
                        }
                        return null;
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RuntimeException e) {
                        sanityRetryCount = LivelinkConnector.this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                        continue;
                    }
                    break;
                }
            }
            return new VolumeAndId(vol, obj);
        }

        public int getCategoryId(String startPath) throws ManifoldCFException, ServiceInterruption {
            LLValue objInfo = this.getObjectValue();
            if (objInfo == null) {
                return -1;
            }
            int obj = objInfo.toInteger("ID");
            int vol = objInfo.toInteger("VolumeID");
            if (startPath.length() == 0) {
                return -1;
            }
            int charindex = 0;
            block5: while (charindex < startPath.length()) {
                char x;
                StringBuilder currentTokenBuffer = new StringBuilder();
                while (charindex < startPath.length() && (x = startPath.charAt(charindex++)) != '/') {
                    if (x == '\\') {
                        x = startPath.charAt(charindex);
                        ++charindex;
                    }
                    currentTokenBuffer.append(x);
                }
                String subFolder = currentTokenBuffer.toString();
                Object filterString = charindex < startPath.length() ? "(SubType=0 or SubType=202 or SubType=136)" : "SubType=131";
                filterString = (String)filterString + " and Name='" + subFolder + "'";
                int sanityRetryCount = 10;
                while (true) {
                    ListObjectsThread t = new ListObjectsThread(vol, obj, (String)filterString);
                    try {
                        LLValue children;
                        t.start();
                        try {
                            children = t.finishUp();
                        }
                        catch (ManifoldCFException e) {
                            sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                            continue;
                        }
                        if (children == null) {
                            return -1;
                        }
                        if (children.size() == 1) {
                            obj = children.toInteger(0, "ID");
                            int subtype = children.toInteger(0, "SubType");
                            if (subtype != 202) continue block5;
                            vol = obj;
                            obj = -obj;
                            continue block5;
                        }
                        return -1;
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RuntimeException e) {
                        sanityRetryCount = LivelinkConnector.this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                        continue;
                    }
                    break;
                }
            }
            return obj;
        }

        public Integer getPermissions() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Integer(this.objectValue.toInteger("Permissions"));
        }

        public String getName() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.toString("NAME");
        }

        public String getComments() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.toString("COMMENT");
        }

        public Integer getParentId() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Integer(elem.toInteger("ParentId"));
        }

        public Integer getOwnerId() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Integer(elem.toInteger("UserId"));
        }

        public Integer getGroupId() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Integer(elem.toInteger("GroupId"));
        }

        public Date getCreationDate() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.toDate("CREATEDATE");
        }

        public Integer getCreatorId() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return new Integer(elem.toInteger("CREATEDBY"));
        }

        public Date getModifyDate() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getObjectValue();
            if (elem == null) {
                return null;
            }
            return elem.toDate("ModifyDate");
        }

        protected LLValue getObjectValue() throws ServiceInterruption, ManifoldCFException {
            if (this.objectValue == null) {
                int sanityRetryCount = 10;
                while (true) {
                    GetObjectInfoThread t = new GetObjectInfoThread(this.volumeID, this.objectID);
                    try {
                        t.start();
                        try {
                            this.objectValue = t.finishUp();
                        }
                        catch (ManifoldCFException e) {
                            sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RuntimeException e) {
                        sanityRetryCount = LivelinkConnector.this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                        continue;
                    }
                    break;
                }
            }
            return this.objectValue;
        }

        public int hashCode() {
            return this.volumeID << 5 ^ this.volumeID >> 3 ^ this.objectID << 5 ^ this.objectID >> 3;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ObjectInformation)) {
                return false;
            }
            ObjectInformation other = (ObjectInformation)o;
            return this.volumeID == other.volumeID && this.objectID == other.objectID;
        }
    }

    protected class VersionInformation {
        protected final int volumeID;
        protected final int objectID;
        protected final int revisionNumber;
        protected LLValue versionValue = null;

        public VersionInformation(int volumeID, int objectID, int revisionNumber) {
            this.volumeID = volumeID;
            this.objectID = objectID;
            this.revisionNumber = revisionNumber;
        }

        public boolean exists() throws ServiceInterruption, ManifoldCFException {
            return this.getVersionValue() != null;
        }

        public Long getDataSize() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return new Long(elem.toLong("FILEDATASIZE"));
        }

        public String getFileName() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.toString("FILENAME");
        }

        public String getMimeType() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.toString("MIMETYPE");
        }

        public Date getModifyDate() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return elem.toDate("MODIFYDATE");
        }

        public Integer getOwnerId() throws ServiceInterruption, ManifoldCFException {
            LLValue elem = this.getVersionValue();
            if (elem == null) {
                return null;
            }
            return new Integer(elem.toInteger("OWNER"));
        }

        protected LLValue getVersionValue() throws ServiceInterruption, ManifoldCFException {
            if (this.versionValue == null) {
                int sanityRetryCount = 10;
                while (true) {
                    GetVersionInfoThread t = new GetVersionInfoThread(this.volumeID, this.objectID, this.revisionNumber);
                    try {
                        t.start();
                        try {
                            this.versionValue = t.finishUp();
                        }
                        catch (ManifoldCFException e) {
                            sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RuntimeException e) {
                        sanityRetryCount = LivelinkConnector.this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                        continue;
                    }
                    break;
                }
            }
            return this.versionValue;
        }

        public int hashCode() {
            return this.volumeID << 5 ^ this.volumeID >> 3 ^ this.objectID << 5 ^ this.objectID >> 3 ^ this.revisionNumber << 5 ^ this.revisionNumber >> 3;
        }

        public boolean equals(Object o) {
            if (!(o instanceof VersionInformation)) {
                return false;
            }
            VersionInformation other = (VersionInformation)o;
            return this.volumeID == other.volumeID && this.objectID == other.objectID && this.revisionNumber == other.revisionNumber;
        }
    }

    protected class UserInformation {
        protected final int userID;
        protected LLValue userValue = null;

        public UserInformation(int userID) {
            this.userID = userID;
        }

        public boolean exists() throws ServiceInterruption, ManifoldCFException {
            return this.getUserValue() != null;
        }

        public String getName() throws ServiceInterruption, ManifoldCFException {
            LLValue userValue = this.getUserValue();
            if (userValue == null) {
                return null;
            }
            return userValue.toString("NAME");
        }

        protected LLValue getUserValue() throws ServiceInterruption, ManifoldCFException {
            if (this.userValue == null) {
                int sanityRetryCount = 10;
                while (true) {
                    GetUserInfoThread t = new GetUserInfoThread(this.userID);
                    try {
                        t.start();
                        try {
                            this.userValue = t.finishUp();
                        }
                        catch (ManifoldCFException e) {
                            sanityRetryCount = LivelinkConnector.assessRetry(sanityRetryCount, e);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (RuntimeException e) {
                        sanityRetryCount = LivelinkConnector.this.handleLivelinkRuntimeException(e, sanityRetryCount, true);
                        continue;
                    }
                    break;
                }
            }
            return this.userValue;
        }

        public String toString() {
            return "(" + this.userID + ")";
        }

        public int hashCode() {
            return this.userID << 5 ^ this.userID >> 3;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UserInformation)) {
                return false;
            }
            UserInformation other = (UserInformation)o;
            return this.userID == other.userID;
        }
    }

    protected class LivelinkContext {
        protected final Map<ObjectInformation, ObjectInformation> objectInfoMap = new HashMap<ObjectInformation, ObjectInformation>();
        protected final Map<VersionInformation, VersionInformation> versionInfoMap = new HashMap<VersionInformation, VersionInformation>();
        protected final Map<UserInformation, UserInformation> userInfoMap = new HashMap<UserInformation, UserInformation>();

        public ObjectInformation getObjectInformation(int volumeID, int objectID) {
            ObjectInformation oi = new ObjectInformation(volumeID, objectID);
            ObjectInformation lookupValue = this.objectInfoMap.get(oi);
            if (lookupValue == null) {
                this.objectInfoMap.put(oi, oi);
                return oi;
            }
            return lookupValue;
        }

        public VersionInformation getVersionInformation(int volumeID, int objectID, int revisionNumber) {
            VersionInformation vi = new VersionInformation(volumeID, objectID, revisionNumber);
            VersionInformation lookupValue = this.versionInfoMap.get(vi);
            if (lookupValue == null) {
                this.versionInfoMap.put(vi, vi);
                return vi;
            }
            return lookupValue;
        }

        public UserInformation getUserInformation(int userID) {
            UserInformation ui = new UserInformation(userID);
            UserInformation lookupValue = this.userInfoMap.get(ui);
            if (lookupValue == null) {
                this.userInfoMap.put(ui, ui);
                return ui;
            }
            return lookupValue;
        }
    }

    protected class GetObjectRightsThread
    extends Thread {
        protected final int vol;
        protected final int objID;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetObjectRightsThread(int vol, int objID) {
            this.setDaemon(true);
            this.vol = vol;
            this.objID = objID;
        }

        @Override
        public void run() {
            try {
                LLValue childrenObjects = new LLValue();
                int status = LivelinkConnector.this.LLDocs.GetObjectRights(this.vol, this.objID, childrenObjects);
                if (status == 103101) {
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving document rights: " + Integer.toString(status) + ": " + LivelinkConnector.this.llServer.getErrors());
                }
                this.rval = childrenObjects;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetAttributeValueThread
    extends Thread {
        protected final LLValue categoryVersion;
        protected final String attributeName;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetAttributeValueThread(LLValue categoryVersion, String attributeName) {
            this.setDaemon(true);
            this.categoryVersion = categoryVersion;
            this.attributeName = attributeName;
        }

        @Override
        public void run() {
            try {
                LLValue children = new LLValue();
                int status = LivelinkConnector.this.LLAttributes.AttrGetValues(this.categoryVersion, this.attributeName, 0, null, children);
                if (status == 103101) {
                    return;
                }
                if (status == 8000604) {
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving attribute value: " + Integer.toString(status) + ": " + LivelinkConnector.this.llServer.getErrors());
                }
                this.rval = children;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetCategoryVersionThread
    extends Thread {
        protected final int objID;
        protected final int catID;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetCategoryVersionThread(int objID, int catID) {
            this.setDaemon(true);
            this.objID = objID;
            this.catID = catID;
        }

        @Override
        public void run() {
            try {
                LLValue objIDValue = new LLValue().setAssoc();
                objIDValue.add("ID", this.objID);
                LLValue catIDValue = new LLValue().setAssoc();
                catIDValue.add("ID", this.catID);
                catIDValue.add("Type", 0);
                LLValue rvalue = new LLValue();
                int status = LivelinkConnector.this.LLDocs.GetObjectAttributesEx(objIDValue, catIDValue, rvalue);
                if (status == 103101 || status == 107205) {
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving category version: " + Integer.toString(status) + ": " + LivelinkConnector.this.llServer.getErrors());
                }
                this.rval = rvalue;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetCategoryAttributesThread
    extends Thread {
        protected final int catObjectID;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public GetCategoryAttributesThread(int catObjectID) {
            this.setDaemon(true);
            this.catObjectID = catObjectID;
        }

        @Override
        public void run() {
            try {
                LLValue catID = new LLValue();
                catID.setAssoc();
                catID.add("ID", this.catObjectID);
                catID.add("Type", 0);
                LLValue catVersion = new LLValue();
                int status = LivelinkConnector.this.LLDocs.FetchCategoryVersion(catID, catVersion);
                if (status == 107105 || status == 107106) {
                    return;
                }
                if (status != 0) {
                    throw new ManifoldCFException("Error getting category version: " + Integer.toString(status));
                }
                LLValue children = new LLValue();
                status = LivelinkConnector.this.LLAttributes.AttrListNames(catVersion, null, children);
                if (status != 0) {
                    throw new ManifoldCFException("Error getting attribute names: " + Integer.toString(status));
                }
                this.rval = children;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    public static final class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }

        public String toString() {
            return this.left + "=" + this.right;
        }
    }

    protected class ListObjectsThread
    extends Thread {
        protected final int vol;
        protected final int objID;
        protected final String filterString;
        protected Throwable exception = null;
        protected LLValue rval = null;

        public ListObjectsThread(int vol, int objID, String filterString) {
            this.setDaemon(true);
            this.vol = vol;
            this.objID = objID;
            this.filterString = filterString;
        }

        @Override
        public void run() {
            try {
                LLValue childrenDocs = new LLValue();
                int status = LivelinkConnector.this.LLDocs.ListObjects(this.vol, this.objID, null, this.filterString, 36865, childrenDocs);
                if (status != 0) {
                    throw new ManifoldCFException("Error retrieving contents of folder " + Integer.toString(this.vol) + ":" + Integer.toString(this.objID) + " : Status=" + Integer.toString(status) + " (" + LivelinkConnector.this.llServer.getErrors() + ")");
                }
                this.rval = childrenDocs;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public LLValue finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
            return this.rval;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                LLValue entinfo;
                int status;
                LivelinkConnector.this.llServer = new LLSERVER(!LivelinkConnector.this.serverProtocol.equals("internal"), LivelinkConnector.this.serverProtocol.equals("https"), LivelinkConnector.this.serverName, LivelinkConnector.this.serverPort, LivelinkConnector.this.serverUsername, LivelinkConnector.this.serverPassword, LivelinkConnector.this.serverHTTPCgi, LivelinkConnector.this.serverHTTPNTLMDomain, LivelinkConnector.this.serverHTTPNTLMUsername, LivelinkConnector.this.serverHTTPNTLMPassword, LivelinkConnector.this.serverHTTPSKeystore);
                LivelinkConnector.this.LLDocs = new LAPI_DOCUMENTS((LLConnect)LivelinkConnector.this.llServer.getLLSession());
                LivelinkConnector.this.LLAttributes = new LAPI_ATTRIBUTES((LLConnect)LivelinkConnector.this.llServer.getLLSession());
                LivelinkConnector.this.LLUsers = new LAPI_USERS((LLConnect)LivelinkConnector.this.llServer.getLLSession());
                if (Logging.connectors.isDebugEnabled()) {
                    String passwordExists = LivelinkConnector.this.serverPassword != null && LivelinkConnector.this.serverPassword.length() > 0 ? "password exists" : "";
                    Logging.connectors.debug((Object)("Livelink: Livelink Session: Server='" + LivelinkConnector.this.serverName + "'; port='" + LivelinkConnector.this.serverPort + "'; user name='" + LivelinkConnector.this.serverUsername + "'; " + passwordExists));
                }
                if ((status = LivelinkConnector.this.LLDocs.AccessEnterpriseWS(entinfo = new LLValue().setAssoc())) != 0) {
                    throw new ManifoldCFException("Error accessing enterprise workspace: " + status);
                }
                LivelinkConnector.this.LLENTWK_ID = entinfo.toInteger("ID");
                LivelinkConnector.this.LLENTWK_VOL = entinfo.toInteger("VolumeID");
                entinfo = new LLValue().setAssoc();
                status = LivelinkConnector.this.LLDocs.AccessCategoryWS(entinfo);
                if (status != 0) {
                    throw new ManifoldCFException("Error accessing category workspace: " + status);
                }
                LivelinkConnector.this.LLCATWK_ID = entinfo.toInteger("ID");
                LivelinkConnector.this.LLCATWK_VOL = entinfo.toInteger("VolumeID");
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws ManifoldCFException, InterruptedException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof ManifoldCFException) {
                    throw (ManifoldCFException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unrecognized exception type: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
            }
        }
    }
}

