/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveBooleanEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class OrEvaluator
extends RecursiveBooleanEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public OrEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    protected RecursiveBooleanEvaluator.Checker constructChecker(Object fromValue) throws IOException {
        if (null == fromValue) {
            throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) because a null value was found", this.constructingFactory.getFunctionName(this.getClass())));
        }
        if (fromValue instanceof Boolean) {
            return new RecursiveBooleanEvaluator.BooleanChecker(){

                @Override
                public boolean test(Object left, Object right) {
                    return (Boolean)left != false || (Boolean)right != false;
                }
            };
        }
        throw new IOException(String.format(Locale.ROOT, "Unable to check %s(...) for values of type '%s'", this.constructingFactory.getFunctionName(this.getClass()), fromValue.getClass().getSimpleName()));
    }
}

