/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.cmis;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.cmis.CmisRepositoryConnectorUtils;
import org.apache.manifoldcf.crawler.connectors.cmis.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class CmisRepositoryConnector
extends BaseRepositoryConnector {
    private static final String JOB_STARTPOINT_NODE_TYPE = "startpoint";
    protected static final String ACTIVITY_READ = "read document";
    protected static final String RELATIONSHIP_CHILD = "child";
    private static final String CMIS_SERVER_TAB_PROPERTY = "CmisRepositoryConnector.Server";
    private static final String CMIS_QUERY_TAB_PROPERTY = "CmisRepositoryConnector.CMISQuery";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Server.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification.js";
    private static final String EDIT_SPEC_FORWARD_CMISQUERY = "editSpecification_CMISQuery.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification.html";
    private static final String CONTENT_PATH_PARAM = "contentPath";
    Session session = null;
    protected String username = null;
    protected String password = null;
    protected String protocol = null;
    protected String server = null;
    protected String port = null;
    protected String path = null;
    protected String repositoryId = null;
    protected String binding = null;
    protected SessionFactory factory = SessionFactoryImpl.newInstance();
    protected Map<String, String> parameters = new HashMap<String, String>();
    public static final String ACTIVITY_FETCH = "fetch";
    protected static final long timeToRelease = 300000L;
    protected long lastSessionFetch = -1L;

    public int getConnectorModel() {
        return 2;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.server};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("CMIS: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
        this.username = null;
        this.password = null;
        this.protocol = null;
        this.server = null;
        this.port = null;
        this.path = null;
        this.binding = null;
        this.repositoryId = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.username = this.params.getParameter("username");
        this.password = this.params.getParameter("password");
        this.protocol = this.params.getParameter("protocol");
        this.server = this.params.getParameter("server");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.binding = this.params.getParameter("binding");
        if (StringUtils.isNotEmpty((String)this.params.getParameter("repositoryId"))) {
            this.repositoryId = this.params.getParameter("repositoryId");
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (StringUtils.isEmpty((String)this.binding)) {
                throw new ManifoldCFException("Parameter binding required but not set");
            }
            if (StringUtils.isEmpty((String)this.username)) {
                throw new ManifoldCFException("Parameter username required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("CMIS: Username = '" + this.username + "'"));
            }
            if (StringUtils.isEmpty((String)this.password)) {
                throw new ManifoldCFException("Parameter password required but not set");
            }
            Logging.connectors.debug((Object)"CMIS: Password exists");
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (StringUtils.isEmpty((String)this.server)) {
                throw new ManifoldCFException("Parameter server required but not set");
            }
            if (StringUtils.isEmpty((String)this.port)) {
                throw new ManifoldCFException("Parameter port required but not set");
            }
            if (StringUtils.isEmpty((String)this.path)) {
                throw new ManifoldCFException("Parameter path required but not set");
            }
            GetSessionThread t = new GetSessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof MalformedURLException) {
                        throw (MalformedURLException)thr;
                    }
                    if (thr instanceof NotBoundException) {
                        throw (NotBoundException)thr;
                    }
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof CmisConnectionException) {
                        throw new ManifoldCFException("CMIS: Error during getting a new session: " + thr.getMessage(), thr);
                    }
                    if (thr instanceof CmisPermissionDeniedException) {
                        throw new ManifoldCFException("CMIS: Wrong credentials during getting a new session: " + thr.getMessage(), thr);
                    }
                    throw (Error)thr;
                }
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (MalformedURLException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            catch (NotBoundException e) {
                Logging.connectors.warn((Object)("CMIS: Server not up at the moment: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                Logging.connectors.warn((Object)("CMIS: Transient remote exception creating session: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("CMIS: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            CheckConnectionThread t = new CheckConnectionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof CmisConnectionException) {
                        throw new ManifoldCFException("CMIS: Error during checking connection: " + thr.getMessage(), thr);
                    }
                    throw (Error)thr;
                }
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("CMIS: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        String cmisQuery = "";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            cmisQuery = sn.getAttributeValue("cmisQuery");
            break;
        }
        if (StringUtils.isEmpty((String)cmisQuery)) {
            ItemIterable cmisObjects = this.session.getRootFolder().getChildren();
            for (CmisObject cmisObject : cmisObjects) {
                activities.addSeedDocument(cmisObject.getId());
            }
        } else {
            cmisQuery = CmisRepositoryConnectorUtils.getCmisQueryWithObjectId(cmisQuery);
            ItemIterable results = this.session.query(cmisQuery, false).getPage(1000000000);
            for (QueryResult result : results) {
                String id = (String)result.getPropertyValueById("cmis:objectId");
                activities.addSeedDocument(id);
            }
        }
        return "";
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, Map<String, String> paramMap) throws ManifoldCFException {
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    private static void fillInServerConfigurationMap(Map<String, String> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String username = parameters.getParameter("username");
        String password = parameters.getParameter("password");
        String protocol = parameters.getParameter("protocol");
        String server = parameters.getParameter("server");
        String port = parameters.getParameter("port");
        String path = parameters.getParameter("path");
        String repositoryId = parameters.getParameter("repositoryId");
        String binding = parameters.getParameter("binding");
        if (username == null) {
            username = "";
        }
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        if (protocol == null) {
            protocol = "http";
        }
        if (server == null) {
            server = "localhost";
        }
        if (port == null) {
            port = "9090";
        }
        if (path == null) {
            path = "/chemistry-opencmis-server-inmemory/atom";
        }
        if (repositoryId == null) {
            repositoryId = "";
        }
        if (binding == null) {
            binding = "atom";
        }
        newMap.put("username", username);
        newMap.put("password", password);
        newMap.put("protocol", protocol);
        newMap.put("server", server);
        newMap.put("port", port);
        newMap.put("path", path);
        newMap.put("repositoryId", repositoryId);
        newMap.put("binding", binding);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CmisRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        CmisRepositoryConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CMIS_SERVER_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CmisRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        CmisRepositoryConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        CmisRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        CmisRepositoryConnector.outputResource(EDIT_CONFIG_FORWARD_SERVER, out, locale, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String repositoryId;
        String path;
        String port;
        String server;
        String protocol;
        String password;
        String username;
        String binding = variableContext.getParameter("binding");
        if (binding != null) {
            parameters.setParameter("binding", binding);
        }
        if ((username = variableContext.getParameter("username")) != null) {
            parameters.setParameter("username", username);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((protocol = variableContext.getParameter("protocol")) != null) {
            parameters.setParameter("protocol", protocol);
        }
        if ((server = variableContext.getParameter("server")) != null && !StringUtils.contains((String)server, (char)'/')) {
            parameters.setParameter("server", server);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            try {
                Integer.parseInt(port);
                parameters.setParameter("port", port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((path = variableContext.getParameter("path")) != null) {
            parameters.setParameter("path", path);
        }
        if ((repositoryId = variableContext.getParameter("repositoryId")) != null) {
            parameters.setParameter("repositoryId", repositoryId);
        }
        return null;
    }

    private static void fillInCMISQuerySpecificationMap(Map<String, String> newMap, Specification ds) {
        String cmisQuery = "";
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            cmisQuery = sn.getAttributeValue("cmisQuery");
        }
        newMap.put("cmisQuery", cmisQuery);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        CmisRepositoryConnector.fillInCMISQuerySpecificationMap(paramMap, ds);
        CmisRepositoryConnector.outputResource(VIEW_SPEC_FORWARD, out, locale, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String cmisQuery = variableContext.getParameter(seqPrefix + "cmisQuery");
        if (cmisQuery != null) {
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode oldNode = ds.getChild(i);
                if (!oldNode.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
                ds.removeChild(i);
                break;
            }
            SpecificationNode node = new SpecificationNode(JOB_STARTPOINT_NODE_TYPE);
            node.setAttribute("cmisQuery", cmisQuery);
            variableContext.setParameter("cmisQuery", cmisQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        CmisRepositoryConnector.fillInCMISQuerySpecificationMap(paramMap, ds);
        CmisRepositoryConnector.outputResource(EDIT_SPEC_FORWARD_CMISQUERY, out, locale, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CMIS_QUERY_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        CmisRepositoryConnector.fillInCMISQuerySpecificationMap(paramMap, ds);
        CmisRepositoryConnector.outputResource(EDIT_SPEC_HEADER_FORWARD, out, locale, paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        cmisQuery = "";
        for (i = 0; i < spec.getChildCount(); ++i) {
            sn = spec.getChild(i);
            if (!sn.getType().equals("startpoint")) continue;
            cmisQuery = sn.getAttributeValue("cmisQuery");
            break;
        }
        for (String documentIdentifier : documentIdentifiers) {
            block41: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("CMIS: Processing document identifier '" + documentIdentifier + "'"));
                                }
                                this.getSession();
                                try {
                                    cmisObject = this.session.getObject(documentIdentifier);
                                }
                                catch (CmisObjectNotFoundException e) {
                                    cmisObject = null;
                                }
                                if (cmisObject == null) {
                                    activities.deleteDocument(documentIdentifier);
                                    continue;
                                }
                                if (!cmisObject.getBaseType().getId().equals(BaseTypeId.CMIS_DOCUMENT.value())) ** GOTO lbl33
                                document = (Document)cmisObject;
                                try {
                                    d = document.getObjectOfLatestVersion(false);
                                    isCurrentVersion = d.getId().equals(documentIdentifier);
                                }
                                catch (CmisObjectNotFoundException e) {
                                    isCurrentVersion = false;
                                }
                                if (isCurrentVersion) {
                                    lmdSeconds = document.getLastModificationDate().getTimeInMillis();
                                    versionString = documentIdentifier + lmdSeconds + ":" + cmisQuery;
                                } else {
                                    activities.deleteDocument(documentIdentifier);
                                    continue;
lbl33:
                                    // 1 sources

                                    versionString = "";
                                }
                                if (versionString.length() != 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, (String)versionString)) continue;
                                errorCode = null;
                                errorDesc = null;
                                fileLengthLong = null;
                                startTime = System.currentTimeMillis();
                                baseTypeId = cmisObject.getBaseType().getId();
                                if (baseTypeId.equals(BaseTypeId.CMIS_FOLDER.value())) {
                                    folder = (Folder)cmisObject;
                                    children = folder.getChildren();
                                    for (CmisObject child : children) {
                                        activities.addDocumentReference(child.getId(), documentIdentifier, "child");
                                    }
                                    break block41;
                                }
                                if (!baseTypeId.equals(BaseTypeId.CMIS_DOCUMENT.value())) ** GOTO lbl137
                                document = (Document)cmisObject;
                                createdDate = document.getCreationDate().getTime();
                                modifiedDate = document.getLastModificationDate().getTime();
                                fileLength = document.getContentStreamLength();
                                fileName = document.getContentStreamFileName();
                                mimeType = document.getContentStreamMimeType();
                                documentURI = this.getDocumentURI(cmisObject);
                                if (activities.checkURLIndexable(documentURI)) break block42;
                                activities.noDocument(documentIdentifier, (String)versionString);
                                errorCode = "EXCLUDEDURL";
                                errorDesc = "Excluding due to URL ('" + documentURI + "')";
                                if (errorCode == null) continue;
                                activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                                continue;
                            }
                            if (activities.checkMimeTypeIndexable(mimeType)) break block43;
                            activities.noDocument(documentIdentifier, (String)versionString);
                            errorCode = "EXCLUDEDMIMETYPE";
                            errorDesc = "Excluding due to mime type (" + mimeType + ")";
                            if (errorCode == null) continue;
                            activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                            continue;
                        }
                        if (activities.checkLengthIndexable(fileLength)) break block44;
                        activities.noDocument(documentIdentifier, (String)versionString);
                        errorCode = "EXCLUDEDLENGTH";
                        errorDesc = "Excluding due to length (" + fileLength + ")";
                        if (errorCode == null) continue;
                        activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                        continue;
                    }
                    if (activities.checkDateIndexable(modifiedDate)) break block45;
                    activities.noDocument(documentIdentifier, (String)versionString);
                    errorCode = "EXCLUDEDDATE";
                    errorDesc = "Excluding due to date (" + modifiedDate + ")";
                    if (errorCode == null) continue;
                    activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                    continue;
                }
                rd = new RepositoryDocument();
                rd.setFileName(fileName);
                rd.setMimeType(mimeType);
                rd.setCreatedDate(createdDate);
                rd.setModifiedDate(modifiedDate);
                is = null;
                try {
                    is = fileLength > 0L ? document.getContentStream().getStream() : null;
                }
                catch (CmisObjectNotFoundException e) {
                    activities.deleteDocument(documentIdentifier);
                    if (errorCode == null) continue;
                    activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
                    continue;
                }
                try {
                    try {
                        if (is != null) {
                            rd.setBinary(is, fileLength);
                        } else {
                            rd.setBinary((InputStream)new NullInputStream(0L), 0L);
                        }
                        modifiedQuery = CmisRepositoryConnectorUtils.getCmisQueryWithObjectId(cmisQuery);
                        CmisRepositoryConnectorUtils.addValuesOfProperties(document, rd, modifiedQuery);
                        try {
                            activities.ingestDocumentWithException(documentIdentifier, (String)versionString, documentURI, rd);
                            fileLengthLong = new Long(fileLength);
                            errorCode = "OK";
                        }
                        catch (IOException e) {
                            errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                            errorDesc = e.getMessage();
                            CmisRepositoryConnector.handleIOException(e, "reading file input stream");
                        }
                        break block41;
                    }
                    catch (Exception ecc) {
                        ecc.printStackTrace();
                        break block41;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                            errorDesc = e.getMessage();
                            CmisRepositoryConnector.handleIOException(e, "closing file input stream");
                        }
                    }
lbl137:
                    // 1 sources

                    activities.noDocument(documentIdentifier, (String)versionString);
                    errorCode = "UNKNOWNTYPE";
                    errorDesc = "Document type is unrecognized: '" + baseTypeId + "'";
                }
                catch (ManifoldCFException e) {
                    try {
                        if (e.getErrorCode() == 2) {
                            errorCode = null;
                        }
                        throw e;
                    }
                    catch (Throwable var34_45) {
                        if (errorCode != null) {
                            activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, errorDesc, null);
                        }
                        throw var34_45;
                    }
                }
            }
            if (errorCode == null) continue;
            activities.recordActivity(new Long(startTime), "read document", fileLengthLong, documentIdentifier, errorCode, (String)errorDesc, null);
        }
    }

    private String getDocumentURI(CmisObject cmisObject) throws ManifoldCFException {
        Object documentURI = "";
        String currentBaseTypeId = cmisObject.getBaseTypeId().value();
        if (StringUtils.equals((String)currentBaseTypeId, (String)BaseTypeId.CMIS_DOCUMENT.value())) {
            Document currentDocument = (Document)cmisObject;
            if (currentDocument.getParents() != null && !currentDocument.getParents().isEmpty()) {
                String path = ((Folder)currentDocument.getParents().get(0)).getPath();
                String name = currentDocument.getName();
                String fullContentPath = path + "/" + name;
                documentURI = fullContentPath;
                String documentDownloadURL = CmisRepositoryConnectorUtils.getDocumentURL(currentDocument, this.session);
                documentURI = StringUtils.contains((String)documentDownloadURL, (char)'?') ? documentDownloadURL + "&contentPath=" + fullContentPath : documentDownloadURL + "?contentPath=" + fullContentPath;
            }
        } else if (StringUtils.equals((String)currentBaseTypeId, (String)BaseTypeId.CMIS_FOLDER.value())) {
            Folder currentFolder = (Folder)cmisObject;
            String path = currentFolder.getPath();
            String name = currentFolder.getName();
            String fullContentPath = path + "/" + name;
            documentURI = fullContentPath;
        }
        return documentURI;
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("CMIS: IOException " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected class DestroySessionThread
    extends Thread {
        protected Throwable exception = null;

        public DestroySessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CmisRepositoryConnector.this.session = null;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CmisRepositoryConnector.this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                Logging.connectors.warn((Object)("CMIS: Error checking repository: " + e.getMessage()), e);
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CmisRepositoryConnector.this.parameters.clear();
                CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.user", CmisRepositoryConnector.this.username);
                CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.password", CmisRepositoryConnector.this.password);
                String endpoint = CmisRepositoryConnector.this.protocol + "://" + CmisRepositoryConnector.this.server + ":" + CmisRepositoryConnector.this.port + CmisRepositoryConnector.this.path;
                if ("atom".equals(CmisRepositoryConnector.this.binding)) {
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", endpoint);
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
                } else if ("ws".equals(CmisRepositoryConnector.this.binding)) {
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", endpoint + "/ACLService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", endpoint + "/DiscoveryService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", endpoint + "/MultiFilingService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", endpoint + "/NavigationService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", endpoint + "/ObjectService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", endpoint + "/PolicyService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", endpoint + "/RelationshipService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", endpoint + "/RepositoryService?wsdl");
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", endpoint + "/VersioningService?wsdl");
                }
                if (StringUtils.isEmpty((String)CmisRepositoryConnector.this.repositoryId)) {
                    List repos = null;
                    try {
                        repos = CmisRepositoryConnector.this.factory.getRepositories(CmisRepositoryConnector.this.parameters);
                        CmisRepositoryConnector.this.session = ((Repository)repos.get(0)).createSession();
                    }
                    catch (Exception e) {
                        Logging.connectors.error((Object)("CMIS: Error during getting CMIS repositories. Please check the endpoint parameters: " + e.getMessage()), (Throwable)e);
                        this.exception = e;
                    }
                } else {
                    CmisRepositoryConnector.this.parameters.put("org.apache.chemistry.opencmis.session.repository.id", CmisRepositoryConnector.this.repositoryId);
                    try {
                        CmisRepositoryConnector.this.session = CmisRepositoryConnector.this.factory.createSession(CmisRepositoryConnector.this.parameters);
                    }
                    catch (Exception e) {
                        Logging.connectors.error((Object)("CMIS: Error during the creation of the new session. Please check the endpoint parameters: " + e.getMessage()), (Throwable)e);
                        this.exception = e;
                    }
                }
                if (CmisRepositoryConnector.this.session != null) {
                    CmisRepositoryConnector.this.session.getDefaultContext().setCacheEnabled(false);
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

