/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.tests;

import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.tests.ManifoldCFInstance;

public class SchedulerTester {
    protected final ManifoldCFInstance instance1;
    protected final ManifoldCFInstance instance2;

    public SchedulerTester(ManifoldCFInstance instance1, ManifoldCFInstance instance2) {
        this.instance1 = instance1;
        this.instance2 = instance2;
    }

    public void executeTest() throws Exception {
        this.instance1.start();
        IThreadContext tc = ThreadContextFactory.make();
        IRepositoryConnectionManager mgr = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
        IRepositoryConnection conn = mgr.create();
        conn.setName("SchedulerTest Connection");
        conn.setDescription("SchedulerTest Connection");
        conn.setClassName("org.apache.manifoldcf.crawler.tests.SchedulingRepositoryConnector");
        conn.setMaxConnections(100);
        mgr.save(conn);
        IOutputConnectionManager outputMgr = OutputConnectionManagerFactory.make((IThreadContext)tc);
        IOutputConnection outputConn = outputMgr.create();
        outputConn.setName("Null Connection");
        outputConn.setDescription("Null Connection");
        outputConn.setClassName("org.apache.manifoldcf.agents.tests.TestingOutputConnector");
        outputConn.setMaxConnections(100);
        outputMgr.save(outputConn);
        IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
        IJobDescription job = jobManager.createJob();
        job.setDescription("Test Job");
        job.setConnectionName("SchedulerTest Connection");
        job.addPipelineStage(-1, true, "Null Connection", "");
        job.setType(1);
        job.setStartMethod(2);
        job.setHopcountMode(0);
        jobManager.save(job);
        jobManager.manualStart(job.getID());
        this.instance1.waitJobRunningNative(jobManager, job.getID(), 30000L);
        this.instance2.start();
        Thread.sleep(5000L);
        this.instance1.stopNoCleanup();
        long startTime = System.currentTimeMillis();
        this.instance2.waitJobInactiveNative(jobManager, job.getID(), 1200000L);
        long endTime = System.currentTimeMillis();
        System.out.println("Crawl took " + (endTime - startTime) + " milliseconds");
        if (jobManager.getStatus(job.getID()).getDocumentsProcessed() != 2010L) {
            throw new Exception("Expected 2010 documents, saw " + jobManager.getStatus(job.getID()).getDocumentsProcessed());
        }
        if (endTime - startTime > 150000L) {
            throw new Exception("Expected crawl to complete in less than 150 seconds; took " + (endTime - startTime) + " ms");
        }
        if (endTime - startTime < 96000L) {
            throw new Exception("Job finished too quickly; throttling clearly failed");
        }
        jobManager.deleteJob(job.getID());
        this.instance2.waitJobDeletedNative(jobManager, job.getID(), 120000L);
        this.instance2.stop();
    }
}

