/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.parser;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlResultParser {
    public Element validate(DataSource dataSource) throws IOException {
        try {
            Document rdocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return this.validate(rdocument, dataSource);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Failed to init document builder", e);
        }
    }

    public Element validate(Document rdocument, DataSource dataSource) throws IOException {
        ValidationResult result;
        String pdfType = null;
        long before = System.currentTimeMillis();
        try {
            PreflightParser parser = new PreflightParser(dataSource);
            try {
                parser.parse();
                PreflightDocument document = parser.getPreflightDocument();
                document.validate();
                pdfType = document.getSpecification().getFname();
                result = document.getResult();
                document.close();
            }
            catch (SyntaxValidationException e) {
                result = e.getResult();
            }
        }
        catch (Exception e) {
            long after = System.currentTimeMillis();
            return this.generateFailureResponse(rdocument, dataSource.getName(), after - before, pdfType, e);
        }
        long after = System.currentTimeMillis();
        if (result.isValid()) {
            Element preflight = this.generateResponseSkeleton(rdocument, dataSource.getName(), after - before);
            Element valid = rdocument.createElement("isValid");
            valid.setAttribute("type", pdfType);
            valid.setTextContent("true");
            preflight.appendChild(valid);
            return preflight;
        }
        Element preflight = this.generateResponseSkeleton(rdocument, dataSource.getName(), after - before);
        this.createResponseWithError(rdocument, pdfType, result, preflight);
        return preflight;
    }

    protected void createResponseWithError(Document rdocument, String pdfType, ValidationResult result, Element preflight) {
        Element valid = rdocument.createElement("isValid");
        valid.setAttribute("type", pdfType);
        valid.setTextContent("false");
        preflight.appendChild(valid);
        Element errors = rdocument.createElement("errors");
        Map<ValidationResult.ValidationError, Integer> cleaned = this.cleanErrorList(result.getErrorsList());
        preflight.appendChild(errors);
        int totalCount = 0;
        for (Map.Entry<ValidationResult.ValidationError, Integer> entry : cleaned.entrySet()) {
            Element error = rdocument.createElement("error");
            int count = entry.getValue();
            error.setAttribute("count", String.format("%d", count));
            totalCount += count;
            Element code = rdocument.createElement("code");
            ValidationResult.ValidationError ve = entry.getKey();
            code.setTextContent(ve.getErrorCode());
            error.appendChild(code);
            Element detail = rdocument.createElement("details");
            detail.setTextContent(ve.getDetails());
            error.appendChild(detail);
            if (ve.getPageNumber() != null) {
                Element page = rdocument.createElement("page");
                page.setTextContent(ve.getPageNumber().toString());
                error.appendChild(page);
            }
            errors.appendChild(error);
        }
        errors.setAttribute("count", String.format("%d", totalCount));
    }

    private Map<ValidationResult.ValidationError, Integer> cleanErrorList(List<ValidationResult.ValidationError> errors) {
        HashMap<ValidationResult.ValidationError, Integer> cleaned = new HashMap<ValidationResult.ValidationError, Integer>(errors.size());
        for (ValidationResult.ValidationError ve : errors) {
            Integer found = (Integer)cleaned.get(ve);
            if (found != null) {
                cleaned.put(ve, found + 1);
                continue;
            }
            cleaned.put(ve, 1);
        }
        return cleaned;
    }

    protected Element generateFailureResponse(Document rdocument, String name, long duration, String pdfType, Exception e) {
        Element preflight = this.generateResponseSkeleton(rdocument, name, duration);
        Element valid = rdocument.createElement("isValid");
        valid.setAttribute("type", pdfType);
        valid.setTextContent("false");
        preflight.appendChild(valid);
        Element exception = rdocument.createElement("exceptionThrown");
        Element message = rdocument.createElement("message");
        message.setTextContent(e.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        Element stack = rdocument.createElement("stackTrace");
        stack.setTextContent(sw.toString());
        exception.appendChild(message);
        exception.appendChild(stack);
        preflight.appendChild(exception);
        return preflight;
    }

    protected Element generateResponseSkeleton(Document rdocument, String name, long duration) {
        Element preflight = rdocument.createElement("preflight");
        preflight.setAttribute("name", name);
        Element eduration = rdocument.createElement("executionTimeMS");
        eduration.setTextContent(String.format("%d", duration));
        preflight.appendChild(eduration);
        return preflight;
    }
}

