/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.wavelet.WaveletFilter;

public abstract class AnWTFilter
implements WaveletFilter {
    public static final char OPT_PREFIX = 'F';
    private static final String[][] pinfo = new String[][]{{"Ffilters", "[<tile-component idx>] <id> [ [<tile-component idx>] <id> ...]", "Specifies which filters to use for specified tile-component. If this option is not used, the encoder choses the filters  of the tile-components according to their quantization  type. If this option is used, a component transformation is applied to the three first components.\n<tile-component idx>: see general note\n<id>: ',' separates horizontal and vertical filters, ':' separates decomposition levels filters. JPEG 2000 part 1 only supports w5x3 and w9x7 filters.", null}};

    public abstract void analyze_lpf(Object var1, int var2, int var3, int var4, Object var5, int var6, int var7, Object var8, int var9, int var10);

    public abstract void analyze_hpf(Object var1, int var2, int var3, int var4, Object var5, int var6, int var7, Object var8, int var9, int var10);

    public abstract float[] getLPSynthesisFilter();

    public abstract float[] getHPSynthesisFilter();

    public float[] getLPSynWaveForm(float[] in, float[] out) {
        return AnWTFilter.upsampleAndConvolve(in, this.getLPSynthesisFilter(), out);
    }

    public float[] getHPSynWaveForm(float[] in, float[] out) {
        return AnWTFilter.upsampleAndConvolve(in, this.getHPSynthesisFilter(), out);
    }

    private static float[] upsampleAndConvolve(float[] in, float[] wf, float[] out) {
        if (in == null) {
            in = new float[]{1.0f};
        }
        if (out == null) {
            out = new float[in.length * 2 + wf.length - 2];
        }
        int maxi = in.length * 2 + wf.length - 2;
        for (int i = 0; i < maxi; ++i) {
            int maxk;
            float tmp = 0.0f;
            int k = (i - wf.length + 2) / 2;
            if (k < 0) {
                k = 0;
            }
            if ((maxk = i / 2 + 1) > in.length) {
                maxk = in.length;
            }
            int j = 2 * k - i + wf.length - 1;
            while (k < maxk) {
                tmp += in[k] * wf[j];
                ++k;
                j += 2;
            }
            out[i] = tmp;
        }
        return out;
    }

    public abstract int getFilterType();

    public static String[][] getParameterInfo() {
        return pinfo;
    }
}

