/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.asb.impl;

import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.asb.impl.FlowControllerContainer;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.JCasFlow_ImplBase;
import org.apache.uima.flow.Step;
import org.apache.uima.impl.Util;
import org.apache.uima.resource.CasManager;
import org.apache.uima.util.UimaTimer;

public class FlowContainer {
    private Flow mFlow;
    private FlowControllerContainer mFlowControllerContainer;
    private boolean mSofaAware;
    private CASImpl mCAS;
    private UimaTimer mTimer = UIMAFramework.newTimer();

    public FlowContainer(Flow aFlow, FlowControllerContainer aFlowControllerContainer, CAS aCAS) {
        this.mFlow = aFlow;
        this.mFlowControllerContainer = aFlowControllerContainer;
        this.mSofaAware = this.mFlowControllerContainer.getProcessingResourceMetaData().isSofaAware();
        this.mCAS = (CASImpl)aCAS;
    }

    public FlowContainer newCasProduced(CAS newCAS, String producedBy) throws AnalysisEngineProcessException {
        FlowContainer flowContainer;
        this.mTimer.startIt();
        CASImpl view = null;
        try {
            view = Util.getStartingView(newCAS, this.mSofaAware, this.mFlowControllerContainer.getUimaContextAdmin().getComponentInfo());
            Class<? extends AbstractCas> requiredInterface = this.mFlowControllerContainer.getRequiredCasInterface();
            AbstractCas casToPass = this.getCasManager().getCasInterface(view, requiredInterface);
            view.switchClassLoaderLockCasCL(this.getFlowClassLoader());
            Flow flow = this.mFlow.newCasProduced(casToPass, producedBy);
            if (flow instanceof CasFlow_ImplBase) {
                ((CasFlow_ImplBase)flow).setCas(view);
            }
            if (flow instanceof JCasFlow_ImplBase) {
                ((JCasFlow_ImplBase)flow).setJCas(view.getJCas());
            }
            flowContainer = new FlowContainer(flow, this.mFlowControllerContainer, newCAS);
            if (null != view) {
                view.restoreClassLoaderUnlockCas();
                view.setCurrentComponentInfo(null);
            }
            this.mTimer.stopIt();
        }
        catch (CASException e) {
            try {
                throw new AnalysisEngineProcessException(e);
            }
            catch (Throwable throwable) {
                if (null != view) {
                    ((CASImpl)view).restoreClassLoaderUnlockCas();
                    view.setCurrentComponentInfo(null);
                }
                this.mTimer.stopIt();
                this.getMBean().reportAnalysisTime(this.mTimer.getDuration());
                this.getMBean().incrementCASesProcessed();
                throw throwable;
            }
        }
        this.getMBean().reportAnalysisTime(this.mTimer.getDuration());
        this.getMBean().incrementCASesProcessed();
        return flowContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step next() throws AnalysisEngineProcessException {
        this.mTimer.startIt();
        try {
            this.mCAS.switchClassLoaderLockCasCL(this.getFlowClassLoader());
            Step step = this.mFlow.next();
            return step;
        }
        finally {
            this.mCAS.restoreClassLoaderUnlockCas();
            this.mTimer.stopIt();
            this.getMBean().reportAnalysisTime(this.mTimer.getDuration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aborted() {
        try {
            this.mCAS.switchClassLoaderLockCasCL(this.getFlowClassLoader());
            this.mFlow.aborted();
        }
        finally {
            this.mCAS.restoreClassLoaderUnlockCas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean continueOnFailure(String failedAeKey, Exception failure) {
        try {
            this.mCAS.switchClassLoaderLockCasCL(this.getFlowClassLoader());
            boolean bl = this.mFlow.continueOnFailure(failedAeKey, failure);
            return bl;
        }
        finally {
            this.mCAS.restoreClassLoaderUnlockCas();
        }
    }

    private CasManager getCasManager() {
        return this.mFlowControllerContainer.getResourceManager().getCasManager();
    }

    public AnalysisEngineManagementImpl getMBean() {
        return (AnalysisEngineManagementImpl)this.mFlowControllerContainer.getUimaContextAdmin().getManagementInterface();
    }

    private ClassLoader getFlowClassLoader() {
        return this.mFlowControllerContainer.getResourceManager().getExtensionClassLoader();
    }
}

