/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.impl.TransientWrapper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;

public class SessionImpl
implements BindingSession {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Map<String, Object> data;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SessionImpl() {
        this.id = UUID.randomUUID().toString();
        this.data = new HashMap<String, Object>();
    }

    @Override
    public String getSessionId() {
        return this.id;
    }

    @Override
    public Collection<String> getKeys() {
        return this.data.keySet();
    }

    @Override
    public Object get(String key) {
        Object value = null;
        this.lock.readLock().lock();
        try {
            value = this.data.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (value instanceof TransientWrapper) {
            return ((TransientWrapper)value).getObject();
        }
        return value;
    }

    @Override
    public Object get(String key, Object defValue) {
        Object value = this.get(key);
        return value == null ? defValue : value;
    }

    @Override
    public int get(String key, int defValue) {
        Object value = this.get(key);
        int intValue = defValue;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof String) {
            try {
                intValue = Integer.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return intValue;
    }

    @Override
    public boolean get(String key, boolean defValue) {
        Object value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defValue;
    }

    @Override
    public void put(String key, Serializable obj) {
        this.lock.writeLock().lock();
        try {
            this.data.put(key, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object obj, boolean isTransient) {
        Object value;
        Object object = value = isTransient ? new TransientWrapper(obj) : obj;
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Object must be serializable!");
        }
        this.lock.writeLock().lock();
        try {
            this.data.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(String key) {
        this.lock.writeLock().lock();
        try {
            this.data.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public void writeLock() {
        this.lock.writeLock().lock();
    }

    @Override
    public void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    public String toString() {
        return "Session " + this.id + ": " + this.data.toString();
    }
}

