/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.compiler.scopes.BasicScope;
import com.github.sommeri.less4j.core.compiler.scopes.ILocalScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScopesTree;
import java.util.Collections;
import java.util.List;

public class PlaceholderScope
extends BasicScope {
    private final ILocalScope.DataPlaceholder placeholder;

    public PlaceholderScope(IScope parent, ILocalScope localScope, IScopesTree surroundingScopes) {
        super(localScope, surroundingScopes);
        super.setParentKeepConsistency(parent);
        this.placeholder = parent.createDataPlaceholder();
    }

    @Override
    public void setParentKeepConsistency(IScope parent) {
        throw new IllegalStateException("Placeholder should never be reparented.");
    }

    public void replaceSelf(IScope by) {
        IScope parent = this.getParent();
        this.replaceChild(parent, this, by.getChilds());
        parent.replacePlaceholder(this.placeholder, by);
    }

    public void removeSelf() {
        List<IScope> nothing = Collections.emptyList();
        this.replaceChild(this.getParent(), this, nothing);
    }
}

