/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.Grib2Collection;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.unidata.io.RandomAccessFile;

public class Grib2CollectionBuilderFromIndex
extends GribCollectionBuilderFromIndex {
    protected Grib2Customizer cust;

    public static GribCollection readFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, boolean dataOnly, Logger logger) throws IOException {
        Grib2CollectionBuilderFromIndex builder = new Grib2CollectionBuilderFromIndex(name, config, dataOnly, logger);
        if (!builder.readIndex(raf)) {
            return null;
        }
        if (builder.gc.getFiles().size() == 0) {
            logger.warn("Grib2CollectionBuilderFromIndex {}: has no files, force recreate ", (Object)builder.gc.getName());
            return null;
        }
        return builder.gc;
    }

    protected Grib2CollectionBuilderFromIndex(String name, FeatureCollectionConfig config, boolean dataOnly, Logger logger) {
        super(new Grib2Collection(name, null, config), dataOnly, logger);
    }

    @Override
    protected String getMagicStart() {
        return "Grib2Collectio2Index";
    }

    @Override
    protected GribTables makeCustomizer() {
        this.cust = Grib2Customizer.factory(this.gc.center, this.gc.subcenter, this.gc.master, this.gc.local, this.gc.getGenProcessId());
        return this.cust;
    }

    @Override
    protected String getLevelNameShort(int levelCode) {
        return this.cust.getLevelNameShort(levelCode);
    }

    @Override
    protected void readGds(GribCollectionProto.Gds p) {
        byte[] rawGds = p.getGds().toByteArray();
        Grib2SectionGridDefinition gdss = new Grib2SectionGridDefinition(rawGds);
        Grib2Gds gds = gdss.getGDS();
        int gdsHash = p.getGdsHash() != 0 ? p.getGdsHash() : gds.hashCode();
        String nameOverride = p.hasNameOverride() ? p.getNameOverride() : null;
        this.gc.addHorizCoordSystem(gds.makeHorizCoordSys(), rawGds, gdsHash, nameOverride, -1);
    }
}

