/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.async.impl;

import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.exceptions.CmisServiceUnavailableException;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.async.AsyncCmisExecutor;
import org.apache.chemistry.opencmis.server.async.AsyncCmisServiceFactory;
import org.apache.chemistry.opencmis.server.async.impl.AsyncCmisServlet;
import org.apache.chemistry.opencmis.server.async.impl.CmisRequestRunner;
import org.apache.chemistry.opencmis.server.impl.CmisRepositoryContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CmisAsyncHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CmisAsyncHelper.class);

    public static AsyncCmisExecutor getAsyncCmisExecutor(ServletConfig config, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        CmisServiceFactory serviceFactory = CmisRepositoryContextListener.getServiceFactory((ServletContext)config.getServletContext());
        if (!(serviceFactory instanceof AsyncCmisServiceFactory)) {
            throw new ServletException("CMIS service factory does not support asynchronous execution!");
        }
        return ((AsyncCmisServiceFactory)serviceFactory).getAsyncCmisExecutor(request, response);
    }

    public static void executeAsync(AsyncCmisServlet servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncCmisExecutor executor = CmisAsyncHelper.getAsyncCmisExecutor(servlet.getServletConfig(), request, response);
        if (executor == null) {
            servlet.executeSync(request, response);
        } else {
            AsyncContext asyncContext = request.startAsync();
            try {
                executor.execute(asyncContext, new CmisRequestRunner(asyncContext, servlet));
            }
            catch (RejectedExecutionException ree) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Submitting async request failed: {}", (Object)ree.toString(), (Object)ree);
                }
                servlet.sendError((Exception)new CmisServiceUnavailableException("CMIS server is busy", (Throwable)ree), request, response);
                asyncContext.complete();
            }
            catch (Exception e) {
                LOG.error("Executing async request failed: {}", (Object)e.toString(), (Object)e);
                servlet.sendError(e, request, response);
                asyncContext.complete();
            }
        }
    }

    private CmisAsyncHelper() {
    }
}

