/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.CreatablePropertyTypes;
import org.apache.chemistry.opencmis.commons.data.NewTypeSettableAttributes;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityOrderBy;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CreatablePropertyTypesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.NewTypeSettableAttributesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.TypeCreator;
import org.apache.chemistry.opencmis.inmemory.TypeManagerImpl;
import org.apache.chemistry.opencmis.inmemory.query.InMemoryQueryProcessor;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.CmisServiceValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.InMemoryAce;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.InMemoryServiceValidatorImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.server.support.TypeDefinitionFactory;
import org.apache.chemistry.opencmis.server.support.TypeManager;

public class StoreManagerImpl
implements StoreManager {
    private static final String UNKNOWN_REPOSITORY = "Unknown repository ";
    private static final String CMIS_READ = "cmis:read";
    private static final String CMIS_WRITE = "cmis:write";
    private static final String CMIS_ALL = "cmis:all";
    private final BindingsObjectFactory fObjectFactory;
    private final TypeDefinitionFactory typeFactory = TypeDefinitionFactory.newInstance();
    private static final String OPENCMIS_VERSION;
    private static final String OPENCMIS_SERVER;
    private final Map<String, TypeManagerImpl> fMapRepositoryToTypeManager = new HashMap<String, TypeManagerImpl>();
    private final Map<String, ObjectStore> fMapRepositoryToObjectStore = new HashMap<String, ObjectStore>();
    private boolean relaxedParserMode = false;

    public ObjectStoreImpl getStore(String repositoryId) {
        return (ObjectStoreImpl)this.fMapRepositoryToObjectStore.get(repositoryId);
    }

    public StoreManagerImpl() {
        this.fObjectFactory = new BindingsObjectFactoryImpl();
    }

    @Override
    public List<String> getAllRepositoryIds() {
        Set<String> repIds = this.fMapRepositoryToObjectStore.keySet();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(repIds);
        return result;
    }

    @Override
    public void initRepository(String repositoryId) {
        this.fMapRepositoryToObjectStore.put(repositoryId, new ObjectStoreImpl(repositoryId));
        this.fMapRepositoryToTypeManager.put(repositoryId, new TypeManagerImpl());
    }

    @Override
    public void createAndInitRepository(String repositoryId, String typeCreatorClassName) {
        if (this.fMapRepositoryToObjectStore.containsKey(repositoryId) || this.fMapRepositoryToTypeManager.containsKey(repositoryId)) {
            throw new CmisInvalidArgumentException("Cannot add repository, repository " + repositoryId + " already exists.");
        }
        this.fMapRepositoryToObjectStore.put(repositoryId, new ObjectStoreImpl(repositoryId));
        this.fMapRepositoryToTypeManager.put(repositoryId, new TypeManagerImpl());
        this.initTypeSystem(repositoryId, typeCreatorClassName);
    }

    @Override
    public void addFlag(String flag) {
        if (flag.trim().equalsIgnoreCase("ParserModeRelaxed")) {
            this.relaxedParserMode = true;
        }
    }

    @Override
    public ObjectStore getObjectStore(String repositoryId) {
        return this.fMapRepositoryToObjectStore.get(repositoryId);
    }

    @Override
    public CmisServiceValidator getServiceValidator() {
        return new InMemoryServiceValidatorImpl(this);
    }

    @Override
    public BindingsObjectFactory getObjectFactory() {
        return this.fObjectFactory;
    }

    @Override
    public TypeDefinitionContainer getTypeById(String repositoryId, String typeId, boolean cmis11) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisObjectNotFoundException(UNKNOWN_REPOSITORY + repositoryId);
        }
        TypeDefinitionContainer tdc = typeManager.getTypeById(typeId);
        if (null != tdc && !cmis11) {
            TypeDefinition td = tdc.getTypeDefinition();
            if (td.getBaseTypeId() == BaseTypeId.CMIS_ITEM || td.getBaseTypeId() == BaseTypeId.CMIS_SECONDARY || td.getId().equals(BaseTypeId.CMIS_ITEM.value()) || td.getId().equals(BaseTypeId.CMIS_SECONDARY.value())) {
                tdc = null;
            } else {
                MutableTypeDefinition tdm = this.typeFactory.copy(td, true);
                tdm.setTypeMutability(null);
                tdc = new TypeDefinitionContainerImpl((TypeDefinition)tdm);
            }
        }
        return tdc;
    }

    @Override
    public TypeDefinitionContainer getTypeById(String repositoryId, String typeId, boolean includePropertyDefinitions, int depthParam, boolean cmis11) {
        int depth = depthParam;
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException(UNKNOWN_REPOSITORY + repositoryId);
        }
        TypeDefinitionContainer tc = typeManager.getTypeById(typeId);
        if (tc != null) {
            if (depth == -1) {
                if (cmis11 && includePropertyDefinitions) {
                    return tc;
                }
                depth = Integer.MAX_VALUE;
            } else if (depth == 0 || depth < -1) {
                throw new CmisInvalidArgumentException("illegal depth value: " + depth);
            }
            return StoreManagerImpl.cloneTypeList(depth, includePropertyDefinitions, tc, null, cmis11);
        }
        return null;
    }

    @Override
    public Collection<TypeDefinitionContainer> getTypeDefinitionList(String repositoryId, boolean includePropertyDefinitions, boolean cmis11) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException(UNKNOWN_REPOSITORY + repositoryId);
        }
        List<TypeDefinitionContainer> typeColl = this.getRootTypes(repositoryId, includePropertyDefinitions, cmis11);
        return typeColl;
    }

    @Override
    public List<TypeDefinitionContainer> getRootTypes(String repositoryId, boolean includePropertyDefinitions, boolean cmis11) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException(UNKNOWN_REPOSITORY + repositoryId);
        }
        ArrayList<TypeDefinitionContainer> rootTypes = typeManager.getRootTypes();
        if (!cmis11) {
            rootTypes = new ArrayList<TypeDefinitionContainer>(rootTypes);
            TypeDefinitionContainer tcItem = null;
            TypeDefinitionContainer tcSecondary = null;
            for (TypeDefinitionContainer tc : rootTypes) {
                if (tc.getTypeDefinition().getId().equals(BaseTypeId.CMIS_ITEM.value())) {
                    tcItem = tc;
                }
                if (!tc.getTypeDefinition().getId().equals(BaseTypeId.CMIS_SECONDARY.value())) continue;
                tcSecondary = tc;
            }
            if (tcItem != null) {
                rootTypes.remove(tcItem);
            }
            if (tcSecondary != null) {
                rootTypes.remove(tcSecondary);
            }
        }
        List<TypeDefinitionContainer> result = cmis11 && includePropertyDefinitions ? rootTypes : this.cloneTypeDefinitionTree(rootTypes, includePropertyDefinitions, cmis11);
        return result;
    }

    private List<TypeDefinitionContainer> cloneTypeDefinitionTree(List<TypeDefinitionContainer> tdcList, boolean includePropertyDefinitions, boolean cmis11) {
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>(tdcList.size());
        for (TypeDefinitionContainer c : tdcList) {
            MutableTypeDefinition td = this.typeFactory.copy(c.getTypeDefinition(), includePropertyDefinitions);
            if (!cmis11) {
                td.setTypeMutability(null);
            }
            TypeDefinitionContainerImpl tdc = new TypeDefinitionContainerImpl((TypeDefinition)td);
            tdc.setChildren(this.cloneTypeDefinitionTree(c.getChildren(), includePropertyDefinitions, cmis11));
            result.add((TypeDefinitionContainer)tdc);
        }
        return result;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(CallContext context, String repositoryId) {
        ObjectStore sm = this.fMapRepositoryToObjectStore.get(repositoryId);
        if (null == sm) {
            return null;
        }
        boolean cmis11 = context.getCmisVersion().equals((Object)CmisVersion.CMIS_1_1);
        RepositoryInfo repoInfo = this.createRepositoryInfo(repositoryId, cmis11);
        return repoInfo;
    }

    public void clearTypeSystem(String repositoryId) {
        TypeManagerImpl typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException(UNKNOWN_REPOSITORY + repositoryId);
        }
        typeManager.clearTypeSystem();
    }

    public static List<TypeDefinition> initTypeSystem(String typeCreatorClassName) {
        List<TypeDefinition> typesList = null;
        if (typeCreatorClassName != null) {
            Object obj = null;
            TypeCreator typeCreator = null;
            String message = "Illegal class to create type system, must implement TypeCreator interface.";
            try {
                obj = Class.forName(typeCreatorClassName).newInstance();
            }
            catch (InstantiationException e) {
                throw new CmisRuntimeException("Illegal class to create type system, must implement TypeCreator interface.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CmisRuntimeException("Illegal class to create type system, must implement TypeCreator interface.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new CmisRuntimeException("Illegal class to create type system, must implement TypeCreator interface.", (Throwable)e);
            }
            if (!(obj instanceof TypeCreator)) {
                throw new CmisRuntimeException("Illegal class to create type system, must implement TypeCreator interface.");
            }
            typeCreator = obj;
            typesList = typeCreator.createTypesList();
        }
        return typesList;
    }

    private void initTypeSystem(String repositoryId, String typeCreatorClassName) {
        List<TypeDefinition> typeDefs = null;
        TypeManagerImpl typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisObjectNotFoundException(UNKNOWN_REPOSITORY + repositoryId);
        }
        if (null != typeCreatorClassName) {
            typeDefs = StoreManagerImpl.initTypeSystem(typeCreatorClassName);
        }
        typeManager.initTypeSystem(typeDefs, true);
    }

    private RepositoryInfo createRepositoryInfo(String repositoryId, boolean cmis11) {
        ArrayList<BaseTypeId> changesOnType;
        ObjectStore objStore = this.getObjectStore(repositoryId);
        String rootFolderId = objStore.getRootFolder().getId();
        RepositoryInfoImpl repoInfo = new RepositoryInfoImpl();
        repoInfo.setId(repositoryId == null ? "inMem" : repositoryId);
        repoInfo.setName("Apache Chemistry OpenCMIS InMemory Repository");
        repoInfo.setDescription("Apache Chemistry OpenCMIS InMemory Repository (Version: " + OPENCMIS_VERSION + ")");
        repoInfo.setRootFolder(rootFolderId);
        repoInfo.setPrincipalAnonymous(InMemoryAce.getAnonymousUser());
        repoInfo.setPrincipalAnyone(InMemoryAce.getAnyoneUser());
        repoInfo.setThinClientUri("");
        repoInfo.setChangesIncomplete(Boolean.TRUE);
        repoInfo.setLatestChangeLogToken("token-24");
        repoInfo.setVendorName("Apache Chemistry");
        repoInfo.setProductName(OPENCMIS_SERVER);
        repoInfo.setProductVersion(OPENCMIS_VERSION);
        RepositoryCapabilitiesImpl caps = new RepositoryCapabilitiesImpl();
        caps.setAllVersionsSearchable(Boolean.valueOf(false));
        caps.setCapabilityAcl(CapabilityAcl.MANAGE);
        caps.setCapabilityChanges(CapabilityChanges.OBJECTIDSONLY);
        caps.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        caps.setCapabilityJoin(CapabilityJoin.NONE);
        caps.setCapabilityQuery(CapabilityQuery.BOTHCOMBINED);
        caps.setCapabilityRendition(CapabilityRenditions.READ);
        caps.setIsPwcSearchable(Boolean.valueOf(false));
        caps.setIsPwcUpdatable(Boolean.valueOf(true));
        caps.setSupportsGetDescendants(Boolean.valueOf(true));
        caps.setSupportsGetFolderTree(Boolean.valueOf(true));
        caps.setSupportsMultifiling(Boolean.valueOf(true));
        caps.setSupportsUnfiling(Boolean.valueOf(true));
        caps.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        caps.setCapabilityAcl(CapabilityAcl.MANAGE);
        AclCapabilitiesDataImpl aclCaps = new AclCapabilitiesDataImpl();
        aclCaps.setAclPropagation(AclPropagation.OBJECTONLY);
        aclCaps.setSupportedPermissions(SupportedPermissions.BASIC);
        ArrayList<PermissionDefinition> permissions = new ArrayList<PermissionDefinition>();
        permissions.add(StoreManagerImpl.createPermission(CMIS_READ, "Read"));
        permissions.add(StoreManagerImpl.createPermission(CMIS_WRITE, "Write"));
        permissions.add(StoreManagerImpl.createPermission(CMIS_ALL, "All"));
        if (cmis11) {
            NewTypeSettableAttributesImpl typeAttrs = new NewTypeSettableAttributesImpl();
            typeAttrs.setCanSetControllableAcl(Boolean.valueOf(false));
            typeAttrs.setCanSetControllablePolicy(Boolean.valueOf(false));
            typeAttrs.setCanSetCreatable(Boolean.valueOf(true));
            typeAttrs.setCanSetDescription(Boolean.valueOf(true));
            typeAttrs.setCanSetDisplayName(Boolean.valueOf(true));
            typeAttrs.setCanSetFileable(Boolean.valueOf(false));
            typeAttrs.setCanSetFulltextIndexed(Boolean.valueOf(false));
            typeAttrs.setCanSetId(Boolean.valueOf(true));
            typeAttrs.setCanSetIncludedInSupertypeQuery(Boolean.valueOf(false));
            typeAttrs.setCanSetLocalName(Boolean.valueOf(true));
            typeAttrs.setCanSetLocalNamespace(Boolean.valueOf(true));
            typeAttrs.setCanSetQueryable(Boolean.valueOf(false));
            typeAttrs.setCanSetQueryName(Boolean.valueOf(true));
            caps.setNewTypeSettableAttributes((NewTypeSettableAttributes)typeAttrs);
        }
        aclCaps.setPermissionDefinitionData(permissions);
        ArrayList<PermissionMapping> list = new ArrayList<PermissionMapping>();
        list.add(StoreManagerImpl.createMapping("canGetDescendents.Folder", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canGetChildren.Folder", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canGetParents.Folder", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canGetFolderParent.Object", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canCreateDocument.Folder", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canCreateFolder.Folder", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canCreateRelationship.Source", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canCreateRelationship.Target", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canGetProperties.Object", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canViewContent.Object", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canUpdateProperties.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canMove.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canMove.Target", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canMove.Source", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canDelete.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canDeleteTree.Folder", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canSetContent.Document", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canDeleteContent.Document", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canAddToFolder.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canRemoveFromFolder.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canCheckout.Document", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canCancelCheckout.Document", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canCheckin.Document", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canGetAllVersions.VersionSeries", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canGetObjectRelationships.Object", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canAddPolicy.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canRemovePolicy.Object", CMIS_WRITE));
        list.add(StoreManagerImpl.createMapping("canGetAppliedPolicies.Object", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canGetACL.Object", CMIS_READ));
        list.add(StoreManagerImpl.createMapping("canApplyACL.Object", CMIS_ALL));
        LinkedHashMap<String, PermissionMapping> map = new LinkedHashMap<String, PermissionMapping>();
        for (PermissionMapping pm : list) {
            map.put(pm.getKey(), pm);
        }
        if (cmis11) {
            repoInfo.setCmisVersionSupported(CmisVersion.CMIS_1_1.value());
            repoInfo.setCmisVersion(CmisVersion.CMIS_1_1);
            changesOnType = new ArrayList<BaseTypeId>(){
                {
                    this.add(BaseTypeId.CMIS_DOCUMENT);
                    this.add(BaseTypeId.CMIS_FOLDER);
                    this.add(BaseTypeId.CMIS_ITEM);
                }
            };
            HashSet<PropertyType> propertyTypeSet = new HashSet<PropertyType>(){
                {
                    this.add(PropertyType.BOOLEAN);
                    this.add(PropertyType.DATETIME);
                    this.add(PropertyType.DECIMAL);
                    this.add(PropertyType.HTML);
                    this.add(PropertyType.ID);
                    this.add(PropertyType.INTEGER);
                    this.add(PropertyType.STRING);
                    this.add(PropertyType.URI);
                }
            };
            CreatablePropertyTypesImpl creatablePropertyTypes = new CreatablePropertyTypesImpl();
            creatablePropertyTypes.setCanCreate((Set)propertyTypeSet);
            caps.setCreatablePropertyTypes((CreatablePropertyTypes)creatablePropertyTypes);
            caps.setCapabilityOrderBy(CapabilityOrderBy.COMMON);
        } else {
            repoInfo.setCmisVersionSupported(CmisVersion.CMIS_1_0.value());
            repoInfo.setCmisVersion(CmisVersion.CMIS_1_0);
            changesOnType = new ArrayList<BaseTypeId>(){
                {
                    this.add(BaseTypeId.CMIS_DOCUMENT);
                    this.add(BaseTypeId.CMIS_FOLDER);
                }
            };
        }
        repoInfo.setChangesOnType((List)changesOnType);
        aclCaps.setPermissionMappingData(map);
        repoInfo.setAclCapabilities((AclCapabilities)aclCaps);
        repoInfo.setCapabilities((RepositoryCapabilities)caps);
        return repoInfo;
    }

    private static PermissionDefinition createPermission(String permission, String description) {
        PermissionDefinitionDataImpl pd = new PermissionDefinitionDataImpl();
        pd.setId(permission);
        pd.setDescription(description);
        return pd;
    }

    private static PermissionMapping createMapping(String key, String permission) {
        PermissionMappingDataImpl pm = new PermissionMappingDataImpl();
        pm.setKey(key);
        pm.setPermissions(Collections.singletonList(permission));
        return pm;
    }

    public static TypeDefinitionContainer cloneTypeList(int depth, boolean includePropertyDefinitions, TypeDefinitionContainer tdc, TypeDefinitionContainer parent, boolean cmis11) {
        TypeDefinitionFactory typeFactory = TypeDefinitionFactory.newInstance();
        MutableTypeDefinition tdClone = typeFactory.copy(tdc.getTypeDefinition(), includePropertyDefinitions);
        if (!cmis11) {
            tdClone.setTypeMutability(null);
        }
        TypeDefinitionContainerImpl tdcClone = new TypeDefinitionContainerImpl((TypeDefinition)tdClone);
        if (null != parent) {
            parent.getChildren().add(tdcClone);
        }
        if (depth > 0) {
            List children = tdc.getChildren();
            for (TypeDefinitionContainer child : children) {
                StoreManagerImpl.cloneTypeList(depth - 1, includePropertyDefinitions, child, (TypeDefinitionContainer)tdcClone, cmis11);
            }
        }
        return tdcClone;
    }

    @Override
    public TypeManager getTypeManager(String repositoryId) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        return typeManager;
    }

    @Override
    public boolean supportsSingleFiling(String repositoryId) {
        return false;
    }

    @Override
    public boolean supportsMultiFilings(String repositoryId) {
        return true;
    }

    @Override
    public ObjectList query(CallContext callContext, String user, String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        TypeManager tm = this.getTypeManager(repositoryId);
        ObjectStore objectStore = this.getObjectStore(repositoryId);
        InMemoryQueryProcessor queryProcessor = new InMemoryQueryProcessor(this.getStore(repositoryId), callContext, this.relaxedParserMode);
        ObjectList objList = queryProcessor.query(tm, objectStore, user, repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
        return objList;
    }

    static {
        Package p = Package.getPackage("org.apache.chemistry.opencmis.inmemory");
        if (p == null) {
            OPENCMIS_VERSION = "?";
            OPENCMIS_SERVER = "Apache-Chemistry-OpenCMIS-InMemory";
        } else {
            String ver = p.getImplementationVersion();
            OPENCMIS_VERSION = null == ver ? "?" : ver;
            OPENCMIS_SERVER = "Apache-Chemistry-OpenCMIS-InMemory/" + OPENCMIS_VERSION;
        }
    }
}

