/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class NavigationService {

    public static class GetCheckedOutDocs
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            String filter = this.getStringParameter(request, "filter");
            String orderBy = this.getStringParameter(request, "orderBy");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectList checkedout = service.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (checkedout == null) {
                throw new CmisRuntimeException("Checked out list is null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonCheckedOut = JSONConverter.convert((ObjectList)checkedout, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonCheckedOut, request, response);
        }
    }

    public static class GetObjectParents
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includeRelativePathSegment = this.getBooleanParameter(request, "includeRelativePathSegment");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            List parents = service.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (parents == null) {
                throw new CmisRuntimeException("Parents are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONArray jsonParents = new JSONArray();
            for (ObjectParentData parent : parents) {
                jsonParents.add((Object)JSONConverter.convert((ObjectParentData)parent, (TypeCache)typeCache, (boolean)succinct, (DateTimeFormat)dateTimeFormat));
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonParents, request, response);
        }
    }

    public static class GetFolderParent
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String filter = this.getStringParameter(request, "filter");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectData parent = service.getFolderParent(repositoryId, objectId, filter, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (parent == null) {
                throw new CmisRuntimeException("Parent is null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)parent, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class GetFolderTree
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            BigInteger depth = this.getBigIntegerParameter(request, "depth");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePathSegment = this.getBooleanParameter(request, "includePathSegment");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            List folderTree = service.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (folderTree == null) {
                throw new CmisRuntimeException("Folder Tree are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONArray jsonDescendants = new JSONArray();
            for (ObjectInFolderContainer descendant : folderTree) {
                jsonDescendants.add((Object)JSONConverter.convert((ObjectInFolderContainer)descendant, (TypeCache)typeCache, (boolean)succinct, (DateTimeFormat)dateTimeFormat));
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonDescendants, request, response);
        }
    }

    public static class GetDescendants
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            BigInteger depth = this.getBigIntegerParameter(request, "depth");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePathSegment = this.getBooleanParameter(request, "includePathSegment");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            List descendants = service.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (descendants == null) {
                throw new CmisRuntimeException("Descendants are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONArray jsonDescendants = new JSONArray();
            for (ObjectInFolderContainer descendant : descendants) {
                jsonDescendants.add((Object)JSONConverter.convert((ObjectInFolderContainer)descendant, (TypeCache)typeCache, (boolean)succinct, (DateTimeFormat)dateTimeFormat));
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonDescendants, request, response);
        }
    }

    public static class GetChildren
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String folderId = ((BrowserCallContextImpl)context).getObjectId();
            String filter = this.getStringParameter(request, "filter");
            String orderBy = this.getStringParameter(request, "orderBy");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            IncludeRelationships includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
            String renditionFilter = this.getStringParameter(request, "renditionFilter");
            Boolean includePathSegment = this.getBooleanParameter(request, "includePathSegment");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectInFolderList children = service.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (children == null) {
                throw new CmisRuntimeException("Children are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonChildren = JSONConverter.convert((ObjectInFolderList)children, (TypeCache)typeCache, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonChildren, request, response);
        }
    }
}

