/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl.office;

import com.healthmarketscience.jackcess.crypt.impl.office.BlockCipherProvider;
import com.healthmarketscience.jackcess.crypt.impl.office.EncryptionHeader;
import com.healthmarketscience.jackcess.crypt.impl.office.EncryptionVerifier;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;

public class ECMAStandardEncryptionProvider
extends BlockCipherProvider {
    private static final Set<EncryptionHeader.CryptoAlgorithm> VALID_CRYPTO_ALGOS = EnumSet.of(EncryptionHeader.CryptoAlgorithm.AES_128, EncryptionHeader.CryptoAlgorithm.AES_192, EncryptionHeader.CryptoAlgorithm.AES_256);
    private static final Set<EncryptionHeader.HashAlgorithm> VALID_HASH_ALGOS = EnumSet.of(EncryptionHeader.HashAlgorithm.SHA1);
    private static final int HASH_ITERATIONS = 50000;
    private final int _hashIterations;
    private final EncryptionHeader _header;
    private final EncryptionVerifier _verifier;
    private final byte[] _baseHash;
    private final int _encKeyByteSize;

    public ECMAStandardEncryptionProvider(PageChannel channel, byte[] encodingKey, ByteBuffer encProvBuf, byte[] pwdBytes) throws IOException {
        this(channel, encodingKey, encProvBuf, pwdBytes, 50000);
    }

    protected ECMAStandardEncryptionProvider(PageChannel channel, byte[] encodingKey, ByteBuffer encProvBuf, byte[] pwdBytes, int hashIterations) throws IOException {
        super(channel, encodingKey);
        this._hashIterations = hashIterations;
        this._header = EncryptionHeader.read(encProvBuf, VALID_CRYPTO_ALGOS, VALID_HASH_ALGOS);
        this._verifier = new EncryptionVerifier(encProvBuf, this._header.getCryptoAlgorithm());
        this._baseHash = ECMAStandardEncryptionProvider.hash(this.getDigest(), this._verifier.getSalt(), pwdBytes);
        this._encKeyByteSize = ECMAStandardEncryptionProvider.bits2bytes(this._header.getKeySize());
    }

    @Override
    protected Digest initDigest() {
        return new SHA1Digest();
    }

    @Override
    protected BlockCipher initCipher() {
        return new AESEngine();
    }

    protected KeyParameter computeCipherParams(int pageNumber) {
        return this.computeEncryptionKey(this.getEncodingKey(pageNumber));
    }

    @Override
    protected boolean verifyPassword(byte[] pwdBytes) {
        BufferedBlockCipher cipher = ECMAStandardEncryptionProvider.decryptInit(this.getBlockCipher(), (CipherParameters)this.computeEncryptionKey(this.int2bytes(0)));
        byte[] verifier = ECMAStandardEncryptionProvider.decryptBytes(cipher, this._verifier.getEncryptedVerifier());
        byte[] verifierHash = ECMAStandardEncryptionProvider.fixToLength(ECMAStandardEncryptionProvider.decryptBytes(cipher, this._verifier.getEncryptedVerifierHash()), this._verifier.getVerifierHashSize());
        byte[] testHash = ECMAStandardEncryptionProvider.fixToLength(ECMAStandardEncryptionProvider.hash(this.getDigest(), verifier), this._verifier.getVerifierHashSize());
        return Arrays.equals(verifierHash, testHash);
    }

    private KeyParameter computeEncryptionKey(byte[] blockBytes) {
        byte[] encKey = this.cryptDeriveKey(this._baseHash, blockBytes, this._encKeyByteSize);
        return new KeyParameter(encKey);
    }

    private byte[] cryptDeriveKey(byte[] baseHash, byte[] blockBytes, int keyByteLen) {
        Digest digest = this.getDigest();
        byte[] iterHash = this.iterateHash(baseHash, this._hashIterations);
        byte[] finalHash = ECMAStandardEncryptionProvider.hash(digest, iterHash, blockBytes);
        byte[] x1 = ECMAStandardEncryptionProvider.hash(digest, ECMAStandardEncryptionProvider.genXBytes(finalHash, 54));
        byte[] x2 = ECMAStandardEncryptionProvider.hash(digest, ECMAStandardEncryptionProvider.genXBytes(finalHash, 92));
        return ECMAStandardEncryptionProvider.fixToLength(ByteUtil.concat((byte[])x1, (byte[])x2), keyByteLen);
    }

    private static byte[] genXBytes(byte[] finalHash, int code) {
        byte[] x = ECMAStandardEncryptionProvider.fill(new byte[64], code);
        for (int i = 0; i < finalHash.length; ++i) {
            int n = i;
            x[n] = (byte)(x[n] ^ finalHash[i]);
        }
        return x;
    }
}

