/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConfig;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;

public class ElasticSearchConnection {
    protected final ElasticSearchConfig config;
    private final HttpClient client;
    private final String serverLocation;
    private final String indexName;
    private String resultDescription = "";
    private String callUrlSnippet = null;
    private String response = null;
    private String resultCode = null;
    private Result result = Result.UNKNOWN;
    protected static final String jsonException = "\"error\"";

    protected ElasticSearchConnection(ElasticSearchConfig config, HttpClient client) {
        this.config = config;
        this.client = client;
        this.serverLocation = config.getServerLocation();
        this.indexName = config.getIndexName();
    }

    protected StringBuffer getApiUrl(String command, boolean checkConnection) throws ManifoldCFException {
        StringBuffer url = new StringBuffer(this.serverLocation);
        if (!this.serverLocation.endsWith("/")) {
            url.append('/');
        }
        if (!checkConnection) {
            url.append(URLEncoder.encode((String)this.indexName)).append("/");
        }
        url.append(command);
        this.callUrlSnippet = url.toString();
        return url;
    }

    protected boolean call(HttpRequestBase method) throws ManifoldCFException, ServiceInterruption {
        CallThread ct = new CallThread(this.client, method);
        try {
            ct.start();
            try {
                ct.finishUp();
                this.response = ct.getResponse();
                return this.handleResultCode(ct.getResultCode(), this.response);
            }
            catch (InterruptedException e) {
                ct.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
        }
        catch (HttpException e) {
            this.handleHttpException(e);
            return false;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return false;
        }
    }

    protected boolean handleResultCode(int code, String response) throws ManifoldCFException, ServiceInterruption {
        if (code == 200 || code == 201) {
            this.setResult("OK", Result.OK, null);
            return true;
        }
        if (code == 404) {
            this.setResult("HTTPERROR", Result.ERROR, "Page not found: " + response);
            throw new ManifoldCFException("Server/page not found");
        }
        if (code >= 400 && code < 500) {
            this.setResult("HTTPERROR", Result.ERROR, "HTTP code = " + code + ", Response = " + response);
            return false;
        }
        if (code >= 500 && code < 600) {
            this.setResult("HTTPERROR", Result.ERROR, "Server exception: " + response);
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Server exception: " + response, (Throwable)new ManifoldCFException(response), currentTime + 300000L, currentTime + 1200000L, -1, false);
        }
        this.setResult("HTTPERROR", Result.UNKNOWN, "HTTP code = " + code + ", Response = " + response);
        throw new ManifoldCFException("Unexpected HTTP result code: " + code + ": " + response);
    }

    protected void handleHttpException(HttpException e) throws ManifoldCFException, ServiceInterruption {
        this.setResult(((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT), Result.ERROR, e.getMessage());
        throw new ManifoldCFException((Throwable)e);
    }

    protected void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException && !(e instanceof SocketTimeoutException)) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        this.setResult(e.getClass().getSimpleName().toUpperCase(Locale.ROOT), Result.ERROR, e.getMessage());
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 60000L, currentTime + 3600000L, -1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponseBodyAsString(HttpEntity entity) throws IOException, HttpException {
        InputStream is = entity.getContent();
        if (is != null) {
            try {
                Charset charSet;
                try {
                    ContentType ct = ContentType.get((HttpEntity)entity);
                    charSet = ct == null ? StandardCharsets.UTF_8 : ct.getCharset();
                }
                catch (ParseException e) {
                    charSet = StandardCharsets.UTF_8;
                }
                char[] buffer = new char[65536];
                InputStreamReader r = new InputStreamReader(is, charSet);
                StringWriter w = new StringWriter();
                try {
                    int amt;
                    while ((amt = r.read(buffer)) != -1) {
                        ((Writer)w).write(buffer, 0, amt);
                    }
                }
                finally {
                    ((Writer)w).flush();
                }
                String string = ((Object)w).toString();
                return string;
            }
            finally {
                is.close();
            }
        }
        return "";
    }

    protected String checkJson(String jsonQuery) throws ManifoldCFException {
        String result = null;
        if (this.response != null) {
            String[] tokens;
            for (String token : tokens = this.response.replaceAll("\\{", "").replaceAll("\\}", "").split(",")) {
                if (!token.contains(jsonQuery)) continue;
                result = token.substring(token.indexOf(":") + 1);
            }
        }
        return result;
    }

    protected void setResult(String resultCode, Result res, String desc) {
        if (res != null) {
            this.result = res;
        }
        if (desc != null && desc.length() > 0) {
            this.resultDescription = desc;
        }
        this.setResultCode(resultCode);
    }

    public String getResultDescription() {
        return this.resultDescription;
    }

    protected String getResponse() {
        return this.response;
    }

    public Result getResult() {
        return this.result;
    }

    public String getCallUrlSnippet() {
        return this.callUrlSnippet;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    protected static class CallThread
    extends Thread {
        protected final HttpClient client;
        protected final HttpRequestBase method;
        protected int resultCode = -1;
        protected String response = null;
        protected Throwable exception = null;

        public CallThread(HttpClient client, HttpRequestBase method) {
            this.client = client;
            this.method = method;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpHost target = new HttpHost(this.method.getURI().getHost(), this.method.getURI().getPort(), this.method.getURI().getScheme());
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            HttpClientContext localContext = HttpClientContext.create();
            localContext.setAuthCache((AuthCache)authCache);
            try {
                try {
                    HttpResponse resp = this.client.execute((HttpUriRequest)this.method, (HttpContext)localContext);
                    this.resultCode = resp.getStatusLine().getStatusCode();
                    this.response = ElasticSearchConnection.getResponseBodyAsString(resp.getEntity());
                }
                finally {
                    this.method.abort();
                }
            }
            catch (SocketTimeoutException e) {
                this.exception = e;
            }
            catch (InterruptedIOException e) {
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws HttpException, IOException, InterruptedException {
            this.join();
            Throwable t = this.exception;
            if (t != null) {
                if (t instanceof HttpException) {
                    throw (HttpException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException("Unexpected exception thrown: " + t.getMessage(), t);
            }
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public String getResponse() {
            return this.response;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static enum Result {
        OK,
        ERROR,
        UNKNOWN;

    }
}

