/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Stream;

public class CSVUtils {
    public static String[] getColumnsLabel(String csvFilePath, String separator) throws FileNotFoundException, IOException {
        File csvFile = new File(csvFilePath);
        if (csvFile.exists() && csvFile.canRead()) {
            try (FileReader fr = new FileReader(csvFile);){
                String[] stringArray;
                try (BufferedReader br = new BufferedReader(fr);){
                    String[] columnsLabel;
                    String firstLine = br.readLine();
                    stringArray = columnsLabel = firstLine.split(separator);
                }
                return stringArray;
            }
        }
        throw new IOException("Cannot read file");
    }

    public static long getCSVLinesNumber(String csvFilePath) throws IOException {
        long numberOfLines;
        File csvFile = new File(csvFilePath);
        try (Stream<String> lines = Files.lines(csvFile.toPath(), StandardCharsets.UTF_8);){
            numberOfLines = lines.count();
        }
        return numberOfLines;
    }
}

