/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.schemas.sharepoint.soap;

import com.microsoft.schemas.sharepoint.soap.Webs;
import com.microsoft.schemas.sharepoint.soap.WebsSoap;
import com.microsoft.schemas.sharepoint.soap.WebsSoapStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class WebsLocator
extends Service
implements Webs {
    private String WebsSoap_address = "http://localhost/_vti_bin/webs.asmx";
    private String WebsSoapWSDDServiceName = "WebsSoap";
    private HashSet ports = null;

    public WebsLocator() {
    }

    public WebsLocator(EngineConfiguration config) {
        super(config);
    }

    public WebsLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getWebsSoapAddress() {
        return this.WebsSoap_address;
    }

    public String getWebsSoapWSDDServiceName() {
        return this.WebsSoapWSDDServiceName;
    }

    public void setWebsSoapWSDDServiceName(String name) {
        this.WebsSoapWSDDServiceName = name;
    }

    @Override
    public WebsSoap getWebsSoap() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.WebsSoap_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getWebsSoap(endpoint);
    }

    @Override
    public WebsSoap getWebsSoap(URL portAddress) throws ServiceException {
        try {
            WebsSoapStub _stub = new WebsSoapStub(portAddress, this);
            _stub.setPortName(this.getWebsSoapWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setWebsSoapEndpointAddress(String address) {
        this.WebsSoap_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (WebsSoap.class.isAssignableFrom(serviceEndpointInterface)) {
                WebsSoapStub _stub = new WebsSoapStub(new URL(this.WebsSoap_address), this);
                _stub.setPortName(this.getWebsSoapWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("WebsSoap".equals(inputPortName)) {
            return this.getWebsSoap();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://schemas.microsoft.com/sharepoint/soap/", "Webs");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://schemas.microsoft.com/sharepoint/soap/", "WebsSoap"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"WebsSoap".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setWebsSoapEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

