/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.util.Acyclic;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeNodeList;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Errors;

public class DefaultTreeTable
implements TreeTable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7991792044044382191L;
    private TreeTable.Node root;
    private transient List<TableColumn<?>> columns;
    final Map<TableColumn<?>, Integer> columnIndices;

    DefaultTreeTable(Map<TableColumn<?>, Integer> map) {
        this.columnIndices = map;
    }

    public DefaultTreeTable(TableColumn<?> ... tableColumnArray) {
        ArgumentChecks.ensureNonEmpty("columns", tableColumnArray);
        tableColumnArray = (TableColumn[])Arrays.copyOf(tableColumnArray, tableColumnArray.length, TableColumn[].class);
        this.columnIndices = DefaultTreeTable.createColumnIndices(tableColumnArray);
        this.columns = UnmodifiableArrayList.wrap(tableColumnArray);
    }

    public DefaultTreeTable(Node node) {
        ArgumentChecks.ensureNonNull("root", node);
        this.root = node;
        this.columnIndices = node.columnIndices;
    }

    static Map<TableColumn<?>, Integer> createColumnIndices(TableColumn<?>[] tableColumnArray) {
        Map<TableColumn<?>, Integer> map;
        switch (tableColumnArray.length) {
            case 0: {
                map = Collections.emptyMap();
                break;
            }
            case 1: {
                map = null;
                break;
            }
            default: {
                map = new LinkedHashMap(Containers.hashMapCapacity(tableColumnArray.length));
            }
        }
        for (int i = 0; i < tableColumnArray.length; ++i) {
            TableColumn<?> tableColumn = tableColumnArray[i];
            ArgumentChecks.ensureNonNullElement("columns", i, tableColumn);
            Integer n = i;
            if (map == null) {
                map = Collections.singletonMap(tableColumn, n);
                continue;
            }
            if (map.put(tableColumn, n) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)25, tableColumn));
        }
        return map;
    }

    static TableColumn<?>[] getColumns(Map<TableColumn<?>, Integer> map) {
        return map.keySet().toArray(new TableColumn[map.size()]);
    }

    @Override
    public final List<TableColumn<?>> getColumns() {
        if (this.columns == null) {
            this.columns = UnmodifiableArrayList.wrap(DefaultTreeTable.getColumns(this.columnIndices));
        }
        return this.columns;
    }

    @Override
    public TreeTable.Node getRoot() {
        if (this.root == null) {
            this.root = new Node(this);
        }
        return this.root;
    }

    public void setRoot(TreeTable.Node node) {
        Map<TableColumn<?>, Integer> map;
        ArgumentChecks.ensureNonNull("root", node);
        if (node instanceof Node && (map = ((Node)node).columnIndices) != this.columnIndices && !this.columnIndices.keySet().containsAll(map.keySet())) {
            throw new IllegalArgumentException(Errors.format((short)69));
        }
        this.root = node;
    }

    public DefaultTreeTable clone() throws CloneNotSupportedException {
        DefaultTreeTable defaultTreeTable = (DefaultTreeTable)super.clone();
        defaultTreeTable.root = (TreeTable.Node)Cloner.cloneIfPublic(defaultTreeTable.root);
        return defaultTreeTable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultTreeTable defaultTreeTable = (DefaultTreeTable)object;
            return this.columnIndices.equals(defaultTreeTable.columnIndices) && Objects.equals(this.root, defaultTreeTable.root);
        }
        return false;
    }

    public int hashCode() {
        return this.columnIndices.hashCode() + 31 * Objects.hashCode(this.root) ^ 0x900EEFEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TreeTableFormat treeTableFormat = TreeTableFormat.INSTANCE;
        synchronized (treeTableFormat) {
            return TreeTableFormat.INSTANCE.format(this);
        }
    }

    @Acyclic
    public static class Node
    implements TreeTable.Node,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -5729029633479218691L;
        private TreeTable.Node parent;
        private List<TreeTable.Node> children;
        final Map<TableColumn<?>, Integer> columnIndices;
        private Object[] values;

        public Node(TreeTable treeTable) {
            ArgumentChecks.ensureNonNull("table", treeTable);
            if (treeTable instanceof DefaultTreeTable) {
                this.columnIndices = ((DefaultTreeTable)treeTable).columnIndices;
            } else {
                List<TableColumn<?>> list = treeTable.getColumns();
                this.columnIndices = DefaultTreeTable.createColumnIndices(list.toArray(new TableColumn[list.size()]));
            }
        }

        public Node(Node node) {
            ArgumentChecks.ensureNonNull("parent", node);
            this.parent = node;
            this.columnIndices = node.columnIndices;
            TreeNodeList treeNodeList = (TreeNodeList)node.getChildren();
            treeNodeList.addChild(treeNodeList.size(), this);
        }

        public Node(Node node, int n) {
            ArgumentChecks.ensureNonNull("parent", node);
            this.parent = node;
            this.columnIndices = node.columnIndices;
            TreeNodeList treeNodeList = (TreeNodeList)node.getChildren();
            ArgumentChecks.ensureValidIndex(treeNodeList.size() + 1, n);
            treeNodeList.addChild(n, this);
        }

        public Node(CharSequence charSequence) {
            this.columnIndices = TableColumn.NAME_MAP;
            if (charSequence != null) {
                this.values = new CharSequence[]{charSequence};
            }
        }

        @Override
        public final TreeTable.Node getParent() {
            return this.parent;
        }

        final void setParent(TreeTable.Node node) {
            Map<TableColumn<?>, Integer> map;
            if (node instanceof Node && (map = ((Node)node).columnIndices) != this.columnIndices && !map.keySet().containsAll(this.columnIndices.keySet())) {
                throw new IllegalArgumentException(Errors.format((short)69));
            }
            this.parent = node;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public final List<TreeTable.Node> getChildren() {
            if (this.children == null) {
                this.children = this.isLeaf() ? Collections.emptyList() : new Children(this);
            }
            return this.children;
        }

        @Override
        public Node newChild() {
            if (this.isLeaf()) {
                throw new UnsupportedOperationException(Errors.format((short)99, this));
            }
            return new Node(this);
        }

        @Override
        public <V> V getValue(TableColumn<V> tableColumn) {
            Integer n;
            ArgumentChecks.ensureNonNull("column", tableColumn);
            if (this.values != null && (n = this.columnIndices.get(tableColumn)) != null) {
                return tableColumn.getElementType().cast(this.values[n]);
            }
            return null;
        }

        @Override
        public <V> void setValue(TableColumn<V> tableColumn, V v) throws IllegalArgumentException {
            ArgumentChecks.ensureNonNull("column", tableColumn);
            Integer n = this.columnIndices.get(tableColumn);
            if (n == null) {
                throw new IllegalArgumentException(Errors.format((short)45, "column", tableColumn));
            }
            if (this.values == null) {
                if (v == null) {
                    return;
                }
                this.values = new Object[this.columnIndices.size()];
            }
            this.values[n.intValue()] = v;
        }

        @Override
        public boolean isEditable(TableColumn<?> tableColumn) {
            ArgumentChecks.ensureNonNull("column", tableColumn);
            return this.columnIndices.containsKey(tableColumn);
        }

        @Override
        public Object getUserObject() {
            return null;
        }

        public Node clone() throws CloneNotSupportedException {
            Node node = (Node)super.clone();
            node.parent = null;
            if (node.values != null) {
                node.values = (Object[])node.values.clone();
            }
            if (node.children != null) {
                node.children = new Children(node);
                for (TreeTable.Node node2 : this.children) {
                    if (!(node2 instanceof Node)) {
                        throw new CloneNotSupportedException(Errors.format((short)20, node2.getClass()));
                    }
                    node.children.add(((Node)node2).clone());
                }
            }
            return node;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Node node = (Node)object;
                if (this.columnIndices.equals(node.columnIndices)) {
                    List<TreeTable.Node> list;
                    int n;
                    List<TreeTable.Node> list2;
                    Object[] objectArray = this.values;
                    Object[] objectArray2 = node.values;
                    if (objectArray != objectArray2) {
                        int n2 = this.columnIndices.size();
                        while (--n2 >= 0) {
                            if (Objects.equals(objectArray != null ? objectArray[n2] : null, objectArray2 != null ? objectArray2[n2] : null)) continue;
                            return false;
                        }
                    }
                    if (((list2 = node.children) != null ? list2.size() : 0) == (n = (list = this.children) != null ? list.size() : 0)) {
                        for (int i = 0; i < n; ++i) {
                            if (list.get(i).equals(list2.get(i))) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = 0;
            Object[] objectArray = this.values;
            if (objectArray != null) {
                int n2 = objectArray.length;
                while (--n2 >= 0) {
                    n = 31 * n + Objects.hashCode(objectArray[n2]);
                }
            }
            if (!Containers.isNullOrEmpty(this.children)) {
                n += 37 * this.children.hashCode();
            }
            return n ^ 0xECC8E9FD;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var2_5;
            Collection<TreeTable.Node> collection;
            Object[] objectArray = this.values;
            if (objectArray != null) {
                for (Object object : objectArray) {
                    String string;
                    if (!(object instanceof CharSequence) || (string = CharSequences.trimWhitespaces(object.toString())) == null || string.isEmpty()) continue;
                    return string;
                }
            }
            String string = this.getClass().getSimpleName();
            if (this.parent != null && (collection = this.parent.getChildren()) instanceof List) {
                String string2 = string + '-' + ((List)collection).indexOf(this);
            }
            return var2_5;
        }

        private static final class Children
        extends TreeNodeList {
            private static final long serialVersionUID = -1543888535672160884L;

            Children(TreeTable.Node node) {
                super(node);
            }

            @Override
            protected void setParentOf(TreeTable.Node node, int n) throws IllegalArgumentException {
                TreeTable.Node node2;
                if (!(node instanceof Node)) {
                    throw new IllegalArgumentException(Errors.format((short)43, "node", Node.class, node.getClass()));
                }
                switch (n) {
                    case 0: {
                        node2 = null;
                        break;
                    }
                    case 1: {
                        node2 = this.parent;
                        break;
                    }
                    case 2: {
                        return;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                ((Node)node).setParent(node2);
            }
        }
    }
}

