/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.file.ResourceNotFoundException;

final class FileTransporter
extends AbstractTransporter {
    private final Path basePath;
    private final FileOp fileOp;

    FileTransporter(Path basePath, FileOp fileOp) throws NoTransporterException {
        this.basePath = basePath;
        this.fileOp = fileOp;
    }

    Path getBasePath() {
        return this.basePath;
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    private FileOp effectiveFileOp(FileOp wanted, GetTask task) {
        if (task.getDataPath() != null) {
            return wanted;
        }
        return FileOp.COPY;
    }

    protected void implPeek(PeekTask task) throws Exception {
        this.getPath((TransportTask)task, true);
    }

    protected void implGet(GetTask task) throws Exception {
        Path path = this.getPath((TransportTask)task, true);
        long size = Files.size(path);
        FileOp effective = this.effectiveFileOp(this.fileOp, task);
        switch (effective.ordinal()) {
            case 0: {
                this.utilGet(task, Files.newInputStream(path, new OpenOption[0]), true, size, false);
                break;
            }
            case 1: 
            case 2: {
                Files.deleteIfExists(task.getDataPath());
                task.getListener().transportStarted(0L, size);
                if (effective == FileOp.HARDLINK) {
                    Files.createLink(task.getDataPath(), path);
                } else {
                    Files.createSymbolicLink(task.getDataPath(), path, new FileAttribute[0]);
                }
                if (size <= 0L) break;
                try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
                    try {
                        task.getListener().transportProgressed((ByteBuffer)fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size()));
                        break;
                    }
                    catch (UnsupportedOperationException e) {
                        ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
                        while (fc.read(byteBuffer) != -1) {
                            byteBuffer.flip();
                            task.getListener().transportProgressed(byteBuffer);
                            byteBuffer.clear();
                        }
                        break;
                    }
                }
            }
            default: {
                throw new IllegalStateException("Unknown fileOp" + (Object)((Object)this.fileOp));
            }
        }
    }

    protected void implPut(PutTask task) throws Exception {
        Path path = this.getPath((TransportTask)task, false);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try {
            this.utilPut(task, Files.newOutputStream(path, new OpenOption[0]), true);
        }
        catch (Exception e) {
            Files.deleteIfExists(path);
            throw e;
        }
    }

    private Path getPath(TransportTask task, boolean required) throws Exception {
        String path = task.getLocation().getPath();
        if (path.contains("../")) {
            throw new IllegalArgumentException("illegal resource path: " + path);
        }
        Path file = this.basePath.resolve(path);
        if (required && !Files.isRegularFile(file, new LinkOption[0])) {
            throw new ResourceNotFoundException("Could not locate " + file);
        }
        return file;
    }

    protected void implClose() {
    }

    static enum FileOp {
        COPY,
        SYMLINK,
        HARDLINK;

    }
}

