/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.Sources;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.AbstractUpgradeStrategy;
import org.apache.maven.cling.invoker.mvnup.goals.JDomUtils;
import org.apache.maven.cling.invoker.mvnup.goals.PluginUpgrade;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.apache.maven.impl.standalone.ApiRunner;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.dispatchers.LegacyDispatcher;
import org.eclipse.aether.internal.impl.DefaultPathProcessor;
import org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import org.eclipse.aether.internal.impl.transport.http.DefaultChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.jdk.JdkTransporterFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

@Named
@Singleton
@Priority(value=10)
public class PluginUpgradeStrategy
extends AbstractUpgradeStrategy {
    private static final List<PluginUpgrade> PLUGIN_UPGRADES = List.of(new PluginUpgrade("org.apache.maven.plugins", "maven-compiler-plugin", "3.2.0", "Maven 4 compatibility"), new PluginUpgrade("org.apache.maven.plugins", "maven-exec-plugin", "3.2.0", "Maven 4 compatibility"), new PluginUpgrade("org.apache.maven.plugins", "maven-enforcer-plugin", "3.0.0", "Maven 4 compatibility"), new PluginUpgrade("org.codehaus.mojo", "flatten-maven-plugin", "1.2.7", "Maven 4 compatibility"), new PluginUpgrade("org.apache.maven.plugins", "maven-shade-plugin", "3.5.0", "Maven 4 compatibility"), new PluginUpgrade("org.apache.maven.plugins", "maven-remote-resources-plugin", "3.0.0", "Maven 4 compatibility"));
    private Session session;

    @Inject
    public PluginUpgradeStrategy() {
    }

    @Override
    public boolean isApplicable(UpgradeContext context) {
        UpgradeOptions options = this.getOptions(context);
        return this.isOptionEnabled(options, options.plugins(), true);
    }

    @Override
    public String getDescription() {
        return "Upgrading Maven plugins to recommended versions";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult doApply(UpgradeContext context, Map<Path, Document> pomMap) {
        HashSet<Path> processedPoms = new HashSet<Path>();
        HashSet<Path> modifiedPoms = new HashSet<Path>();
        HashSet<Path> errorPoms = new HashSet<Path>();
        try {
            Path tempDir = this.createTempProjectStructure(context, pomMap);
            Map<Path, Set<String>> pluginsNeedingManagement = this.analyzePluginsUsingEffectiveModels(context, pomMap, tempDir);
            for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
                Path pomPath = entry.getKey();
                Document pomDocument = entry.getValue();
                processedPoms.add(pomPath);
                context.info(String.valueOf(pomPath) + " (checking for plugin upgrades)");
                context.indent();
                try {
                    boolean hasUpgrades = false;
                    hasUpgrades |= this.upgradePluginsInDocument(pomDocument, context);
                    Set<String> pluginsForThisPom = pluginsNeedingManagement.get(pomPath);
                    if (pluginsForThisPom != null && !pluginsForThisPom.isEmpty()) {
                        hasUpgrades |= this.addPluginManagementForEffectivePlugins(context, pomDocument, pluginsForThisPom);
                        context.detail("Added plugin management to " + String.valueOf(pomPath) + " (target parent for " + pluginsForThisPom.size() + " plugins)");
                    }
                    if (hasUpgrades) {
                        modifiedPoms.add(pomPath);
                        context.success("Plugin upgrades applied");
                        continue;
                    }
                    context.success("No plugin upgrades needed");
                }
                catch (Exception e) {
                    context.failure("Failed to upgrade plugins: " + e.getMessage());
                    errorPoms.add(pomPath);
                }
                finally {
                    context.unindent();
                }
            }
            this.cleanupTempDirectory(tempDir);
        }
        catch (Exception e) {
            context.failure("Failed to create temp project structure: " + e.getMessage());
            errorPoms.addAll(pomMap.keySet());
        }
        return new UpgradeResult(processedPoms, modifiedPoms, errorPoms);
    }

    private boolean upgradePluginsInDocument(Document pomDocument, UpgradeContext context) {
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        boolean hasUpgrades = false;
        Map<String, PluginUpgradeInfo> pluginUpgrades = this.getPluginUpgradesMap();
        Element buildElement = root.getChild("build", namespace);
        if (buildElement != null) {
            Element managedPluginsElement;
            Element pluginManagementElement;
            Element pluginsElement = buildElement.getChild("plugins", namespace);
            if (pluginsElement != null) {
                hasUpgrades |= this.upgradePluginsInSection(pluginsElement, namespace, pluginUpgrades, pomDocument, "build/plugins", context);
            }
            if ((pluginManagementElement = buildElement.getChild("pluginManagement", namespace)) != null && (managedPluginsElement = pluginManagementElement.getChild("plugins", namespace)) != null) {
                hasUpgrades |= this.upgradePluginsInSection(managedPluginsElement, namespace, pluginUpgrades, pomDocument, "build/pluginManagement/plugins", context);
            }
        }
        return hasUpgrades;
    }

    private Map<String, PluginUpgradeInfo> getPluginUpgradesMap() {
        HashMap<String, PluginUpgradeInfo> upgrades = new HashMap<String, PluginUpgradeInfo>();
        upgrades.put("org.apache.maven.plugins:maven-compiler-plugin", new PluginUpgradeInfo("org.apache.maven.plugins", "maven-compiler-plugin", "3.2"));
        upgrades.put("org.codehaus.mojo:exec-maven-plugin", new PluginUpgradeInfo("org.codehaus.mojo", "exec-maven-plugin", "3.2.0"));
        upgrades.put("org.apache.maven.plugins:maven-enforcer-plugin", new PluginUpgradeInfo("org.apache.maven.plugins", "maven-enforcer-plugin", "3.0.0"));
        upgrades.put("org.codehaus.mojo:flatten-maven-plugin", new PluginUpgradeInfo("org.codehaus.mojo", "flatten-maven-plugin", "1.2.7"));
        upgrades.put("org.apache.maven.plugins:maven-shade-plugin", new PluginUpgradeInfo("org.apache.maven.plugins", "maven-shade-plugin", "3.5.0"));
        upgrades.put("org.apache.maven.plugins:maven-remote-resources-plugin", new PluginUpgradeInfo("org.apache.maven.plugins", "maven-remote-resources-plugin", "3.0.0"));
        return upgrades;
    }

    private boolean upgradePluginsInSection(Element pluginsElement, Namespace namespace, Map<String, PluginUpgradeInfo> pluginUpgrades, Document pomDocument, String sectionName, UpgradeContext context) {
        boolean hasUpgrades = false;
        List pluginElements = pluginsElement.getChildren("plugin", namespace);
        for (Element pluginElement : pluginElements) {
            String pluginKey;
            PluginUpgradeInfo upgrade;
            String groupId = this.getChildText(pluginElement, "groupId", namespace);
            String artifactId = this.getChildText(pluginElement, "artifactId", namespace);
            if (groupId == null && artifactId != null && artifactId.startsWith("maven-")) {
                groupId = "org.apache.maven.plugins";
            }
            if (groupId == null || artifactId == null || (upgrade = pluginUpgrades.get(pluginKey = groupId + ":" + artifactId)) == null || !this.upgradePluginVersion(pluginElement, namespace, upgrade, pomDocument, sectionName, context)) continue;
            hasUpgrades = true;
        }
        return hasUpgrades;
    }

    private boolean upgradePluginVersion(Element pluginElement, Namespace namespace, PluginUpgradeInfo upgrade, Document pomDocument, String sectionName, UpgradeContext context) {
        String currentVersion;
        Element versionElement = pluginElement.getChild("version", namespace);
        boolean isProperty = false;
        String propertyName = null;
        if (versionElement != null) {
            currentVersion = versionElement.getTextTrim();
            if (currentVersion.startsWith("${") && currentVersion.endsWith("}")) {
                isProperty = true;
                propertyName = currentVersion.substring(2, currentVersion.length() - 1);
            }
        } else {
            context.debug("Plugin " + upgrade.groupId + ":" + upgrade.artifactId + " has no explicit version, may inherit from parent");
            return false;
        }
        if (isProperty) {
            return this.upgradePropertyVersion(pomDocument, propertyName, upgrade, sectionName, context);
        }
        if (this.isVersionBelow(currentVersion, upgrade.minVersion)) {
            versionElement.setText(upgrade.minVersion);
            context.detail("Upgraded " + upgrade.groupId + ":" + upgrade.artifactId + " from " + currentVersion + " to " + upgrade.minVersion + " in " + sectionName);
            return true;
        }
        context.debug("Plugin " + upgrade.groupId + ":" + upgrade.artifactId + " version " + currentVersion + " is already >= " + upgrade.minVersion);
        return false;
    }

    private boolean upgradePropertyVersion(Document pomDocument, String propertyName, PluginUpgradeInfo upgrade, String sectionName, UpgradeContext context) {
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element propertiesElement = root.getChild("properties", namespace = root.getNamespace());
        if (propertiesElement != null) {
            Element propertyElement = propertiesElement.getChild(propertyName, namespace);
            if (propertyElement != null) {
                String currentVersion = propertyElement.getTextTrim();
                if (this.isVersionBelow(currentVersion, upgrade.minVersion)) {
                    propertyElement.setText(upgrade.minVersion);
                    context.detail("Upgraded property " + propertyName + " (for " + upgrade.groupId + ":" + upgrade.artifactId + ") from " + currentVersion + " to " + upgrade.minVersion + " in " + sectionName);
                    return true;
                }
                context.debug("Property " + propertyName + " version " + currentVersion + " is already >= " + upgrade.minVersion);
            } else {
                context.warning("Property " + propertyName + " not found in POM properties");
            }
        } else {
            context.warning("No properties section found in POM for property " + propertyName);
        }
        return false;
    }

    private boolean isVersionBelow(String currentVersion, String minVersion) {
        if (currentVersion == null || minVersion == null) {
            return false;
        }
        String cleanCurrent = currentVersion.split("-")[0];
        String cleanMin = minVersion.split("-")[0];
        try {
            String[] currentParts = cleanCurrent.split("\\.");
            String[] minParts = cleanMin.split("\\.");
            int maxLength = Math.max(currentParts.length, minParts.length);
            for (int i = 0; i < maxLength; ++i) {
                int minPart;
                int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                int n = minPart = i < minParts.length ? Integer.parseInt(minParts[i]) : 0;
                if (currentPart < minPart) {
                    return true;
                }
                if (currentPart <= minPart) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return currentVersion.compareTo(minVersion) < 0;
        }
    }

    private String getChildText(Element parent, String childName, Namespace namespace) {
        Element child = parent.getChild(childName, namespace);
        return child != null ? child.getTextTrim() : null;
    }

    public static List<PluginUpgrade> getPluginUpgrades() {
        return PLUGIN_UPGRADES;
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = this.createMaven4Session();
        }
        return this.session;
    }

    private Session createMaven4Session() {
        Session session = ApiRunner.createSession(injector -> {
            injector.bindInstance(Dispatcher.class, (Object)new LegacyDispatcher());
            injector.bindInstance(TransporterProvider.class, (Object)new DefaultTransporterProvider(Map.of("https", new JdkTransporterFactory((ChecksumExtractor)new DefaultChecksumExtractor(Map.of()), (PathProcessor)new DefaultPathProcessor()), "file", new FileTransporterFactory())));
        });
        RemoteRepository central = session.createRemoteRepository("central", "https://repo.maven.apache.org/maven2");
        RemoteRepository snapshots = ((RepositoryFactory)session.getService(RepositoryFactory.class)).createRemote(Repository.newBuilder().id("apache-snapshots").url("https://repository.apache.org/content/repositories/snapshots/").releases(RepositoryPolicy.newBuilder().enabled("false").build()).snapshots(RepositoryPolicy.newBuilder().enabled("true").build()).build());
        return session.withRemoteRepositories(List.of(central, snapshots));
    }

    private Path createTempProjectStructure(UpgradeContext context, Map<Path, Document> pomMap) throws Exception {
        Path tempDir = Files.createTempDirectory("mvnup-project-", new FileAttribute[0]);
        context.debug("Created temp project directory: " + String.valueOf(tempDir));
        Path commonRoot = this.findCommonRoot(pomMap.keySet());
        context.debug("Common root: " + String.valueOf(commonRoot));
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path originalPath = entry.getKey();
            Document document = entry.getValue();
            Path relativePath = commonRoot.relativize(originalPath);
            Path tempPomPath = tempDir.resolve(relativePath);
            Files.createDirectories(tempPomPath.getParent(), new FileAttribute[0]);
            this.writePomToFile(document, tempPomPath);
            context.debug("Wrote POM to temp location: " + String.valueOf(tempPomPath));
        }
        return tempDir;
    }

    private Path findCommonRoot(Set<Path> pomPaths) {
        Path commonRoot = null;
        for (Path pomPath : pomPaths) {
            Path parent = pomPath.getParent();
            if (parent == null) {
                parent = Path.of(".", new String[0]);
            }
            if (commonRoot == null) {
                commonRoot = parent;
                continue;
            }
            while (!parent.startsWith(commonRoot) && (commonRoot = commonRoot.getParent()) != null) {
            }
        }
        return commonRoot;
    }

    private void writePomToFile(Document document, Path filePath) throws Exception {
        try (FileWriter writer = new FileWriter(filePath.toFile());){
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, (Writer)writer);
        }
    }

    private Map<Path, Set<String>> analyzePluginsUsingEffectiveModels(UpgradeContext context, Map<Path, Document> pomMap, Path tempDir) {
        HashMap<Path, Set<String>> result = new HashMap<Path, Set<String>>();
        Map<String, PluginUpgrade> pluginUpgrades = this.getPluginUpgradesAsMap();
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path originalPomPath = entry.getKey();
            try {
                Path commonRoot = this.findCommonRoot(pomMap.keySet());
                Path relativePath = commonRoot.relativize(originalPomPath);
                Path tempPomPath = tempDir.resolve(relativePath);
                Set<String> pluginsNeedingUpgrade = this.analyzeEffectiveModelForPlugins(context, tempPomPath, pluginUpgrades);
                Path targetPomForManagement = this.findLastLocalParentForPluginManagement(context, tempPomPath, pomMap, tempDir, commonRoot);
                if (targetPomForManagement == null) continue;
                result.computeIfAbsent(targetPomForManagement, k -> new HashSet()).addAll(pluginsNeedingUpgrade);
                if (pluginsNeedingUpgrade.isEmpty()) continue;
                context.debug("Will add plugin management to " + String.valueOf(targetPomForManagement) + " for plugins: " + String.valueOf(pluginsNeedingUpgrade));
            }
            catch (Exception e) {
                context.debug("Failed to analyze effective model for " + String.valueOf(originalPomPath) + ": " + e.getMessage());
            }
        }
        return result;
    }

    private Map<String, PluginUpgrade> getPluginUpgradesAsMap() {
        HashMap<String, PluginUpgrade> result = new HashMap<String, PluginUpgrade>();
        for (PluginUpgrade upgrade : PLUGIN_UPGRADES) {
            String key = upgrade.groupId() + ":" + upgrade.artifactId();
            result.put(key, upgrade);
        }
        return result;
    }

    private Set<String> analyzeEffectiveModelForPlugins(UpgradeContext context, Path tempPomPath, Map<String, PluginUpgrade> pluginUpgrades) {
        Session session = this.getSession();
        ModelBuilder modelBuilder = (ModelBuilder)session.getService(ModelBuilder.class);
        ModelBuilderRequest request = ModelBuilderRequest.builder().session(session).source(Sources.buildSource((Path)tempPomPath)).requestType(ModelBuilderRequest.RequestType.BUILD_EFFECTIVE).recursive(false).build();
        ModelBuilderResult result = modelBuilder.newSession().build(request);
        Model effectiveModel = result.getEffectiveModel();
        return this.analyzePluginsFromEffectiveModel(context, effectiveModel, pluginUpgrades);
    }

    private Set<String> analyzePluginsFromEffectiveModel(UpgradeContext context, Model effectiveModel, Map<String, PluginUpgrade> pluginUpgrades) {
        HashSet<String> pluginsNeedingUpgrade = new HashSet<String>();
        Build build = effectiveModel.getBuild();
        if (build != null) {
            for (Plugin plugin : build.getPlugins()) {
                String effectiveVersion;
                String pluginKey = this.getPluginKey(plugin);
                PluginUpgrade upgrade = pluginUpgrades.get(pluginKey);
                if (upgrade == null || !this.isVersionBelow(effectiveVersion = plugin.getVersion(), upgrade.minVersion())) continue;
                pluginsNeedingUpgrade.add(pluginKey);
                context.debug("Plugin " + pluginKey + " version " + effectiveVersion + " needs upgrade to " + upgrade.minVersion());
            }
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                for (Plugin plugin : pluginManagement.getPlugins()) {
                    String effectiveVersion;
                    String pluginKey = this.getPluginKey(plugin);
                    PluginUpgrade upgrade = pluginUpgrades.get(pluginKey);
                    if (upgrade == null || !this.isVersionBelow(effectiveVersion = plugin.getVersion(), upgrade.minVersion())) continue;
                    pluginsNeedingUpgrade.add(pluginKey);
                    context.debug("Managed plugin " + pluginKey + " version " + effectiveVersion + " needs upgrade to " + upgrade.minVersion());
                }
            }
        }
        return pluginsNeedingUpgrade;
    }

    private String getPluginKey(Plugin plugin) {
        String groupId = plugin.getGroupId();
        String artifactId = plugin.getArtifactId();
        if (groupId == null && artifactId != null && artifactId.startsWith("maven-")) {
            groupId = "org.apache.maven.plugins";
        }
        return groupId + ":" + artifactId;
    }

    private Path findLastLocalParentForPluginManagement(UpgradeContext context, Path tempPomPath, Map<Path, Document> pomMap, Path tempDir, Path commonRoot) {
        Parent parent;
        Path parentPath;
        Path currentOriginalPath;
        Session session = this.getSession();
        ModelBuilder modelBuilder = (ModelBuilder)session.getService(ModelBuilder.class);
        ModelBuilderRequest request = ModelBuilderRequest.builder().session(session).source(Sources.buildSource((Path)tempPomPath)).requestType(ModelBuilderRequest.RequestType.BUILD_EFFECTIVE).recursive(false).build();
        ModelBuilderResult result = modelBuilder.newSession().build(request);
        Model effectiveModel = result.getEffectiveModel();
        Path relativePath = tempDir.relativize(tempPomPath);
        Path lastLocalParent = currentOriginalPath = commonRoot.resolve(relativePath);
        Model currentModel = effectiveModel;
        while (currentModel.getParent() != null && (parentPath = this.findParentInPomMap(parent = currentModel.getParent(), pomMap)) != null) {
            lastLocalParent = parentPath;
            Path parentTempPath = tempDir.resolve(commonRoot.relativize(parentPath));
            ModelBuilderRequest parentRequest = ModelBuilderRequest.builder().session(session).source(Sources.buildSource((Path)parentTempPath)).requestType(ModelBuilderRequest.RequestType.BUILD_EFFECTIVE).recursive(false).build();
            ModelBuilderResult parentResult = modelBuilder.newSession().build(parentRequest);
            currentModel = parentResult.getEffectiveModel();
        }
        context.debug("Last local parent for " + String.valueOf(currentOriginalPath) + " is " + String.valueOf(lastLocalParent));
        return lastLocalParent;
    }

    private Path findParentInPomMap(Parent parent, Map<Path, Document> pomMap) {
        String parentGroupId = parent.getGroupId();
        String parentArtifactId = parent.getArtifactId();
        String parentVersion = parent.getVersion();
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Document doc = entry.getValue();
            Element root = doc.getRootElement();
            Namespace namespace = root.getNamespace();
            String groupId = this.getChildText(root, "groupId", namespace);
            String artifactId = this.getChildText(root, "artifactId", namespace);
            String version = this.getChildText(root, "version", namespace);
            Element parentElement = root.getChild("parent", namespace);
            if (parentElement != null) {
                if (groupId == null) {
                    groupId = this.getChildText(parentElement, "groupId", namespace);
                }
                if (version == null) {
                    version = this.getChildText(parentElement, "version", namespace);
                }
            }
            if (!parentGroupId.equals(groupId) || !parentArtifactId.equals(artifactId) || !parentVersion.equals(version)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean addPluginManagementForEffectivePlugins(UpgradeContext context, Document pomDocument, Set<String> pluginKeys) {
        Element managedPluginsElement;
        Element pluginManagementElement;
        Namespace namespace;
        Map<String, PluginUpgrade> pluginUpgrades = this.getPluginUpgradesAsMap();
        boolean hasUpgrades = false;
        Element root = pomDocument.getRootElement();
        Element buildElement = root.getChild("build", namespace = root.getNamespace());
        if (buildElement == null) {
            buildElement = JDomUtils.insertNewElement("build", root);
        }
        if ((pluginManagementElement = buildElement.getChild("pluginManagement", namespace)) == null) {
            pluginManagementElement = JDomUtils.insertNewElement("pluginManagement", buildElement);
        }
        if ((managedPluginsElement = pluginManagementElement.getChild("plugins", namespace)) == null) {
            managedPluginsElement = JDomUtils.insertNewElement("plugins", pluginManagementElement);
        }
        for (String pluginKey : pluginKeys) {
            PluginUpgrade upgrade = pluginUpgrades.get(pluginKey);
            if (upgrade == null || this.isPluginAlreadyManagedInElement(managedPluginsElement, namespace, upgrade)) continue;
            this.addPluginManagementEntryFromUpgrade(managedPluginsElement, upgrade, context);
            hasUpgrades = true;
        }
        return hasUpgrades;
    }

    private boolean isPluginAlreadyManagedInElement(Element pluginsElement, Namespace namespace, PluginUpgrade upgrade) {
        List pluginElements = pluginsElement.getChildren("plugin", namespace);
        for (Element pluginElement : pluginElements) {
            String groupId = this.getChildText(pluginElement, "groupId", namespace);
            String artifactId = this.getChildText(pluginElement, "artifactId", namespace);
            if (groupId == null && artifactId != null && artifactId.startsWith("maven-")) {
                groupId = "org.apache.maven.plugins";
            }
            if (!upgrade.groupId().equals(groupId) || !upgrade.artifactId().equals(artifactId)) continue;
            return true;
        }
        return false;
    }

    private void addPluginManagementEntryFromUpgrade(Element managedPluginsElement, PluginUpgrade upgrade, UpgradeContext context) {
        Element pluginElement = JDomUtils.insertNewElement("plugin", managedPluginsElement);
        JDomUtils.insertContentElement(pluginElement, "groupId", upgrade.groupId());
        JDomUtils.insertContentElement(pluginElement, "artifactId", upgrade.artifactId());
        JDomUtils.insertContentElement(pluginElement, "version", upgrade.minVersion());
        context.detail("Added plugin management for " + upgrade.groupId() + ":" + upgrade.artifactId() + " version " + upgrade.minVersion() + " (found through effective model analysis)");
    }

    private void cleanupTempDirectory(Path tempDir) {
        try {
            Files.walk(tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class PluginUpgradeInfo {
        final String groupId;
        final String artifactId;
        final String minVersion;

        PluginUpgradeInfo(String groupId, String artifactId, String minVersion) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.minVersion = minVersion;
        }
    }
}

